/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    private static String DEFAULT_THUMB_PREVFIX = "thumb_";
    private static String DEFAULT_CUT_PREVFIX = "cut_";
    private static Boolean DEFAULT_FORCE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutImage(File srcImg, OutputStream output, Rectangle rect) {
        if (srcImg.exists()) {
            FileInputStream fis = null;
            ImageInputStream iis = null;
            try {
                fis = new FileInputStream(srcImg);
                String types = Arrays.toString(ImageIO.getReaderFormatNames()).replace("]", ",");
                String suffix = null;
                if (srcImg.getName().indexOf(".") > -1) {
                    suffix = srcImg.getName().substring(srcImg.getName().lastIndexOf(".") + 1);
                }
                if (suffix == null || types.toLowerCase().indexOf(suffix.toLowerCase() + ",") < 0) {
                    return;
                }
                iis = ImageIO.createImageInputStream(fis);
                ImageReader reader = ImageIO.getImageReadersBySuffix(suffix).next();
                reader.setInput(iis, true);
                ImageReadParam param = reader.getDefaultReadParam();
                param.setSourceRegion(rect);
                BufferedImage bi = reader.read(0, param);
                ImageIO.write((RenderedImage)bi, suffix, output);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (iis != null) {
                        iis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutImage(byte[] srcImgData, OutputStream output, Rectangle rect) {
        ByteArrayInputStream fis = null;
        ImageInputStream iis = null;
        try {
            fis = new ByteArrayInputStream(srcImgData);
            String suffix = "jpg";
            iis = ImageIO.createImageInputStream(fis);
            ImageReader reader = ImageIO.getImageReadersBySuffix(suffix).next();
            reader.setInput(iis);
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, suffix, output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (iis != null) {
                    iis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void cutImage(File srcImg, OutputStream output, int x, int y, int width, int height) {
        ImageUtil.cutImage(srcImg, output, new Rectangle(x, y, width, height));
    }

    public void cutImage(File srcImg, String destImgPath, Rectangle rect) {
        File destImg = new File(destImgPath);
        if (destImg.exists()) {
            Object p = destImg.getPath();
            try {
                if (!destImg.isDirectory()) {
                    p = destImg.getParent();
                }
                if (!((String)p).endsWith(File.separator)) {
                    p = (String)p + File.separator;
                }
                ImageUtil.cutImage(srcImg, (OutputStream)new FileOutputStream((String)p + DEFAULT_CUT_PREVFIX + "_" + new Date().getTime() + "_" + srcImg.getName()), rect);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void cutImage(File srcImg, String destImg, int x, int y, int width, int height) {
        this.cutImage(srcImg, destImg, new Rectangle(x, y, width, height));
    }

    public void cutImage(String srcImg, String destImg, int x, int y, int width, int height) {
        this.cutImage(new File(srcImg), destImg, new Rectangle(x, y, width, height));
    }

    public void thumbnailImage(File srcImg, OutputStream output, int w, int h, String prevfix, boolean force) {
        if (srcImg.exists()) {
            try {
                String types = Arrays.toString(ImageIO.getReaderFormatNames()).replace("]", ",");
                String suffix = null;
                if (srcImg.getName().indexOf(".") > -1) {
                    suffix = srcImg.getName().substring(srcImg.getName().lastIndexOf(".") + 1);
                }
                if (suffix == null || types.toLowerCase().indexOf(suffix.toLowerCase() + ",") < 0) {
                    return;
                }
                BufferedImage img = ImageIO.read(srcImg);
                if (!force) {
                    int height;
                    int width = ((Image)img).getWidth(null);
                    if ((double)width * 1.0 / (double)w < (double)(height = ((Image)img).getHeight(null)) * 1.0 / (double)h) {
                        if (width > w) {
                            h = Integer.parseInt(new DecimalFormat("0").format((double)(height * w) / ((double)width * 1.0)));
                        }
                    } else if (height > h) {
                        w = Integer.parseInt(new DecimalFormat("0").format((double)(width * h) / ((double)height * 1.0)));
                    }
                }
                BufferedImage bi = new BufferedImage(w, h, 1);
                Graphics g = bi.getGraphics();
                g.drawImage(img, 0, 0, w, h, Color.LIGHT_GRAY, null);
                g.dispose();
                ImageIO.write((RenderedImage)bi, suffix, output);
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void thumbnailImage(File srcImg, int w, int h, String prevfix, boolean force) {
        Object p = srcImg.getAbsolutePath();
        try {
            if (!srcImg.isDirectory()) {
                p = srcImg.getParent();
            }
            if (!((String)p).endsWith(File.separator)) {
                p = (String)p + File.separator;
            }
            this.thumbnailImage(srcImg, new FileOutputStream((String)p + prevfix + srcImg.getName()), w, h, prevfix, force);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void thumbnailImage(String imagePath, int w, int h, String prevfix, boolean force) {
        File srcImg = new File(imagePath);
        this.thumbnailImage(srcImg, w, h, prevfix, force);
    }

    public void thumbnailImage(String imagePath, int w, int h, boolean force) {
        this.thumbnailImage(imagePath, w, h, DEFAULT_THUMB_PREVFIX, (boolean)DEFAULT_FORCE);
    }

    public void thumbnailImage(String imagePath, int w, int h) {
        this.thumbnailImage(imagePath, w, h, DEFAULT_FORCE);
    }

    public static boolean imageSaveTo(String sourcePath, String targetPath, int width, int height, List<AppendInfo> appendInfos) {
        try {
            File srcImgFile = new File(sourcePath);
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            BufferedImage bufImg = new BufferedImage(width, height, 1);
            Graphics2D g = bufImg.createGraphics();
            g.setFont(new Font("", 1, 12));
            g.drawImage(srcImg, 0, 0, width, height, null);
            if (appendInfos != null && !appendInfos.isEmpty()) {
                for (int i = 0; i < appendInfos.size(); ++i) {
                    AppendInfo appendInfo = appendInfos.get(i);
                    g.setColor(appendInfo.getColor());
                    g.drawString(appendInfo.getInfo(), appendInfo.getX(), appendInfo.getY());
                }
                g.dispose();
            }
            FileOutputStream outImgStream = new FileOutputStream(targetPath);
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        ArrayList<AppendInfo> resultList = new ArrayList<AppendInfo>();
        AppendInfo appendInfo = new AppendInfo();
        appendInfo.setColor(Color.white);
        appendInfo.setInfo("\u83cf\u6cfd\u4e07\u8fbe\u5e7f\u573a");
        appendInfo.setX(10);
        appendInfo.setY(50);
        resultList.add(appendInfo);
        appendInfo = new AppendInfo();
        appendInfo.setColor(Color.white);
        appendInfo.setInfo("\u5468\u5927\u751f");
        appendInfo.setX(10);
        appendInfo.setY(65);
        resultList.add(appendInfo);
        appendInfo = new AppendInfo();
        appendInfo.setColor(Color.white);
        appendInfo.setInfo("\u5468\u5927\u751f");
        appendInfo.setX(10);
        appendInfo.setY(80);
        resultList.add(appendInfo);
        appendInfo = new AppendInfo();
        appendInfo.setColor(Color.white);
        appendInfo.setInfo("2019-04-26 15:10:24 337");
        appendInfo.setX(10);
        appendInfo.setY(95);
        resultList.add(appendInfo);
        ImageUtil.imageSaveTo("D://a.jpg", "D://b.jpg", 352, 288, resultList);
    }

    public static class AppendInfo {
        private int x;
        private int y;
        private String info;
        private Color color;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

