///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2008, Robert D. Eden All Rights Reserved.
// Copyright (c) 2009, Jeff Randall All Rights Reserved.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the com.viontech.keliu.chart Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// com.viontech.keliu.chart General Public License for more details.
//
// You should have received a copy of the com.viontech.keliu.chart Lesser General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
///////////////////////////////////////////////////////////////////////////////


package com.viontech.keliu.util.trove;


import com.viontech.keliu.util.trove.decorator.TByteByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TByteCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TByteDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TByteFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TByteIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TByteListDecorator;
import com.viontech.keliu.util.trove.decorator.TByteLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TByteObjectMapDecorator;
import com.viontech.keliu.util.trove.decorator.TByteSetDecorator;
import com.viontech.keliu.util.trove.decorator.TByteShortMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharListDecorator;
import com.viontech.keliu.util.trove.decorator.TCharLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharObjectMapDecorator;
import com.viontech.keliu.util.trove.decorator.TCharSetDecorator;
import com.viontech.keliu.util.trove.decorator.TCharShortMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleListDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleObjectMapDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleSetDecorator;
import com.viontech.keliu.util.trove.decorator.TDoubleShortMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatListDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatObjectMapDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatSetDecorator;
import com.viontech.keliu.util.trove.decorator.TFloatShortMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntListDecorator;
import com.viontech.keliu.util.trove.decorator.TIntLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntObjectMapDecorator;
import com.viontech.keliu.util.trove.decorator.TIntSetDecorator;
import com.viontech.keliu.util.trove.decorator.TIntShortMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongListDecorator;
import com.viontech.keliu.util.trove.decorator.TLongLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongObjectMapDecorator;
import com.viontech.keliu.util.trove.decorator.TLongSetDecorator;
import com.viontech.keliu.util.trove.decorator.TLongShortMapDecorator;
import com.viontech.keliu.util.trove.decorator.TObjectByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TObjectCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TObjectDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TObjectFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TObjectIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TObjectLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TObjectShortMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortByteMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortCharMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortDoubleMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortFloatMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortIntMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortListDecorator;
import com.viontech.keliu.util.trove.decorator.TShortLongMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortObjectMapDecorator;
import com.viontech.keliu.util.trove.decorator.TShortSetDecorator;
import com.viontech.keliu.util.trove.decorator.TShortShortMapDecorator;
import com.viontech.keliu.util.trove.list.TByteList;
import com.viontech.keliu.util.trove.list.TCharList;
import com.viontech.keliu.util.trove.list.TDoubleList;
import com.viontech.keliu.util.trove.list.TFloatList;
import com.viontech.keliu.util.trove.list.TIntList;
import com.viontech.keliu.util.trove.list.TLongList;
import com.viontech.keliu.util.trove.list.TShortList;
import com.viontech.keliu.util.trove.map.TByteByteMap;
import com.viontech.keliu.util.trove.map.TByteCharMap;
import com.viontech.keliu.util.trove.map.TByteDoubleMap;
import com.viontech.keliu.util.trove.map.TByteFloatMap;
import com.viontech.keliu.util.trove.map.TByteIntMap;
import com.viontech.keliu.util.trove.map.TByteLongMap;
import com.viontech.keliu.util.trove.map.TByteObjectMap;
import com.viontech.keliu.util.trove.map.TByteShortMap;
import com.viontech.keliu.util.trove.map.TCharByteMap;
import com.viontech.keliu.util.trove.map.TCharCharMap;
import com.viontech.keliu.util.trove.map.TCharDoubleMap;
import com.viontech.keliu.util.trove.map.TCharFloatMap;
import com.viontech.keliu.util.trove.map.TCharIntMap;
import com.viontech.keliu.util.trove.map.TCharLongMap;
import com.viontech.keliu.util.trove.map.TCharObjectMap;
import com.viontech.keliu.util.trove.map.TCharShortMap;
import com.viontech.keliu.util.trove.map.TDoubleByteMap;
import com.viontech.keliu.util.trove.map.TDoubleCharMap;
import com.viontech.keliu.util.trove.map.TDoubleDoubleMap;
import com.viontech.keliu.util.trove.map.TDoubleFloatMap;
import com.viontech.keliu.util.trove.map.TDoubleIntMap;
import com.viontech.keliu.util.trove.map.TDoubleLongMap;
import com.viontech.keliu.util.trove.map.TDoubleObjectMap;
import com.viontech.keliu.util.trove.map.TDoubleShortMap;
import com.viontech.keliu.util.trove.map.TFloatByteMap;
import com.viontech.keliu.util.trove.map.TFloatCharMap;
import com.viontech.keliu.util.trove.map.TFloatDoubleMap;
import com.viontech.keliu.util.trove.map.TFloatFloatMap;
import com.viontech.keliu.util.trove.map.TFloatIntMap;
import com.viontech.keliu.util.trove.map.TFloatLongMap;
import com.viontech.keliu.util.trove.map.TFloatObjectMap;
import com.viontech.keliu.util.trove.map.TFloatShortMap;
import com.viontech.keliu.util.trove.map.TIntByteMap;
import com.viontech.keliu.util.trove.map.TIntCharMap;
import com.viontech.keliu.util.trove.map.TIntDoubleMap;
import com.viontech.keliu.util.trove.map.TIntFloatMap;
import com.viontech.keliu.util.trove.map.TIntIntMap;
import com.viontech.keliu.util.trove.map.TIntLongMap;
import com.viontech.keliu.util.trove.map.TIntObjectMap;
import com.viontech.keliu.util.trove.map.TIntShortMap;
import com.viontech.keliu.util.trove.map.TLongByteMap;
import com.viontech.keliu.util.trove.map.TLongCharMap;
import com.viontech.keliu.util.trove.map.TLongDoubleMap;
import com.viontech.keliu.util.trove.map.TLongFloatMap;
import com.viontech.keliu.util.trove.map.TLongIntMap;
import com.viontech.keliu.util.trove.map.TLongLongMap;
import com.viontech.keliu.util.trove.map.TLongObjectMap;
import com.viontech.keliu.util.trove.map.TLongShortMap;
import com.viontech.keliu.util.trove.map.TObjectByteMap;
import com.viontech.keliu.util.trove.map.TObjectCharMap;
import com.viontech.keliu.util.trove.map.TObjectDoubleMap;
import com.viontech.keliu.util.trove.map.TObjectFloatMap;
import com.viontech.keliu.util.trove.map.TObjectIntMap;
import com.viontech.keliu.util.trove.map.TObjectLongMap;
import com.viontech.keliu.util.trove.map.TObjectShortMap;
import com.viontech.keliu.util.trove.map.TShortByteMap;
import com.viontech.keliu.util.trove.map.TShortCharMap;
import com.viontech.keliu.util.trove.map.TShortDoubleMap;
import com.viontech.keliu.util.trove.map.TShortFloatMap;
import com.viontech.keliu.util.trove.map.TShortIntMap;
import com.viontech.keliu.util.trove.map.TShortLongMap;
import com.viontech.keliu.util.trove.map.TShortObjectMap;
import com.viontech.keliu.util.trove.map.TShortShortMap;
import com.viontech.keliu.util.trove.set.TByteSet;
import com.viontech.keliu.util.trove.set.TCharSet;
import com.viontech.keliu.util.trove.set.TDoubleSet;
import com.viontech.keliu.util.trove.set.TFloatSet;
import com.viontech.keliu.util.trove.set.TIntSet;
import com.viontech.keliu.util.trove.set.TLongSet;
import com.viontech.keliu.util.trove.set.TShortSet;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * This is a static utility class that provides functions for simplifying creation of
 * decorators.
 *
 * @author  Robert D. Eden
 * @author  Jeff Randall
 * @since   Trove 2.1
 */
public class TDecorators {
    // Hide the constructor
    private TDecorators() {}


    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Double,Double> wrap( TDoubleDoubleMap map ) {
        return new TDoubleDoubleMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Double,Float> wrap( TDoubleFloatMap map ) {
        return new TDoubleFloatMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Double,Integer> wrap( TDoubleIntMap map ) {
        return new TDoubleIntMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Double,Long> wrap( TDoubleLongMap map ) {
        return new TDoubleLongMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Double,Byte> wrap( TDoubleByteMap map ) {
        return new TDoubleByteMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Double,Short> wrap( TDoubleShortMap map ) {
        return new TDoubleShortMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Double,Character> wrap( TDoubleCharMap map ) {
        return new TDoubleCharMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Float,Double> wrap( TFloatDoubleMap map ) {
        return new TFloatDoubleMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Float,Float> wrap( TFloatFloatMap map ) {
        return new TFloatFloatMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Float,Integer> wrap( TFloatIntMap map ) {
        return new TFloatIntMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Float,Long> wrap( TFloatLongMap map ) {
        return new TFloatLongMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Float,Byte> wrap( TFloatByteMap map ) {
        return new TFloatByteMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Float,Short> wrap( TFloatShortMap map ) {
        return new TFloatShortMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Float,Character> wrap( TFloatCharMap map ) {
        return new TFloatCharMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Integer,Double> wrap( TIntDoubleMap map ) {
        return new TIntDoubleMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Integer,Float> wrap( TIntFloatMap map ) {
        return new TIntFloatMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Integer,Integer> wrap( TIntIntMap map ) {
        return new TIntIntMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Integer,Long> wrap( TIntLongMap map ) {
        return new TIntLongMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Integer,Byte> wrap( TIntByteMap map ) {
        return new TIntByteMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Integer,Short> wrap( TIntShortMap map ) {
        return new TIntShortMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Integer,Character> wrap( TIntCharMap map ) {
        return new TIntCharMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Long,Double> wrap( TLongDoubleMap map ) {
        return new TLongDoubleMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Long,Float> wrap( TLongFloatMap map ) {
        return new TLongFloatMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Long,Integer> wrap( TLongIntMap map ) {
        return new TLongIntMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Long,Long> wrap( TLongLongMap map ) {
        return new TLongLongMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Long,Byte> wrap( TLongByteMap map ) {
        return new TLongByteMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Long,Short> wrap( TLongShortMap map ) {
        return new TLongShortMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Long,Character> wrap( TLongCharMap map ) {
        return new TLongCharMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Byte,Double> wrap( TByteDoubleMap map ) {
        return new TByteDoubleMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Byte,Float> wrap( TByteFloatMap map ) {
        return new TByteFloatMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Byte,Integer> wrap( TByteIntMap map ) {
        return new TByteIntMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Byte,Long> wrap( TByteLongMap map ) {
        return new TByteLongMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Byte,Byte> wrap( TByteByteMap map ) {
        return new TByteByteMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Byte,Short> wrap( TByteShortMap map ) {
        return new TByteShortMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Byte,Character> wrap( TByteCharMap map ) {
        return new TByteCharMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Short,Double> wrap( TShortDoubleMap map ) {
        return new TShortDoubleMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Short,Float> wrap( TShortFloatMap map ) {
        return new TShortFloatMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Short,Integer> wrap( TShortIntMap map ) {
        return new TShortIntMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Short,Long> wrap( TShortLongMap map ) {
        return new TShortLongMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Short,Byte> wrap( TShortByteMap map ) {
        return new TShortByteMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Short,Short> wrap( TShortShortMap map ) {
        return new TShortShortMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Short,Character> wrap( TShortCharMap map ) {
        return new TShortCharMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Character,Double> wrap( TCharDoubleMap map ) {
        return new TCharDoubleMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Character,Float> wrap( TCharFloatMap map ) {
        return new TCharFloatMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Character,Integer> wrap( TCharIntMap map ) {
        return new TCharIntMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Character,Long> wrap( TCharLongMap map ) {
        return new TCharLongMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Character,Byte> wrap( TCharByteMap map ) {
        return new TCharByteMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Character,Short> wrap( TCharShortMap map ) {
        return new TCharShortMapDecorator( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static Map<Character,Character> wrap( TCharCharMap map ) {
        return new TCharCharMapDecorator( map );
    }


    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TObjectDoubleMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<T,Double> wrap( TObjectDoubleMap<T> map ) {
        return new TObjectDoubleMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TObjectFloatMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<T,Float> wrap( TObjectFloatMap<T> map ) {
        return new TObjectFloatMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TObjectIntMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<T,Integer> wrap( TObjectIntMap<T> map ) {
        return new TObjectIntMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TObjectLongMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<T,Long> wrap( TObjectLongMap<T> map ) {
        return new TObjectLongMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TObjectByteMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<T,Byte> wrap( TObjectByteMap<T> map ) {
        return new TObjectByteMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TObjectShortMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<T,Short> wrap( TObjectShortMap<T> map ) {
        return new TObjectShortMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TObjectCharMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<T,Character> wrap( TObjectCharMap<T> map ) {
        return new TObjectCharMapDecorator<T>( map );
    }


    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TDoubleObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<Double,T> wrap( TDoubleObjectMap<T> map ) {
        return new TDoubleObjectMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TFloatObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<Float,T> wrap( TFloatObjectMap<T> map ) {
        return new TFloatObjectMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TIntObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<Integer,T> wrap( TIntObjectMap<T> map ) {
        return new TIntObjectMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TLongObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<Long,T> wrap( TLongObjectMap<T> map ) {
        return new TLongObjectMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TByteObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<Byte,T> wrap( TByteObjectMap<T> map ) {
        return new TByteObjectMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TShortObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<Short,T> wrap( TShortObjectMap<T> map ) {
        return new TShortObjectMapDecorator<T>( map );
    }

    /**
     * Wrap the given map in a decorator that uses the standard {@link Map Map}
     * interface.
     *
     * @param map the <tt>TCharObjectMap</tt> to be wrapped
     * @return the wrapped map.
     */
    public static <T> Map<Character,T> wrap( TCharObjectMap<T> map ) {
        return new TCharObjectMapDecorator<T>( map );
    }


    /**
     * Wrap the given set in a decorator that uses the standard {@link Set Set}
     * interface.
     *
     * @param set the <tt>TDoubleSet</tt> to be wrapped
     * @return the wrapped set.
     */
    public static Set<Double> wrap( TDoubleSet set ) {
        return new TDoubleSetDecorator( set );
    }

    /**
     * Wrap the given set in a decorator that uses the standard {@link Set Set}
     * interface.
     *
     * @param set the <tt>TFloatSet</tt> to be wrapped
     * @return the wrapped set.
     */
    public static Set<Float> wrap( TFloatSet set ) {
        return new TFloatSetDecorator( set );
    }

    /**
     * Wrap the given set in a decorator that uses the standard {@link Set Set}
     * interface.
     *
     * @param set the <tt>TIntSet</tt> to be wrapped
     * @return the wrapped set.
     */
    public static Set<Integer> wrap( TIntSet set ) {
        return new TIntSetDecorator( set );
    }

    /**
     * Wrap the given set in a decorator that uses the standard {@link Set Set}
     * interface.
     *
     * @param set the <tt>TLongSet</tt> to be wrapped
     * @return the wrapped set.
     */
    public static Set<Long> wrap( TLongSet set ) {
        return new TLongSetDecorator( set );
    }

    /**
     * Wrap the given set in a decorator that uses the standard {@link Set Set}
     * interface.
     *
     * @param set the <tt>TByteSet</tt> to be wrapped
     * @return the wrapped set.
     */
    public static Set<Byte> wrap( TByteSet set ) {
        return new TByteSetDecorator( set );
    }

    /**
     * Wrap the given set in a decorator that uses the standard {@link Set Set}
     * interface.
     *
     * @param set the <tt>TShortSet</tt> to be wrapped
     * @return the wrapped set.
     */
    public static Set<Short> wrap( TShortSet set ) {
        return new TShortSetDecorator( set );
    }

    /**
     * Wrap the given set in a decorator that uses the standard {@link Set Set}
     * interface.
     *
     * @param set the <tt>TCharSet</tt> to be wrapped
     * @return the wrapped set.
     */
    public static Set<Character> wrap( TCharSet set ) {
        return new TCharSetDecorator( set );
    }


    /**
     * Wrap the given list in a decorator that uses the standard {@link List List}
     * interface.
     *
     * @param list	the <tt>TDoubleList</tt> to be wrapped
     * @return the wrapped list.
     */
    public static List<Double> wrap( TDoubleList list ) {
        return new TDoubleListDecorator( list );
    }

    /**
     * Wrap the given list in a decorator that uses the standard {@link List List}
     * interface.
     *
     * @param list	the <tt>TFloatList</tt> to be wrapped
     * @return the wrapped list.
     */
    public static List<Float> wrap( TFloatList list ) {
        return new TFloatListDecorator( list );
    }

    /**
     * Wrap the given list in a decorator that uses the standard {@link List List}
     * interface.
     *
     * @param list	the <tt>TIntList</tt> to be wrapped
     * @return the wrapped list.
     */
    public static List<Integer> wrap( TIntList list ) {
        return new TIntListDecorator( list );
    }

    /**
     * Wrap the given list in a decorator that uses the standard {@link List List}
     * interface.
     *
     * @param list	the <tt>TLongList</tt> to be wrapped
     * @return the wrapped list.
     */
    public static List<Long> wrap( TLongList list ) {
        return new TLongListDecorator( list );
    }

    /**
     * Wrap the given list in a decorator that uses the standard {@link List List}
     * interface.
     *
     * @param list	the <tt>TByteList</tt> to be wrapped
     * @return the wrapped list.
     */
    public static List<Byte> wrap( TByteList list ) {
        return new TByteListDecorator( list );
    }

    /**
     * Wrap the given list in a decorator that uses the standard {@link List List}
     * interface.
     *
     * @param list	the <tt>TShortList</tt> to be wrapped
     * @return the wrapped list.
     */
    public static List<Short> wrap( TShortList list ) {
        return new TShortListDecorator( list );
    }

    /**
     * Wrap the given list in a decorator that uses the standard {@link List List}
     * interface.
     *
     * @param list	the <tt>TCharList</tt> to be wrapped
     * @return the wrapped list.
     */
    public static List<Character> wrap( TCharList list ) {
        return new TCharListDecorator( list );
    }
}