package com.viontech.keliu.util;


import org.apache.commons.codec.digest.DigestUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * <p>User: Zhang Kaitao
 * <p>Date: 14-2-26
 * <p>Version: 1.0
 */
public class MD5Util {

    public static String digest(String salt, String content) {
    	String md5 = DigestUtils.md5Hex(content+salt).toString();
    	return md5;
    }
    public static String digest(String content) {
    	String md5 = DigestUtils.md5Hex(content).toString();
    	return md5;
    }

    public static String digest(String salt,String url,Map<String, ?> map) {
        StringBuilder s = new StringBuilder();
        s.append("_URI_=");
        s.append(encode(url));
        List<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);//对请求参数进行排序
        for(String key :keys) {//按照顺序拼接请求字符串
        	s.append("&");
        	s.append(key);
        	s.append("=");
        	Object value = map.get(key);
            if(value instanceof String[]) {
                for(String vStr : (String[])value ) {
                    s.append(encode(vStr));
                    s.append(encode(","));
                }
                s.setLength(s.length()-3);
            } else if(value  instanceof List) {
                for(String vStr : (List<String>)value ) {
                    s.append(encode(vStr));
                    s.append(encode(","));
                }
                s.setLength(s.length()-3);
            } else {
                s.append(encode(value.toString()));
            }
        }
        String content = s.toString();
       System.out.println(content);
        return digest(salt,content);
    }
    private static String encode(String s){
    	String result = s;
    	try {
			result = URLEncoder.encode(result,Constants.URI_ENCODING);//对url进行编码
			result =  result.replace("+","%20");//url编码会把空格转成+ 这儿把+转成%20
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
    	return  result;
    }

}