package com.viontech.keliu.configuration;

import com.viontech.keliu.oss.S3ClientHelper;
import com.viontech.keliu.storage.S3Storage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.ByteArrayConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * .
 *
 * @author 谢明辉
 * @date 2020/12/29
 */
@Configuration
@ConditionalOnBean(S3ClientHelper.class)
public class S3StorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(S3StorageConfiguration.class);

    @Bean("imageStorage")
    @ConditionalOnMissingBean(name = "imageStorage")
    public Storage s3ImageStorage(StoragePathGenerator imagePathGenerator, S3ClientHelper s3ClientHelper) {
        logger.info("=============S3 imageStorage==================");
        S3Storage ossImageStorage = new S3Storage(s3ClientHelper);
        ossImageStorage.setConvert(new BufferedImageConvert());
        ossImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ossImageStorage;
    }

    @Bean("featureStorage")
    @ConditionalOnMissingBean(name = "featureStorage")
    public Storage s3FeatureStorage(StoragePathGenerator featurePathGenerator, S3ClientHelper s3ClientHelper) {
        logger.info("=============S3 featureStorage==================");
        S3Storage ossFeatureStorage = new S3Storage(s3ClientHelper);
        ossFeatureStorage.setConvert(new StringConvert());
        ossFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ossFeatureStorage;
    }

    /**
     * 配置一个S3轨迹文件存储器
     */
    @Bean("simpleStringStorage")
    @ConditionalOnMissingBean(name = "simpleStringStorage")
    public Storage s3SimpleStringStorage(StoragePathGenerator simplePathGenerator, S3ClientHelper s3ClientHelper) {
        logger.info("=============S3 simpleStringStorage==================");
        S3Storage simpleStorage = new S3Storage<>(s3ClientHelper);
        simpleStorage.setConvert(new StringConvert());
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }


    /**
     * 配置一个S3轨迹文件存储器
     */
    @Bean("simpleImageStorage")
    @ConditionalOnMissingBean(name = "simpleImageStorage")
    public Storage s3SimpleImageStorage(StoragePathGenerator simplePathGenerator, S3ClientHelper s3ClientHelper) {
        logger.info("=============S3 simpleImageStorage==================");
        S3Storage simpleStorage = new S3Storage(s3ClientHelper);
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    /**
     * 字节数组存储器
     */
    @Bean("byteArrayStorage")
    @ConditionalOnMissingBean(name = "byteArrayStorage")
    public Storage byteArrayStorage(StoragePathGenerator imagePathGenerator, S3ClientHelper s3ClientHelper) {
        logger.info("=============S3 byteArrayStorage==================");
        S3Storage<byte[]> byteArrayStorage = new S3Storage(s3ClientHelper);
        byteArrayStorage.setConvert(new ByteArrayConvert());
        byteArrayStorage.setStoragePathGenerator(imagePathGenerator);
        return byteArrayStorage;
    }

    @Bean("simpleByteArrayStorage")
    @ConditionalOnMissingBean(name = "simpleByteArrayStorage")
    public Storage simpleByteArrayStorage(StoragePathGenerator simplePathGenerator, S3ClientHelper s3ClientHelper) {
        logger.info("=============S3 simpleByteArrayStorage==================");
        S3Storage simpleStorage = new S3Storage(s3ClientHelper);
        simpleStorage.setConvert(new ByteArrayConvert());
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

}
