package com.viontech.keliu.configuration;

import com.viontech.keliu.oss.S3ClientHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * .
 *
 * @author 谢明辉
 * @date 2020/12/23
 */

@Configuration
public class AmazonS3Configuration {

    @Bean
    @ConditionalOnProperty("s3.config.accessKeyId")
    public S3ClientHelper init(@Value("${s3.config.accessKeyId:}") String accessKey
            , @Value("${s3.config.accessKeySecret:}") String secretKey
            , @Value("${s3.config.endPoint:}") String host
            , @Value("${s3.config.bucket:}") String bucket) {
        return new S3ClientHelper(accessKey, secretKey, host, bucket);
    }

}
