package com.viontech.keliu.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;

/**
 * @author 谢明辉
 * @createDate 2018-10-27
 * @description
 */

public class OssClientHelper implements ClientHelper{
    Logger log = LoggerFactory.getLogger(OssClientHelper.class);
    private String key;
    private String secret;
    private String endPoint;
    private String bucket;
    private static OSSClient ossClient;

    public OSSClient getClient() {
        if (ossClient == null) {
            ClientConfiguration conf=new ClientConfiguration();
            conf.setRequestTimeoutEnabled(true);
            conf.setRequestTimeout(10000000);
            conf.setConnectionTimeout(10000000);
            ossClient = new OSSClient(endPoint, key, secret,conf);
        }
        return ossClient;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public String storeFile(String remoteFile, InputStream stream) {
        OSSClient ossClient = getClient();
        return ossClient.putObject(bucket, remoteFile, stream).getETag();
    }

    @Override
    public String storeFile(String remoteFile, byte[] content) {
        OSSClient ossClient = getClient();
        return ossClient.putObject(bucket, remoteFile, new ByteArrayInputStream(content)).getETag();
    }

    @Override
    public boolean isExist(String key){
        return getClient().doesObjectExist(bucket, key);
    }
    @Override
    public String getItem(String key) {
        BufferedReader br = new BufferedReader(new InputStreamReader(getClient().getObject(bucket, key).getObjectContent()));
        StringBuilder sb = new StringBuilder();
        String s;
        try {
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        } catch (Exception e) {
            log.info("oss getItem error");
            e.printStackTrace();
        } finally {
            try {
                br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    @Override
    public byte[] getByteArray(String key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            return IOUtils.readStreamAsByteArray(getClient().getObject(bucket, key).getObjectContent());
        } catch (IOException e) {
            log.info("oss getByteArray error");
            return new byte[0];
        }
    }

    @Override
    public BufferedImage getBufferedImage(String key) {
        try {
            return ImageIO.read(getClient().getObject(bucket, key).getObjectContent());
        } catch (IOException e) {
            log.info("oss getBufferedImage error");
        }
        return null;
    }
    @Override
    public InputStream getObjectContent(String key) {
        return getClient().getObject(bucket, key).getObjectContent();
    }

    @Override
    public byte[] getByteArrayImage(String key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            return IOUtils.readStreamAsByteArray(getClient().getObject(bucket, key).getObjectContent());
        } catch (IOException e) {
            log.error("oss getByteArrayImage error");
            e.printStackTrace();
        }
        return null;
    }
    @Override
    public boolean deleteItem(String key){
        try {
            getClient().deleteObject(bucket,key);
            return true;
        } catch (OSSException | ClientException e) {
            e.printStackTrace();
        }
        return false;
    }
}
