package com.viontech.keliu.configuration;

import com.viontech.keliu.ftp.FtpPoolConfig;
import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.oss.S3ClientHelper;
import com.viontech.keliu.storage.LocalStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.ByteArrayConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.File;

/**
 * .
 *
 * @author 谢明辉
 * @date 2020/12/29
 */
@Configuration
@ConditionalOnMissingBean({OssClientHelper.class, S3ClientHelper.class, FtpPoolConfig.class})
public class LocalStorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LocalStorageConfiguration.class);
    /**
     * 配置一个本地图片存储器
     */
    @Bean("imageStorage")
    @ConditionalOnMissingBean(name = "imageStorage")
    public Storage localImageStorage(StoragePathGenerator imagePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localImageStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();

        }
        logger.info("================local imageStorage==================");
        localImageStorage.setBasePath(path);
        localImageStorage.setConvert(new BufferedImageConvert());
        localImageStorage.setStoragePathGenerator(imagePathGenerator);
        return localImageStorage;
    }

    /**
     * 配置一个本地轨迹文件存储器
     */
    @Bean("simpleStringStorage")
    @ConditionalOnMissingBean(name = "simpleStringStorage")
    public Storage localSimpleStringStorage(StoragePathGenerator simplePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localSimpleStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local simpleStringStorage==================");
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new StringConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    /**
     * 配置一个本地轨迹文件存储器
     */
    @Bean("simpleImageStorage")
    @ConditionalOnMissingBean(name = "simpleImageStorage")
    public Storage localSimpleImageStorage(StoragePathGenerator simplePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localSimpleStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local simpleImageStorage==================");
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new BufferedImageConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }



    /**
     * 配置一个本地特征文件存储器
     */
    @Bean("featureStorage")
    @ConditionalOnMissingBean(name = "featureStorage")
    public Storage localFeatureStorage(StoragePathGenerator featurePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localFeatureStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local featureStorage==================");
        localFeatureStorage.setBasePath(path);
        localFeatureStorage.setConvert(new StringConvert());
        localFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return localFeatureStorage;
    }


    /**
     * 配置一个本地特征文件存储器
     */
    @Bean("simpleByteArrayStorage")
    @ConditionalOnMissingBean(name = "simpleByteArrayStorage")
    public Storage simpleByteArrayStorage(StoragePathGenerator simplePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localSimpleStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local simpleByteArrayStorage==================");
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new ByteArrayConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }


    /**
     * 配置一个本地特征文件存储器
     */
    @Bean("byteArrayStorage")
    @ConditionalOnMissingBean(name = "byteArrayStorage")
    public Storage byteArrayStorage(StoragePathGenerator imagePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("=============local byteArrayStorage==================");
        localStorage.setBasePath(path);
        localStorage.setConvert(new ByteArrayConvert());
        localStorage.setStoragePathGenerator(imagePathGenerator);
        return localStorage;
    }

}
