/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.oss.S3ClientHelper;
import com.viontech.keliu.storage.pathgenerator.PathStorage;

public class S3Storage<T>
extends PathStorage<T> {
    private final S3ClientHelper s3ClientHelper;

    public S3Storage(S3ClientHelper s3ClientHelper) {
        this.s3ClientHelper = s3ClientHelper;
    }

    @Override
    public void setItem(String key, T item) {
        this.s3ClientHelper.storeFile(this.storagePathGenerator.generator(key), this.getConvert().object2bytes(item));
    }

    @Override
    public T getItem(String key) {
        try {
            return this.getConvert().bytes2Object(this.getByteArrayItem(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return this.s3ClientHelper.getByteArrayImage(this.storagePathGenerator.generator(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isItemExist(String key) {
        return this.s3ClientHelper.isExist(this.storagePathGenerator.generator(key));
    }

    @Override
    public boolean deleteItem(String key) {
        return this.s3ClientHelper.deleteItem(this.storagePathGenerator.generator(key));
    }
}

