/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.OssStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.ByteArrayConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={OssClientHelper.class})
public class OssStorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OssStorageConfiguration.class);

    @Bean(value={"imageStorage"})
    public Storage ossImageStorage(StoragePathGenerator imagePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS imageStorage==================");
        OssStorage<BufferedImage> ossImageStorage = new OssStorage<BufferedImage>();
        ossImageStorage.setConvert(new BufferedImageConvert());
        ossImageStorage.setOssClientHelper(ossClientHelper);
        ossImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ossImageStorage;
    }

    @Bean(value={"featureStorage"})
    public Storage ossFeatureStorage(StoragePathGenerator featurePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS featureStorage==================");
        OssStorage<String> ossFeatureStorage = new OssStorage<String>();
        ossFeatureStorage.setConvert(new StringConvert());
        ossFeatureStorage.setOssClientHelper(ossClientHelper);
        ossFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ossFeatureStorage;
    }

    @Bean(value={"simpleStringStorage"})
    public Storage simpleStringStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS simpleStringStorage==================");
        OssStorage<String> simpleStorage = new OssStorage<String>();
        simpleStorage.setConvert(new StringConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    @Bean(value={"simpleImageStorage"})
    public Storage simpleImageStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS simpleImageStorage==================");
        OssStorage<BufferedImage> simpleStorage = new OssStorage<BufferedImage>();
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    @Bean(value={"byteArrayStorage"})
    public Storage byteArrayStorage(StoragePathGenerator imagePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS byteArrayStorage==================");
        OssStorage<byte[]> byteArrayStorage = new OssStorage<byte[]>();
        byteArrayStorage.setConvert(new ByteArrayConvert());
        byteArrayStorage.setOssClientHelper(ossClientHelper);
        byteArrayStorage.setStoragePathGenerator(imagePathGenerator);
        return byteArrayStorage;
    }

    @Bean(value={"simpleByteArrayStorage"})
    public Storage simpleByteArrayStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS simpleByteArrayStorage==================");
        OssStorage<byte[]> simpleStorage = new OssStorage<byte[]>();
        simpleStorage.setConvert(new ByteArrayConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }
}

