/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3.xmlmapper.elements;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.elements.AbstractXmlElementGenerator;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;

public class ResultMapWithoutBLOBsElementGenerator
extends AbstractXmlElementGenerator {
    private boolean isSimple;

    public ResultMapWithoutBLOBsElementGenerator(boolean isSimple) {
        this.isSimple = isSimple;
    }

    @Override
    public void addElements(XmlElement parentElement) {
        XmlElement answer = new XmlElement("resultMap");
        answer.addAttribute(new Attribute("id", this.introspectedTable.getBaseResultMapRootId()));
        String returnType = this.isSimple ? this.introspectedTable.getBaseRecordType() : (this.introspectedTable.getRules().generateBaseRecordClass() ? this.introspectedTable.getBaseRecordType() : this.introspectedTable.getPrimaryKeyType());
        answer.addAttribute(new Attribute("type", returnType));
        this.context.getCommentGenerator().addComment(answer);
        if (this.introspectedTable.isConstructorBased()) {
            this.addResultMapConstructorElements(answer);
        } else {
            this.addResultMapElements(answer, this.introspectedTable, null);
        }
        if (this.context.getPlugins().sqlMapResultMapWithoutBLOBsElementGenerated(answer, this.introspectedTable)) {
            parentElement.addElement(answer);
        }
        answer = new XmlElement("resultMap");
        answer.addAttribute(new Attribute("id", this.introspectedTable.getBaseResultMapId()));
        answer.addAttribute(new Attribute("type", returnType));
        answer.addAttribute(new Attribute("extends", this.introspectedTable.getBaseResultMapRootId()));
        if (this.introspectedTable.getRules().generateLeftJoin()) {
            this.addResultMapAssociationElements(answer);
        }
        if (this.context.getPlugins().sqlMapResultMapWithoutBLOBsElementGenerated(answer, this.introspectedTable)) {
            parentElement.addElement(answer);
        }
    }

    private void addResultMapElements(XmlElement answer, IntrospectedTable introspectedTable, String propertyPrefix) {
        for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
            XmlElement resultElement = new XmlElement("result");
            if (propertyPrefix == null) {
                resultElement = new XmlElement("id");
            }
            resultElement.addAttribute(new Attribute("column", MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap(introspectedColumn)));
            if (propertyPrefix != null) {
                resultElement.addAttribute(new Attribute("property", propertyPrefix + introspectedColumn.getJavaProperty()));
            } else {
                resultElement.addAttribute(new Attribute("property", introspectedColumn.getJavaProperty()));
            }
            if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
                resultElement.addAttribute(new Attribute("typeHandler", introspectedColumn.getTypeHandler()));
            }
            answer.addElement(resultElement);
        }
        List<IntrospectedColumn> columns = this.isSimple ? introspectedTable.getNonPrimaryKeyColumns() : introspectedTable.getBaseColumns();
        for (IntrospectedColumn introspectedColumn : columns) {
            XmlElement resultElement = new XmlElement("result");
            resultElement.addAttribute(new Attribute("column", MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap(introspectedColumn)));
            if (propertyPrefix != null) {
                resultElement.addAttribute(new Attribute("property", propertyPrefix + introspectedColumn.getJavaProperty()));
            } else {
                resultElement.addAttribute(new Attribute("property", introspectedColumn.getJavaProperty()));
            }
            if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
                resultElement.addAttribute(new Attribute("typeHandler", introspectedColumn.getTypeHandler()));
            }
            answer.addElement(resultElement);
        }
    }

    private void addResultMapConstructorElements(XmlElement answer) {
        XmlElement constructor = new XmlElement("constructor");
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getPrimaryKeyColumns()) {
            XmlElement resultElement = new XmlElement("idArg");
            resultElement.addAttribute(new Attribute("column", MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap(introspectedColumn)));
            resultElement.addAttribute(new Attribute("jdbcType", introspectedColumn.getJdbcTypeName()));
            resultElement.addAttribute(new Attribute("javaType", introspectedColumn.getFullyQualifiedJavaType().getFullyQualifiedName()));
            if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
                resultElement.addAttribute(new Attribute("typeHandler", introspectedColumn.getTypeHandler()));
            }
            constructor.addElement(resultElement);
        }
        List<IntrospectedColumn> columns = this.isSimple ? this.introspectedTable.getNonPrimaryKeyColumns() : this.introspectedTable.getBaseColumns();
        for (IntrospectedColumn introspectedColumn : columns) {
            XmlElement resultElement = new XmlElement("arg");
            resultElement.addAttribute(new Attribute("column", MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap(introspectedColumn)));
            resultElement.addAttribute(new Attribute("jdbcType", introspectedColumn.getJdbcTypeName()));
            resultElement.addAttribute(new Attribute("javaType", introspectedColumn.getFullyQualifiedJavaType().getFullyQualifiedName()));
            if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
                resultElement.addAttribute(new Attribute("typeHandler", introspectedColumn.getTypeHandler()));
            }
            constructor.addElement(resultElement);
        }
        answer.addElement(constructor);
    }

    private void addResultMapAssociationElements(XmlElement answer) {
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getAllColumns()) {
            IntrospectedColumn introspectedImportColumn = introspectedColumn.getIntrospectedImportColumn();
            if (introspectedImportColumn == null) continue;
            IntrospectedTable introspectedImportTable = introspectedImportColumn.getIntrospectedTable();
            String resultMap = introspectedImportTable.getMyBatis3SqlMapNamespace() + "." + introspectedImportTable.getBaseResultMapId();
            if (introspectedImportTable.equals(this.introspectedTable)) continue;
            FullyQualifiedJavaType type = new FullyQualifiedJavaType(introspectedImportTable.getBaseRecordType());
            this.addResultMapElements(answer, introspectedImportTable, JavaBeansUtil.getValidPropertyName(type.getShortName()) + ".");
        }
    }
}

