/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3.controller;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.messages.Messages;

public class ControllerWebGenerator
extends AbstractJavaGenerator {
    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.8", table.toString()));
        Plugin plugins = this.context.getPlugins();
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        FullyQualifiedJavaType baseControllerType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType().replace(".model", ".controller.base") + "BaseController");
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType().replace(".model", ".controller.web") + "Controller");
        TopLevelClass topLevelClass = new TopLevelClass(type);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.setAbstract(false);
        commentGenerator.addJavaFileComment(topLevelClass);
        topLevelClass.addImportedType(baseControllerType);
        FullyQualifiedJavaType modelType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType());
        topLevelClass.addImportedType("org.springframework.stereotype.Controller");
        topLevelClass.addImportedType("org.springframework.web.bind.annotation.RequestMapping");
        topLevelClass.addAnnotation("@Controller");
        topLevelClass.addAnnotation("@RequestMapping(\"/" + JavaBeansUtil.getValidPropertyName(modelType.getShortName()) + (modelType.getShortName().endsWith("s") ? "es" : "s") + "\")");
        FullyQualifiedJavaType superClass = baseControllerType;
        FullyQualifiedJavaType serviceType = new FullyQualifiedJavaType(this.introspectedTable.getMyBatis3JavaMapperType().replaceAll("Mapper", "Service").replaceAll(".mapper", ".service.adapter"));
        if (superClass != null) {
            topLevelClass.setSuperClass(superClass);
            topLevelClass.addImportedType(superClass);
        }
        this.createGetExampleMethod(topLevelClass);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.context.getPlugins().modelBaseRecordClassGenerated(topLevelClass, this.introspectedTable)) {
            answer.add(topLevelClass);
        }
        return answer;
    }

    private void createGetExampleMethod(TopLevelClass topLevelClass) {
        Method method = new Method();
        method.addAnnotation("@Override");
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setConstructor(false);
        method.setName("getExample");
        FullyQualifiedJavaType modelType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordVoType());
        FullyQualifiedJavaType exampleType = new FullyQualifiedJavaType(this.introspectedTable.getExampleType());
        Parameter parameter = new Parameter(modelType, JavaBeansUtil.getValidPropertyName(modelType.getShortName()));
        method.addParameter(parameter);
        parameter = new Parameter(FullyQualifiedJavaType.getIntInstance(), "type");
        method.addParameter(parameter);
        FullyQualifiedJavaType baseMapperType = new FullyQualifiedJavaType(this.context.getBasePackage() + ".BaseMapper<" + this.introspectedTable.getBaseRecordType() + ">");
        topLevelClass.addImportedType(baseMapperType);
        topLevelClass.addImportedType(exampleType);
        FullyQualifiedJavaType baseExample = new FullyQualifiedJavaType(this.context.getBasePackage() + ".BaseExample");
        topLevelClass.addImportedType(baseExample);
        method.setReturnType(baseExample);
        StringBuilder sb = new StringBuilder();
        sb.append(exampleType.getShortName()).append(" ").append(JavaBeansUtil.getValidPropertyName(exampleType.getShortName())).append(" = ").append("(").append(exampleType.getShortName()).append(")").append("super.getExample(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(",type);");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return " + JavaBeansUtil.getValidPropertyName(exampleType.getShortName()) + ";");
        topLevelClass.addMethod(method);
    }
}

