/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.internal.util.StringUtility;

public class MyBatis3FormattingUtilities {
    private MyBatis3FormattingUtilities() {
    }

    public static String getParameterClause(IntrospectedColumn introspectedColumn) {
        return MyBatis3FormattingUtilities.getParameterClause(introspectedColumn, null);
    }

    public static String getParameterClause(IntrospectedColumn introspectedColumn, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("#{");
        sb.append(introspectedColumn.getJavaProperty(prefix));
        sb.append(",jdbcType=");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append(",typeHandler=");
            sb.append(introspectedColumn.getTypeHandler());
        }
        sb.append('}');
        return sb.toString();
    }

    public static String getSelectListPhrase(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            StringBuilder sb = new StringBuilder();
            sb.append(MyBatis3FormattingUtilities.getAliasedEscapedColumnName(introspectedColumn));
            sb.append(" as ");
            if (introspectedColumn.isColumnNameDelimited()) {
                sb.append(introspectedColumn.getContext().getBeginningDelimiter());
            }
            sb.append(introspectedColumn.getTableAlias());
            sb.append('_');
            sb.append(MyBatis3FormattingUtilities.escapeStringForMyBatis3(introspectedColumn.getActualColumnName()));
            if (introspectedColumn.isColumnNameDelimited()) {
                sb.append(introspectedColumn.getContext().getEndingDelimiter());
            }
            return sb.toString();
        }
        return MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn);
    }

    public static String getSelectListPhraseWithEscape(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            StringBuilder sb = new StringBuilder();
            sb.append(MyBatis3FormattingUtilities.getAliasedEscapedColumnNameWithEscape(introspectedColumn));
            sb.append(" as ");
            if (introspectedColumn.isColumnNameDelimited()) {
                sb.append(StringUtility.escapeStringForJava(introspectedColumn.getContext().getBeginningDelimiter()));
            }
            sb.append(introspectedColumn.getTableAlias());
            sb.append('_');
            sb.append(MyBatis3FormattingUtilities.escapeStringForMyBatis3(introspectedColumn.getActualColumnName()));
            if (introspectedColumn.isColumnNameDelimited()) {
                sb.append(StringUtility.escapeStringForJava(introspectedColumn.getContext().getEndingDelimiter()));
            }
            return sb.toString();
        }
        return MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn);
    }

    public static String getAliasedEscapedColumnNameWithEscape(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            return StringUtility.escapeStringForJava(introspectedColumn.getContext().getBeginningDelimiter()) + introspectedColumn.getTableAlias() + StringUtility.escapeStringForJava(introspectedColumn.getContext().getEndingDelimiter()) + '.' + MyBatis3FormattingUtilities.getEscapedColumnNameWithEscape(introspectedColumn);
        }
        return MyBatis3FormattingUtilities.getEscapedColumnNameWithEscape(introspectedColumn);
    }

    public static String getEscapedColumnNameWithEscape(IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append(MyBatis3FormattingUtilities.escapeStringForMyBatis3(introspectedColumn.getActualColumnName()));
        if (introspectedColumn.isColumnNameDelimited()) {
            sb.insert(0, StringUtility.escapeStringForJava(introspectedColumn.getContext().getBeginningDelimiter()));
            sb.append(StringUtility.escapeStringForJava(introspectedColumn.getContext().getEndingDelimiter()));
        }
        return sb.toString();
    }

    public static String getEscapedColumnName(IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append(MyBatis3FormattingUtilities.escapeStringForMyBatis3(introspectedColumn.getActualColumnName()));
        if (introspectedColumn.isColumnNameDelimited()) {
            sb.insert(0, introspectedColumn.getContext().getBeginningDelimiter());
            sb.append(introspectedColumn.getContext().getEndingDelimiter());
        }
        return sb.toString();
    }

    public static String getAliasedEscapedColumnName(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            return introspectedColumn.getContext().getBeginningDelimiter() + introspectedColumn.getTableAlias() + introspectedColumn.getContext().getEndingDelimiter() + '.' + MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn);
        }
        return MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn);
    }

    public static String getAliasedActualColumnName(IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            sb.append(StringUtility.escapeStringForJava(introspectedColumn.getContext().getBeginningDelimiter()));
            sb.append(introspectedColumn.getTableAlias());
            sb.append(StringUtility.escapeStringForJava(introspectedColumn.getContext().getEndingDelimiter()));
            sb.append('.');
        }
        if (introspectedColumn.isColumnNameDelimited()) {
            sb.append(StringUtility.escapeStringForJava(introspectedColumn.getContext().getBeginningDelimiter()));
        }
        sb.append(introspectedColumn.getActualColumnName());
        if (introspectedColumn.isColumnNameDelimited()) {
            sb.append(StringUtility.escapeStringForJava(introspectedColumn.getContext().getEndingDelimiter()));
        }
        return sb.toString();
    }

    public static String getRenamedColumnNameForResultMap(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            StringBuilder sb = new StringBuilder();
            sb.append(introspectedColumn.getTableAlias());
            sb.append('_');
            sb.append(introspectedColumn.getActualColumnName());
            return sb.toString();
        }
        return introspectedColumn.getActualColumnName();
    }

    public static String escapeStringForMyBatis3(String s) {
        return s;
    }
}

