package com.viontech.keliu.configuration.elasticsearch.Configuration;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.net.ssl.SSLContext;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;

@Component
public class ElasticsearchConfiguration {

    @Bean
    @ConfigurationProperties(prefix = "spring.elasticsearch.rest")
    public CustomElasticsearchProperties Properties() {
        return new CustomElasticsearchProperties();
    }


    @Bean
    public ElasticsearchClient createElasticsearchClient(CustomElasticsearchProperties properties) {
        HttpHost[] esHosts = properties.getUris().stream().filter(StringUtils::hasLength).map(HttpHost::create).toArray(HttpHost[]::new);
        final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (properties.getUsername() != null) {
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(properties.getUsername(), properties.getPassword()));
        }

        final IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(properties.getIoThreadCount()).setConnectTimeout(10).setRcvBufSize(5).setSoKeepAlive(true).build();
        PoolingNHttpClientConnectionManager connectionManager = null;
        try {
            connectionManager = new PoolingNHttpClientConnectionManager(new
                    DefaultConnectingIOReactor(ioReactorConfig));
            // 设置最大连接数
            connectionManager.setMaxTotal(100);  // 整个连接池的最大连接数
            connectionManager.setDefaultMaxPerRoute(20);
        } catch (IOReactorException e) {
            throw new RuntimeException(e);
        }

        PoolingNHttpClientConnectionManager finalConnectionManager = connectionManager;
        RestClient restClient = RestClient.builder(esHosts)
                .setRequestConfigCallback(requestConfigBuilder -> {
                    requestConfigBuilder.setConnectTimeout(properties.getConnectionTimeout());
                    requestConfigBuilder.setSocketTimeout(properties.getSocketTimeout());
                    requestConfigBuilder.setConnectionRequestTimeout(-1);
                    return requestConfigBuilder;
                })
                .setHttpClientConfigCallback(httpClientBuilder -> {
                    httpClientBuilder.setMaxConnTotal(properties.getMaxConnTotal());
                    httpClientBuilder.setMaxConnPerRoute(properties.getMaxConnPerRoute());
                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                    httpClientBuilder.setConnectionManager(finalConnectionManager);
//                    try {
//                        // 创建一个信任所有证书的 TrustStrategy 策略
//                        TrustStrategy acceptTrustStrategy = new TrustStrategy() {
//                            @Override
//                            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
//                                return true;
//                            }
//                        };
//                        // 使用 SSLContextBuilder 创建 SSLContext
//                        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, acceptTrustStrategy).build();
//                        httpClientBuilder.setSSLContext(sslContext);
//                    } catch (NoSuchAlgorithmException | KeyStoreException | KeyManagementException e) {
//                        e.printStackTrace();
//                    }
                    try {
                        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (TrustStrategy) (chain, authType) -> true).build();
//                        sslContext.init(null, new TrustManager[] {
//                                        new X509TrustManager() {
//                                            @Override
//                                            public void checkClientTrusted(X509Certificate[] x509Certificates, String s)
//                                                    throws CertificateException {
//                                                // 忽略证书错误 信任任何客户端证书
//                                            }
//
//                                            @Override
//                                            public void checkServerTrusted(X509Certificate[] x509Certificates, String s)
//                                                    throws CertificateException {
//                                                // 忽略证书错误 信任任何客户端证书
//                                            }
//
//                                            @Override
//                                            public X509Certificate[] getAcceptedIssuers() {
//                                                return new X509Certificate[0];
//                                            }
//                                        }
//                                },
//                                null);
                        httpClientBuilder.setSSLContext(sslContext);
                    } catch (NoSuchAlgorithmException | KeyManagementException | KeyStoreException e) {
                        System.out.println("忽略证书错误");
                    }
                    httpClientBuilder.setSSLHostnameVerifier(new NoopHostnameVerifier());
                    return httpClientBuilder;
                })
                .build();
        ElasticsearchTransport transport = new RestClientTransport(restClient, new JacksonJsonpMapper());
        return new ElasticsearchClient(transport);
    }
}
