package com.viontech.keliu.configuration.elasticsearch.Configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


public class CustomElasticsearchProperties {

    /**
     * Comma-separated list of the Elasticsearch instances to use.
     */
    private List<String> uris = new ArrayList<>(Collections.singletonList("http://localhost:9200"));

    /**
     * Username for authentication with Elasticsearch.
     */
    private String username;

    /**
     * Password for authentication with Elasticsearch.
     */
    private String password;

    /**
     * Connection timeout used when communicating with Elasticsearch.
     */
    private int connectionTimeout = 1;

    /**
     * Socket timeout used when communicating with Elasticsearch.
     */
    private int socketTimeout = 30000;

    /**
     * Prefix added to the path of every request sent to Elasticsearch.
     */
    private String pathPrefix;

    private boolean customized = false;

    private Integer ioThreadCount = 50;

    private Integer maxConnTotal = 200;

    private Integer maxConnPerRoute = 50;

    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(List<String> uris) {
        customized = true;
        this.uris = uris;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        customized = true;
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        customized = true;
        this.password = password;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        customized = true;
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        customized = true;
        this.socketTimeout = socketTimeout;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        customized = true;
        this.pathPrefix = pathPrefix;
    }

    public boolean isCustomized() {
        return customized;
    }

    public Integer getIoThreadCount() {
        return ioThreadCount;
    }

    public void setIoThreadCount(Integer ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
    }

    public Integer getMaxConnTotal() {
        return maxConnTotal;
    }

    public void setMaxConnTotal(Integer maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
    }

    public Integer getMaxConnPerRoute() {
        return maxConnPerRoute;
    }

    public void setMaxConnPerRoute(Integer maxConnPerRoute) {
        this.maxConnPerRoute = maxConnPerRoute;
    }
}

