//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.viontech.keliu.configuration.elasticsearch.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.data.annotation.Persistent;

@Persistent
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface Setting {
    String settingPath() default "";

    boolean useServerConfiguration() default false;

    short shards() default 1;

    short replicas() default 1;

    String refreshInterval() default "1s";

    String indexStoreType() default "fs";

    String[] sortFields() default {};

    SortOrder[] sortOrders() default {};

    SortMode[] sortModes() default {};

    SortMissing[] sortMissingValues() default {};

    boolean enableDeleted() default false;

    public static enum SortMissing {
        _last,
        _first;

        private SortMissing() {
        }
    }

    public static enum SortMode {
        min,
        max;

        private SortMode() {
        }
    }

    public static enum SortOrder {
        asc,
        desc;

        private SortOrder() {
        }
    }
}
