package com.viontech.keliu.configuration.elasticsearch.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.viontech.keliu.configuration.elasticsearch.annotation.ESPrefix;
import com.viontech.keliu.configuration.elasticsearch.annotation.Template;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.Document;

import java.lang.reflect.Field;
import java.util.Date;

/**
 * Author: inggg
 * Date: 2022/03/28 15:23
 */
public class ESUtil {

    public static String getBaseIndexName(Class clazz) {
        Document annotation = (Document) clazz.getAnnotation(Document.class);
        if (null == annotation) {
            throw new IllegalArgumentException(clazz.getName() + "没有Document注解");
        }
        ESPrefix prefixAnnotation = (ESPrefix) clazz.getAnnotation(ESPrefix.class);
        String templateName;
        if (null != prefixAnnotation) {
            String prefix = ESUtil.getPrefix(prefixAnnotation);
            templateName = prefix + "-" + annotation.indexName();
        } else {
            templateName = annotation.indexName();
        }
        return templateName;
    }

    public static <T> String getIndexName(T t) throws Exception {
        Class<?> clazz = t.getClass();
        String index = getBaseIndexName(clazz);
        Template template = (Template) clazz.getAnnotation(Template.class);
        if (null != template) {
            String dateFormat = template.dataFormat();
            String field = template.dateField();
            if (StringUtils.isNotBlank(field)) {
                Field dateField = clazz.getDeclaredField(field);
                if (null != dateField && Date.class == dateField.getType()) {
                    dateField.setAccessible(true);
                    Date date = (Date) dateField.get(t);
                    String format = DateUtil.format(date, dateFormat);
                    index = index + "-" + format;
                } else {
                    throw new RuntimeException("@IndexSplit dateField字段非日期类型");
                }
            }
        }
        if (StringUtils.isEmpty(index)) {
            throw new RuntimeException("索引不能为空");
        }
        return index;
    }

    public static String getPrefix(ESPrefix prefix) {
        String prefix1 = prefix.prefix();
        if (prefix1.startsWith("${") && prefix1.endsWith("}")) {
            String substring = prefix1.substring(2);
            String substring1 = substring.substring(0, substring.length() - 1);
            String property = SpringUtil.getProperty(substring1);
            return property;
        }
        return prefix1;
    }
}
