package com.viontech.keliu.chart.factory;

import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.DateAxis;
import com.viontech.keliu.chart.axis.StringAxis;
import com.viontech.keliu.util.DateUtil;

import java.util.Calendar;
import java.util.Date;

public class AxisFactory {
	
	/**
	 * 日报生成时间轴，单位：小时
	 * @return
	 */
	public static Axis<Date> createHourAxis(){
		return new DateAxis(Calendar.HOUR_OF_DAY);
	}
	
	public static Axis<Date> createMinuteOfHourAxis(){
		return new DateAxis(Calendar.MINUTE);
	}

	public static Axis<Date> createHourOfDayAxis(){
		return  new DateAxis(DateUtil.FORMAT_HHMM,Calendar.HOUR);
	}

	/**
	 *
	 * @param sdf  格式化日期
	 * @param scaleType  步径的最小单位  分钟  小时   天
	 * @return
	 */
	public static Axis<Date> creatSdfDateAxix(String sdf,int scaleType){
		return  new DateAxis(sdf,scaleType);
	}

	/**
	 * 月报生成时间轴，单位：天
	 */
	public static Axis<Date> createDayOFMonthAxis(){
		return new DateAxis(Calendar.DAY_OF_MONTH);
	}
	
	/**
	 * 月报生成时间轴，单位：天
	 */
	public static Axis<Date> createDayOFMonthAxis(Date startDate,Date endDate){
		Axis<Date> axis = new DateAxis(Calendar.DAY_OF_MONTH);
		axis.setMin(startDate);
		axis.setMax(endDate);
		return axis;
	}
	/**
	 * 年报生成时间轴，单位：天
	 */
	public static Axis<Date> createDayOFYearAxis(Date startDate,Date endDate){
		Axis<Date> axis = new DateAxis(Calendar.DAY_OF_MONTH);
		axis.setMin(startDate);
		axis.setMax(endDate);
		return axis;
	}	
	/**
	 * 年报生成时间轴，单位：周
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static Axis<Date> createWeekOFYearAxis(){
		return new DateAxis(Calendar.WEEK_OF_YEAR);
	}
	/**
	 * 年报生成时间轴，单位：月
	 */
	public static Axis<Date> createMonthOFYearAxis(){
		return new DateAxis(Calendar.MONTH);
	}
	/**
	 * 月报生成时间轴，单位：天
	 * @return
	 */
	public static Axis<Date> createDayOfWeekAxis(){
		Axis<Date> axis = new DateAxis(Calendar.DAY_OF_WEEK);
		Date date = new Date();
		axis.setMin(DateUtil.getMondayOfWeek(date));
		axis.setMax(DateUtil.getSundayOfWeek(date));
		return axis;
	}
	/**
	 * 月报生成时间轴，单位：周
	 * @return
	 */
	public static Axis<Date> createWeekOFMonthAxis(){
		return new DateAxis(Calendar.WEEK_OF_MONTH);
	}
	
	public static Axis<String> createStringAxis(){
		return new StringAxis();
	}

	
}
