package com.viontech.keliu.chart.axis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.exception.AxisLockException;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateAxis extends AxisBase<Date> {

	private String sdfStr = null;
	private int scaleType = Calendar.HOUR_OF_DAY;

	public DateAxis(int scaleType) {
		this.scaleType = scaleType;
	}

	/**
	 * 指定生产时间轴的日期格式类型
	 * @param sdfStr
	 */
	public DateAxis(String sdfStr,int scaleType) {
		this.sdfStr = sdfStr;
		this.scaleType = scaleType;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> getData() {
		if(data.size() > 0){
			return data;
		}
		lock();
		if(sdfStr == null){
			sdfStr =getSimpleDateFormatStr();
		}
		//TODO   x轴按周划分时，先把跨年的处理注释掉，后面考虑添加方法判断是否允许跨年
        /*if(scaleType == Calendar.WEEK_OF_YEAR){// 如果是 每年的 第几周  强行将最大值最小值的年份进行统一
            min = DateUtil.setYears(min,DateUtil.getYear(max));
        }*/
		// 由于在生成坐标时，是从setMin的日期开始，取日期所在的周，然后日期加7天后再取下一个周，会有一种情况，当前端选择了整月或整年的数据时，传值的startDate和endDate不是整周，
		// 比如23年整年的数据，startDate=2023-01-01, endDate=2023-04-05, 第一周 按设定只有一天 2023-01-01，是周日，就导致横坐标取值时只能取到第14周，因为从2023-01-01开始每周加7天，
		// 第15周的日期是 2023-04-09 周日，这个日期大于 endDate=2023-04-05,就导致最终返回的数据里也少了一周。所以下面直接将maxDate设置为结束日期所在周的最后一日。
		Date endDate = getMax();
		if (scaleType == Calendar.WEEK_OF_MONTH || scaleType == Calendar.WEEK_OF_YEAR){
			endDate = DateUtil.addDays(endDate, 7 - DateUtil.getDayOfWeek(endDate));
		}
        // 营业时间设置可以设置为非整点，假如开始时间 9:40, 结束时间 10:30, 生成坐标时，9:00 记录生成后，startTime 加1个小时，变成 10:40,就在endTime之后了，那么10:00 的统计数据就不会生成。
		// 此处加个修改，小时级统计时，如果endDate不是整点，就把endDate的分钟数设为59
		if (scaleType == Calendar.HOUR || scaleType == Calendar.HOUR_OF_DAY){
			if (DateUtil.getMinute(endDate) != 0 && DateUtil.getMinute(endDate) != 59){
				endDate = DateUtil.setMinutes(endDate,59);
			}
		}

		Calendar cal = Calendar.getInstance();
		cal.setTime((Date) getMin());

		while(true){
			if(cal.getTime().after(endDate)){
				break;
			}
			if(scaleType == Calendar.WEEK_OF_MONTH){
				data.add(String.valueOf(DateUtil.getWeekOfMonth(cal.getTime())));
			}else if (scaleType == Calendar.WEEK_OF_YEAR) {
				//data.add(String.valueOf(DateUtil.getWeekOfYearStr(cal.getTime())));
				//翻译中英文
				int weekOfYear = DateUtil.getWeekOfYear(cal.getTime());
				data.add(String.valueOf(LocalMessageUtil.getMessage("weekOfyearStrFormat",new Object[]{weekOfYear})));
			}else {
				data.add(DateUtil.format(sdfStr,cal.getTime()));
			}
			cal.add(scaleType, scale==null?1:scale);
		}
		return data;

	}

	public void setMin(Date startDate) {
		if(lockMinMax){
			return ;
		}
		if(isLock()){
			throw new AxisLockException("x轴已被锁定");
		}
		if(min == null){
			this.min = startDate;
		}else{
		    if(scaleType == Calendar.WEEK_OF_YEAR){
                try {
                    startDate = DateUtil.parse(DateUtil.FORMAT_SHORT, DateUtil.format(DateUtil.FORMAT_SHORT,startDate));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                if(startDate.before((Date) getMin())){
                    min = startDate;
                }
                return ;
            }
			if(sdfStr == null || sdfStr.length() <=0){
				sdfStr =getSimpleDateFormatStr();
			}
			try {
				startDate = DateUtil.parse(sdfStr, DateUtil.format(sdfStr,startDate));
			} catch (Exception e) {
				e.printStackTrace();
			}
			if(startDate.before((Date) getMin())){
				min = startDate;
			}
		}

	}



	public void setMax(Date endDate) {
		if(lockMinMax){
			return ;
		}
		if(isLock()){
			throw new AxisLockException("x轴已被锁定");
		}
		if(max == null){
			this.max = endDate;
		}else{
			if(scaleType == Calendar.WEEK_OF_YEAR){
				try {
					endDate = DateUtil.parse(DateUtil.FORMAT_SHORT, DateUtil.format(DateUtil.FORMAT_SHORT,endDate));
				} catch (ParseException e) {
					e.printStackTrace();
				}
				if(endDate.after(getMax())){
					max = endDate;
				}
				return ;
			}
            if(sdfStr == null || sdfStr.length() <=0){
				sdfStr =getSimpleDateFormatStr();
			}
			try {
				endDate = DateUtil.parse(sdfStr, DateUtil.format(sdfStr,endDate));
			} catch (Exception e) {
				e.printStackTrace();
			}
			if(endDate.after((Date) getMax())){
				max = endDate;
			}
		}
	}
	@JsonIgnore
	public String getSimpleDateFormatStr(){
		Date startDate = (Date) getMin();
		Date endDate = (Date) getMax();
		StringBuilder sb = new StringBuilder();
		if(Calendar.YEAR==scaleType){
			sb.append("yyyy");
		}
		if(Calendar.MONTH == scaleType){
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameYear(startDate, endDate)){
				sb.append("yyyy-");
			}
			sb.append("MM");
		}
		if(Calendar.DAY_OF_MONTH == scaleType){
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameYear(startDate, endDate)){
				sb.append("yyyy-");
			}
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameMonth(startDate, endDate)){
				sb.append("MM-");
			}
			sb.append("dd(E)");
		}
		if(Calendar.HOUR_OF_DAY == scaleType){
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameYear(startDate, endDate)){
				sb.append("yyyy-");
			}
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameMonth(startDate, endDate)){
				sb.append("MM-");
			}
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameDay(startDate, endDate)){
				sb.append("dd ");
			}
			sb.append("HH:00");
		}

		if(Calendar.MINUTE == scaleType){
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameYear(startDate, endDate)){
				sb.append("yyyy-");
			}
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameMonth(startDate, endDate)){
				sb.append("MM-");
			}
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameDay(startDate, endDate)){
				sb.append("dd ");
			}
			if(startDate!=null&&endDate!=null&&!DateUtil.isSameHour(startDate, endDate)){
				sb.append("HH:");
			}
			sb.append("mm");
		}
		if(Calendar.DAY_OF_WEEK == scaleType){
            sdfStr = DateUtil.FORMAT_DAY_OF_WEEK_SORT_CN;
            return  sdfStr;
		}
		if (Calendar.WEEK_OF_YEAR == scaleType){
            sdfStr =DateUtil.FORMAT_WEEK_OF_YEAR;
			//sdfStr=LocalMessageUtil.getMessage("weekOfyearStrFormat");
            return  sdfStr;
        }
		sdfStr = sb.toString();
		return sdfStr;
	}

	@Override
	public void lock() {

	}

	@JsonIgnore
	@Override
	public boolean isLock() {
		return false;
	}
	public void setDateFormatStr(String dateFormatStr){
		this.sdfStr = dateFormatStr;
	}

	@Override
	public int getIndexByCoordinate(Date date) {
		Object coor = date;
		if(date != null) {
			if(sdfStr == null){
				sdfStr =getSimpleDateFormatStr();
			}
			if(scaleType == Calendar.WEEK_OF_MONTH)
				coor =  String.valueOf(DateUtil.getWeekOfMonth(date));
			else if(scaleType == Calendar.WEEK_OF_YEAR){
				//coor =  String.valueOf(DateUtil.getWeekOfYearStr(date));
				int weekOfYear = DateUtil.getWeekOfYear(date);
				coor =  String.valueOf(LocalMessageUtil.getMessage("weekOfyearStrFormat",new Object[]{weekOfYear}));
			} else if (scaleType == Calendar.MINUTE && scale > 1) {
				Calendar instance = Calendar.getInstance();
				instance.setTime(date);
				int minute = instance.get(Calendar.MINUTE);
				minute = (minute / scale) * scale;
				instance.set(Calendar.MINUTE, minute);
				coor = DateUtil.format(sdfStr, instance.getTime());
			}else {
				coor = DateUtil.format(sdfStr, date);
			}
		}
		return getData().indexOf(coor);
//		if(index == -1){
//			addData(date);
//		}
//		return getData().indexOf(coor);
	}

	@Override
	public void addData(Date t) {
		data = new ArrayList<>();
		setMin(t);
		setMax(t);
	}

}
