package com.viontech.keliu.chart.series;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.util.NumberUtil;

public abstract class AxisSeries extends Series{

	public AxisSeries(Chart chart) {
		super(chart);
	}

	public AxisSeries(String name,Chart chart) {
		super(name,chart);
	}
	
	public AxisSeries(String name,String stack,Chart chart) {
		super(name, stack, chart);
	}
	
	public boolean adjustOrPutValueByIndex2(int index,Object value){
		int countNum = getCountByIndex(index) == null ? 0 : getCountByIndex(index);
		setCountByIndex(index, countNum+1);
		return putValueByIndex(index ,NumberUtil.valueAdd(getValueByIndex(index), value));
	}
	
	@JsonIgnore
	protected int getIndexByCoordinate(Object coordinate){
		return chart.getIndexByCoordinate(coordinate);
	}
	

}
