/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.chart.series;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.model.PieData;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public class Pie<T>
extends Series {
    List<Object> coordinates = new ArrayList<Object>();

    public Pie(Chart chart) {
        super(chart);
    }

    public Pie(String name, Chart chart) {
        super(name, chart);
    }

    @Override
    public String getType() {
        return SeriesType.pie.toString();
    }

    @Override
    protected int getIndexByCoordinate(Object coordinate) {
        int index = this.coordinates.indexOf(coordinate);
        if (index < 0) {
            this.coordinates.add(coordinate);
            index = this.coordinates.size() - 1;
        }
        return index;
    }

    @Override
    public boolean putValueByIndex(int index, Object value) {
        if (index < 0) {
            return false;
        }
        PieData pieData = new PieData();
        pieData.setName(this.coordinates.get(index).toString());
        pieData.setValue(value);
        super.putValueByIndex(index, pieData);
        return true;
    }

    @Override
    public boolean adjustOrPutValueByIndex2(int index, Object value) {
        PieData pieData = (PieData)this.getValueByIndex(index);
        if (pieData == null) {
            this.putValueByIndex(index, value);
        } else {
            pieData.setValue(NumberUtil.valueAdd((Object)pieData.getValue(), (Object)value));
            super.putValueByIndex(index, pieData);
        }
        return true;
    }

    @Override
    protected Object calcAvg(Object value, Integer count) {
        return super.calcAvg(((PieData)value).getValue(), count);
    }
}

