/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.chart.factory;

import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.DateAxis;
import com.viontech.keliu.chart.axis.StringAxis;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;

public class AxisFactory {
    public static Axis<Date> createHourAxis() {
        return new DateAxis(11);
    }

    public static Axis<Date> createMinuteOfHourAxis() {
        return new DateAxis(12);
    }

    public static Axis<Date> createHourOfDayAxis() {
        return new DateAxis(DateUtil.FORMAT_HHMM, 10);
    }

    public static Axis<Date> creatSdfDateAxix(String sdf, int scaleType) {
        return new DateAxis(sdf, scaleType);
    }

    public static Axis<Date> createDayOFMonthAxis() {
        return new DateAxis(5);
    }

    public static Axis<Date> createDayOFMonthAxis(Date startDate, Date endDate) {
        DateAxis axis = new DateAxis(5);
        axis.setMin(startDate);
        axis.setMax(endDate);
        return axis;
    }

    public static Axis<Date> createDayOFYearAxis(Date startDate, Date endDate) {
        DateAxis axis = new DateAxis(5);
        axis.setMin(startDate);
        axis.setMax(endDate);
        return axis;
    }

    public static Axis<Date> createWeekOFYearAxis() {
        return new DateAxis(3);
    }

    public static Axis<Date> createMonthOFYearAxis() {
        return new DateAxis(2);
    }

    public static Axis<Date> createDayOfWeekAxis() {
        DateAxis axis = new DateAxis(7);
        Date date = new Date();
        axis.setMin(DateUtil.getMondayOfWeek((Date)date));
        axis.setMax(DateUtil.getSundayOfWeek((Date)date));
        return axis;
    }

    public static Axis<Date> createWeekOFMonthAxis() {
        return new DateAxis(4);
    }

    public static Axis<String> createStringAxis() {
        return new StringAxis();
    }
}

