package com.viontech.keliu.chart.series;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.util.NumberUtil;

public class Row extends Series{

	
	public Row(Chart chart) {
		super(chart);
	}
	public Row(String name,Chart chart) {
		super(name, chart);
	}

	@Override
	public String getType() {
		return SeriesType.table.toString();
	}

	@Override
	protected boolean adjustOrPutValueByIndex2(int index, Object value) {
		int countNum = getCountByIndex(index) == null ? 0 : getCountByIndex(index);
		setCountByIndex(index, countNum+1);
		return putValueByIndex(index ,NumberUtil.valueAdd(getValueByIndex(index), value));
	}
	
	@Override
	protected int getIndexByCoordinate(Object coordinate) {
		return chart.getIndexByCoordinate(coordinate);
	}

	public int getIndexByHeadColumn(String headColumn){
		return  getIndexByCoordinate(headColumn);
	}

	public Object getValueByHeadColumn(String headColumn) {
		return getValueByCoordinate(headColumn);
	}


	public boolean putValueByHeadColumn(String headColumn, Object value) {
		return putValueByCoordinate(headColumn, value);
	}

	public boolean adjustOrPutValueByHeadColumn(String headColumn, Object value) {
		return adjustOrPutValueByCoordinate(headColumn, value);
	}

	public void setCountByHeadColumn(String headColumn, Integer count) {
		setCountByCoordinate(headColumn, count);
	}

	public Integer getCountByHeadColumn(String headColumn) {
		return getCountByCoordinate(headColumn);
	}

	public void setCalcTypeByHeadColumn(String headColumn, int calcType) {
		setCalcTypeByCoordinate(headColumn, calcType);
	}

	public Integer getCalcTypeByHeadColumn(String headColumn) {
		return getCalcTypeByCoordinate(headColumn);
	}

}
