package com.viontech.keliu.chart;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.series.Row;
import com.viontech.keliu.chart.series.SeriesType;

public class Table<T> extends Chart<T>{
	

	public Table(String title, SeriesType defaulType) {
		super(title, SeriesType.table);
	}
	
	public Table(String title) {
		super(title, SeriesType.table);
	}
	
	public int getIndexByTableHead(String tableHead){
		return getIndexByCoordinate(tableHead);
	}

	public Row getRow(String rowName){
		return (Row) getSeries(rowName);
	}
	
	@JsonIgnore
	public Axis getTableHead() {
		return getXAxis();
	}

	public void setTableHead(TableHead tableHead) {
		setXAxis(tableHead);
	}
	
}
