package com.viontech.keliu.runner;

import com.viontech.keliu.redis.KryoRedisSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

/**
 * Created by 苏曼 on 2019/5/31.
 */
@Component
@Order(-1)
public class RedisSerializerConfigRunner implements CommandLineRunner {
    Logger logger = LoggerFactory.getLogger(RedisSerializerConfigRunner.class);
    @Autowired(required = false)
    RedisTemplate redisTemplate;
    @Autowired(required = false)
    StringRedisTemplate stringRedisTemplate;


    @Override
    public void run(String... args) throws Exception {
        if(redisTemplate!=null){
            logger.info("redisTemplate设置序列化方式为kryo");
            KryoRedisSerializer kryoRedisSerializer = new KryoRedisSerializer();
            RedisSerializer<String> stringSerializer = new StringRedisSerializer();
            redisTemplate.setValueSerializer(kryoRedisSerializer);
            redisTemplate.setHashValueSerializer(kryoRedisSerializer);
            redisTemplate.setKeySerializer(stringSerializer);
            redisTemplate.setHashKeySerializer(stringSerializer);

        }
        if(stringRedisTemplate!=null){
            logger.info("stringRedisTemplate设置序列化方式为kryo");
            KryoRedisSerializer kryoRedisSerializer = new KryoRedisSerializer();
            stringRedisTemplate.setValueSerializer(kryoRedisSerializer);
            stringRedisTemplate.setHashValueSerializer(kryoRedisSerializer);
        }
    }
}