/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.converter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.core.convert.converter.Converter;

public class DateConverter
implements Converter<String, Date> {
    private static final List<String> formarts = new ArrayList<String>();

    public DateConverter() {
        System.out.println("[" + new Date() + "] [INFO] (" + this.getClass().getName() + ")  -   \u65e5\u671f\u683c\u5f0f\u5316\u7ec4\u4ef6\u521b\u5efa\u6210\u529f");
    }

    public Date convert(String source) {
        String value = source.trim();
        if ("".equals(value)) {
            return null;
        }
        if (source.matches("^\\d{4}-\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(0));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(1));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(2));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(3));
        }
        if (source.matches("([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]")) {
            return this.parseDate(source, formarts.get(4));
        }
        if (source.matches("([01][0-9]|2[0-3]):[0-5][0-9]")) {
            return this.parseDate(source, formarts.get(5));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}[-,+]\\d{1,2}:\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(6));
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source + "'");
    }

    public Date parseDate(String dateStr, String format) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            date = dateFormat.parse(dateStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static void main(String[] args) {
        System.err.println(new DateConverter().convert("12:00"));
    }

    static {
        formarts.add("yyyy-MM");
        formarts.add("yyyy-MM-dd");
        formarts.add("yyyy-MM-dd HH:mm");
        formarts.add("yyyy-MM-dd HH:mm:ss");
        formarts.add("HH:mm:ss");
        formarts.add("HH:mm");
        formarts.add("yyyy-MM-dd'T'HH:mm:ss");
    }
}

