/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.base;

import cn.monitor4all.logRecord.annotation.OperationLog;
import cn.monitor4all.logRecord.context.LogRecordContext;
import com.github.pagehelper.PageInfo;
import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseModel;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.base.VoInterface;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.FileUtil;
import com.viontech.keliu.util.JsonMessageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class BaseController<O extends BaseModel, T extends VoInterface<O>> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MESSAGE_ADD_SUCCESS = "addSuccess";
    public static final String MESSAGE_ADD_ERROR = "addError";
    public static final String MESSAGE_UPDATE_SUCCESS = "updateSuccess";
    public static final String MESSAGE_UPDATE_ERROR = "updateError";
    public static final String MESSAGE_DELETE_SUCCESS = "delSuccess";
    public static final String MESSAGE_DELETE_ERROR = "delError";
    public static final String MESSAGE_COUNT_SUCCESS = "countSuccess";
    public static final String MESSAGE_COUNT_ERROR = "countError";
    public static final String MESSAGE_SELECT_SUCCESS = "selSuccess";
    public static final String MESSAGE_SELECT_ERROR = "selError";
    public static final String MESSAGE_LIST_SUCCESS = "listSuccess";
    public static final String MESSAGE_LIST_ERROR = "listError";
    public static final String MESSAGE_PAGE_SUCCESS = "pageSuccess";
    public static final String MESSAGE_PAGE_ERROR = "pageError";
    public static final String MESSAGE_WEBROOT_NOTFOUND_ERROR = "webRootNotFoundError";
    public static final String MESSAGE_FILE_UPLOAD_SUCCESS = "fileUploadSuccess";
    public static final String MESSAGE_FILE_UPLOAD_ERROR = "fileUploadError";
    public static final String MESSAGE_FILE_DOWNLOAD_ERROR = "fileDownloadError";
    public static final String MESSAGE_FILE_NOTFOUND_ERROR = "fileNotFoundError";
    public static final String MESSAGE_ID_NOT_EMPTY = "idNotEmpty";
    public static final String MESSAGE_MODE_NOT_EXISTENCE = "modleNotExistence";
    public static final int EXAMPLE_TYPE_SIMPLE = 0;
    public static final int EXAMPLE_TYPE_NORMAL = 1;
    public static final int EXAMPLE_TYPE_COUNT = 3;
    public static final int EXAMPLE_TYPE_PAGE = 4;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    @OperationLog(bizId="#t.getModel().getId()", bizType="#className", msg="#className + '\u65b0\u589e'")
    public Object add(@RequestBody T t) {
        this.getService().insertSelective((BaseModel)t.getModel());
        LogRecordContext.putVariable((String)"className", (Object)((BaseModel)t.getModel()).getClass().getSimpleName());
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_ADD_SUCCESS, this.getClass()), t);
    }

    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    @ResponseBody
    public Object count(T t) {
        int result = this.getService().countByExample(this.getExample(t, 3));
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_COUNT_SUCCESS, this.getClass()), (Object)result);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    @OperationLog(bizId="#id", bizType="#className", msg="#className + '\u4fe1\u606f\u4fee\u6539'", extra="#_DIFF(#oldObject, #newObject)")
    public Object update(@PathVariable(value="id") Long id, @RequestBody T t) {
        ((BaseModel)t.getModel()).setId(id);
        this.getService().updateByPrimaryKeySelective((BaseModel)t.getModel());
        O record = this.getService().selectByPrimaryKey(id);
        LogRecordContext.putVariable((String)"oldObject", record);
        LogRecordContext.putVariable((String)"newObject", t.getModel());
        LogRecordContext.putVariable((String)"className", (Object)((BaseModel)t.getModel()).getClass().getSimpleName());
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_UPDATE_SUCCESS, this.getClass()), t);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @OperationLog(bizId="#id", bizType="#className", msg="'\u5220\u9664' + #className")
    public Object del(@PathVariable(value="id") Long id) {
        if (id == null) {
            return JsonMessageUtil.getErrorJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_ID_NOT_EMPTY, this.getClass()));
        }
        int result = this.getService().deleteByPrimaryKey(id);
        if (result == 0) {
            return JsonMessageUtil.getErrorJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_MODE_NOT_EXISTENCE, this.getClass()));
        }
        String requestURI = LogRecordContext.getVariable((String)"requestURI").toString();
        String[] split = requestURI.split("/");
        LogRecordContext.putVariable((String)"className", (Object)split[split.length - 2]);
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_DELETE_SUCCESS, this.getClass()), null);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object selOne(@PathVariable(value="id") Long id) {
        O t = this.getService().selectByPrimaryKey(id);
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_LIST_SUCCESS, this.getClass()), t);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public Object page(T t, @RequestParam(value="page", defaultValue="-1") int page, @RequestParam(value="pageSize", defaultValue="100") int pageSize, String sortName, String sortOrder) {
        BaseExample baseExample = this.getExample(t, 4);
        if (page <= 0) {
            List<O> result = this.getService().selectByExample(baseExample);
            return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_SELECT_SUCCESS, this.getClass()), result);
        }
        PageInfo pageInfo = this.getService().pagedQuery(baseExample, page, pageSize);
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)MESSAGE_PAGE_SUCCESS, this.getClass()), (Object)pageInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/img/{location}/{picture:.+}"})
    public void getIMG(@PathVariable(value="picture") String picture, @PathVariable(value="location") String location, HttpServletResponse response) {
        if (picture.contains("svg")) {
            response.setContentType("image/svg+xml;charset=UTF-8");
            response.addHeader("Accept-Ranges", "bytes");
        } else {
            response.setContentType("image/jpeg");
        }
        FileInputStream fis = null;
        OutputStream out = null;
        try {
            String basePath = FileUtil.getBasePath();
            File file = new File(basePath + "/" + location, picture);
            if (!file.exists()) {
                System.out.println(file.getAbsolutePath());
                return;
            }
            out = response.getOutputStream();
            fis = new FileInputStream(file);
            byte[] b = new byte[fis.available()];
            response.setContentLength(b.length);
            fis.read(b);
            out.write(b);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract BaseService<O> getService();

    protected abstract BaseExample getExample(T var1, int var2);

    public static boolean isNotNull(Object object) {
        if (object == null) {
            return false;
        }
        return !object.toString().trim().isEmpty();
    }
}

