package com.viontech.keliu.redis;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

import java.io.ByteArrayOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @param <T>
 * @author yuhao.wang
 */
public class KryoRedisSerializer<T> implements RedisSerializer<T> {
    Logger logger = LoggerFactory.getLogger(KryoRedisSerializer.class);

    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private static final ThreadLocal<Kryo> kryos = ThreadLocal.withInitial(Kryo::new);
    private static final ThreadLocal<Kryo> oldkryos = ThreadLocal.withInitial(Kryo::new);



    public KryoRedisSerializer() {
        super();
    }

    @Override
    public byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return EMPTY_BYTE_ARRAY;
        }
        Kryo kryo = kryos.get();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(false);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Output output = new Output(baos)) {
            kryo.writeClassAndObject(output, t);
            output.flush();
            return baos.toByteArray();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        
        return EMPTY_BYTE_ARRAY;
    }
    RedisSerializer<String> stringSerializer = new StringRedisSerializer();
    Pattern pattern = Pattern.compile("[0-9]*");
    @Override
    public T deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }

        Kryo kryo = kryos.get();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(false);
        try (Input input = new Input(bytes)) {
            return (T) kryo.readClassAndObject(input);
        }catch(Exception e){
        	 kryo = oldkryos.get();
        	 kryo.setReferences(false);
        	 kryo.register(Object.class);
        	 try (Input input = new Input(bytes)) {
                 return (T) kryo.readClassAndObject(input);
             }catch(Exception e2){
                 String result = stringSerializer.deserialize(bytes);
                 Matcher isNum = pattern.matcher(result);
                 if(!isNum.matches()){
                     logger.error("kryo序列化失败:",e);
                 }
                 return (T)result;

             }
        } 

    }

}