package com.viontech.keliu.base;

import java.util.*;


/**
 * 所有Example都需要继承自该类<br>
 * 该类自动生成不需要修改
 * @author suman
 * 2016年8月15日 下午1:58:40
 */
public abstract class BaseExample {
    protected String orderByClause;

    protected String groupByClause;
    
    protected boolean distinct;

    protected boolean ignoreCase;

    protected String tableName;

    protected String tableAlias;

    protected List<GeneratedCriteria> oredCriteria;

    protected Map<String, ColumnContainerBase> columnContainerMap;

    protected Set<String> leftJoinTableSet;

    public BaseExample() {
        oredCriteria = new ArrayList<GeneratedCriteria>();
        columnContainerMap = new HashMap<String,ColumnContainerBase>();
        leftJoinTableSet = new HashSet<String>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        if(orderByClause == null){
           return getTableAlias()+".id";
        }
        return orderByClause;
    }

    public void setGroupByClause(String groupByClause) {
        this.groupByClause = groupByClause;
    }

    public String getGroupByClause() {
        return groupByClause;
    }


    public String getTableName() {
        return tableName;
    }

    public String getTableAlias() {
        return tableAlias;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public boolean isIgnoreCase() {
        return ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        oredCriteria.forEach(item ->{
            item.setIgnoreCase(this.ignoreCase);
        });

    }

    public List<GeneratedCriteria> getOredCriteria() {
        return oredCriteria;
    }

    public Set<ColumnContainerBase> getColumnContainerSet() {
        if(columnContainerMap.size()==0){
            columnContainerMap.put(getTableName(), createColumns());
        }
        return new HashSet(columnContainerMap.values());
    }

    public Set<String> getLeftJoinTableSet() {
        return leftJoinTableSet;
    }

    public void or(GeneratedCriteria criteria) {
        oredCriteria.add(criteria);
        if(!criteria.getTableName().equals(getTableName())){
            leftJoinTableSet.add(criteria.getTableName());
        }
    }

    public GeneratedCriteria and(GeneratedCriteria criteria) {
        GeneratedCriteria oldCriteria =  criteria;
        if(oredCriteria.size()<=0){
            oredCriteria.add(criteria);
        }else{
            oldCriteria = oredCriteria.get(oredCriteria.size()-1);
            oldCriteria.getCriteria().addAll(criteria.getCriteria());
        }
        if(!criteria.getTableName().equals(getTableName())){
            leftJoinTableSet.add(criteria.getTableName());
        }
        return oldCriteria;
    }

    public abstract GeneratedCriteria createCriteria();

    protected abstract GeneratedCriteria createCriteriaInternal();

    protected abstract ColumnContainerBase createColumns();

    public void clear() {
        oredCriteria.clear();
        columnContainerMap.clear();
        leftJoinTableSet.clear();
        orderByClause = null;
        groupByClause = null;
        distinct = false;
        ignoreCase = false;
    }

    public abstract static class GeneratedCriteria {
        protected List<Criterion> criteria;
        protected boolean ignoreCase = false;
        private String tableName;

        public boolean isIgnoreCase() {
            return ignoreCase;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            this.criteria.forEach(item->{
                item.setIgnoreCase(ignoreCase);
            });
        }

        protected GeneratedCriteria(String tableName) {
            super();
            this.criteria = new ArrayList<Criterion>();
            this.tableName = tableName;
        }
        protected GeneratedCriteria(String tableName,boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        public void setCriteria(List<Criterion> criteria){
            this.criteria = criteria;
        }

        public String getTableName() {
            return tableName;
        }
    }

    public static class Criterion {

        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private boolean ignoreCase;

        public String getCondition() {
            return condition;
        }

        public void setCondition(String condition){
            this.condition = condition;
        }

        public Object getValue() {
            return value;
        }

        public void setValue(Object value){
            this.value = value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public void setNoValue(boolean noValue) {
            this.noValue = noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public void setSingleValue(boolean singleValue){
            this.singleValue = singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public void setListValue(boolean listValue){
            this.listValue = listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        public boolean isIgnoreCase() {
            return ignoreCase;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            if(ignoreCase && value instanceof String){
                String[] conditions = condition.split(" ");
                this.condition = "upper("+conditions[0]+") " + conditions[1];
                this.value = String.valueOf(value).toUpperCase();
            }
        }

        public Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }


        public Criterion(String condition, Object value, String typeHandler) {
          this(condition,value,typeHandler,false);
        }
        public Criterion(String condition, Object value, String typeHandler,boolean ignoreCase) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
            if(ignoreCase && value instanceof String){
                String[] conditions = condition.split(" ");
                this.condition = "upper("+conditions[0]+") " + conditions[1];
                this.value = String.valueOf(value).toUpperCase();
            }

        }

        public Criterion(String condition, Object value) {
            this(condition,value,false);
        }

        public Criterion(String condition, Object value,boolean ignoreCase) {
            this(condition, value, null,ignoreCase);
        }

        public Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        public Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }

    protected static class ColumnContainerBase {
        private StringBuffer columnContainerStr;

        private String tableName;

        protected ColumnContainerBase(String tableName) {
            super();
            columnContainerStr = new StringBuffer();
            this.tableName = tableName;
        }

        public boolean isValid() {
            return columnContainerStr.length() > 0;
        }

        public StringBuffer getAllColumn() {
            return columnContainerStr;
        }

        public StringBuffer getColumnContainerStr() {
            return columnContainerStr;
        }

        public void addColumnStr(String column) {
            if(columnContainerStr.toString().indexOf(column)!=-1){
            	return;
            }
            if (columnContainerStr.length() > 0) {
                columnContainerStr.append(",");
            }
            columnContainerStr.append(column);
        }

        public String getTableName() {
            return tableName;
        }
    }


   
}