/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.utils;

import java.util.Arrays;

public class Util {
    public static boolean isEmpty(String s) {
        return "".equals(s) || s == null;
    }

    public static boolean isNotEmpty(String s) {
        return !Util.isEmpty(s);
    }

    public static double consineVectorSimilarity(Double[] leftVector, Double[] rightVector) {
        if (leftVector.length != rightVector.length) {
            return 1.0;
        }
        leftVector = Util.transferBodyFeature(leftVector);
        rightVector = Util.transferBodyFeature(rightVector);
        double dotProduct = 0.0;
        double leftNorm = 0.0;
        double rightNorm = 0.0;
        for (int i = 0; i < leftVector.length; ++i) {
            dotProduct += leftVector[i] * rightVector[i];
            leftNorm += leftVector[i] * leftVector[i];
            rightNorm += rightVector[i] * rightVector[i];
        }
        return dotProduct / (Math.sqrt(leftNorm) * Math.sqrt(rightNorm));
    }

    public static Double[] transferBodyFeature(Double[] f1) {
        try {
            int i;
            int featureLen = f1[0].intValue();
            int npiece = f1[1].intValue();
            Double[] vec1 = Arrays.copyOfRange(f1, 3, 2051);
            Double[] temp = Arrays.copyOfRange(f1, 3 + featureLen + npiece, f1.length);
            Double[] wt1 = Util.getWeights(temp);
            Double normCoeF1 = 0.0;
            for (i = 0; i < 8; ++i) {
                normCoeF1 = normCoeF1 + wt1[i] * wt1[i] * f1[2051 + i];
            }
            normCoeF1 = 1.0 / Math.sqrt(normCoeF1);
            for (i = 0; i < 2048; ++i) {
                vec1[i] = vec1[i] * wt1[i / 256] * normCoeF1;
            }
            return vec1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return f1;
        }
    }

    private static Double[] getWeights(Double[] landmarks) {
        Object[] wt = new Double[8];
        Arrays.fill(wt, (Object)1.0);
        if (!(landmarks[47] > 0.8) || !(landmarks[50] > 0.8)) {
            if (landmarks[47] > 0.8 || landmarks[50] > 0.8) {
                wt[7] = 0.7;
            } else if (landmarks[41] > 0.8 && landmarks[44] > 0.8) {
                wt[7] = 0.2;
                wt[3] = 0.7;
            } else if (landmarks[41] > 0.8 || landmarks[44] > 0.8) {
                wt[7] = 0.1;
                wt[3] = 0.4;
            } else if (landmarks[35] > 0.7 && landmarks[38] > 0.7) {
                wt[7] = 0.0;
                wt[3] = 0.2;
                wt[6] = 0.8;
                wt[2] = 1.1;
                wt[5] = 1.1;
            } else {
                wt[7] = 0.0;
                wt[3] = 0.0;
                wt[6] = 0.3;
                wt[2] = 1.2;
                wt[5] = 1.4;
            }
        }
        return wt;
    }
}

