/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.utils;

import com.alibaba.fastjson.JSON;
import com.viontech.keliu.http.EBodyFormat;
import com.viontech.keliu.http.VionRequest;
import com.viontech.keliu.http.VionResponse;
import com.viontech.keliu.model.AlgResult;
import com.viontech.keliu.websocket.AlgApiClient;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public void send(String url, HashMap params, Consumer<AlgResult> callBack) {
        this.send(url, params, callBack, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String url, HashMap params, Consumer<AlgResult> callBack, Long timeout) {
        String rid = "";
        try {
            rid = (String)params.get("rid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        VionRequest request = new VionRequest();
        request.setReadTimeout(timeout.intValue());
        request.setUri(url);
        request.setBody(params);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        try {
            int len = request.getBodyStr().getBytes(request.getContentEncoding()).length;
            request.addHeader("Content-Length", Integer.toString(len));
            request.addHeader("Content-Type", "application/json");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        VionResponse post = this.post(request);
        String bodyStr = post.getBodyStr();
        AlgResult algResult = null;
        try {
            algResult = (AlgResult)JSON.parseObject((String)bodyStr, AlgResult.class);
        }
        catch (Exception exception) {
        }
        finally {
            if (algResult != null) {
                rid = algResult.getRid();
            }
            callBack.accept(algResult);
            AlgApiClient.rqid_consumer.remove(rid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VionResponse post(VionRequest request) {
        String charset = request.getContentEncoding();
        String content = request.getBodyStr();
        HashMap<String, String> header = request.getHeaders();
        VionResponse response = new VionResponse();
        FilterOutputStream out = null;
        InputStream is = null;
        try {
            String url = request.getParams().isEmpty() ? request.getUri().toString() : String.format("%s?%s", request.getUri().toString(), request.getParamStr());
            URL console = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)console.openConnection(Proxy.NO_PROXY);
            if (request.getConnectTimeout() != null) {
                conn.setConnectTimeout(request.getConnectTimeout());
            }
            if (request.getReadTimeout() != null) {
                conn.setReadTimeout(request.getReadTimeout());
            }
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            for (Map.Entry<String, String> entry : header.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            conn.connect();
            out = new DataOutputStream(conn.getOutputStream());
            out.write(content.getBytes(charset));
            ((DataOutputStream)out).flush();
            int statusCode = conn.getResponseCode();
            response.setHeader(conn.getHeaderFields());
            response.setStatus(statusCode);
            response.setCharset(charset);
            if (statusCode != 200) {
                InputStream errorStream = conn.getErrorStream();
                String errStr = IOUtils.toString((InputStream)errorStream, (String)charset);
                log.info("http error,code:[{}],info:[{}]", (Object)statusCode, (Object)errStr);
                VionResponse vionResponse = response;
                return vionResponse;
            }
            is = conn.getInputStream();
            if (is != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                response.setBody(outStream.toByteArray());
            }
            VionResponse vionResponse = response;
            return vionResponse;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return response;
    }
}

