/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.viontech.keliu.websocket.WsClient;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsClientFacetory {
    private String urL = null;
    private URI uri;
    private Session session;
    private WebSocketContainer container;
    private Logger logger = LoggerFactory.getLogger(WsClientFacetory.class);

    public void setUrl(String urL) {
        this.urL = urL;
    }

    public synchronized void send(String text) throws IOException, DeploymentException {
        if (text == null || "".equals(text)) {
            return;
        }
        try {
            Session session = this.createConnect();
            session.getBasicRemote().sendText(text);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    public synchronized void send(String text, long timeout) throws IOException, DeploymentException {
        if (text == null || "".equals(text)) {
            return;
        }
        try {
            Session session = this.getSession(timeout);
            session.getBasicRemote().sendText(text);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private Session createConnect() throws DeploymentException, IOException {
        return this.getSession();
    }

    private URI getUri() {
        if (this.uri == null) {
            this.uri = URI.create(this.urL);
        }
        return this.uri;
    }

    private synchronized Session getSession() throws DeploymentException, IOException {
        return this.getSession(0x6DDD00L);
    }

    private synchronized Session getSession(long timeout) throws DeploymentException, IOException {
        if (this.session == null || !this.session.isOpen()) {
            if (this.session != null && !this.session.isOpen()) {
                this.logger.warn("session:{}\u975eopen\u72b6\u6001\uff0c\u88ab\u5173\u95ed", (Object)this.session.getId());
                this.session.close();
            }
            this.session = this.getContainer().connectToServer(WsClient.class, this.getUri());
        }
        this.session.setMaxTextMessageBufferSize(0xA00000);
        this.session.setMaxIdleTimeout(timeout);
        return this.session;
    }

    private WebSocketContainer getContainer() {
        if (this.container == null) {
            this.container = ContainerProvider.getWebSocketContainer();
        }
        return this.container;
    }
}

