package com.viontech.mall.report.util;

import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.Event;
import com.viontech.mall.service.adapter.EventService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;

@Component
public class EventReportUtil {
	
	@Resource
	private  EventService eventService;
	
	private static final String FIELD_HOLIDAY_OBJECT = "holidayObjects";
	private static final String FIELD_HOLIDAY_DATES = "holidayDates";
	private static final String FIELD_HOLIDAY_SORT_DATES = "holidaySortDates";
	
	/**
	 * 对日期数据进行分类   日期是节假日的   日期是周末的（非节假日） 日期是工作日的（非节假日）
	 * @return
	 */
	public  Map<String,List<Date>> getClassifyByDate(Map<String, Object> dataMap){
		Map<String,List<Date>> sortDateMap = (Map<String, List<Date>>) dataMap.get(FIELD_HOLIDAY_SORT_DATES);
		if(sortDateMap == null){
			sortDateMap = new HashMap<String, List<Date>>();
			//所有节假日数据
			List<Event> holidays = getOrQueryHolidayAndEvent(dataMap);
			//所有节假日和活动的日期		
			Set<Date> holidaySet = getHolidayContainDate(holidays, dataMap);
			//把有用的参数临时存储
			for (Event holiday : holidays) {
				String key =DateUtil.format(DateUtil.FORMAT_SHORT,holiday.getEventDate()); 
				//节假日活动期间日期
				Date date_start = holiday.getStartDate();
				Date date_end = holiday.getEndDate();
				List<Date> dates = DateUtil.getDaysBetweenDates(date_start, date_end);
				sortDateMap.put(key+"#holiday",dates);
				//活动开始前，所有的日期
				Date startDay = DateUtil.getFirstDateOfYear(date_start);
				//如果是元旦，开始时间从去年1.1号开始
				if(DateUtil.isSameDay(startDay, holiday.getEventDate())){
					startDay = DateUtil.addYears(startDay, -1);
				}
				List<Date>  allDates= DateUtil.getDaysBetweenDates(startDay, date_start);
				allDates.remove(date_start);//去除活动开始时间
				//获取工作日日期、双休日日期(针对元旦应该特殊处理的，把去年的节假日活动日都去除)
				List<Date> weekdayDates = new ArrayList<Date>();
				List<Date> weekendDates = new ArrayList<Date>();
				for (Date date : allDates) {
					if(holidaySet.contains(date)){
						continue;
					}
					if(DateUtil.isWeekday(date)){
						weekdayDates.add(date);
					}
					if(!DateUtil.isWeekday(date)){	
						weekendDates.add(date);
					}
				}
				sortDateMap.put(key+"#weekday",weekdayDates);
				sortDateMap.put(key+"#weekend",weekendDates);
			}
		}
		return sortDateMap;
	}
	
	/**
	 * 获取选择年份的,所属商场的所有节假日和活动
	 * @param dataMap
	 * @return
	 */
	public  List<Event> getOrQueryHolidayAndEvent(Map<String, Object> dataMap){
		List<Event>  holidayEvents = (List<Event>) dataMap.get(FIELD_HOLIDAY_OBJECT);
		if(holidayEvents == null){
			holidayEvents = new ArrayList<Event>();
			Date year= (Date) dataMap.get("year");
			Long mallId = (Long) dataMap.get("mallId");
			try {
				holidayEvents = eventService.getEvents(year, mallId);
			} catch (Exception e) {
				e.printStackTrace();
			}
			dataMap.put(FIELD_HOLIDAY_OBJECT, holidayEvents);
		}
		return holidayEvents;
	}
	
	/**
	 * 获取节假日的所有日期(去重)
	 * @param holidayList
	 * @param dataMap
	 * @return
	 */
	public  Set<Date> getHolidayContainDate(List<Event> holidayList, Map<String, Object> dataMap){
		Set<Date> holidayDate = (Set<Date>) dataMap.get(FIELD_HOLIDAY_DATES);
		if(holidayDate == null){
			holidayDate = new HashSet<Date>();
			for (Event holidayEvent : holidayList) {
				List<Date> dates = DateUtil.getDaysBetweenDates(holidayEvent.getStartDate(), holidayEvent.getEndDate());
				holidayDate.addAll(dates);
			}
			dataMap.put(FIELD_HOLIDAY_DATES, holidayDate);
		}
		return holidayDate;
	}
}
