package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.model.ZoneDayCountData;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service
public class ZoneYearReportServiceImpl extends AbstractZoneReportServiceImpl {

	/** 年客流环比 */
	private  final String FIELD_YEAR_COMPARED_INNUM = "comparedYearInnum";

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Map<String, Object> head = super.getHead(orgIds, startDate, endDate, dataMap);
		Long orgId = orgIds[0];
		Integer comparedInnum=null;
		java.util.List<ZoneDayCountData> historyDatas = getOrQueryHistoryZoneDayTraffic(orgId, DateUtil.getLastDateOfYear(startDate), DateUtil.getLastDateOfYear(DateUtil.getLastYear(endDate)), dataMap);
		if(historyDatas != null && historyDatas.size() > 0){
			comparedInnum = 0;
			for (ZoneDayCountData zoneDayCountData : historyDatas) {
				comparedInnum += zoneDayCountData.getInnum();
			}
		}
		if(head.get(FIELD_ZONE_ACCUMULATIVE_TRAFFIC)==null) {
			return head;
		}
		String trafficgrowRate = NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_ZONE_ACCUMULATIVE_TRAFFIC))), comparedInnum);
		if (trafficgrowRate != null) {
			head.put(FIELD_YEAR_COMPARED_INNUM, trafficgrowRate.replace("%", ""));
		}
		return head;
	}

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		Long orgId = orgIds[0];
		switch (reportChart.getKey()) {
		case REPORT_ZONE_CUSTOMERFEATURE_GENDER:/**店铺顾客特征--性别分布*/
			chart =  genderDistributionReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_ZONE_CUSTOMERFEATURE_AGE:/**店铺顾客特征--年龄分布*/
			chart = ageDistributionReport(orgId,startDate,endDate, dataMap, reportChart);		
			break;
		case REPORT_ZONE_CUSTOMERFEATURE_NAO:/**店铺顾客特征--新老顾客*/
			//chart = visitorStatisticReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_ZONE_DAY_TRAFFIC_TREND:/**店铺近期客流趋势*/
			chart = trafficTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		
		case REPORT_ZONE_DAY_SALE_TREND:/**店铺近期销售额趋势*/
			chart = SaleTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		
		case REPORT_ZONE_DAY_ENTERINGRATE_TREND:/**店铺近期进店率趋势*/
			chart = EnteringRateTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		
		case REPORT_ZONE_DAY_PERTRANSACTION_TREND:/**店铺近期客单价趋势*/
			chart = PerTransactionTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		
		case REPORT_ZONE_DAY_PERSQUARE_TREND:/**店铺近期坪效趋势*/
			chart = PerSquareTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		
		case REPORT_ZONE_DAY_HANDBAGRATE_TREND:/**店铺近期提袋率趋势*/
			chart = HandbagRateTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		
		case REPORT_ZONE_DAY_DURATIONTIME_TREND:/**店铺近期滞留时间趋势*/
			chart = DurationTimeTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
			
		default:
			break;
		}
		
		return chart;
	}

}
