package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import com.viontech.mall.service.adapter.ZoneHourFaceRecognitionStaService;
import com.viontech.mall.service.adapter.ZoneService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: ShoppingMall-parent
 * @description: 区域客群分时统计
 * @author: WJY
 * @create: 2019-02-19 14:12
 **/
@Service
public class ZoneTrafficTimeStatisticsServiceImpl extends ChartReportBaseService {

    //区域客群分时统计顾客人次折线图
    private static final String REPORTCUSTOMERMANTIME = "customerMantime";
    //区域客群分时统计顾客人数折线图
    private static final String REPORTCUSTOMERCOUNT = "customerCount";
    //区域客群分时统计顾客人数及人次表格
    private static final String REPORTCUSTOMERMANTIMEANDCOUNT = "customerMantimeAndCount";

    @Resource
    private ZoneHourFaceRecognitionStaService zoneHourFaceRecognitionStaService;

    @Resource
    private ZoneReportDataService zoneReportDataService;

    @Resource
    private ZoneService zoneService;

    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = null;
        List<Long> orgIdList = Arrays.asList(orgIds);
        BaseDataServiceImpl.DateCriteria mallOpentime = zoneReportDataService.getMallOpentimesByOrgId(orgIds[0],null,dataMap);
        List<ZoneHourFaceRecognitionSta> zoneHourFaceRecognitionStas = getZoneFaceHourData(orgIdList,startDate,reportChart);
        dataMap.put("zoneFaceData",zoneHourFaceRecognitionStas);
        dataMap.put("zones",getZones(orgIdList));
        switch(reportChart.getKey()){
            case REPORTCUSTOMERMANTIME:
                chart = getGraphics(orgIdList,dataMap,reportChart);
                break;
            case REPORTCUSTOMERCOUNT:
                chart = getGraphics(orgIdList,dataMap,reportChart);
                break;
            case REPORTCUSTOMERMANTIMEANDCOUNT:
                chart = getForm(orgIdList,dataMap,reportChart);
                default:
                    break;
        }
        return chart;
    }

    /**
    * @Description: 获取区域客群分时统计的图形报表
    * @Param: [orgIds, dataMap, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/2/19
    */ 
    private Chart getGraphics(List<Long> orgIds,Map<String,Object> dataMap,ReportChart reportChart){
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        BaseDataServiceImpl.DateCriteria mallOpentime = (BaseDataServiceImpl.DateCriteria)dataMap.get("mallOpenTime");
        Axis<Date> xAxis = AxisFactory.createHourOfDayAxis();
        xAxis.setMin(mallOpentime.getStartDate());
        xAxis.setMax(mallOpentime.getEndDate());
        xAxis.lockMinMax();
        chart.setXAxis(xAxis);
        List<ZoneHourFaceRecognitionSta> zoneHourFaceRecognitionStas = (List<ZoneHourFaceRecognitionSta>) dataMap.get("zoneFaceData");
        Map<Long,String> zones = (Map<Long,String>)dataMap.get("zones");
        for(ZoneHourFaceRecognitionSta zoneHourFaceRecognitionSta : zoneHourFaceRecognitionStas){
            Date currentTime = zoneHourFaceRecognitionSta.getCounttime();
                if(zoneHourFaceRecognitionSta.getCustomMantime()!= null) {
                    chart.getSeries(zones.get(zoneHourFaceRecognitionSta.getZoneId())).adjustOrPutValueByCoordinate(currentTime, zoneHourFaceRecognitionSta.getCustomMantime());
                }else {
                    chart.getSeries(zones.get(zoneHourFaceRecognitionSta.getZoneId())).adjustOrPutValueByCoordinate(currentTime, zoneHourFaceRecognitionSta.getCustomCount());
                }
        }
        return chart;
    }

    /**
    * @Description: 获取区域客群分时统计的表格报表
    * @Param: [orgIds, dataMap, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/2/19
    */ 
    private Chart getForm(List<Long> orgIds,Map<String,Object> dataMap,ReportChart reportChart){
        Table table = new Table(reportChart.getTitle());
        final String time = LocalMessageUtil.getMessage("DateMessage.time");
        final String manTime = LocalMessageUtil.getMessage("Face.allTime");
        final String manCount = LocalMessageUtil.getMessage("Face.allCount");
        Map<Long,String> zones = (Map<Long,String>)dataMap.get("zones");

        TableHead tableHead = new TableHead();
        tableHead.addData(time);
        for(Map.Entry entry : zones.entrySet()){
            tableHead.addData((String) entry.getValue()+"@"+manTime);
            tableHead.addData((String) entry.getValue()+"@"+manCount);
        }
        table.setTableHead(tableHead);

        BaseDataServiceImpl.DateCriteria mallOpentime = (BaseDataServiceImpl.DateCriteria)dataMap.get("mallOpenTime");
        Date openTime = mallOpentime.getStartDate();
        Date closeTime = mallOpentime.getEndDate();
        Date currentTime = openTime;
        List<ZoneHourFaceRecognitionSta> zoneHourFaceRecognitionStas = (List<ZoneHourFaceRecognitionSta>) dataMap.get("zoneFaceData");
        while(currentTime.before(closeTime)|| currentTime.equals(closeTime)){
            String dateStr = DateUtil.format("HH:00",currentTime);
            currentTime = DateUtil.addHours(currentTime,1);
            String nextTimeStr = DateUtil.format("HH:00",currentTime);
            table.getRow(dateStr).putValueByHeadColumn(time,dateStr+"-"+nextTimeStr);
        }

        for (ZoneHourFaceRecognitionSta zoneHourFaceRecognitionSta : zoneHourFaceRecognitionStas){
            Date date = zoneHourFaceRecognitionSta.getCounttime();
            Long zoneId = zoneHourFaceRecognitionSta.getZoneId();
            String dateStr = DateUtil.format("HH:00",date);
            table.getRow(dateStr).adjustOrPutValueByHeadColumn(zones.get(zoneId)+"@"+manTime,zoneHourFaceRecognitionSta.getCustomMantime());
            table.getRow(dateStr).adjustOrPutValueByHeadColumn(zones.get(zoneId)+"@"+manCount,zoneHourFaceRecognitionSta.getCustomCount());
        }
        List<String> headsList = table.getTableHead().getData();

        Map<String,List<String>> headStrMap = new LinkedHashMap<>();
        for (String head : headsList) {
            if (head.contains("@")){
                String[] split = head.split("@");
                String key = split[0] == null ? "":split[0];
                String value = split[1] == null ? "":split[1];
                List<String> values = new ArrayList();
                if (headStrMap.get(key) == null){
                    values.add(value);
                }else {
                    values = headStrMap.get(key);
                    values.add(value);
                }
                headStrMap.put(key,values);
            }else{
                List<String> values = new ArrayList();
                values.add(head);
                headStrMap.put(head,values);
            }
        }

        TableHead tableHead_change = new TableHead();
        for (Map.Entry<String, List<String>> entry : headStrMap.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (values.size() == 1){
                tableHead_change.addData(values.get(0));
            }else if (values.size() > 1){
                String cooditionStr = "["+"\'"+key+"\'"+",\'"+StringUtils.join(values.toArray(),"\',\'")+"\'"+"]";
                tableHead_change.addData(cooditionStr);
            }
        }
        table.setTableHead(tableHead_change);

        return table;
    }


    /**
    * @Description: 得到指定日期的所需门店的数据
    * @Param: [orgIds, date]
    * @return: java.util.List<com.viontech.mall.model.ZoneHourFaceRecognitionSta>
    * @Date: 2019/2/19
    */ 
    private List<ZoneHourFaceRecognitionSta> getZoneFaceHourData(List<Long> orgIds,Date date,ReportChart reportChart){
        //修改获取不同数据
        ZoneHourFaceRecognitionStaExample zoneHourFaceRecognitionStaExample = new ZoneHourFaceRecognitionStaExample();
        zoneHourFaceRecognitionStaExample.createCriteria().andCountdateEqualTo(date).andZoneIdIn(orgIds);
        switch (reportChart.getKey()){
            case REPORTCUSTOMERMANTIME:
                zoneHourFaceRecognitionStaExample.createColumns().hasZoneIdColumn().hasCustomMantimeColumn().hasCounttimeColumn();
                break;
            case REPORTCUSTOMERCOUNT:
                zoneHourFaceRecognitionStaExample.createColumns().hasZoneIdColumn().hasCustomCountColumn().hasCounttimeColumn();
                break;
            case REPORTCUSTOMERMANTIMEANDCOUNT:
                zoneHourFaceRecognitionStaExample.createColumns().hasZoneIdColumn().hasCustomCountColumn().hasCustomMantimeColumn().hasCounttimeColumn();
                break;
        }
        return zoneHourFaceRecognitionStaService.selectByExample(zoneHourFaceRecognitionStaExample);
    }

    /**
    * @Description: 获取对应的区域id和区域名称
    * @Param: [orgIds]
    * @return: java.util.Map<java.lang.Long,java.lang.String>
    * @Date: 2019/2/19
    */ 
    private Map<Long,String> getZones(List<Long> orgIds){
        ZoneExample zoneExample = new ZoneExample();
        zoneExample.createColumns().hasNameColumn().hasIdColumn();
        zoneExample.createCriteria().andIdIn(orgIds);
        List<Zone> zones = zoneService.selectByExample(zoneExample);
        return zones.stream().collect(Collectors.toMap(Zone::getId,Zone::getName));
    }
}
