package com.viontech.mall.report.service.impl;

import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.service.adapter.AbstractReportDataService;
import com.viontech.mall.report.service.adapter.SaleDataService;
import com.viontech.mall.report.service.adapter.ZoneDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import com.viontech.mall.service.adapter.SaleService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class ZoneReportDataServiceImpl extends AbstractReportDataService implements ZoneReportDataService {
	
	@Resource
	private ZoneDataService zoneDataService;
	
	@Resource
	private SaleDataService saleDataService;
	
	@Resource
	private ZoneService zoneService;
	
	@Resource
	private SaleService saleService;

	
	/**获取多个店铺时间段的小时级的客流数据*/
	@SuppressWarnings("unchecked")
	public List<ZoneHourCountData>  getOrQueryZoneBetweenDateHourTraffic(Long[] zoneIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<ZoneHourCountData> datas = (List<ZoneHourCountData>) dataMap.get(KEY_ZONE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneHourCountData>();
			List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
			datas = (List<ZoneHourCountData>) zoneDataService.getHourData(dates, Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个店铺时间点的小时级的客流数据*/
	@SuppressWarnings("unchecked")
	public List<ZoneHourCountData>  getOrQueryZoneInDatesHourTraffic(Long[] zoneIds,List<Date> dates ,Map<String,Object> dataMap){
		List<ZoneHourCountData> datas = (List<ZoneHourCountData>) dataMap.get(KEY_ZONE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneHourCountData>();
			datas = (List<ZoneHourCountData>) zoneDataService.getHourData(dates, Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个店铺时间点的10分钟级的客流数据*/
	@Override
	public List<ZoneMinuteCountData>  getOrQueryZoneInDates10MinetuTraffic(Long[] zoneIds,List<Date> dates,Map<String,Object> dataMap){
		List<ZoneMinuteCountData> datas = (List<ZoneMinuteCountData>) dataMap.get(KEY_10MINUTE_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneMinuteCountData>();
			datas = (List<ZoneMinuteCountData>) zoneDataService.getMinuteData(dates, Arrays.asList(zoneIds));
			dataMap.put(KEY_10MINUTE_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个店铺时间段的天级的客流数据*/
	@Override
	public List<ZoneDayCountData> getOrQueryZoneBetweenDateDayTraffic(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneDayCountData>();
			datas = (List<ZoneDayCountData>) zoneDataService.getDayData(startDate, endDate, Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个店铺时间点的天级的客流数据*/
	@Override
	public List<ZoneDayCountData> getOrQueryZoneInDatesDayTraffic(Long[] zoneIds, List<Date> dates, Map<String, Object> dataMap) {
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneDayCountData>();
			datas = (List<ZoneDayCountData>) zoneDataService.getDayData(dates, Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个店铺时间段的天级的销售数据*/
	@SuppressWarnings("unchecked")
	public List<Sale> getOrQueryZoneBetweenDateSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			sales = saleDataService.getDayData(startDate, endDate, Arrays.asList(zoneIds), OrgType.zone);
			dataMap.put(KEY_ZONE_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取多个店铺时间点的天级的销售数据*/
	@SuppressWarnings("unchecked")
	public List<Sale> getOrQueryZoneInDatesSale(Long[] zoneIds, List<Date> dates, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			sales = saleDataService.getDayData(dates, Arrays.asList(zoneIds), OrgType.zone);
			dataMap.put(KEY_ZONE_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取店铺的人脸数据*/
	public List<ZoneDayFaceRecognitionSta> getOrQueryZoneDayFaceRecognitionStas(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		//人脸
		List<ZoneDayFaceRecognitionSta> zoneFaceDatas= (List<ZoneDayFaceRecognitionSta>) dataMap.get(KEY_FACE_DATA);
		if (dataMap.get(KEY_FACE_DATA) == null) {
			zoneFaceDatas = new ArrayList<ZoneDayFaceRecognitionSta>();
			zoneFaceDatas = (List<ZoneDayFaceRecognitionSta>) zoneDataService.getFaceDayData(startDate, endDate, Arrays.asList(zoneIds));
			dataMap.put(KEY_FACE_DATA,zoneFaceDatas);
		}
		return zoneFaceDatas;
	}
	
	/**根据店铺id获取店铺信息*/
	public Zone getOrQueryZoneById(Long zoneId,Map<String,Object> dataMap){
		Map<Long, Zone> zoneMaps =  (Map<Long, Zone>) dataMap.get(KEY_ZONE_INFO);
		if (zoneMaps == null) {
			zoneMaps = new HashMap<Long, Zone>();
			ZoneExample example = new ZoneExample();
			List<Zone> zones = zoneService.selectByExample(example);
			if (zones != null) {
				for (Zone zone : zones) {
					Long Id = zone.getId();
					zoneMaps.put(Id, zone);
				}
			}
			dataMap.put(KEY_ZONE_INFO, zoneMaps);
		}
		return zoneMaps.get(zoneId);
	}
	
	
	
	/**
	 * 把店铺的人脸数据转成通用人脸数据类中
	 * @param zoneFaceDatas
	 * @return
	 */
	public List<FaceVo> convertFace2Data(List<ZoneDayFaceRecognitionSta> zoneFaceDatas){
		List<FaceVo> faceVos = new ArrayList<FaceVo>();
		if (zoneFaceDatas != null && zoneFaceDatas.size() > 0) {
			for (ZoneDayFaceRecognitionSta faceData : zoneFaceDatas) {
				FaceVo faceVo = new FaceVo();
				faceVo.setPersonMantime(faceData.getPersonMantime());
				faceVo.setPersonCount(faceData.getPersonCount());
				faceVo.setCustomMantime(faceData.getCustomMantime());
				faceVo.setCustomCount(faceData.getCustomCount());
				faceVo.setMaleMantime(faceData.getMaleMantime());
				faceVo.setMaleCount(faceData.getMaleCount());
				faceVo.setFemaleMantime(faceData.getFemaleMantime());
				faceVo.setFemaleCount(faceData.getFemaleCount());
				faceVo.setStaffMantime(faceData.getStaffMantime());
				faceVo.setStaffCount(faceData.getStaffCount());
				faceVo.setCountdate(faceData.getCountdate());
				faceVo.setMallId(faceData.getMallId());
				faceVo.setAccountId(faceData.getAccountId());
				faceVo.setFloorId(faceData.getFloorId());
				faceVo.setZoneId(faceData.getZoneId());
				faceVo.setMaleStage(faceData.getMaleStage());
				faceVo.setFemaleStage(faceData.getFemaleStage());
				faceVos.add(faceVo);
			}
		}
		return faceVos;
	}
	
	/**
	 * 把店铺的小时客流、天级客流、销售    数据转成通用的数据类
	 * @param datas
	 * @return
	 */
	public   <T> List<DataVo> convert2Data(List<T> datas){
		List<DataVo> dataVos = new ArrayList<DataVo>();
		
		if (datas != null && datas.size() > 0) {
			boolean typeFlag = false;
			//泛型类型   1：ZoneHourCountData  2： ZoneDayCountData  3: Sale 4:minuteCountDate
			int type = 0;
			for (T t : datas) {
				if (!typeFlag) {
					if(t instanceof ZoneHourCountData){
						type = 1;
						typeFlag = true;
					}else if (t instanceof ZoneDayCountData) {
						type = 2;
						typeFlag = true;
					}else if (t instanceof Sale) {
						type = 3;
						typeFlag = true;
					}else if (t instanceof ZoneMinuteCountData) {
						type = 4;
						typeFlag = true;
					}
				}
				DataVo dataVo = new DataVo();
				dataVo.setDataType(type);
				switch (type) {
				case 1:
					ZoneHourCountData hourData = (ZoneHourCountData) t;
					dataVo.setZoneId(hourData.getZoneId());
					dataVo.setFloorId(hourData.getFloorId());
					dataVo.setMallId(hourData.getMallId());
					dataVo.setAccountId(hourData.getAccountId());
					dataVo.setDate(hourData.getCountdate());
					dataVo.setTime(hourData.getCounttime());
					dataVo.setOutnum(hourData.getOutnum());
					dataVo.setInnum(hourData.getInnum());
					dataVo.setPassInnum(hourData.getOutsideInnum());
					dataVo.setPassOutnum(hourData.getOutsideOutnum());
					dataVos.add(dataVo);
					break;
				case 2:
					ZoneDayCountData dayData = (ZoneDayCountData) t;
					dataVo.setZoneId(dayData.getZoneId());
					dataVo.setFloorId(dayData.getFloorId());
					dataVo.setMallId(dayData.getMallId());
					dataVo.setAccountId(dayData.getAccountId());
					dataVo.setDate(dayData.getCountdate());
					dataVo.setTime(dayData.getCounttime());
					dataVo.setOutnum(dayData.getOutnum());
					dataVo.setInnum(dayData.getInnum());
					dataVo.setPassInnum(dayData.getOutsideInnum());
					dataVo.setPassOutnum(dayData.getOutsideOutnum());
					dataVos.add(dataVo);
					break;
				case 3:
					Sale sale = (Sale) t;
					dataVo.setZoneId(sale.getZoneId());
					dataVo.setFloorId(sale.getFloorId());
					dataVo.setMallId(sale.getMallId());
					dataVo.setSaleCount(sale.getSalecount());
					dataVo.setDate(sale.getSaledate());
					dataVo.setMoney(sale.getMoney());
					dataVos.add(dataVo);
					break;
				case 4:
					ZoneMinuteCountData minuteData = (ZoneMinuteCountData) t;
					dataVo.setZoneId(minuteData.getZoneId());
					dataVo.setFloorId(minuteData.getFloorId());
					dataVo.setMallId(minuteData.getMallId());
					dataVo.setAccountId(minuteData.getAccountId());
					dataVo.setDate(minuteData.getCountdate());
					dataVo.setTime(minuteData.getCounttime());
					dataVo.setOutnum(minuteData.getOutnum());
					dataVo.setInnum(minuteData.getInnum());
					dataVo.setPassInnum(minuteData.getOutsideInnum());
					dataVo.setPassOutnum(minuteData.getOutsideOutnum());
					dataVos.add(dataVo);
					break;
				default:
					break;
				}
				
			}
			
		}
		
		return dataVos;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
//-----------------------------------------------------------------以下代码以后需要修改---------------------------------------------------------------//
	/**获取店铺近5年 的客流数据 */
	@SuppressWarnings("unchecked")
	public List<ZoneDayCountData> getNear5YearZoneTraffic(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear5YearDates(startDate, endDate));
			datas = (List<ZoneDayCountData>) zoneDataService.getDayData(dates, Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取店铺近5年 的销售数据 */
	@SuppressWarnings("unchecked")
	public List<Sale> getNear5YearZoneSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(getNear5YearDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(zoneIds, new ArrayList<Date>(dates), dataMap);
			dataMap.put(KEY_ZONE_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取店铺近三月 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<ZoneDayCountData> getNear3MonthZoneTraffic(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear6MonthDates(startDate, endDate));
			datas = (List<ZoneDayCountData>) zoneDataService.getDayData(dates, Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取店铺近三月 的销售数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<Sale> getNear3MonthZoneSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(getNear3MonthDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(zoneIds, new ArrayList<Date>(dates), dataMap);
			dataMap.put(KEY_ZONE_DAY_SALE, sales);
		}
		return sales;
	}
	
	
	/**获取店铺近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<ZoneDayCountData> getNear3WeekZoneTraffic(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(get8WeekDates(startDate, endDate));
			datas = (List<ZoneDayCountData>) zoneDataService.getDayData(dates, Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	public List<ZoneDayCountData> getNear3WeekZoneTraffic(Long zoneId, Date startDate, Date endDate, Map<String, Object> dataMap){
		return getNear3WeekZoneTraffic(new Long[]{zoneId},startDate,endDate,dataMap);
	}
	
	/**获取店铺近三周 的销售数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<Sale> getNear3WeekZoneSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(get3WeekDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(zoneIds, new ArrayList<Date>(dates), dataMap);
			dataMap.put(KEY_ZONE_DAY_SALE, sales);
		}
		return sales;
	}
	public List<Sale> getNear3WeekZoneSale(Long zoneId, Date startDate, Date endDate, Map<String, Object> dataMap){
		return getNear3WeekZoneSale(new Long[]{zoneId},startDate,endDate,dataMap);
	}
	
	/**获取店铺的销售数据  当天   昨天  上周同期     上月同期    上年同期   近15天*/
	public List<Sale> getZoneNear15DaySales(Long[] zoneIds,Date date,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			sales = getOrQueryZoneSales(zoneIds, startDate, date, dataMap);
		}
		return sales;
	}
	public List<Sale> getZoneNear15DaySales(Long zoneId,Date date,Map<String,Object> dataMap){
		return getZoneNear15DaySales(new Long[]{zoneId},date,dataMap);
	}
	/**获取店铺天级的客流数据   近15天*/
	public List<ZoneDayCountData> getZoneNear15DayTraffic(Long[] zoneIds,Date date,Map<String,Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			datas = getOrQueryZoneDayTraffic(zoneIds, startDate, date, dataMap);
		}
		return datas;
	}
	public List<ZoneDayCountData> getZoneNear15DayTraffic(Long zoneId,Date date,Map<String,Object> dataMap){
		return getZoneNear15DayTraffic(new Long[]{zoneId},date,dataMap);
	}
	/**获取店铺的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期  (当天)*/
	public List<ZoneHourCountData> getZoneNearCurrentDayHourTraffic(Long[] zoneIds,Date date,Map<String,Object> dataMap){
		List<ZoneHourCountData> datas = (List<ZoneHourCountData>) dataMap.get(KEY_ZONE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = getOrQueryZoneHourTraffic(zoneIds, date, date, dataMap);
		}
		return datas;
	}
	public List<ZoneHourCountData> getZoneNearCurrentDayHourTraffic(Long zoneId,Date date,Map<String,Object> dataMap){
		return getZoneNearCurrentDayHourTraffic(new Long[]{zoneId},date,dataMap);
	}
	
	/**
	 * 获取多个店铺的销售额   近n天的（当天+上周同期+上月同期+上年同期）
	 * @param zoneId
	 * @param startDate  起始时间
	 * @param endDate	 结束日期
	 * @param dataMap
	 * @return
	 */
	public List<Sale> getOrQueryZoneSales(Long[] zoneIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			sales = new ArrayList<Sale>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			sales = querySalesByDatesAndOrgIds(zoneIds, new ArrayList<Date>(dates), dataMap);
			dataMap.put(KEY_ZONE_DAY_SALE, sales);
		}
		return sales;
	}
	public List<Sale> getOrQueryZoneSales(Long zoneId,Date startDate,Date endDate,Map<String,Object> dataMap){
		return getOrQueryZoneSales(new Long[]{zoneId},startDate,endDate,dataMap);
	}
	
	/**
	 * 获取多个店铺近段日期       所有的日期的  当天+ 上周同期 + 上月同期+ 上年同期的客流数据  
	 * @param zoneId
	 * @param tartDate
	 * @param endDate
	 * @param dataMap
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List<ZoneDayCountData> getOrQueryZoneDayTraffic(Long[] zoneIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneDayCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<ZoneDayCountData>) zoneDataService.getDayData(new ArrayList<Date>(dates), Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	public List<ZoneDayCountData> getOrQueryZoneDayTraffic(Long zoneId,Date startDate,Date endDate,Map<String,Object> dataMap){
		return getOrQueryZoneDayTraffic(new Long[]{zoneId},startDate,endDate,dataMap);
	}
	
	/**获取多个店铺小时级的客流数据     近n天的数据+上周同期+上月同期+上年同期*/
	@SuppressWarnings("unchecked")
	public List<ZoneHourCountData>  getOrQueryZoneHourTraffic(Long[] zoneIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<ZoneHourCountData> datas = (List<ZoneHourCountData>) dataMap.get(KEY_ZONE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneHourCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<ZoneHourCountData>) zoneDataService.getHourData(new ArrayList<Date>(dates), Arrays.asList(zoneIds));
			dataMap.put(KEY_ZONE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	public List<ZoneHourCountData>  getOrQueryZoneHourTraffic(Long zoneId,Date startDate,Date endDate,Map<String,Object> dataMap){
		return getOrQueryZoneHourTraffic(new Long[]{zoneId},startDate,endDate,dataMap);
	}
}
