package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.FloorDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import com.viontech.mall.report.util.AgeProcessUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

@Service
public class ZoneDayReportServiceImpl extends AbstractZoneReportServiceImpl {

	@Value("${Age.stage}")
	private String ageStage;

	@Resource
	private FloorDataService floorDataService;
	
	@Resource
	private ZoneReportDataService zoneReportDataService;

	/**累计客流*/
	private final String FIELD_ZONE_ACCUMULATIVE_TRAFFIC = "accumulativeTraffic";
	/**累计销售额*/
	private final String FIELD_ACCUMULATIVE_SALE ="accumulativeSale";
	/**进店率*/
	private final String FIELD_ENTERINGRATE = "enteringRate";
	/**客流占比*/
	private final String FIELD_RATIOOFTRAFFIC ="trafficRatio";
	/**滞留时间*/
	private final String FIELD_DURATIONTIME ="durationTime";
	/**坪效*/
	private final String FIELD_PERSQUAREMETER ="perSquaremeter";
	/**成交量*/
	private final String FIELD_TURNOVER = "turnover";
	/**客单价*/
	private final String FIELD_PERCUSTOMERTRANSACTION = "perTransaction";
	/**提袋率*/
	private final String FIELD_HANDBAGRATE = "handbagRate";
	
	
	/**店铺顾客特征--性别分布*/
	private final String REPORT_ZONE_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**店铺顾客特征--年龄分布*/
	private final String REPORT_ZONE_CUSTOMERFEATURE_AGE ="customerfeature_age";
	/**店铺顾客特征--新老顾客*/
	private final String REPORT_ZONE_CUSTOMERFEATURE_NAO ="customerfeature_NAO";
	/**店铺实时客流*/
	private final String REPORT_ZONE_DAY_HOUR_TRAFFIC = "hourTrafficTrend";
	/**店铺累计客流*/
	private final String REPORT_ZONE_DAY_HOUR_ACCUMULATIVETRAFFIC ="accumulativeTraffic";
	/**店铺近期客流趋势*/
	private final String REPORT_ZONE_DAY_TRAFFIC_TREND7 = "trafficTrend7";
	private final String REPORT_ZONE_DAY_TRAFFIC_TREND15 = "trafficTrend15";
	private final String REPORT_ZONE_DAY_TRAFFIC_TREND30 = "trafficTrend30";
	/**店铺近期销售额趋势*/
	private final String REPORT_ZONE_DAY_SALE_TREND7 = "SaleTrend7";
	private final String REPORT_ZONE_DAY_SALE_TREND15 = "SaleTrend15";
	private final String REPORT_ZONE_DAY_SALE_TREND30 = "SaleTrend30";
	/**店铺近期进店率趋势*/
	private final String REPORT_ZONE_DAY_ENTERINGRATE_TREND7 = "EnteringRateTrend7";
	private final String REPORT_ZONE_DAY_ENTERINGRATE_TREND15 = "EnteringRateTrend15";
	private final String REPORT_ZONE_DAY_ENTERINGRATE_TREND30 = "EnteringRateTrend30";
	/**店铺近期客单价趋势*/
	private final String REPORT_ZONE_DAY_PERTRANSACTION_TREND7 = "PerTransactionTrend7";
	private final String REPORT_ZONE_DAY_PERTRANSACTION_TREND15 = "PerTransactionTrend15";
	private final String REPORT_ZONE_DAY_PERTRANSACTION_TREND30 = "PerTransactionTrend30";
	/**店铺近期坪效趋势*/
	private final String REPORT_ZONE_DAY_PERSQUARE_TREND7 = "PerSquareTrend7";
	private final String REPORT_ZONE_DAY_PERSQUARE_TREND15 = "PerSquareTrend15";
	private final String REPORT_ZONE_DAY_PERSQUARE_TREND30 = "PerSquareTrend30";
	/**店铺近期提袋率趋势*/
	private final String REPORT_ZONE_DAY_HANDBAGRATE_TREND7 = "HandbagRateTrend7";
	private final String REPORT_ZONE_DAY_HANDBAGRATE_TREND15 = "HandbagRateTrend15";
	private final String REPORT_ZONE_DAY_HANDBAGRATE_TREND30 = "HandbagRateTrend30";
	/**店铺近期滞留时间趋势*/
	private final String REPORT_ZONE_DAY_DURATIONTIME_TREND7 = "durationtimeTrend7";
	private final String REPORT_ZONE_DAY_DURATIONTIME_TREND15 = "durationtimeTrend15";
	private final String REPORT_ZONE_DAY_DURATIONTIME_TREND30 = "durationtimeTrend30";

	/** 商场面积 */
	private  final String FIELD_ZONE_OPENED_AREA = "zoneArea";
	/** 日客流环比 */
	private  final String FIELD_DAY_COMPARED_INNUM = "comparedInnum";

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate,Map<String, Object> dataMap) {
		Date date = startDate;
		Long orgId = orgIds[0];
		Map<String, Object> head = new HashMap<String, Object>();
		Zone zone = getOrQueryZoneById(orgId, dataMap);
		/** 商场面积 */
		head.put(FIELD_ZONE_OPENED_AREA,zone.getArea());
		//今日累计客流
		Map<DateType, List<ZoneHourCountData>> zoneHourMapData = getOrQueryZoneHourMapData(orgId, date, dataMap);
		List<ZoneHourCountData> zoneHourDatas = zoneHourMapData.get(DateType.TODAY);
		Integer allInnum = null,outsideNum = null,stayNum = null;
		Long floorId = null;
		if (zoneHourDatas != null && zoneHourDatas.size() > 0) {
			outsideNum = 0;allInnum = 0;stayNum = 0;
			for (ZoneHourCountData zoneHourCountData : zoneHourDatas) {
				floorId = zoneHourCountData.getFloorId();
				allInnum += zoneHourCountData.getInnum();
				Integer outside_innum = Optional.ofNullable(zoneHourCountData.getOutsideInnum()).orElse(0);
				Integer outside_outnum = Optional.ofNullable(zoneHourCountData.getOutsideInnum()).orElse(0);
				outsideNum +=(outside_innum + outside_outnum);
				int zoneNowNum = zoneHourCountData.getInnum() - zoneHourCountData.getOutnum() ;
				stayNum += (zoneNowNum < 0 ? 0 : zoneNowNum);
			}
		}
		head.put(FIELD_ZONE_ACCUMULATIVE_TRAFFIC, allInnum);
		//日客流环比
		List<ZoneHourCountData> yesterdayHourDatas = zoneHourMapData.get(DateType.YESTERDAY);
		Integer comparedInnum = null;
		if (yesterdayHourDatas!= null && yesterdayHourDatas.size() >0) {
			comparedInnum = 0;
			for (ZoneHourCountData zoneHourCountData : yesterdayHourDatas) {
				comparedInnum += zoneHourCountData.getInnum();
			}
		}
		String trafficgrowRate = NumberUtil.growthRate(allInnum, comparedInnum);
		if (trafficgrowRate != null) {
			head.put(FIELD_DAY_COMPARED_INNUM,trafficgrowRate.replace("%", ""));
		}

		//客流占比
		Integer floorInnum = null;
		List<FloorHourCountData> floorHourDatas =  null;
		if (floorId != null) {
			floorHourDatas = (List<FloorHourCountData>) floorDataService.getHourData(date, floorId);
		}
		if (floorHourDatas != null && floorHourDatas.size() > 0) {
			floorInnum = 0;
			for (FloorHourCountData floorHourCountData : floorHourDatas) {
				floorInnum += floorHourCountData.getInnum();
			}
		}
		Double trafficRatio = NumberUtil.percentage(allInnum, floorInnum, 2);
		head.put(FIELD_RATIOOFTRAFFIC, trafficRatio);
		//滞留时间
		Double stayTime = NumberUtil.divide(stayNum, allInnum, 2);
		head.put(FIELD_DURATIONTIME, stayTime);

		//有效客流、店员人才、男性顾客人数、女性顾客人数
		Integer effectiveTraffic = null;
		Integer staffTime = null;
		Integer maleTraffic = null;
		Integer femaleTraffic = null;

		//获取系统配置参数
		Long mallId = Optional.ofNullable(zone.getMallId()).orElse(0L);
		Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
		ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
		String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");

		List<ZoneDayFaceRecognitionSta> datas = getOrQueryZoneDayFaceRecognitionStaData(orgId, date, date, dataMap);
		if (datas != null && datas.size() > 0){
			for (ZoneDayFaceRecognitionSta faceData : datas) {
				//计算有效客流
				if (effectiveTraffic == null){
					if("0".equals(enableTrafficFlag))
						effectiveTraffic = faceData.getCustomCount();
					else
						effectiveTraffic = faceData.getMaleCount()+faceData.getFemaleCount();
				}else{
					if("0".equals(enableTrafficFlag))
						effectiveTraffic = faceData.getCustomCount();
					else
						effectiveTraffic = faceData.getMaleCount()+faceData.getFemaleCount();
				}
				if(faceData.getStaffCount() != null){
					if (staffTime == null)
						staffTime = faceData.getStaffMantime();
					else
						staffTime += faceData.getStaffMantime();
				}
				if(faceData.getMaleCount() != null){
					if (maleTraffic == null)
						maleTraffic = faceData.getMaleCount();
					else
						maleTraffic += faceData.getMaleCount();
				}
				if(faceData.getFemaleCount() != null){
					if (femaleTraffic == null)
						femaleTraffic = faceData.getFemaleCount();
					else
						femaleTraffic += faceData.getFemaleCount();
				}
			}
		}
		head.put(FIELD_ENABLE_INNUM,effectiveTraffic);
		head.put(FIELD_STAFF_INNUM,staffTime);
		head.put(FIELD_MALE_INNUM,maleTraffic);
		head.put(FIELD_FEMALE_INNUM,femaleTraffic);

		//进店率
		Double enterRate = 0.0;
		ConfigParams enterRateConfig = configParamsMap.get("enterRateConfig");
		String enterRateConfigFlag = Optional.ofNullable(enterRateConfig.getValue()).orElse("0");
		if ("0".equals(enterRateConfigFlag)){
			Number outsideTraffic = (Number) NumberUtil.valueAdd(outsideNum,allInnum);
			enterRate = NumberUtil.percentage(allInnum, outsideTraffic, 2);
		}else if ("1".equals(enterRateConfigFlag)){
			Number outsideTraffic = (Number) NumberUtil.valueAdd(outsideNum,effectiveTraffic);
			enterRate =NumberUtil.percentage(effectiveTraffic, outsideTraffic, 2);
		}else if ("2".equals(enterRateConfigFlag)){
			enterRate =NumberUtil.percentage(allInnum, outsideNum, 2);
		}else {
			enterRate =NumberUtil.percentage(effectiveTraffic, outsideNum, 2);
		}
		head.put(FIELD_ENTERINGRATE, enterRate);

		/**累计销售额*/
		List<Sale> sales = getOrQueryTodayZoneSales(orgId, date, dataMap);
		Double accumulativeSale =null,saleMoney = null;
		Integer saleCount = null;
		if (sales != null && sales.size() > 0) {
			accumulativeSale = 0.0;saleMoney = 0.0;
			saleCount = 0;
			for (Sale sale : sales) {
				accumulativeSale += sale.getMoney();
				saleMoney += sale.getMoney();
				saleCount += sale.getSalecount();
			}
		}
		head.put(FIELD_ACCUMULATIVE_SALE, accumulativeSale);
		/**坪效*/
		Float zoneArea = null;
		if (zone != null && zone.getArea() != null) {
			zoneArea = zone.getArea();
		}
		head.put(FIELD_PERSQUAREMETER, NumberUtil.divide(accumulativeSale, zoneArea, 2));
		/**成交量*/
		head.put(FIELD_TURNOVER, saleCount);
		/**客单价*/
		head.put(FIELD_PERCUSTOMERTRANSACTION, NumberUtil.divide(accumulativeSale, saleCount, 2));
		/**提袋率*/
		head.put(FIELD_HANDBAGRATE, NumberUtil.percentage(saleCount, allInnum, 2));
		return head;
	}

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Date date = startDate;
		Long orgId = orgIds[0];
		Chart chart = null;
		switch (reportChart.getKey()) {
		case REPORT_ZONE_CUSTOMERFEATURE_GENDER:/**店铺顾客特征--性别分布*/
			chart =  genderDistributionReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_ZONE_CUSTOMERFEATURE_AGE:/**店铺顾客特征--年龄分布*/
			chart = ageDistributionReport(orgId, date,  dataMap, reportChart);		
			break;
		case REPORT_ZONE_CUSTOMERFEATURE_NAO:/**店铺顾客特征--新老顾客*/
			//chart = visitorStatisticReport(orgId, date,  dataMap, reportChart);
			break;
		case REPORT_ZONE_DAY_HOUR_TRAFFIC:/**店铺实时客流*/
			chart =  trafficCountingReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_ZONE_DAY_HOUR_ACCUMULATIVETRAFFIC:/**店铺累计客流*/
			chart = trafficAddReport(orgId, date,  dataMap, reportChart);		
			break;
		case REPORT_ZONE_DAY_TRAFFIC_TREND7:/**店铺近期客流趋势*/
			chart = trafficTrendReport(orgId, date,  dataMap, reportChart,-6);
			break;
		case REPORT_ZONE_DAY_TRAFFIC_TREND15:/**店铺近期客流趋势*/
			chart = trafficTrendReport(orgId, date,  dataMap, reportChart,-14);
			break;
		case REPORT_ZONE_DAY_TRAFFIC_TREND30:/**店铺近期客流趋势*/
			chart = trafficTrendReport(orgId, date,  dataMap, reportChart,-29);
			break;
		case REPORT_ZONE_DAY_SALE_TREND7:/**店铺近期销售额趋势*/
			chart = SaleTrendReport(orgId, date,  dataMap, reportChart,-6);
			break;
		case REPORT_ZONE_DAY_SALE_TREND15:/**店铺近期销售额趋势*/
			chart = SaleTrendReport(orgId, date,  dataMap, reportChart,-14);
			break;
		case REPORT_ZONE_DAY_SALE_TREND30:/**店铺近期销售额趋势*/
			chart = SaleTrendReport(orgId, date,  dataMap, reportChart,-29);
			break;
		case REPORT_ZONE_DAY_ENTERINGRATE_TREND7:/**店铺近期进店率趋势*/
			chart = EnteringRateTrendReport(orgId, date,  dataMap, reportChart,-6);
			break;
		case REPORT_ZONE_DAY_ENTERINGRATE_TREND15:/**店铺近期进店率趋势*/
			chart = EnteringRateTrendReport(orgId, date,  dataMap, reportChart,-14);
			break;
		case REPORT_ZONE_DAY_ENTERINGRATE_TREND30:/**店铺近期进店率趋势*/
			chart = EnteringRateTrendReport(orgId, date,  dataMap, reportChart,-29);
			break;
		case REPORT_ZONE_DAY_PERTRANSACTION_TREND7:/**店铺近期客单价趋势*/
			chart = PerTransactionTrendReport(orgId, date,  dataMap, reportChart,-6);
			break;
		case REPORT_ZONE_DAY_PERTRANSACTION_TREND15:/**店铺近期客单价趋势*/
			chart = PerTransactionTrendReport(orgId, date,  dataMap, reportChart,-14);
			break;
		case REPORT_ZONE_DAY_PERTRANSACTION_TREND30:/**店铺近期客单价趋势*/
			chart = PerTransactionTrendReport(orgId, date,  dataMap, reportChart,-29);
			break;
		case REPORT_ZONE_DAY_PERSQUARE_TREND7:/**店铺近期坪效趋势*/
			chart = PerSquareTrendReport(orgId, date,  dataMap, reportChart,-6);
			break;
		case REPORT_ZONE_DAY_PERSQUARE_TREND15:/**店铺近期坪效趋势*/
			chart = PerSquareTrendReport(orgId, date,  dataMap, reportChart,-14);
			break;
		case REPORT_ZONE_DAY_PERSQUARE_TREND30:/**店铺近期坪效趋势*/
			chart = PerSquareTrendReport(orgId, date,  dataMap, reportChart,-29);
			break;
		case REPORT_ZONE_DAY_HANDBAGRATE_TREND7:/**店铺近期提袋率趋势*/
			chart = HandbagRateTrendReport(orgId, date,  dataMap, reportChart,-6);
			break;
		case REPORT_ZONE_DAY_HANDBAGRATE_TREND15:/**店铺近期提袋率趋势*/
			chart = HandbagRateTrendReport(orgId, date,  dataMap, reportChart,-14);
			break;
		case REPORT_ZONE_DAY_HANDBAGRATE_TREND30:/**店铺近期提袋率趋势*/
			chart = HandbagRateTrendReport(orgId, date,  dataMap, reportChart,-29);
			break;
		case REPORT_ZONE_DAY_DURATIONTIME_TREND7:/**店铺近期滞留时间趋势*/
			chart = DurationTimeTrendReport(orgId, date,  dataMap, reportChart,-6);
			break;
		case REPORT_ZONE_DAY_DURATIONTIME_TREND15:/**店铺近期滞留时间趋势*/
			chart = DurationTimeTrendReport(orgId, date,  dataMap, reportChart,-14);
			break;
		case REPORT_ZONE_DAY_DURATIONTIME_TREND30:/**店铺近期滞留时间趋势*/
			chart = DurationTimeTrendReport(orgId, date,  dataMap, reportChart,-29);
			break;
		default:
			break;
		}
		
		return chart;
	}
	/**店铺近期滞留时间趋势*/
	private Chart DurationTimeTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.DURATIONTIME.toString());
		
		Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
		List<Date> containDate = DateUtil.getDaysBetweenDates(beforeDate, date);
		Map<Date, List<ZoneHourCountData>> datas = getOrQueryZoneHourMapData(orgId, startDate, date, dataMap);
		for (Entry<Date, List<ZoneHourCountData>> entry : datas.entrySet()) {
			Date keyDate = entry.getKey();
			if (containDate.contains(keyDate)) {
				List<ZoneHourCountData> zoneHourDatas = entry.getValue();
				int innumHour = 0,innumDay = 1;
				for (ZoneHourCountData zoneHourCountData : zoneHourDatas) {
					innumHour += zoneHourCountData.getInnum();
				}
				List<ZoneDayCountData> todayZoneDatas = getOrQueryZoneTodayDayTraffic(orgId, keyDate, dataMap);
				if (todayZoneDatas != null && todayZoneDatas.size() > 0) {
					innumDay = todayZoneDatas.get(0).getInnum();
				}
				chart.getSeries(ParamName.DURATIONTIME.toString()).adjustOrPutValueByCoordinate(keyDate, 
						NumberUtil.divide(innumHour, innumDay, 2));
				
			}
		}
		
		return chart;
	}
	/**店铺近期提袋率趋势*/
	private Chart HandbagRateTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.HANDBAGRATE.toString());
		
		List<ZoneDayCountData> zoneDatas = getOrQueryZoneDayTraffic(orgId, date, dataMap);
		Map<Date, ZoneDayCountData> zoneDataMap = new HashMap<Date, ZoneDayCountData>();
		for (ZoneDayCountData zoneDayCountData : zoneDatas) {
			zoneDataMap.put(zoneDayCountData.getCountdate(), zoneDayCountData);
		}
		
		List<Sale> sales = getOrQueryZoneSales(orgId, date, dataMap);
		if (sales != null && sales.size() > 0) {
			List<Date> containDates = DateUtil.getDaysBetweenDates(beforeDate, date);
			for (Sale sale : sales) {
				Date saleDate = sale.getSaledate();
				int innum = zoneDataMap.get(saleDate).getInnum();
				if (containDates.contains(saleDate)) {
					chart.getSeries(ParamName.HANDBAGRATE.toString()).adjustOrPutValueByCoordinate(saleDate,
							NumberUtil.percentage(sale.getSalecount(), innum, 2));
				}
			}
		}
		return chart;
	}
	/**店铺近期坪效趋势*/
	private Chart PerSquareTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.PERAREAVALUE.toString());
		
		List<Sale> sales = getOrQueryZoneSales(orgId, date, dataMap);
		if (sales != null && sales.size() > 0) {
			List<Date> containDates = DateUtil.getDaysBetweenDates(beforeDate, date);
			Zone zone = getOrQueryZoneById(orgId, dataMap);
			float area = zone.getArea();
			for (Sale sale : sales) {
				Date saleDate = sale.getSaledate();
				if (containDates.contains(saleDate)) {
					chart.getSeries(ParamName.PERAREAVALUE.toString()).adjustOrPutValueByCoordinate(saleDate
							, NumberUtil.divide(sale.getMoney(), area, 2));
				}
			}
		}
		return chart;
	}
	/**店铺近期客单价趋势*/
	private Chart PerTransactionTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.PREPRICE.toString());
		
		List<Sale> sales = getOrQueryZoneSales(orgId, date, dataMap);
		if (sales != null && sales.size() > 0) {
			List<Date> containDates = DateUtil.getDaysBetweenDates(beforeDate, date);
			for (Sale sale : sales) {
				Date saleDate = sale.getSaledate();
				if (containDates.contains(saleDate)) {
					chart.getSeries(ParamName.PREPRICE.toString()).adjustOrPutValueByCoordinate(saleDate,
							NumberUtil.divide(sale.getMoney(), sale.getSalecount(), 2));
				}
			}
		}
		return chart;
	}
	/**店铺近期进店率趋势*/
	private Chart EnteringRateTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.ENTERINGRATE.toString());
		
		List<ZoneDayCountData> datas = getOrQueryZoneDayTraffic(orgId, date, dataMap);
		if (datas != null && datas.size() > 0) {
			List<Date> containDates = DateUtil.getDaysBetweenDates(beforeDate, date);
			for (ZoneDayCountData z : datas) {
				Date dataDate = z.getCountdate();
				if (containDates.contains(dataDate)) {
					int allNum =  z.getOutsideInnum()+z.getOutsideOutnum();
					chart.getSeries(ParamName.ENTERINGRATE.toString()).adjustOrPutValueByCoordinate(dataDate,NumberUtil.percentage(z.getInnum(),allNum, 2));
				}
			}
		}
		
		return chart;
	}

	/**店铺近期销售额趋势*/
	private Chart SaleTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.SALES.toString());
		//销售额
		List<Sale> sales = getOrQueryZoneSales(orgId, date, dataMap);
		List<Date> dates = DateUtil.getDaysBetweenDates(beforeDate, date);
		for (Sale sale : sales) {
			Date saleDate = sale.getSaledate();
			if (dates.contains(saleDate)) {
				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
			}
		}
		return chart;
	}
	
	/**店铺近期客流量趋势*/
	private Chart trafficTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		// 客流量
		List<ZoneDayCountData> DayTraffic = getOrQueryZoneDayTraffic(orgId, date, dataMap);
		List<Date> dates = DateUtil.getDaysBetweenDates(beforeDate, date);
		for (ZoneDayCountData DayCountData : DayTraffic) {
			Date dataTime = DayCountData.getCountdate();
			if (dates.contains(dataTime)) {
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(DayCountData.getCountdate(), DayCountData.getInnum());
			}
		}
		return chart;
	}
	
	/**店铺累计客流*/
	private Chart trafficAddReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line) {
			@Override
			public Object calcValue(String name,int index, List data) {
				Double result = null;
				if (data.get(index) != null) {
					result = Double.parseDouble(data.get(index).toString());
					if(index==0){
						return result;
					}
					int pre = index;
					while((--pre) > 0){
						if(data.get(pre) == null){
							continue;
						}
						result += Double.parseDouble(data.get(pre).toString());
						break;
					}
				}
				return result;
			}
		};
		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = zoneReportDataService.getMallOpentimesByOrgId(orgId,OrgType.zone,dataMap);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);


		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());
		
		Map<DateType, List<ZoneHourCountData>> trafficMap = getOrQueryZoneHourMapData(orgId, date, dataMap);
		
		for (Entry<DateType, List<ZoneHourCountData>> entry: trafficMap.entrySet()) {
			List<ZoneHourCountData> datas = entry.getValue();
			String SeriesName = entry.getKey().toString(); 
			for (ZoneHourCountData zoneHourCountData : datas) {
				Date counttime = zoneHourCountData.getCounttime();
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(counttime, zoneHourCountData.getInnum());
			}
		}
		return chart;
	}
	
	/**店铺实时客流*/
	private Chart trafficCountingReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = zoneReportDataService.getMallOpentimesByOrgId(orgId,OrgType.zone,dataMap);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);


		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());
		
		Map<DateType, List<ZoneHourCountData>> trafficMap = getOrQueryZoneHourMapData(orgId, date, dataMap);
		
		for (Entry<DateType, List<ZoneHourCountData>> entry: trafficMap.entrySet()) {
			List<ZoneHourCountData> datas = entry.getValue();
			String SeriesName = entry.getKey().toString(); 
			for (ZoneHourCountData zoneHourCountData : datas) {
				Date counttime = zoneHourCountData.getCounttime();
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(counttime, zoneHourCountData.getInnum());
			}
		}
		return chart;
	}

	/**店铺顾客特征--性别分布*/
	public Chart genderDistributionReport(Long orgId,  Date date,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
		
		chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());
	
		List<ZoneDayFaceRecognitionSta> datas = getOrQueryZoneDayFaceRecognitionStaData(orgId,date,date,dataMap);
		for (ZoneDayFaceRecognitionSta zoneFaceRecognitionSta : datas) {
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),zoneFaceRecognitionSta.getFemaleCount());
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), zoneFaceRecognitionSta.getMaleCount());
		}
		return chart;
	}
	
	/**店铺顾客特征--年龄分布*/
	public Chart ageDistributionReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		String[] ages = ageStage.split(",");
		List<Integer> ageStages = new ArrayList<>();
		for (String age : ages) {
			Integer ageInt = Integer.parseInt(age);
			ageStages.add(ageInt);
		}
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
		Axis<String> axis = AxisFactory.createStringAxis();
		chart.setXAxis(axis);

		List<ZoneDayFaceRecognitionSta> ageSta = getOrQueryZoneDayFaceRecognitionStaData(orgId,date,date,dataMap);
		
		if (ageSta != null && ageSta.size() >0) {
			for (ZoneDayFaceRecognitionSta ageStatistic : ageSta) {
				String maleStage = ageStatistic.getMaleStage();
				String femaleStage = ageStatistic.getFemaleStage();
				if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
					continue;
				}
				String[] maleAgestatic = maleStage.split(",", -2);
				String[] femaleAgestatic = femaleStage.split(",", -2);

				if (maleAgestatic.length != femaleAgestatic.length) {
					continue;
				}
				for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
					int maleNum = Integer.parseInt("" + maleAgestatic[rangeNum].trim());
					int femaleNum = Integer.parseInt("" + femaleAgestatic[rangeNum].trim());
					String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);
					//chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
				}
			}
		}
		return chart;
	}
	
	/**获取店铺当日的销售额*/
	private List<Sale> getOrQueryTodayZoneSales(Long zoneId,Date date,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			sales = getOrQueryZoneSales(zoneId, startDate, date, dataMap);
		}
		List<Sale> todaySales = new ArrayList<Sale>();
		for (Sale sale : sales) {
			if (DateUtil.isSameDay(date, sale.getSaledate())) {
				todaySales.add(sale);
			}
		}
		return todaySales;
	}
	
	/**获取店铺的销售数据 */
	private List<Sale> getOrQueryZoneSales(Long zoneId,Date date,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
		if (sales == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			sales = getOrQueryZoneSales(zoneId, startDate, date, dataMap);
		}
		return sales;
	}
	
	/**获取店铺当日的天级客流数据*/
	private List<ZoneDayCountData> getOrQueryZoneTodayDayTraffic(Long zoneId,Date date,Map<String,Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		
		if (datas == null) {
			datas = getOrQueryZoneDayTraffic(zoneId,date, dataMap);
		}
		
		List<ZoneDayCountData> dayList = new ArrayList<ZoneDayCountData>();
		for (ZoneDayCountData zoneDayCountData : datas) {
			if (DateUtil.isSameDay(date, zoneDayCountData.getCountdate())) {
				dayList.add(zoneDayCountData);
			}
		}
		return dayList;
	}
	
	/**获取店铺天级的客流数据  默认近30天*/
	private List<ZoneDayCountData> getOrQueryZoneDayTraffic(Long zoneId,Date date,Map<String,Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			datas = getOrQueryZoneDayTraffic(zoneId, startDate, date, dataMap);
		}
		return datas;
	}
	
	/**获取店铺的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期*/
	private Map<DateType,List<ZoneHourCountData>> getOrQueryZoneHourMapData(Long zoneId,Date date,Map<String,Object> dataMap){
		Map<Date,List<ZoneHourCountData>> datas = (Map<Date, List<ZoneHourCountData>>) dataMap.get(KEY_ZONE_HOUR_TRAFFIC);
		if (datas == null) {
			Date beforeDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			datas = getOrQueryZoneHourMapData(zoneId, beforeDate, date, dataMap);
		}
		Map<DateType,List<ZoneHourCountData>> dateTypeMap = new HashMap<DateType, List<ZoneHourCountData>>();
		for (Entry<Date, List<ZoneHourCountData>> entry : datas.entrySet()) {
			Date date2 = entry.getKey();
			DateType type = DateType.valueOfDay(date, date2);
			List<ZoneHourCountData> dayList = dateTypeMap.get(type);
			if (dayList == null) {
				dayList = entry.getValue();
				dateTypeMap.put(type, dayList);
			}
		}
		dataMap.put(KEY_ZONE_HOUR_TRAFFIC, datas);
		return dateTypeMap;
	}
}
