package com.viontech.mall.report.service.impl;

import com.viontech.keliu.base.BaseModel;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.service.adapter.ZoneDataService;
import com.viontech.mall.service.adapter.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service
public class ZoneDataServiceImpl extends BaseDataServiceImpl implements ZoneDataService {
	@Resource
	private ZoneDayCountDataService zoneDayCountDataService;
	@Resource
	private ZoneHourCountDataService zoneHourCountDataService;
	@Resource
	private ZoneMinuteCountDataService zoneMinuteCountDataService;
	@Resource
	private ZoneDayFaceRecognitionStaService zoneDayFaceRecognitionStaService;
	@Resource
	private ZoneHourFaceRecognitionStaService zoneHourFaceRecognitionStaService;

	@Override
	public List<? extends BaseModel> getMinuteData(List<Date> dates, List<Long> ids) {
		ZoneMinuteCountDataExample example = new ZoneMinuteCountDataExample();
		example.createColumns();
		ZoneMinuteCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andZoneIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andZoneIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else  if(dates != null && dates.size() >1) {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return zoneMinuteCountDataService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getHourData(List<Date> dates, List<Long> ids) {
		ZoneHourCountDataExample example = new ZoneHourCountDataExample();
		example.createColumns();
		ZoneHourCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andZoneIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() > 1) {
			criteria.andZoneIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else  if(dates != null && dates.size() >1)  {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return zoneHourCountDataService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getDayData(List<Date> dates, List<Long> ids) {
		ZoneDayCountDataExample example = new ZoneDayCountDataExample();
		example.createColumns();
		ZoneDayCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andZoneIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() > 1) {
			criteria.andZoneIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return zoneDayCountDataService.selectByExample(example);
	}


	@Override
	public List<? extends BaseModel> getDaysData(List<DateCriteria> dates, List<Long> ids) {
		ZoneDayCountDataExample example = new ZoneDayCountDataExample();
		example.createColumns();
		ZoneDayCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andZoneIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andZoneIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return zoneDayCountDataService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceDayData(List<Date> dates, List<Long> ids) {
		ZoneDayFaceRecognitionStaExample example = new ZoneDayFaceRecognitionStaExample();
		example.createColumns();
		ZoneDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andZoneIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andZoneIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".countdate asc");
		return zoneDayFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceHourData(List<Date> dates, List<Long> ids) {
		ZoneHourFaceRecognitionStaExample example = new ZoneHourFaceRecognitionStaExample();
		example.createColumns();
		ZoneHourFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andZoneIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andZoneIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCounttimeEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCounttimeIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return zoneHourFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceDaysData(List<DateCriteria> dates, List<Long> ids) {
		ZoneDayFaceRecognitionStaExample example = new ZoneDayFaceRecognitionStaExample();
		example.createColumns();
		ZoneDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andZoneIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andZoneIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		example.setOrderByClause(example.getTableAlias()+".countdate asc");
		return zoneDayFaceRecognitionStaService.selectByExample(example);
	}

}