package com.viontech.mall.report.service.impl;

import com.alibaba.druid.util.DaemonThreadFactory;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Row;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.*;
import java.util.Map.Entry;


@Service
public class YoYOrMoMYearReportServiceImpl extends YoYOrMoMBaseService {

	@Resource
	private ZoneReportDataService zoneReportDataService;

	@Resource
	private GateReportDataService gateReportDataService;

	@Resource
	private FloorReportDataService floorReportDataService;

	@Resource
	private MallReportDataService mallReportDataService;

	/**近3年同环比报表*/
	public static final String REPORT_3YEAR_YoY ="Near3YearYoY";
	/**本年每月同环比报表*/
	public static final String REPORT_MONTHOFYEAR_YoY ="MonthOfYearYoY";
	/**本年工作日/双休日同环比报表*/
	public static final String REPORT_WEEKDAYOREND_YoY ="WeekDayOrEndYoY";

	public static final String REPORT_THISYEARTRAFFIC_TREND = "thisYearTrafficTrend";

	public static final String REPORT_THISYEARYO_TREND = "thisYearYTrend";

	public static final String REPORT_MOREOBJECT_TABLE = "moreObjectTable";

	public static final String REPOR_MOREOBJECT_BAR = "moreObjectBar";

	public static final String REPOR_TRAFFICANDYO_BAR = "trafficAndYO";

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		Chart chart = null;
		List datas = null;

		if (orgType == OrgType.zone){
			datas = getNear3YearZoneData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.gate){
			datas = getNear3YearGateData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.floor){
			datas = getNear3YearFloorData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.mall) {
			datas = getNear3YearMallData(orgIds, startDate, endDate, dataMap, kpiType);
		}
		switch (reportChart.getKey()) {
			case REPORT_3YEAR_YoY:/**近3年同环比报表*/
				chart = YearsOfNear3YoY( startDate, endDate, datas, dataMap, reportChart,true,kpiType);
				break;
			case REPORT_MONTHOFYEAR_YoY:/**本年每月同环比报表*/
				chart = MonthsOfYearYoY(startDate, endDate, datas, dataMap, reportChart,kpiType);
				break;
			case REPORT_WEEKDAYOREND_YoY:/**本年工作日/双休日同环比报表*/
				chart = YearsOfNear3YoY(startDate, endDate, datas, dataMap, reportChart,false,kpiType);
				break;
			case REPORT_THISYEARTRAFFIC_TREND:
				chart = getThisYearTraffic(startDate,endDate,datas,reportChart);
				break;
			case REPORT_THISYEARYO_TREND:
				chart = getThisYearYTrendChart(startDate,endDate,datas,reportChart);
				break;
			case REPORT_MOREOBJECT_TABLE:
				chart = getMoreObjectTable(orgIds,startDate,dataMap,reportChart);
				break;
			case REPOR_MOREOBJECT_BAR:
				chart = getMoreObjectBar(orgIds,startDate,dataMap,reportChart);
				break;
			case REPOR_TRAFFICANDYO_BAR:
				chart = getTrafficAndYOBar(startDate,endDate,datas,reportChart);
				break;
			default:
				break;
		}
		return chart;
	}

	/**本年每月同环比
	 * @param datas   传入报表的数据
	 * @param kpiType
	 */
	private Chart MonthsOfYearYoY(Date startDate, Date endDate,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart, KPIType kpiType){

		final String dateStr = LocalMessageUtil.getMessage("month");//国际化:日期
		final String ToMD = LocalMessageUtil.getMessage("ToMD");//国际化:上月环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年环比
		final String YoBY = LocalMessageUtil.getMessage("YoBY");//国际化:前年环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int monthIndex = getIndexByTableHead(DateType.MONTH.getName());
				Number monthNum =  data.get(monthIndex) == null ? 0 : (Number) data.get(monthIndex);
				String result = "0%";
				if(getIndexByTableHead(ToMD) == index){
					Number lastmonthNum = (Number) data.get(getIndexByTableHead(DateType.LASTMONTH.getName()));
					result = NumberUtil.growthRate(monthNum, lastmonthNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastYearMonthNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARMONTH.getName()));
					result = NumberUtil.growthRate(monthNum, lastYearMonthNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else if(getIndexByTableHead(YoBY) == index){
					Number beforeLastYearMonthNum = (Number) data.get(getIndexByTableHead(DateType.BEFORELASTYEARMONTH.getName()));
					result = NumberUtil.growthRate(monthNum, beforeLastYearMonthNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else{
					return data.get(index);
				}

			}
		};

		TableHead tableHead = new TableHead();
		tableHead.addData(dateStr,DateType.MONTH.getName(),DateType.LASTMONTH.getName(),ToMD,DateType.LASTYEARMONTH.getName(),ToYD,DateType.BEFORELASTYEARMONTH.getName(),ToMD,DateType.LASTYEARDAY.getName(),YoBY);
		table.setTableHead(tableHead);

		List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
		Collections.reverse(dates);
		putValue2Table(table, datas, dates,kpiType);

		return table;
	}


	/** 得到近几个月的客流量的柱状图 */
	public Chart getThisYearTraffic(Date startDate, Date endDate, List<YoYOrMoMBaseService.Data> datas, ReportChart reportChart){
		List<String> keys = new ArrayList<>();
		int nowMonth = DateUtil.getMonth(endDate);
		for(int i= 0;i<12;i++){
			int index = nowMonth-Integer.parseInt(String.valueOf(i));
			if(index>0) {
				keys.add(i, LocalMessageUtil.getMessage("monthOfyearStrFormat", new Object[]{index}));
			}
		}
		return getRecentBar(keys,getRecentMonthYODataMap(startDate,endDate,datas,keys),startDate,reportChart);
	}

	/** 近几个月的同比趋势 */
	public Chart getThisYearYTrendChart(Date startDate, Date endDate, List<YoYOrMoMBaseService.Data> datas, ReportChart reportChart){
		List<String> keys = new ArrayList<>();
		String now = DateUtil.format("yyyy",startDate);
		String last = DateUtil.format("yyyy",DateUtil.getLastYear(startDate));
		int nowMonth = DateUtil.getMonth(endDate);
		for(int i= 0;i<12;i++){
			int index = nowMonth-Integer.parseInt(String.valueOf(i));
			if(index>0) {
				keys.add(i, LocalMessageUtil.getMessage("monthOfyearStrFormat", new Object[]{index}));
			}
		}
		Map<String,Map<String,Object>> excelMap = getRecentMonthYODataMap(startDate,endDate,datas,keys);
		Map<String,Object> YOTrendMap = new LinkedHashMap<>();
		for (Entry entry : excelMap.entrySet()){
			Map<String,Object> map = (Map<String,Object>)entry.getValue();
			String growth = NumberUtil.growthRate((Double)map.get(now),(Double)map.get(last));
			if(growth != null) {
				growth = growth.replace("%", "");
			}
			YOTrendMap.put(entry.getKey().toString(),growth);
		}
		return getYoyTrend(keys,reportChart,YOTrendMap);
	}

	/**
	 * 得到近几月的所有数据，组装为Map
	 * @param startDate
	 * @param endDate
	 * @param datas
	 * @return
	 */
	private Map<String,Map<String,Object>> getRecentMonthYODataMap(Date startDate, Date endDate, List<YoYOrMoMBaseService.Data> datas, List<String> keys){
		List<Date> dates = new ArrayList<>();
		Date endStartDate = DateUtil.getFirstDateOfMonth(endDate);
		dates.add(0,endDate);
//		dates.add(1,endStartDate);
		Date currentDate = endStartDate;
		int i = 1;
		while (currentDate.compareTo(startDate)!=-1){
			dates.add(i,currentDate);
			i++;
			currentDate = DateUtil.addMonths(currentDate,-1);
		}
//		Date startDate1 = DateUtil.getLastYear(startDate);
//		Date startDate2 = DateUtil.getLastYear(startDate1);
//		Date startDate3 = DateUtil.getLastYear(startDate2);
//		Date startDate4 = DateUtil.getLastYear(startDate3);
//		Date startDate5 = DateUtil.getLastYear(startDate4);
//		Date startDate6 = DateUtil.getLastYear(startDate5);
//		Date startDate7 = DateUtil.getLastYear(startDate6);
//		Date startDate8 = DateUtil.getLastYear(startDate7);
//		Date startDate9 = DateUtil.getLastYear(startDate8);
//		Date startDate10 = DateUtil.getLastYear(startDate9);
//		Date startDate11 = DateUtil.getLastYear(startDate10);



//		dates.add(2,startDate1);
//		dates.add(3,startDate2);
//		dates.add(4,startDate3);
//		dates.add(5,startDate4);
//		dates.add(6,startDate5);
//		dates.add(7,startDate6);
//		dates.add(8,startDate7);
//		dates.add(9,startDate8);
//		dates.add(10,startDate9);
//		dates.add(11,startDate10);
//		dates.add(12,startDate11);
//		Map<String,Map<String,Object>> resultMap = new LinkedHashMap<>();
//		for(int index = 0;i<keys.size();i++){
//			resultMap.put(keys.get(index),null);
//		}
		return getDataMap(dates,datas,keys);
	}

	/** 近3年同环比
	 * 本月工作日/双休日同环比
	 * @param orgId
	 * @param date
	 * @param datas
	 * @param dataMap
	 * @param reportChart
	 * @param kpiType
	 * @param isTimeCounting
	 * @return
	 */
	private Chart YearsOfNear3YoY(Date startDate,Date endDate,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart,boolean isNear3Month, KPIType kpiType){

		final String dateStr = LocalMessageUtil.getMessage("year");//国际化:年份
		final String YoLY = LocalMessageUtil.getMessage("YoLY");//国际化:去年环比
		final String YoBY = LocalMessageUtil.getMessage("YoBY");//国际化:前年环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int thisYear = getIndexByTableHead(DateType.YEAR.getName());
				Number thisYearNum =  data.get(thisYear) == null ? 0 : (Number) data.get(thisYear);
				String result = "0%";
				if(getIndexByTableHead(YoLY) == index){
					Number lastYearNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEAR.getName()));
					result = NumberUtil.growthRate(thisYearNum, lastYearNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(YoBY) == index){
					Number beforeLastYearNum = (Number) data.get(getIndexByTableHead(DateType.BEFORELASTYEAR.getName()));
					result = NumberUtil.growthRate(thisYearNum, beforeLastYearNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else{
					return data.get(index);
				}

			}
		};

		TableHead tableHead = new TableHead();
		List<Date> dates = null;
		try {
			if (isNear3Month) {
				tableHead.addData(dateStr,DateType.YEAR.getName(),DateType.LASTYEAR.getName(),YoLY,DateType.BEFORELASTYEAR.getName(),YoBY);
				table.setTableHead(tableHead);
				Date yearBeforLast = DateUtil.addYears(startDate, -2);
				dates = DateUtil.getDaysBetweenDates(yearBeforLast, endDate);
				Collections.reverse(dates);
				putValue2Table(table, datas, dates,kpiType,true);
			}else {
				int yearNum = DateUtil.getYear(startDate);
				String dateHeadStr = LocalMessageUtil.getMessage("Nyear",new Object[]{String.valueOf(yearNum)});//国际化:N年
				tableHead.addData(dateHeadStr,DateType.YEAR.getName(),DateType.LASTYEAR.getName(),YoLY,DateType.BEFORELASTYEAR.getName(),YoBY);
				table.setTableHead(tableHead);
				dates = DateUtil.getDaysBetweenDates(startDate, endDate);
				Collections.reverse(dates);
				putValue2Table(table, datas, dates,kpiType,false);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return table;
	}

	/**
	 * 获取近三年的店铺数据
	 * @param zoneId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3YearZoneData(Long[] zoneIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<ZoneDayCountData> zoneTraffic = zoneReportDataService.getNear5YearZoneTraffic(zoneIds, startDate, endDate, dataMap);
		List<Sale> sales = zoneReportDataService.getNear5YearZoneSale(zoneIds, startDate, endDate, dataMap);

		Map<Date, Integer> trafficMap = new HashMap<Date, Integer>();
		if (kpiType == KPIType.TRAFFIC || kpiType == KPIType.ENTERINGRATE ||kpiType == KPIType.HANDBAGRATE ||
				kpiType == KPIType.DURATIONTIME	) {
			if (zoneTraffic == null || zoneTraffic.size() <= 0 ) {
				return datas;
			}

			for (ZoneDayCountData zoneDayCountData : zoneTraffic) {
				Date date = zoneDayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = zoneDayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if ( kpiType == KPIType.ENTERINGRATE) {
					int innum = zoneDayCountData.getInnum();
					int passNum = zoneDayCountData.getOutsideInnum()+zoneDayCountData.getOutsideOutnum();
					Data data = new Data(null, date, innum, passNum);
					datas.add(data);
				}else if (kpiType == KPIType.HANDBAGRATE) {
					int innum = zoneDayCountData.getInnum();
					trafficMap.put(date, innum);
				}else if (kpiType == KPIType.DURATIONTIME) {
					int innum = zoneDayCountData.getInnum();
					List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(zoneIds, date, dataMap);
					int allHourInnum = 0;
					if (zoneDatas == null || zoneDatas.size() <= 0) {
						return datas;
					}
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						allHourInnum += zoneHourCountData.getInnum();
					}
					Data data = new Data(null, date, allHourInnum,innum);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES  || kpiType == KPIType.ORDER || kpiType == KPIType.PREPRICE ||
				kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.HANDBAGRATE){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.ORDER) {
					int value = sale.getSalecount();
					Data  data =  new Data(null,date,value);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleMoney, saleCount);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Long zoneId = sale.getZoneId();
					float zoneArea = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap).getArea();
					Data data = new Data(null, date, saleMoney, zoneArea);
					datas.add(data);
				}else if (kpiType == KPIType.HANDBAGRATE) {
					int innum = trafficMap.get(date);
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleCount,innum);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/**
	 * 获取近三年的监控点数据
	 * @param gateId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3YearGateData(Long[] gateIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<GateDayCountData> gateTraffic = gateReportDataService.getNear5YearGateTraffic(gateIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	) {
			if (gateTraffic == null || gateTraffic.size() <= 0 ) {
				return datas;
			}
			for (GateDayCountData gateDayCountData : gateTraffic) {
				Date date = gateDayCountData.getCountdate();
				int innum = gateDayCountData.getInnum();
				Data data = new Data(null, date, innum);
				datas.add(data);
			}
		}
		return datas;
	}

	/**
	 * 获取近三年楼层数据
	 * @param floorId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3YearFloorData(Long[] floorIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<FloorDayCountData> floorTraffic = floorReportDataService.getNear5YearFloorTraffic(floorIds, startDate, endDate, dataMap);
		List<Sale> sales = floorReportDataService.getNear5YearFloorSale(floorIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	) {
			if (floorTraffic == null || floorTraffic.size() <= 0 ) {
				return datas;
			}
			for (FloorDayCountData DayCountData : floorTraffic) {
				Date date = DayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = DayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES ){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/**
	 * 获取近三年商场数据
	 * @param floorId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3YearMallData(Long[] mallIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<MallDayCountData> Traffic = mallReportDataService.getNear5YearMallTraffic(mallIds, startDate, endDate, dataMap);
		List<Sale> sales = floorReportDataService.getNear5YearFloorSale(mallIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	|| kpiType == KPIType.DURATIONTIME) {
			if (Traffic == null || Traffic.size() <= 0 ) {
				return datas;
			}
			for (MallDayCountData DayCountData : Traffic) {
				Date date = DayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = DayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.DURATIONTIME) {
					int innum = DayCountData.getInnum();
					Long mallId = DayCountData.getMallId();
					List<Long> zoneIds = mallReportDataService.getZoneIdsByMallId(mallId, dataMap);
					List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(zoneIds.toArray(new Long[zoneIds.size()]), date, dataMap);
					int allHourInnum = 0;
					if (zoneDatas == null || zoneDatas.size() <= 0) {
						return datas;
					}
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						allHourInnum += zoneHourCountData.getInnum();
					}
					Data data = new Data(null, date, allHourInnum,innum);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleMoney, saleCount);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Long zoneId = sale.getZoneId();
					float zoneArea = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap).getArea();
					Data data = new Data(null, date, saleMoney, zoneArea);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/***
	 * 处理原始数据，把处理结果放入报表中
	 * 本月每日同环比
	 * @param table
	 * @param datas
	 * @param startDate
	 * @param endDate
	 */
	private void putValue2Table(Table table,List<Data> datas,List<Date> dates,KPIType kpiType){
		if (datas == null || datas.size() <= 0) {
			return;
		}
		final String dateStr = LocalMessageUtil.getMessage("month");//国际化:月份
		Map<String, Date> serierDateMap = new HashMap<String, Date>();
		for (Date date : dates) {
			int monthNum = DateUtil.getMonth(date);
			String serierName = LocalMessageUtil.getMessage("Nmonth", new Object[]{monthNum});
			table.getRow(serierName).putValueByHeadColumn(dateStr, serierName);
			serierDateMap.put(serierName, date);
		}
		List<Row> rows = table.getSeries();
		for (Row row : rows) {
			String serierName = row.getName();
			Date date = serierDateMap.get(serierName);
			for (Data data : datas) {
				Date countDate = data.getCountDate();
				DateType dateType = DateType.valueOfMonth(date, countDate);
				if(dateType == null || dateType == DateType.NONE) {
					continue;
				}
				if(kpiType == KPIType.TRAFFIC || kpiType == KPIType.SALES || kpiType == KPIType.ORDER){
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
				}else if (kpiType == KPIType.ENTERINGRATE || kpiType == KPIType.HANDBAGRATE ) {
					double value1 = NumberUtil.parseDouble(data.getValue());
					double value2 = NumberUtil.parseDouble(data.getValue2()) ;
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.percentage(value1, value2, 2));
				}else if (kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.DURATIONTIME) {
					double value1 = NumberUtil.parseDouble(data.getValue());
					double value2 = NumberUtil.parseDouble(data.getValue2()) ;
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.divide(value1, value2, 2));
				}
			}
		}

	}

	/***
	 * 处理原始数据，把处理结果放入报表中
	 * 近三年同环比
	 * 本年工作日/双休日同环比
	 * @param table
	 * @param datas
	 * @param startDate
	 * @param endDate
	 * @throws ParseException
	 */
	private void putValue2Table(Table table,List<Data> datas,List<Date> dates,KPIType kpiType,boolean isNear3Year) throws ParseException{
		if (datas == null || datas.size() <= 0) {
			return;
		}
		int weekdayNum = 0,weekendNum = 0,yearNum = 0;
		Map<String, Date> serierDateMap = new HashMap<String, Date>();
		for (Date date : dates) {
			String dateStr ="" ,serierName = "";
			yearNum = DateUtil.getYear(date);
			if (isNear3Year) {
				dateStr = LocalMessageUtil.getMessage("year");//国际化:月份
				serierName = LocalMessageUtil.getMessage("Nyear",new Object[]{String.valueOf(yearNum)});
				serierDateMap.put(serierName, date);
				table.getRow(serierName).putValueByHeadColumn(dateStr, serierName);
			}else {
				if (weekdayNum > 0) {
					break;
				}
				Date workDate = null,weekendDate = null;
				for (Date today : dates) {
					if (DateUtil.getDayOfWeek(today)>5) {
						weekendNum ++;
						weekendDate = today;
					}else {
						weekdayNum++;
						workDate = today;
					}
				}
				dateStr = LocalMessageUtil.getMessage("Nyear",new Object[]{String.valueOf(yearNum)});//国际化:N年
				String weekdayStrValue = LocalMessageUtil.getMessage("weekdayN",new Object[]{weekdayNum});
				table.getRow(weekdayStrValue).putValueByHeadColumn(dateStr, weekdayStrValue);
				serierDateMap.put(weekdayStrValue, workDate);
				String weekendStrValue = LocalMessageUtil.getMessage("weekendN",new Object[]{weekendNum});
				table.getRow(weekendStrValue).putValueByHeadColumn(dateStr, weekendStrValue);
				serierDateMap.put(weekendStrValue, weekendDate);
			}
		}

		List<Row> rows = table.getSeries();
		for(Row row : rows){
			String serierName = row.getName();
			Date date = serierDateMap.get(serierName);
			Map<DateType, Double> valueMap1 = new HashMap<DateType, Double>();
			Map<DateType, Double> valueMap2 = new HashMap<DateType, Double>();

			for (Data data : datas) {
				Date countDate = data.getCountDate();
				if (!isNear3Year) {
					boolean serierFlag = DateUtil.isWeekday(date);
					boolean dataFlag = DateUtil.isWeekday(countDate);
					if (serierFlag != dataFlag ) {
						continue;
					}
				}
				DateType dateType = DateType.valueOfYear(date, countDate);
				if(dateType == null || dateType == DateType.NONE) {
					continue;
				}
				double value1=0.0,value2 = 0.0;
				switch (kpiType) {
					case TRAFFIC:
					case SALES:
					case ORDER:
						table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
						break;
					case ENTERINGRATE:
					case HANDBAGRATE:
					case PREPRICE:
						value1 = NumberUtil.parseDouble(data.getValue()) ;
						value2 = NumberUtil.parseDouble(data.getValue2());
						if (valueMap1.get(dateType)==null) {
							valueMap1.put(dateType, 0.0);
						}
						Double allValues1 = valueMap1.get(dateType);
						allValues1 += value1;
						valueMap1.put(dateType, allValues1);
						if (valueMap2.get(dateType)==null) {
							valueMap2.put(dateType, 0.0);
						}
						Double allValue2 = valueMap1.get(dateType);
						allValue2 += value2;
						valueMap2.put(dateType, allValue2);
						break;

					case PERAREAVALUE:
					case DURATIONTIME:
						value1 = NumberUtil.parseDouble(data.getValue());
						value2 = NumberUtil.parseDouble(data.getValue2());
						table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.divide(value1, value2, 2));
						break;
					default:
						break;
				}
			}
			if (kpiType == KPIType.ENTERINGRATE || kpiType == KPIType.PREPRICE ||kpiType == KPIType.HANDBAGRATE) {
				for (Entry<DateType, Double> entity:valueMap1.entrySet()) {
					DateType dateType = entity.getKey();
					double allValues1 = valueMap1.get(dateType);
					double allValues2 = valueMap2.get(dateType);
					if (kpiType == KPIType.PREPRICE ) {
						table.getRow(serierName).putValueByHeadColumn(dateType.getName(), NumberUtil.divide(allValues1, allValues2, 2));
					}else {
						table.getRow(serierName).putValueByHeadColumn(dateType.getName(), NumberUtil.percentage(allValues1, allValues2, 2));
					}
				}
			}
		}
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

//	class Data<T,O>{
//		private Date countTime;
//		private Date countDate;
//		private T value;
//		private O value2;
//
//		public Data(Date countTime, Date countDate, T value) {
//			this(countTime,countDate,value,null);
//		}
//
//		public Data(Date countTime, Date countDate, T value, O value2) {
//			this.countTime = countTime;
//			this.countDate = countDate;
//			this.value = value;
//			this.value2 = value2;
//		}
//
//		public Date getCountTime() {
//			return countTime;
//		}
//		public void setCountTime(Date countTime) {
//			this.countTime = countTime;
//		}
//		public Date getCountDate() {
//			return countDate;
//		}
//		public void setCountDate(Date countDate) {
//			this.countDate = countDate;
//		}
//		public T getValue() {
//			return value;
//		}
//		public void setValue(T value) {
//			this.value = value;
//		}
//
//		public O getValue2() {
//			return value2;
//		}
//
//		public void setValue2(O value2) {
//			this.value2 = value2;
//		}
//	}

	/**
	 * @Description: 得到多对象的表格数据
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/14
	 */
	private Chart getMoreObjectTable(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart){
		Table table = new Table(reportChart.getTitle());
		TableHead tableHead = new TableHead();
		Map<Long, String> orgs = getOrgsMap(dataMap);
		String name = LocalMessageUtil.getMessage("NAME");
		String thisYearTotal = LocalMessageUtil.getMessage("THISYEARTOTAL");
		String lastYearTotal = LocalMessageUtil.getMessage("LASTYEARTOTAL");
		String lastYearYo = LocalMessageUtil.getMessage("YoLY");
		String beforeLastYear = LocalMessageUtil.getMessage("BEFORELASTYEARTOTAL");
		String beforeLastYearYo = LocalMessageUtil.getMessage("YoBY");
		tableHead.addData(name);
		tableHead.addData(thisYearTotal);
		tableHead.addData(lastYearTotal);
		tableHead.addData(lastYearYo);
		tableHead.addData(beforeLastYear);
		tableHead.addData(beforeLastYearYo);
		table.setTableHead(tableHead);
		Date startDate = DateUtil.getFirstDateOfYear(date);
		Date endDate = DateUtil.getLastDateOfYear(date);
		Date lastYearStartDate = DateUtil.getLastYear(startDate);
		Date beforeLastYearStartDate = DateUtil.getLastYear(lastYearStartDate);
		List<Data> datas = getMoreObjectData(orgIds, lastYearStartDate, endDate, dataMap);
		for (Long orgId : orgIds){
			table.getRow(orgs.get(orgId)).putValueByHeadColumn(name,orgs.get(orgId));
		}
		for (Data data : datas){
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisYearTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisYearTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisYearTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisYearTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisYearTotal, data.getValue());
			} else if (DateUtil.compareDate(data.getCountDate(), lastYearStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), startDate) == -1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearTotal, data.getValue());
			} else if (DateUtil.compareDate(data.getCountDate(), beforeLastYearStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), lastYearStartDate) == -1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(beforeLastYear) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(beforeLastYear, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(beforeLastYear).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(beforeLastYear, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(beforeLastYear, data.getValue());
			}
		}
		for (Long orgId : orgIds){
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisYearTotal) == null) {
				continue;
			}
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearTotal) != null){
				String lastYearYoStr = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisYearTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearTotal)));
//				if(lastYearYoStr != null) {
//					lastYearYoStr = lastYearYoStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastYearYo, lastYearYoStr);

			}
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(beforeLastYear) != null) {
				String beforeLastYearYoStr = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisYearTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(beforeLastYear)));
//				if(beforeLastYearYoStr != null) {
//					beforeLastYearYoStr = beforeLastYearYoStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(beforeLastYearYo, beforeLastYearYoStr);

			}
		}
		return table;
	}

	/**
	 * @Description: 多对象的柱状图
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/14
	 */
	private Chart getMoreObjectBar(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		String thisYearTotal = LocalMessageUtil.getMessage("THISYEARTOTAL");
		String lastYearTotal = LocalMessageUtil.getMessage("LASTYEARTOTAL");
		Map<Long, String> orgs = getOrgsMap(dataMap);
		Axis xAxis = AxisFactory.createStringAxis();
		Date startDate = DateUtil.getFirstDateOfYear(date);
		Date endDate = DateUtil.getLastDateOfYear(date);
		Date lastYearStartDate = DateUtil.getLastYear(startDate);
		List<Data> datas = getMoreObjectData(orgIds, lastYearStartDate, endDate, dataMap);
		for(Long orgId : orgIds){
			xAxis.addData(orgs.get(orgId));
		}
		chart.setXAxis(xAxis);
		Map<Long,Integer> thisYearNumMap = new HashMap<>();
		Map<Long,Integer> lastYearMap = new HashMap<>();

		for (Data data : datas){
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
				if(thisYearNumMap.get(data.getValue3())==null) {
					thisYearNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					thisYearNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+thisYearNumMap.get(Long.parseLong(data.getValue3().toString())));
				}

			}else if (DateUtil.compareDate(data.getCountDate(), lastYearStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), startDate) == -1){
				if(lastYearMap.get(data.getValue3())==null) {
					lastYearMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					lastYearMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+lastYearMap.get(Long.parseLong(data.getValue3().toString())));
				}
			}
		}
		for(Long orgId : orgIds){
			chart.getSeries(thisYearTotal).adjustOrPutValueByCoordinate(orgs.get(orgId),thisYearNumMap.get(orgId));
			chart.getSeries(lastYearTotal).adjustOrPutValueByCoordinate(orgs.get(orgId),lastYearMap.get(orgId));
		}
		return chart;
	}

	private Chart getTrafficAndYOBar(Date startDate,Date endDate,List<Data> datas,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		Date lastYear1 = DateUtil.getLastYear(startDate);
		Date lastYear2 = DateUtil.getLastYear(lastYear1);
		Date lastYear3 = DateUtil.getLastYear(lastYear2);
		Date lastYear4 = DateUtil.getLastYear(lastYear3);
		Axis<String> xAxis = AxisFactory.createStringAxis();
		String lastYearStr = DateUtil.format("yyyy",startDate);
		String lastYearStr1 = DateUtil.format("yyyy",lastYear1);
		String lastYearStr2 = DateUtil.format("yyyy",lastYear2);
		String lastYearStr3 = DateUtil.format("yyyy",lastYear3);
		String lastYearStr4 = DateUtil.format("yyyy",lastYear4);
		xAxis.addData(lastYearStr);
		xAxis.addData(lastYearStr1);
		xAxis.addData(lastYearStr2);
		chart.setXAxis(xAxis);
		String traffic = LocalMessageUtil.getMessage("ENTERINGRATE.EFFECTIVE");
		String yO = LocalMessageUtil.getMessage("YoLY");
		chart.createSeries(traffic,SeriesType.bar);
		chart.createSeries(yO,SeriesType.line);
		Map<String,Integer> calDataMap = new HashMap<>();
		for (Data data : datas){
			if(DateUtil.compareDate(data.getCountDate(),startDate) !=-1&&DateUtil.compareDate(data.getCountDate(),endDate) == -1){
				if(calDataMap.get(lastYearStr)==null){
					calDataMap.put(lastYearStr,Integer.parseInt(data.getValue().toString()));
				}else{
					calDataMap.put(lastYearStr,Integer.parseInt(data.getValue().toString())+calDataMap.get(lastYearStr));
				}
			}
			else if(DateUtil.compareDate(data.getCountDate(),lastYear1) !=-1&&DateUtil.compareDate(data.getCountDate(),startDate) == -1){
				if(calDataMap.get(lastYearStr1)==null){
					calDataMap.put(lastYearStr1,Integer.parseInt(data.getValue().toString()));
				}else{
					calDataMap.put(lastYearStr1,Integer.parseInt(data.getValue().toString())+calDataMap.get(lastYearStr1));
				}
			} else if(DateUtil.compareDate(data.getCountDate(),lastYear2) !=-1&&DateUtil.compareDate(data.getCountDate(),lastYear1) == -1){
				if(calDataMap.get(lastYearStr2)==null){
					calDataMap.put(lastYearStr2,Integer.parseInt(data.getValue().toString()));
				}else{
					calDataMap.put(lastYearStr2,Integer.parseInt(data.getValue().toString())+calDataMap.get(lastYearStr2));
				}
			}
//			else if(DateUtil.compareDate(data.getCountDate(),lastYear3) !=-1&&DateUtil.compareDate(data.getCountDate(),lastYear2) == -1){
//				if(calDataMap.get(lastYearStr3)==null){
//					calDataMap.put(lastYearStr3,Integer.parseInt(data.getValue().toString()));
//				}else{
//					calDataMap.put(lastYearStr3,Integer.parseInt(data.getValue().toString())+calDataMap.get(lastYearStr3));
//				}
//			}
		}
		chart.getSeries(traffic).adjustOrPutValueByCoordinate(lastYearStr,calDataMap.get(lastYearStr));
		String lastYear1Str = NumberUtil.growthRate(calDataMap.get(lastYearStr),calDataMap.get(lastYearStr1));
		if(lastYear1Str != null) {
			lastYear1Str = lastYear1Str.replace("%", "");
		}
		chart.getSeries(yO).adjustOrPutValueByCoordinate(lastYearStr,lastYear1Str);

		chart.getSeries(traffic).adjustOrPutValueByCoordinate(lastYearStr1,calDataMap.get(lastYearStr1));
		String lastYear2Str = NumberUtil.growthRate(calDataMap.get(lastYearStr1),calDataMap.get(lastYearStr2));
		if(lastYear2Str != null) {
			lastYear2Str = lastYear2Str.replace("%", "");
		}
		chart.getSeries(yO).adjustOrPutValueByCoordinate(lastYearStr1,lastYear2Str);

		chart.getSeries(traffic).adjustOrPutValueByCoordinate(lastYearStr2,calDataMap.get(lastYearStr2));
		String lastYear3Str = NumberUtil.growthRate(calDataMap.get(lastYearStr2),calDataMap.get(lastYearStr3));
		if(lastYear3Str != null) {
			lastYear3Str = lastYear3Str.replace("%", "");
		}
		chart.getSeries(yO).adjustOrPutValueByCoordinate(lastYearStr2,lastYear3Str);

		return chart;
	}
}
