package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Row;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.*;
import java.util.Map.Entry;


@Service
public class YoYOrMoMWeekReportServiceImpl extends YoYOrMoMBaseService {

	@Resource
	private ZoneReportDataService zoneReportDataService;

	@Resource
	private GateReportDataService gateReportDataService;

	@Resource
	private FloorReportDataService floorReportDataService;

	@Resource
	private MallReportDataService mallReportDataService;

	/**近3周同环比报表*/
	public static final String REPORT_3WEEK_YoY ="Near3WeekYoY";
	/**本周每日同环比报表*/
	public static final String REPORT_DAYOFWEEK_YoY ="DayOfWeekYoY";
	/**本周工作日/双休日同环比报表*/
	public static final String REPORT_WEEKDAYOREND_YoY ="WeekDayOrEndYoY";

	/** 近几周的同环比报表客流量柱状图 */
	public static final String REPORT_8WEEKTRAFFIC_TREND = "8WeekTrafficTrendLine";

	public static final String REPORT_8WEEKY_TREND = "8WeekYTrendLine";

	public static final String REPORT_THISWEEK_TRAFFIC_TREND = "thisWeekTrafficTrend";

	public static final String REPORT_THISWEEK_YO_TREND = "thisWeekYOTrend";

	public static final String REPORT_MOREOBJECT_TABLE = "moreObjectTable";

	public static final String REPOR_MOREOBJECT_BAR = "moreObjectBar";

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		Chart chart = null;
		List datas = null;

		if (orgType == OrgType.zone){
			datas = getNear3WeekZoneData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.gate){
			datas = getNear3WeekGateData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.floor){
			datas = getNear3WeekFloorData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.mall) {
			datas = getNear3WeekMallData(orgIds, startDate, endDate, dataMap, kpiType);
		}
		switch (reportChart.getKey()) {
			case REPORT_3WEEK_YoY:/**近3周同环比报表*/
				chart = WeeksOfNear3YoY( startDate, endDate, datas, dataMap, reportChart,true,kpiType);
				break;
			case REPORT_DAYOFWEEK_YoY:/**本周每日同环比报表*/
				chart = DaysOfWeekYoY(startDate, endDate, datas, dataMap, reportChart,kpiType);
				break;
			case REPORT_WEEKDAYOREND_YoY:/**本周工作日/双休日同环比报表*/
				chart = WeeksOfNear3YoY(startDate, endDate, datas, dataMap, reportChart,false,kpiType);
				break;
			case REPORT_8WEEKTRAFFIC_TREND:
				chart = getRecentWeekYOTrendBar(startDate,endDate,datas,reportChart);
				break;
			case REPORT_8WEEKY_TREND:
				chart = getRecentWeekYOTrendLine(startDate,endDate,datas,reportChart);
				break;
			case REPORT_THISWEEK_TRAFFIC_TREND:
				chart = getTrafficTrendLine(startDate,endDate,datas,reportChart);
				break;
			case REPORT_THISWEEK_YO_TREND:
				chart = getYOTrendLine(startDate,endDate,datas,reportChart);
				break;
			case REPORT_MOREOBJECT_TABLE:
				chart = getMoreObjectTable(orgIds,startDate,dataMap,reportChart);
				break;
			case REPOR_MOREOBJECT_BAR:
				chart = getMoreObjectBar(orgIds,startDate,dataMap,reportChart);
				break;
			default:
				break;
		}
		return chart;
	}

	/**本周每日同环比
	 * @param datas   传入报表的数据
	 * @param kpiType
	 */
	private Chart DaysOfWeekYoY(Date startDate, Date endDate,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart, KPIType kpiType){

		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		final String ToY = LocalMessageUtil.getMessage("ToY");//国际化:昨日环比
		final String ToWD = LocalMessageUtil.getMessage("ToWD");//国际化:上周环比
		final String ToMD = LocalMessageUtil.getMessage("ToMD");//国际化:上月同日环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年同期环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int todayIndex = getIndexByTableHead(DateType.TODAY.getName());
				Number todayNum =  data.get(todayIndex) == null ? 0 : (Number) data.get(todayIndex);
				String result = "0%";
				if(getIndexByTableHead(ToWD) == index){
					Number lastweekdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTWEEKDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastweekdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(ToMD) == index){
					Number lastmonthdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTMONTHDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastmonthdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastyeardayNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastyeardayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else{
					return data.get(index);
				}

			}
		};

		TableHead tableHead = new TableHead();
		tableHead.addData(dateStr,DateType.TODAY.getName(),DateType.LASTWEEKDAY.getName(),ToWD,DateType.LASTMONTHDAY.getName(),ToMD,DateType.LASTYEARDAY.getName(),ToYD);
		table.setTableHead(tableHead);

		List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
		Collections.reverse(dates);
		putValue2Table(table, datas, dates,kpiType);

		return table;
	}

	/** 近3周同环比
	 * 本周工作日/双休日同环比
	 * @param orgId
	 * @param date
	 * @param datas
	 * @param dataMap
	 * @param reportChart
	 * @param kpiType
	 * @param isTimeCounting
	 * @return
	 */
	private Chart WeeksOfNear3YoY(Date startDate,Date endDate,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart,boolean isNear3Week, KPIType kpiType){

		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		final String ToWD = LocalMessageUtil.getMessage("ToWD");//国际化:上周环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年同期环比
		final String LASTAVGYO4 = LocalMessageUtil.getMessage("LASTAVGYO4");//国际化:前四周平均环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int thisWeek = getIndexByTableHead(DateType.WEEK.getName());
				Number thisWeekNum =  data.get(thisWeek) == null ? 0 : (Number) data.get(thisWeek);
				String result = "0%";
				if(getIndexByTableHead(ToWD) == index){
					Number lastweekNum = (Number) data.get(getIndexByTableHead(DateType.LASTWEEK.getName()));
					result = NumberUtil.growthRate(thisWeekNum, lastweekNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(LASTAVGYO4) == index){
					Number lastFourWeekNum = (Number) data.get(getIndexByTableHead(DateType.LASTFOURWEEK.getName()));
					result = NumberUtil.growthRate(thisWeekNum, lastFourWeekNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastyearWeekNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARWEEK.getName()));
					result = NumberUtil.growthRate(thisWeekNum, lastyearWeekNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else{
					return data.get(index);
				}

			}
		};

		TableHead tableHead = new TableHead();
		tableHead.addData(dateStr,DateType.WEEK.getName(),DateType.LASTWEEK.getName(),ToWD,DateType.LASTFOURWEEK.getName(),LASTAVGYO4,DateType.LASTYEARWEEK.getName(),ToYD);
		table.setTableHead(tableHead);
		List<Date> dates = null;
		try {
			if (isNear3Week) {
				Date weekBeforLastMonday = DateUtil.addDays(endDate, PARAM_DEFAULT_BEFOREDAY56);
				dates = DateUtil.getDaysBetweenDates(weekBeforLastMonday, endDate);
				Collections.reverse(dates);
				putValue2Table(table, datas, dates,kpiType,true);
			}else {
				dates = DateUtil.getDaysBetweenDates(startDate, endDate);
				Collections.reverse(dates);
				putValue2Table(table, datas, dates,kpiType,false);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return table;
	}

	/** 近8周对比柱状图 */
	private Chart getRecentWeekYOTrendBar(Date startDate,Date endDate,List<Data> datas,ReportChart reportChart){
		List<String> keys = new ArrayList<>();
		int nowWeek = DateUtil.getWeekOfYear(startDate);
		for(int i = 0;i<8;i++){
			int nowIndex = nowWeek-Integer.parseInt(String.valueOf(i));
			if(nowIndex>0) {
				keys.add(i, LocalMessageUtil.getMessage("weekOfyearStrFormat", new Object[]{nowIndex}));
			}
		}
		Map<String,Map<String,Object>> excelMap = getRecentWeekYODataMap(startDate,endDate,datas,keys);
		return getRecentBar(keys,excelMap,startDate,reportChart);
	}

	/** 今8周同比趋势 */
	private Chart getRecentWeekYOTrendLine(Date startDate,Date endDate,List<Data> datas,ReportChart reportChart){
		List<String> keys = new ArrayList<>();
		String now = DateUtil.format("yyyy",startDate);
		String last = DateUtil.format("yyyy",DateUtil.getLastYear(startDate));
		int nowWeek = DateUtil.getWeekOfYear(startDate);
		for(int i = 0;i<8;i++){
			int nowIndex = nowWeek-Integer.parseInt(String.valueOf(i));
			if(nowIndex>0) {
				keys.add(i, LocalMessageUtil.getMessage("weekOfyearStrFormat", new Object[]{nowIndex}));
			}
		}
		Map<String,Map<String,Object>> excelMap = getRecentWeekYODataMap(startDate,endDate,datas,keys);
		Map<String,Object> YOTrendMap = new LinkedHashMap<>();
		for (Entry entry : excelMap.entrySet()){
			Map<String,Object> map = (Map<String,Object>)entry.getValue();
			String growth = NumberUtil.growthRate((Double)map.get(now),(Double)map.get(last));
			if(growth != null) {
				growth = growth.replace("%", "");
			}
			YOTrendMap.put(entry.getKey().toString(),growth);
		}
		return getYoyTrend(keys,reportChart,YOTrendMap);
	}

	/**
	 * 得到近8周的所有数据，组装为Map
	 * @param startDate
	 * @param endDate
	 * @param datas
	 * @return
	 */
	private Map<String,Map<String,Object>> getRecentWeekYODataMap(Date startDate,Date endDate,List<Data> datas,List<String> keys){
		List<Date> dates = new ArrayList<>();
		Date firstDayOfThisYear = DateUtil.getFirstDateOfYear(startDate);
		Date startDateTemple1 = startDate;
		Date endDateTemple = endDate;
		Date startDateTemple2 = DateUtil.getLastWeek(startDateTemple1);
		Date startDateTemple3 = DateUtil.getLastWeek(startDateTemple2);
		Date startDateTemple4 = DateUtil.getLastWeek(startDateTemple3);
		Date startDateTemple5 = DateUtil.getLastWeek(startDateTemple4);
		Date startDateTemple6 = DateUtil.getLastWeek(startDateTemple5);
		Date startDateTemple7 = DateUtil.getLastWeek(startDateTemple6);
		Date startDateTemple8 = DateUtil.getLastWeek(startDateTemple7);
		dates.add(0,endDateTemple);
		dates.add(1,startDateTemple1);
		dates.add(2,startDateTemple2);
		dates.add(3,startDateTemple3);
		dates.add(4,startDateTemple4);
		dates.add(5,startDateTemple5);
		dates.add(6,startDateTemple6);
		dates.add(7,startDateTemple7);
		dates.add(8,startDateTemple8);
		//////
        //对于符合条件的数据进行过滤
        //dates.stream().filter( d -> d.compareTo(firstDayOfThisYear) != -1);
//		Map<String,Map<String,Object>> resultMap = new LinkedHashMap<>();
//		for(int i = 0;i<keys.size();i++){
//			resultMap.put(keys.get(i),null);
//		}
		return getDataMap(dates,datas,keys);
	}



	/**
	 * 获取近三周的店铺数据
	 * @param
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3WeekZoneData(Long[] zoneIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<ZoneDayCountData> zoneTraffic = zoneReportDataService.getNear3WeekZoneTraffic(zoneIds, startDate, endDate, dataMap);
		List<Sale> sales = zoneReportDataService.getNear3WeekZoneSale(zoneIds, startDate, endDate, dataMap);

		Map<Date, Integer> trafficMap = new HashMap<Date, Integer>();
		if (kpiType == KPIType.TRAFFIC || kpiType == KPIType.ENTERINGRATE ||kpiType == KPIType.HANDBAGRATE ||
				kpiType == KPIType.DURATIONTIME	) {
			if (zoneTraffic == null || zoneTraffic.size() <= 0 ) {
				return datas;
			}

			for (ZoneDayCountData zoneDayCountData : zoneTraffic) {
				Date date = zoneDayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = zoneDayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if ( kpiType == KPIType.ENTERINGRATE) {
					int innum = zoneDayCountData.getInnum();
					int passNum = zoneDayCountData.getOutsideInnum()+zoneDayCountData.getOutsideOutnum();
					Data data = new Data(null, date, innum, passNum);
					datas.add(data);
				}else if (kpiType == KPIType.HANDBAGRATE) {
					int innum = zoneDayCountData.getInnum();
					trafficMap.put(date, innum);
				}else if (kpiType == KPIType.DURATIONTIME) {
					int innum = zoneDayCountData.getInnum();
					List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(zoneIds, date, dataMap);
					int allHourInnum = 0;
					if (zoneDatas == null || zoneDatas.size() <= 0) {
						return datas;
					}
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						allHourInnum += zoneHourCountData.getInnum();
					}
					Data data = new Data(null, date, allHourInnum,innum);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES  || kpiType == KPIType.ORDER || kpiType == KPIType.PREPRICE ||
				kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.HANDBAGRATE){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.ORDER) {
					int value = sale.getSalecount();
					Data  data =  new Data(null,date,value);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleMoney, saleCount);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Long zoneId = sale.getZoneId();
					float zoneArea = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap).getArea();
					Data data = new Data(null, date, saleMoney, zoneArea);
					datas.add(data);
				}else if (kpiType == KPIType.HANDBAGRATE) {
					int innum = trafficMap.get(date);
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleCount,innum);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/**
	 * 获取近三周的监控点数据
	 * @param gateId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3WeekGateData(Long[] gateIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<GateDayCountData> gateTraffic = gateReportDataService.getNear3WeekGateTraffic(gateIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	) {
			if (gateTraffic == null || gateTraffic.size() <= 0 ) {
				return datas;
			}
			for (GateDayCountData gateDayCountData : gateTraffic) {
				Date date = gateDayCountData.getCountdate();
				int innum = gateDayCountData.getInnum();
				Data data = new Data(null, date, innum);
				datas.add(data);
			}
		}
		return datas;
	}

	/**
	 * 获取近三周楼层数据
	 * @param floorId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3WeekFloorData(Long[] floorIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<FloorDayCountData> floorTraffic = floorReportDataService.getNear3WeekFloorTraffic(floorIds, startDate, endDate, dataMap);
		List<Sale> sales = floorReportDataService.getNear3WeekFloorSale(floorIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	) {
			if (floorTraffic == null || floorTraffic.size() <= 0 ) {
				return datas;
			}
			for (FloorDayCountData DayCountData : floorTraffic) {
				Date date = DayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = DayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES ){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/**
	 * 获取近三周商场数据
	 * @param floorId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3WeekMallData(Long[] mallIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<MallDayCountData> Traffic = mallReportDataService.getNear3WeekMallTraffic(mallIds, startDate, endDate, dataMap);
		List<Sale> sales = floorReportDataService.getNear3WeekFloorSale(mallIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	|| kpiType == KPIType.DURATIONTIME) {
			if (Traffic == null || Traffic.size() <= 0 ) {
				return datas;
			}
			for (MallDayCountData DayCountData : Traffic) {
				Date date = DayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = DayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.DURATIONTIME) {
					int innum = DayCountData.getInnum();
					Long mallId = DayCountData.getMallId();
					List<Long> zoneIds = mallReportDataService.getZoneIdsByMallId(mallId, dataMap);
					List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(zoneIds.toArray(new Long[zoneIds.size()]), date, dataMap);
					int allHourInnum = 0;
					if (zoneDatas == null || zoneDatas.size() <= 0) {
						return datas;
					}
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						allHourInnum += zoneHourCountData.getInnum();
					}
					Data data = new Data(null, date, allHourInnum,innum);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleMoney, saleCount);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Long zoneId = sale.getZoneId();
					float zoneArea = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap).getArea();
					Data data = new Data(null, date, saleMoney, zoneArea);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/***
	 * 处理原始数据，把处理结果放入报表中
	 * 本周每日同环比
	 * @param table
	 * @param datas
	 * @param startDate
	 * @param endDate
	 */
	private void putValue2Table(Table table,List<Data> datas,List<Date> dates,KPIType kpiType){
		if (datas == null || datas.size() <= 0) {
			return;
		}
		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		Map<String, Date> serierDateMap = new HashMap<String, Date>();
		for (Date date : dates) {
			String serierName = DateUtil.format(DateUtil.FORMAT_SHORT_WEEK, date);
			table.getRow(serierName).putValueByHeadColumn(dateStr, serierName);
			serierDateMap.put(serierName, date);
		}
		List<Row> rows = table.getSeries();
		for (Row row : rows) {
			String serierName = row.getName();
			Date date = serierDateMap.get(serierName);
			for (Data data : datas) {
				Date countDate = data.getCountDate();
				DateType dateType = DateType.valueOfDay(date, countDate);
				if(dateType == null || dateType == DateType.NONE|| dateType == DateType.YESTERDAY) {
					continue;
				}
				if(kpiType == KPIType.TRAFFIC || kpiType == KPIType.SALES || kpiType == KPIType.ORDER){
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
				}else if (kpiType == KPIType.ENTERINGRATE || kpiType == KPIType.HANDBAGRATE ) {
					double value1 = NumberUtil.parseDouble(data.getValue());
					double value2 = NumberUtil.parseDouble(data.getValue2()) ;
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.percentage(value1, value2, 2));
				}else if (kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.DURATIONTIME) {
					double value1 = NumberUtil.parseDouble(data.getValue());
					double value2 = NumberUtil.parseDouble(data.getValue2()) ;
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.divide(value1, value2, 2));
				}
			}
		}
	}

	/***
	 * 处理原始数据，把处理结果放入报表中
	 * 近三周同环比
	 * 本周工作日/双休日同环比
	 * @param table
	 * @param datas
	 * @param startDate
	 * @param endDate
	 * @throws ParseException
	 */
	private void putValue2Table(Table table,List<Data> datas,List<Date> dates,KPIType kpiType,boolean isNear3Week) throws ParseException{
		if (datas == null || datas.size() <= 0) {
			return;
		}
		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		Map<String, Date> seriesDate = new HashMap<String, Date>();
		if (isNear3Week) {
			for (Date date : dates) {
				String dateStrValue = "";
				Date monday = DateUtil.getMondayOfWeek(date);
				Date sunday = DateUtil.getSundayOfWeek(date);
				String serierName = "";
				int weekNum = DateUtil.getWeekOfYear(date);
				serierName = DateUtil.format(DateUtil.FORMAT_MM_DD, monday)+"--"+DateUtil.format(DateUtil.FORMAT_MM_DD, sunday);
				dateStrValue = LocalMessageUtil.getMessage("weekNumL",new Object[]{weekNum,serierName});
				table.getRow(dateStrValue).putValueByHeadColumn(dateStr, dateStrValue);
				seriesDate.put(dateStrValue, date);
			}
		}else {
			Date weekDate = dates.get(0);
			Date monday = DateUtil.getMondayOfWeek(weekDate);
			Date sunday = DateUtil.getSundayOfWeek(weekDate);
			Date friday = DateUtil.addDays(sunday, -2);
			Date saturday = DateUtil.addDays(sunday, -1);

			String weekdayBetween = DateUtil.format(DateUtil.FORMAT_MM_DD, monday)+"--"+DateUtil.format(DateUtil.FORMAT_MM_DD, friday);
			String weekdayStrValue = LocalMessageUtil.getMessage("weekday",new Object[]{weekdayBetween});
			table.getRow(weekdayStrValue).putValueByHeadColumn(dateStr, weekdayStrValue);
			seriesDate.put(weekdayStrValue, monday);
			String weekendBetween = DateUtil.format(DateUtil.FORMAT_MM_DD, saturday)+"--"+DateUtil.format(DateUtil.FORMAT_MM_DD, sunday);
			String weekendStrValue = LocalMessageUtil.getMessage("weekend",new Object[]{weekendBetween});
			table.getRow(weekendStrValue).putValueByHeadColumn(dateStr, weekendStrValue);
			seriesDate.put(weekendStrValue, sunday);
		}


		List<Row> rows = table.getSeries();
		for(Row row : rows){
			String serierName = row.getName();
			Date date = seriesDate.get(serierName);
			Map<DateType, Double> valueMap1 = new HashMap<DateType, Double>();
			Map<DateType, Double> valueMap2 = new HashMap<DateType, Double>();

			for (Data data : datas) {
				Date countDate = data.getCountDate();
				if (!isNear3Week) {
					boolean serierFlag = DateUtil.isWeekday(date);
					boolean dataFlag = DateUtil.isWeekday(countDate);
					if (serierFlag != dataFlag ) {
						continue;
					}
				}
				DateType dateType = DateType.valueOfWeek(date, countDate);
				if(dateType == null || dateType == DateType.NONE) {
					continue;
				}
				double value1=0.0,value2 = 0.0;
				switch (kpiType) {
					case TRAFFIC:
					case SALES:
					case ORDER:
						if(dateType==DateType.LASTWEEK){
							table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
							table.getRow(serierName).adjustOrPutValueByHeadColumn(DateType.LASTFOURWEEK.getName(), NumberUtil.divide((Number)(data.getValue()),4,0));
						}
						else if(dateType==DateType.LASTFOURWEEK){
							table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), NumberUtil.divide((Number)(data.getValue()),4,0));
						}else {
							table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
						}
						break;
					case ENTERINGRATE:
					case HANDBAGRATE:
					case PREPRICE:
						value1 = NumberUtil.parseDouble(data.getValue()) ;
						value2 = NumberUtil.parseDouble(data.getValue2());
						if (valueMap1.get(dateType)==null) {
							valueMap1.put(dateType, 0.0);
						}
						Double allValues1 = valueMap1.get(dateType);
						allValues1 += value1;
						valueMap1.put(dateType, allValues1);
						if (valueMap2.get(dateType)==null) {
							valueMap2.put(dateType, 0.0);
						}
						Double allValue2 = valueMap1.get(dateType);
						allValue2 += value2;
						valueMap2.put(dateType, allValue2);
						break;

					case PERAREAVALUE:
					case DURATIONTIME:
						value1 = NumberUtil.parseDouble(data.getValue());
						value2 = NumberUtil.parseDouble(data.getValue2());
						table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.divide(value1, value2, 2));
						break;
					default:
						break;
				}
			}
			if (kpiType == KPIType.ENTERINGRATE || kpiType == KPIType.PREPRICE ||kpiType == KPIType.HANDBAGRATE) {
				for (Entry<DateType, Double> entity:valueMap1.entrySet()) {
					DateType dateType = entity.getKey();
					double allValues1 = valueMap1.get(dateType);
					double allValues2 = valueMap2.get(dateType);
					if (kpiType == KPIType.PREPRICE ) {
						table.getRow(serierName).putValueByHeadColumn(dateType.getName(), NumberUtil.divide(allValues1, allValues2, 2));
					}else {
						table.getRow(serierName).putValueByHeadColumn(dateType.getName(), NumberUtil.percentage(allValues1, allValues2, 2));
					}
				}
			}
		}
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

//	class Data<T,O>{
//		private Date countTime;
//		private Date countDate;
//		private T value;
//		private O value2;
//
//		public Data(Date countTime, Date countDate, T value) {
//			this(countTime,countDate,value,null);
//		}
//
//		public Data(Date countTime, Date countDate, T value, O value2) {
//			this.countTime = countTime;
//			this.countDate = countDate;
//			this.value = value;
//			this.value2 = value2;
//		}
//
//		public Date getCountTime() {
//			return countTime;
//		}
//		public void setCountTime(Date countTime) {
//			this.countTime = countTime;
//		}
//		public Date getCountDate() {
//			return countDate;
//		}
//		public void setCountDate(Date countDate) {
//			this.countDate = countDate;
//		}
//		public T getValue() {
//			return value;
//		}
//		public void setValue(T value) {
//			this.value = value;
//		}
//
//		public O getValue2() {
//			return value2;
//		}
//
//		public void setValue2(O value2) {
//			this.value2 = value2;
//		}
//	}

	/**
	 * @Description:	得到周报表的表格
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/13
	 */
	private Chart getMoreObjectTable(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart) {
		Table table = new Table(reportChart.getTitle());
		String name = LocalMessageUtil.getMessage("NAME");
		String thisWeekTotal = LocalMessageUtil.getMessage("THISWEEKTOTAL");
		String lastWeekTotal = LocalMessageUtil.getMessage("LASTWEEKTOTAL");
		String lastWeekYo = LocalMessageUtil.getMessage("ToWD");
		String lastAvg4 = LocalMessageUtil.getMessage("LASTAVG4");
		String lastAvgYO4 = LocalMessageUtil.getMessage("LASTAVGYO4");
		String lastYearTotal = LocalMessageUtil.getMessage("LASTYEARTHISWEEK");
		String lastYearYO = LocalMessageUtil.getMessage("ToYD");
		TableHead tableHead = new TableHead();
		tableHead.addData(name);
		tableHead.addData(thisWeekTotal);
		tableHead.addData(lastWeekTotal);
		tableHead.addData(lastWeekYo);
		tableHead.addData(lastAvg4);
		tableHead.addData(lastAvgYO4);
		tableHead.addData(lastYearTotal);
		tableHead.addData(lastYearYO);
		table.setTableHead(tableHead);
		Map<Long, String> orgs = getOrgsMap(dataMap);
		for (Long orgId : orgIds) {
			table.getRow(orgs.get(orgId)).putValueByHeadColumn(name, orgs.get(orgId));
		}
		Date startDate = DateUtil.getMondayOfWeek(date);
		Date endDate = DateUtil.getSundayOfWeek(date);
		Date lastWeekStartDate = DateUtil.getLastWeek(startDate);
		Date lastWeekEndDate = DateUtil.getLastWeek(endDate);
		Date lastYearStartDate = DateUtil.getLastYear(startDate);
		List<Data> datas = getMoreObjectData(orgIds, lastYearStartDate, endDate, dataMap);
		Date lastFourWeekStartDate = DateUtil.addDays(startDate, -27);
		Date lastYearEndDate = DateUtil.getLastYear(endDate);
		for (Data data : datas) {
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisWeekTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisWeekTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisWeekTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisWeekTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisWeekTotal, data.getValue());
			} if (DateUtil.compareDate(data.getCountDate(), lastWeekStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), lastWeekEndDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastWeekTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastWeekTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastWeekTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastWeekTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastWeekTotal, data.getValue());
			} if (DateUtil.compareDate(data.getCountDate(), lastFourWeekStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), startDate) == -1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastAvg4) == null) {
//					table.getRow(zones.get(data.getValue3())).putValueByHeadColumn(lastAvg4, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastAvg4).toString());
//					table.getRow(zones.get(data.getValue3())).putValueByHeadColumn(lastAvg4, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastAvg4, data.getValue());
			} if (DateUtil.compareDate(data.getCountDate(), lastYearStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), lastYearEndDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearTotal, data.getValue());
			}
		}

		for (Long orgId : orgIds) {
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastAvg4) != null) {
				//Double innumAvg = Double.parseDouble(table.getRow(zones.get(orgId)).getValueByHeadColumn(lastAvg4).toString()) / 4.0;
				Object innumAvg = NumberUtil.divide((Number) table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastAvg4),4,0);
				table.getRow(orgs.get(orgId)).putValueByHeadColumn(lastAvg4, innumAvg);
			}
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisWeekTotal) == null) {
				continue;
			}
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastWeekTotal) != null) {
				String lastWeekYOStr =  NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisWeekTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastWeekTotal)));
//				if(lastWeekYOStr != null) {
//					lastWeekYOStr = lastWeekYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastWeekYo,lastWeekYOStr);

			}
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastAvg4) != null) {
				String lastAvgYO4Str = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisWeekTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastAvg4)));
//				if(lastAvgYO4Str != null) {
//					lastAvgYO4Str = lastAvgYO4Str.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastAvgYO4, lastAvgYO4Str);

			}
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearTotal) != null) {
				String lastYearYOStr = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisWeekTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearTotal)));
//				if(lastYearYOStr != null) {
//					lastYearYOStr = lastYearYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastYearYO, lastYearYOStr);

			}
		}
//		for (Long id : orgIds){
//			Object thisWeekTotalO = table.getRow(zones.get(id)).getValueByHeadColumn(thisWeekTotal);
//			if(thisWeekTotalO==null){
//				continue;
//			}
//			Integer thisWeekNum = Integer.parseInt(thisWeekTotalO.toString());
//			Object last4WeekTotalO = table.getRow(zones.get(id)).getValueByHeadColumn(lastAvg4);
//			if(last4WeekTotalO == null){
//				continue;
//			}
//			Double last4WeekTotal = Double.parseDouble(last4WeekTotalO.toString())/4.0;
//				String lastAvgYO4Str = NumberUtil.growthRate(thisWeekNum,last4WeekTotal);
//				if(lastAvgYO4Str != null) {
//					lastAvgYO4Str = lastAvgYO4Str.replace("%", "");
//				}
//				table.getRow(zones.get(id)).adjustOrPutValueByHeadColumn(lastAvgYO4, lastAvgYO4Str);
//			table.getRow(zones.get(id)).adjustOrPutValueByHeadColumn(lastAvg4,last4WeekTotal);
//			table.getRow(zones.get(id)).adjustOrPutValueByHeadColumn(lastAvg4,last4WeekTotal);
//		}
		return table;
	}

	/**
	 * @Description: 得到周的柱状图
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/13
	 */
	public Chart getMoreObjectBar(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		String thisWeekTotal = LocalMessageUtil.getMessage("THISWEEKTOTAL");
		String lastAvg4 = LocalMessageUtil.getMessage("LASTAVG4");
		Map<Long, String> orgs = getOrgsMap(dataMap);
		Axis xAxis = AxisFactory.createStringAxis();
		Date startDate = DateUtil.getMondayOfWeek(date);
		Date endDate = DateUtil.getSundayOfWeek(date);
		Date lastFourWeekStartDate = DateUtil.addDays(startDate, -27);
		List<Data> datas = getMoreObjectData(orgIds, lastFourWeekStartDate, endDate, dataMap);
		for(Long orgId : orgIds){
			xAxis.addData(orgs.get(orgId));
		}
		chart.setXAxis(xAxis);
		Map<Long,Integer> thisWeekNumMap = new HashMap<>();
		Map<Long,Integer> lastFourWeekAvgMap = new HashMap<>();

		for (Data data : datas){
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
				if(thisWeekNumMap.get(data.getValue3())==null) {
					thisWeekNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					thisWeekNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+thisWeekNumMap.get(Long.parseLong(data.getValue3().toString())));
				}

			}else if (DateUtil.compareDate(data.getCountDate(), lastFourWeekStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), startDate) == -1){
				if(lastFourWeekAvgMap.get(data.getValue3())==null) {
					lastFourWeekAvgMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					lastFourWeekAvgMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+lastFourWeekAvgMap.get(Long.parseLong(data.getValue3().toString())));
				}
			}
		}
		for(Long orgId : orgIds){
			chart.getSeries(thisWeekTotal).adjustOrPutValueByCoordinate(orgs.get(orgId),thisWeekNumMap.get(orgId));
			Integer lastFourAvgInteger = lastFourWeekAvgMap.get(orgId);
			Double lastFourAvgDouble = null;
			if(lastFourAvgInteger != null){
				//lastFourAvgDouble = lastFourAvgInteger/4.0;
				lastFourAvgDouble = NumberUtil.divide(lastFourAvgInteger,4,0);
			}
			chart.getSeries(lastAvg4).adjustOrPutValueByCoordinate(orgs.get(orgId),lastFourAvgDouble);
		}
		return chart;
	}
}
