package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Row;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.*;
import java.util.Map.Entry;


@Service
public class YoYOrMoMMonthReportServiceImpl extends YoYOrMoMBaseService {

	@Resource
	private ZoneReportDataService zoneReportDataService;

	@Resource
	private GateReportDataService gateReportDataService;

	@Resource
	private FloorReportDataService floorReportDataService;

	@Resource
	private MallReportDataService mallReportDataService;

	/**近3月同环比报表*/
	public static final String REPORT_3MONTH_YoY ="Near3MonthYoY";
	/**本月每日同环比报表*/
	public static final String REPORT_DAYOFMONTH_YoY ="DayOfMonthYoY";
	/**本月工作日/双休日同环比报表*/
	public static final String REPORT_WEEKDAYOREND_YoY ="WeekDayOrEndYoY";

	public static final String REPORT_RECENTMONTH_TRAFFIC = "recentMonthTrafficTrend";

	public static final String REPORT_RECENTMONTH_YTREND = "recentMonthYTrend";

	public static final String REPOR_THISMONTHTRAFFIC_TREND = "thisMonthTrafficTrend";

	public static final String REPORTTHISMONTHYO_TREND = "thisMonthYOTrend";

	public static final String REPORT_MOREOBJECT_TABLE = "moreObjectTable";

	public static final String REPOR_MOREOBJECT_BAR = "moreObjectBar";

	public static final String REPORT_MOREOBJECT_CUSTOMIZE_TABLE = "moreObjectCustomizeTable";

	public static final String REPORT_MOREOBJECT_CUSTOMIZE_Bar = "moreObjectCustomizeBar";

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		Chart chart = null;
		List datas = null;

		if (orgType == OrgType.zone){
			datas = getNear3MonthZoneData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.gate){
			datas = getNear3MonthGateData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.floor){
			datas = getNear3MonthFloorData(orgIds, startDate, endDate, dataMap, kpiType);
		}else if (orgType == OrgType.mall) {
			datas = getNear3MonthMallData(orgIds, startDate, endDate, dataMap, kpiType);
		}
		switch (reportChart.getKey()) {
			case REPORT_3MONTH_YoY:/**近3月同环比报表*/
				chart = MonthsOfNear3YoY( startDate, endDate, datas, dataMap, reportChart,true,kpiType);
				break;
			case REPORT_DAYOFMONTH_YoY:/**本月每日同环比报表*/
				chart = DaysOfMonthYoY(startDate, endDate, datas, dataMap, reportChart,kpiType);
				break;
			case REPORT_WEEKDAYOREND_YoY:/**本月工作日/双休日同环比报表*/
				chart = MonthsOfNear3YoY(startDate, endDate, datas, dataMap, reportChart,false,kpiType);
				break;
			case REPORT_RECENTMONTH_TRAFFIC:
				chart = getRecentMonthTraffic(startDate,endDate,datas,reportChart);
				break;
			case REPORT_RECENTMONTH_YTREND:
				chart = getRecentMonthYTrendChart(startDate,endDate,datas,reportChart);
				break;
			case REPOR_THISMONTHTRAFFIC_TREND:
				chart = getTrafficTrendLine(startDate,endDate,datas,reportChart);
				break;
			case REPORTTHISMONTHYO_TREND:
				chart = getYOTrendLine(startDate,endDate,datas,reportChart);
				break;
			case REPORT_MOREOBJECT_TABLE:
				chart = getMoreObjectTable(orgIds,startDate,dataMap,reportChart);
				break;
			case REPOR_MOREOBJECT_BAR:
				chart = getMoreObjectBar(orgIds,startDate,dataMap,reportChart);
				break;
			case REPORT_MOREOBJECT_CUSTOMIZE_TABLE:
				chart = getCustomizeTable(orgIds,startDate,endDate,dataMap,reportChart);
				break;
			case REPORT_MOREOBJECT_CUSTOMIZE_Bar:
				chart = getCustomizeBar(orgIds,startDate,endDate,dataMap,reportChart);
				break;
			default:
				break;
		}
		return chart;
	}

	/**本月每日同环比
	 * @param datas   传入报表的数据
	 * @param kpiType
	 */
	private Chart DaysOfMonthYoY(Date startDate, Date endDate,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart, KPIType kpiType){

		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		final String ToY = LocalMessageUtil.getMessage("ToY");//国际化:昨日环比
		final String ToWD = LocalMessageUtil.getMessage("ToWD");//国际化:上周环比
		final String ToMD = LocalMessageUtil.getMessage("ToMD");//国际化:上月同日环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年同期环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int todayIndex = getIndexByTableHead(DateType.TODAY.getName());
				Number todayNum =  data.get(todayIndex) == null ? 0 : (Number) data.get(todayIndex);
				String result = "0%";
				if(getIndexByTableHead(ToWD) == index){
					Number lastweekdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTWEEKDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastweekdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(ToY) == index){
					Number yesterdayNum = (Number) data.get(getIndexByTableHead(DateType.YESTERDAY.getName()));
					result = NumberUtil.growthRate(todayNum, yesterdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else if(getIndexByTableHead(ToMD) == index){
					Number lastmonthdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTMONTHDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastmonthdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastyeardayNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastyeardayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else{
					return data.get(index);
				}

			}
		};

		TableHead tableHead = new TableHead();
		tableHead.addData(dateStr,DateType.TODAY.getName(),DateType.YESTERDAY.getName(),ToY,DateType.LASTWEEKDAY.getName(),ToWD,DateType.LASTMONTHDAY.getName(),ToMD,DateType.LASTYEARDAY.getName(),ToYD);
		table.setTableHead(tableHead);

		List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
		Collections.reverse(dates);
		putValue2Table(table, datas, dates,kpiType);

		return table;
	}

	/** 近3月同环比
	 * 本月工作日/双休日同环比
	 * @param
	 * @param
	 * @param datas
	 * @param dataMap
	 * @param reportChart
	 * @param kpiType
	 * @param
	 */
	private Chart MonthsOfNear3YoY(Date startDate,Date endDate,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart,boolean isNear3Month, KPIType kpiType){

		final String dateStr = LocalMessageUtil.getMessage("month");//国际化:月份
		final String ToWD = LocalMessageUtil.getMessage("ToWD");//国际化:上月环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年同月环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int thisMonth = getIndexByTableHead(DateType.MONTH.getName());
				Number thisMonthNum =  data.get(thisMonth) == null ? 0 : (Number) data.get(thisMonth);
				String result = "0%";
				if(getIndexByTableHead(ToWD) == index){
					Number lastMonthNum = (Number) data.get(getIndexByTableHead(DateType.LASTMONTH.getName()));
					result = NumberUtil.growthRate(thisMonthNum, lastMonthNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastyearMonthNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARMONTH.getName()));
					result = NumberUtil.growthRate(thisMonthNum, lastyearMonthNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else{
					return data.get(index);
				}

			}
		};

		TableHead tableHead = new TableHead();

		List<Date> dates = null;
		try {
			if (isNear3Month) {
				tableHead.addData(dateStr,DateType.MONTH.getName(),DateType.LASTMONTH.getName(),ToWD,DateType.LASTYEARMONTH.getName(),ToYD);
				table.setTableHead(tableHead);
				Date monthBeforLastMonth = DateUtil.addMonths(startDate, -5);
				dates = DateUtil.getDaysBetweenDates(monthBeforLastMonth, endDate);
				Collections.reverse(dates);
				putValue2Table(table, datas, dates,kpiType,true);
			}else {
				int monthNum = DateUtil.getMonth(startDate);
				String dateHeadStr = LocalMessageUtil.getMessage("Nmonth",new Object[]{monthNum});//国际化:N月
				tableHead.addData(dateHeadStr,DateType.MONTH.getName(),DateType.LASTMONTH.getName(),ToWD,DateType.LASTYEARMONTH.getName(),ToYD);
				table.setTableHead(tableHead);
				dates = DateUtil.getDaysBetweenDates(startDate, endDate);
				Collections.reverse(dates);
				putValue2Table(table, datas, dates,kpiType,false);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return table;
	}

	/** 得到近几个月的客流量的柱状图 */
	public Chart getRecentMonthTraffic(Date startDate,Date endDate,List<Data> datas,ReportChart reportChart){
		List<String> keys = new ArrayList<>();
		int nowMonth = DateUtil.getMonth(startDate);
		for(int i=0;i<6;i++){
			int index = nowMonth-Integer.parseInt(String.valueOf(i));
			if(index>0) {
				keys.add(i, LocalMessageUtil.getMessage("monthOfyearStrFormat", new Object[]{index}));
			}
		}
		return getRecentBar(keys,getRecentMonthYODataMap(startDate,endDate,datas,keys),startDate,reportChart);
	}

	/** 近几个月的同比趋势 */
	public Chart getRecentMonthYTrendChart(Date startDate,Date endDate,List<Data> datas,ReportChart reportChart){
		List<String> keys = new ArrayList<>();
		String now = DateUtil.format("yyyy",startDate);
		String last = DateUtil.format("yyyy",DateUtil.getLastYear(startDate));
		int nowMonth = DateUtil.getMonth(startDate);
		for(int i = 0;i<6;i++){
			int index = nowMonth-Integer.parseInt(String.valueOf(i));
			if(index>0) {
				keys.add(i, LocalMessageUtil.getMessage("monthOfyearStrFormat", new Object[]{index}));
			}
		}
		Map<String,Map<String,Object>> excelMap = getRecentMonthYODataMap(startDate,endDate,datas,keys);
		Map<String,Object> YOTrendMap = new LinkedHashMap<>();
		for (Entry entry : excelMap.entrySet()){
			Map<String,Object> map = (Map<String,Object>)entry.getValue();
			String growth = NumberUtil.growthRate((Double)map.get(now),(Double)map.get(last));
			if(growth != null) {
				growth = growth.replace("%", "");
			}
			YOTrendMap.put(entry.getKey().toString(),growth);
		}
		return getYoyTrend(keys,reportChart,YOTrendMap);
	}

	/**
	 * 得到近几月的所有数据，组装为Map
	 * @param startDate
	 * @param endDate
	 * @param datas
	 * @return
	 */
	private Map<String,Map<String,Object>> getRecentMonthYODataMap(Date startDate,Date endDate,List<Data> datas,List<String> keys){
		List<Date> dates = new ArrayList<>();
		Date startDate1 = DateUtil.getLastMonth(startDate);
		Date startDate2 = DateUtil.getLastMonth(startDate1);
		Date startDate3 = DateUtil.getLastMonth(startDate2);
		Date startDate4 = DateUtil.getLastMonth(startDate3);
		Date startDate5 = DateUtil.getLastMonth(startDate4);
		dates.add(0,endDate);
		dates.add(1,startDate);
		dates.add(2,startDate1);
		dates.add(3,startDate2);
		dates.add(4,startDate3);
		dates.add(5,startDate4);
		dates.add(6,startDate5);
//		Map<String,Map<String,Object>> resultMap = new LinkedHashMap<>();
//		for(int i = 0;i<keys.size();i++){
//			resultMap.put(keys.get(i),null);
//		}
		return getDataMap(dates,datas,keys);
	}

	/**
	 * 获取近三月的店铺数据
	 * @param zoneId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3MonthZoneData(Long[] zoneIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<ZoneDayCountData> zoneTraffic = zoneReportDataService.getNear3MonthZoneTraffic(zoneIds, startDate, endDate, dataMap);
		List<Sale> sales = zoneReportDataService.getNear3MonthZoneSale(zoneIds, startDate, endDate, dataMap);

		Map<Date, Integer> trafficMap = new HashMap<Date, Integer>();
		if (kpiType == KPIType.TRAFFIC || kpiType == KPIType.ENTERINGRATE ||kpiType == KPIType.HANDBAGRATE ||
				kpiType == KPIType.DURATIONTIME	) {
			if (zoneTraffic == null || zoneTraffic.size() <= 0 ) {
				return datas;
			}

			for (ZoneDayCountData zoneDayCountData : zoneTraffic) {
				Date date = zoneDayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = zoneDayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if ( kpiType == KPIType.ENTERINGRATE) {
					int innum = zoneDayCountData.getInnum();
					int passNum = zoneDayCountData.getOutsideInnum()+zoneDayCountData.getOutsideOutnum();
					Data data = new Data(null, date, innum, passNum);
					datas.add(data);
				}else if (kpiType == KPIType.HANDBAGRATE) {
					int innum = zoneDayCountData.getInnum();
					trafficMap.put(date, innum);
				}else if (kpiType == KPIType.DURATIONTIME) {
					int innum = zoneDayCountData.getInnum();
					List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(zoneIds, date, dataMap);
					int allHourInnum = 0;
					if (zoneDatas == null || zoneDatas.size() <= 0) {
						return datas;
					}
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						allHourInnum += zoneHourCountData.getInnum();
					}
					Data data = new Data(null, date, allHourInnum,innum);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES  || kpiType == KPIType.ORDER || kpiType == KPIType.PREPRICE ||
				kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.HANDBAGRATE){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.ORDER) {
					int value = sale.getSalecount();
					Data  data =  new Data(null,date,value);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleMoney, saleCount);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Long zoneId = sale.getZoneId();
					float zoneArea = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap).getArea();
					Data data = new Data(null, date, saleMoney, zoneArea);
					datas.add(data);
				}else if (kpiType == KPIType.HANDBAGRATE) {
					int innum = trafficMap.get(date);
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleCount,innum);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/**
	 * 获取近三月的监控点数据
	 * @param gateId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3MonthGateData(Long[] gateIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<GateDayCountData> gateTraffic = gateReportDataService.getNear3MonthGateTraffic(gateIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	) {
			if (gateTraffic == null || gateTraffic.size() <= 0 ) {
				return datas;
			}
			for (GateDayCountData gateDayCountData : gateTraffic) {
				Date date = gateDayCountData.getCountdate();
				int innum = gateDayCountData.getInnum();
				Data data = new Data(null, date, innum);
				datas.add(data);
			}
		}
		return datas;
	}

	/**
	 * 获取近三月楼层数据
	 * @param floorId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3MonthFloorData(Long[] floorIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<FloorDayCountData> floorTraffic = floorReportDataService.getNear3MonthFloorTraffic(floorIds, startDate, endDate, dataMap);
		List<Sale> sales = floorReportDataService.getNear3WeekFloorSale(floorIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	) {
			if (floorTraffic == null || floorTraffic.size() <= 0 ) {
				return datas;
			}
			for (FloorDayCountData DayCountData : floorTraffic) {
				Date date = DayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = DayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES ){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/**
	 * 获取近三月商场数据
	 * @param floorId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getNear3MonthMallData(Long[] mallIds,Date startDate,Date endDate,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		List<MallDayCountData> Traffic = mallReportDataService.getNear3MonthMallTraffic(mallIds, startDate, endDate, dataMap);
		List<Sale> sales = floorReportDataService.getNear3WeekFloorSale(mallIds, startDate, endDate, dataMap);

		if (kpiType == KPIType.TRAFFIC 	|| kpiType == KPIType.DURATIONTIME) {
			if (Traffic == null || Traffic.size() <= 0 ) {
				return datas;
			}
			for (MallDayCountData DayCountData : Traffic) {
				Date date = DayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC ) {
					int value = DayCountData.getInnum();
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.DURATIONTIME) {
					int innum = DayCountData.getInnum();
					Long mallId = DayCountData.getMallId();
					List<Long> zoneIds = mallReportDataService.getZoneIdsByMallId(mallId, dataMap);
					List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(zoneIds.toArray(new Long[zoneIds.size()]), date, dataMap);
					int allHourInnum = 0;
					if (zoneDatas == null || zoneDatas.size() <= 0) {
						return datas;
					}
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						allHourInnum += zoneHourCountData.getInnum();
					}
					Data data = new Data(null, date, allHourInnum,innum);
					datas.add(data);
				}
			}
		}
		if(kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE){
			if (sales == null || sales.size() <= 0) {
				return datas;
			}
			for (Sale sale : sales) {
				Date date = sale.getSaledate();
				double saleMoney = sale.getMoney();
				if (kpiType == KPIType.SALES ) {
					double value = saleMoney;
					Data data = new Data(null, date, value);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Data data = new Data(null, date, saleMoney, saleCount);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Long zoneId = sale.getZoneId();
					float zoneArea = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap).getArea();
					Data data = new Data(null, date, saleMoney, zoneArea);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/***
	 * 处理原始数据，把处理结果放入报表中
	 * 本月每日同环比
	 * @param table
	 * @param datas
	 * @param startDate
	 * @param endDate
	 */
	private void putValue2Table(Table table,List<Data> datas,List<Date> dates,KPIType kpiType){
		if (datas == null || datas.size() <= 0) {
			return;
		}
		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		Map<String, Date> serierDateMap = new HashMap<String, Date>();
		for (Date date : dates) {
			String serierName = DateUtil.format(DateUtil.FORMAT_SHORT_WEEK, date);
			table.getRow(serierName).putValueByHeadColumn(dateStr, serierName);
			serierDateMap.put(serierName, date);
		}
		List<Row> rows = table.getSeries();
		for (Row row : rows) {
			String serierName = row.getName();
			Date date = serierDateMap.get(serierName);
			for (Data data : datas) {
				Date countDate = data.getCountDate();
				DateType dateType = DateType.valueOfDay(date, countDate);
				if(dateType == null || dateType == DateType.NONE) {
					continue;
				}
				if(kpiType == KPIType.TRAFFIC || kpiType == KPIType.SALES || kpiType == KPIType.ORDER){
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
				}else if (kpiType == KPIType.ENTERINGRATE || kpiType == KPIType.HANDBAGRATE ) {
					double value1 = NumberUtil.parseDouble(data.getValue());
					double value2 = NumberUtil.parseDouble(data.getValue2()) ;
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.percentage(value1, value2, 2));
				}else if (kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.DURATIONTIME) {
					double value1 = NumberUtil.parseDouble(data.getValue());
					double value2 = NumberUtil.parseDouble(data.getValue2()) ;
					table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.divide(value1, value2, 2));
				}
			}
		}
	}

	/***
	 * 处理原始数据，把处理结果放入报表中
	 * 近三月同环比
	 * 本月工作日/双休日同环比
	 * @param table
	 * @param datas
	 * @param startDate
	 * @param endDate
	 * @throws ParseException
	 */
	private void putValue2Table(Table table,List<Data> datas,List<Date> dates,KPIType kpiType,boolean isNear3Month) throws ParseException{
		if (datas == null || datas.size() <= 0) {
			return;
		}
		int weekdayNum = 0,weekendNum = 0,monthNum = 0;
		Map<String, Date> serierDateMap = new HashMap<String, Date>();
		for (Date date : dates) {
			String dateStr ="" ,serierName = "";
			if (isNear3Month) {
				dateStr = LocalMessageUtil.getMessage("month");//国际化:月份
				monthNum = DateUtil.getMonth(date);
				serierName = LocalMessageUtil.getMessage("Nmonth",new Object[]{monthNum});
				serierDateMap.put(serierName, date);
				table.getRow(serierName).putValueByHeadColumn(dateStr, serierName);
			}else {
				if (weekdayNum > 0) {
					break;
				}
				Date workDate = null,weekendDate = null;
				for (Date today : dates) {
					if (DateUtil.getDayOfWeek(today)>5) {
						weekendNum ++;
						weekendDate = today;
					}else {
						weekdayNum++;
						workDate = today;
					}
				}
				monthNum = DateUtil.getMonth(date);
				dateStr = LocalMessageUtil.getMessage("Nmonth",new Object[]{monthNum});//国际化:N月
				String weekdayStrValue = LocalMessageUtil.getMessage("weekdayN",new Object[]{weekdayNum});
				table.getRow(weekdayStrValue).putValueByHeadColumn(dateStr, weekdayStrValue);
				serierDateMap.put(weekdayStrValue, workDate);
				String weekendStrValue = LocalMessageUtil.getMessage("weekendN",new Object[]{weekendNum});
				table.getRow(weekendStrValue).putValueByHeadColumn(dateStr, weekendStrValue);
				serierDateMap.put(weekendStrValue, weekendDate);
			}
		}

		List<Row> rows = table.getSeries();
		for(Row row : rows){
			String serierName = row.getName();
			System.out.println("serierName>>>>>>>>>>>>>>>>>>>>>>>>>>>"+serierName);
			Date date = serierDateMap.get(serierName);
			Map<DateType, Double> valueMap1 = new HashMap<DateType, Double>();
			Map<DateType, Double> valueMap2 = new HashMap<DateType, Double>();

			for (Data data : datas) {
				Date countDate = data.getCountDate();
				if (!isNear3Month) {
					System.out.println("date时间》》》》》》》》》》》》》》》》》》》》》》》》》》》》》》》》》》"+date);

					if(date==null || countDate==null){
						continue;
					}
					boolean serierFlag = DateUtil.isWeekday(date);
					boolean dataFlag = DateUtil.isWeekday(countDate);
					if (serierFlag != dataFlag ) {
						continue;
					}
				}
				DateType dateType = DateType.valueOfMonth(date, countDate);
				if(dateType == null || dateType == DateType.NONE) {
					continue;
				}
				double value1=0.0,value2 = 0.0;
				switch (kpiType) {
					case TRAFFIC:
					case SALES:
					case ORDER:
						table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
						break;
					case ENTERINGRATE:
					case HANDBAGRATE:
					case PREPRICE:
						value1 = NumberUtil.parseDouble(data.getValue()) ;
						value2 = NumberUtil.parseDouble(data.getValue2());
						if (valueMap1.get(dateType)==null) {
							valueMap1.put(dateType, 0.0);
						}
						Double allValues1 = valueMap1.get(dateType);
						allValues1 += value1;
						valueMap1.put(dateType, allValues1);
						if (valueMap2.get(dateType)==null) {
							valueMap2.put(dateType, 0.0);
						}
						Double allValue2 = valueMap1.get(dateType);
						allValue2 += value2;
						valueMap2.put(dateType, allValue2);
						break;

					case PERAREAVALUE:
					case DURATIONTIME:
						value1 = NumberUtil.parseDouble(data.getValue());
						value2 = NumberUtil.parseDouble(data.getValue2());
						table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(),NumberUtil.divide(value1, value2, 2));
						break;
					default:
						break;
				}
			}
			if (kpiType == KPIType.ENTERINGRATE || kpiType == KPIType.PREPRICE ||kpiType == KPIType.HANDBAGRATE) {
				for (Entry<DateType, Double> entity:valueMap1.entrySet()) {
					DateType dateType = entity.getKey();
					double allValues1 = valueMap1.get(dateType);
					double allValues2 = valueMap2.get(dateType);
					if (kpiType == KPIType.PREPRICE ) {
						table.getRow(serierName).putValueByHeadColumn(dateType.getName(), NumberUtil.divide(allValues1, allValues2, 2));
					}else {
						table.getRow(serierName).putValueByHeadColumn(dateType.getName(), NumberUtil.percentage(allValues1, allValues2, 2));
					}
				}
			}
		}
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

//	class Data<T,O>{
//		private Date countTime;
//		private Date countDate;
//		private T value;
//		private O value2;
//
//		public Data(Date countTime, Date countDate, T value) {
//			this(countTime,countDate,value,null);
//		}
//
//		public Data(Date countTime, Date countDate, T value, O value2) {
//			this.countTime = countTime;
//			this.countDate = countDate;
//			this.value = value;
//			this.value2 = value2;
//		}
//
//		public Date getCountTime() {
//			return countTime;
//		}
//		public void setCountTime(Date countTime) {
//			this.countTime = countTime;
//		}
//		public Date getCountDate() {
//			return countDate;
//		}
//		public void setCountDate(Date countDate) {
//			this.countDate = countDate;
//		}
//		public T getValue() {
//			return value;
//		}
//		public void setValue(T value) {
//			this.value = value;
//		}
//
//		public O getValue2() {
//			return value2;
//		}
//
//		public void setValue2(O value2) {
//			this.value2 = value2;
//		}
//	}
//
	/**
	 * @Description: 得到同环比分析多对象的表格
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/14
	 */
	private Chart getMoreObjectTable(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart){
		Table table = new Table(reportChart.getTitle());
		TableHead tableHead = new TableHead();
		Map<Long, String> orgs = getOrgsMap(dataMap);
		String name = LocalMessageUtil.getMessage("NAME");
		String thisMonthTotal = LocalMessageUtil.getMessage("THISMONTHTOTAL");
		String lastMonthTotal = LocalMessageUtil.getMessage("LASTMONTHTOTAL");
		String lastMonthYo = LocalMessageUtil.getMessage("ToMD");
		String lastYearMonth = LocalMessageUtil.getMessage("LASTYEARMONTH");
		String lastYearYO = LocalMessageUtil.getMessage("ToYD");
		tableHead.addData(name);
		tableHead.addData(thisMonthTotal);
		tableHead.addData(lastMonthTotal);
		tableHead.addData(lastMonthYo);
		tableHead.addData(lastYearMonth);
		tableHead.addData(lastYearYO);
		table.setTableHead(tableHead);
		Date startDate = DateUtil.getFirstDateOfMonth(date);
		Date endDate = DateUtil.getLastDateOfMonth(date);
		Date lastMonthStartDate = DateUtil.getLastMonth(startDate);
		Date lastYearStartDate = DateUtil.getLastYear(startDate);
		Date lastYearEndDate = DateUtil.getLastYear(endDate);
		List<Data> datas = getMoreObjectData(orgIds, lastYearStartDate, endDate, dataMap);
		for (Long orgId : orgIds){
			table.getRow(orgs.get(orgId)).putValueByHeadColumn(name,orgs.get(orgId));
		}
		for (Data data : datas){
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisMonthTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisMonthTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisMonthTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisMonthTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisMonthTotal, data.getValue());
			} else if (DateUtil.compareDate(data.getCountDate(), lastMonthStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), startDate) == -1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastMonthTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastMonthTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastMonthTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastMonthTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastMonthTotal, data.getValue());
			} else if (DateUtil.compareDate(data.getCountDate(), lastYearStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), lastYearEndDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearMonth) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearMonth, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearMonth).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearMonth, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearMonth, data.getValue());
			}
		}
		for (Long orgId : orgIds){
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisMonthTotal) == null) {
				continue;
			}
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastMonthTotal) != null){
				String lastMonthYOStr = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisMonthTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastMonthTotal)));
//				if(lastMonthYOStr != null) {
//					lastMonthYOStr = lastMonthYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastMonthYo, lastMonthYOStr);

			}
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearMonth) != null) {
				String lastYearYOStr = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisMonthTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearMonth)));
//				if(lastYearYOStr != null) {
//					lastYearYOStr = lastYearYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastYearYO,lastYearYOStr );

			}
		}
		return table;
	}


	/**
	 * @Description: 得到多对象的柱状图
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/14
	 */
	private Chart getMoreObjectBar(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		String thisMonthTotal = LocalMessageUtil.getMessage("THISMONTHTOTAL");
		String lastMonthTotal = LocalMessageUtil.getMessage("LASTMONTHTOTAL");
		Map<Long, String> orgs = getOrgsMap(dataMap);
		Axis xAxis = AxisFactory.createStringAxis();
		Date startDate = DateUtil.getFirstDateOfMonth(date);
		Date endDate = DateUtil.getLastDateOfMonth(date);
		Date lastMonthStartDate = DateUtil.getLastMonth(startDate);
		List<Data> datas = getMoreObjectData(orgIds, lastMonthStartDate, endDate, dataMap);
		for(Long orgId : orgIds){
			xAxis.addData(orgs.get(orgId));
		}
		chart.setXAxis(xAxis);
		Map<Long,Integer> thisMonthNumMap = new HashMap<>();
		Map<Long,Integer> lastMonthMap = new HashMap<>();

		for (Data data : datas){
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
				if(thisMonthNumMap.get(data.getValue3())==null) {
					thisMonthNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					thisMonthNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+thisMonthNumMap.get(Long.parseLong(data.getValue3().toString())));
				}

			}else if (DateUtil.compareDate(data.getCountDate(), lastMonthStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), startDate) == -1){
				if(lastMonthMap.get(data.getValue3())==null) {
					lastMonthMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					lastMonthMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+lastMonthMap.get(Long.parseLong(data.getValue3().toString())));
				}
			}
		}
		for(Long orgId : orgIds){
			chart.getSeries(thisMonthTotal).adjustOrPutValueByCoordinate(orgs.get(orgId),thisMonthNumMap.get(orgId));
			chart.getSeries(lastMonthTotal).adjustOrPutValueByCoordinate(orgs.get(orgId),lastMonthMap.get(orgId));
		}
		return chart;
	}

	/**
	 * @Description: 得到多对象的自定义表格
	 * @Param: [orgIds, startDate, endDate, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/14
	 */
	private Chart getCustomizeTable(Long[] orgIds,Date startDate,Date endDate,Map<String,Object> dataMap,ReportChart reportChart){
		Table table = new Table(reportChart.getTitle());
		Map<Long, String> orgs = getOrgsMap(dataMap);
		String name = LocalMessageUtil.getMessage("NAME");
		String thisMonthTotal = LocalMessageUtil.getMessage("ParamName.traffic");
		String lastMonthTotal = LocalMessageUtil.getMessage("DateType.lastMonthDay");
		String lastMonthYo = LocalMessageUtil.getMessage("ToMD");
		String lastYearMonth = LocalMessageUtil.getMessage("DateType.lastYearDay");
		String lastYearYO = LocalMessageUtil.getMessage("ToYD");
		TableHead tableHead = new TableHead();
		tableHead.addData(name);
		tableHead.addData(thisMonthTotal);
		tableHead.addData(lastMonthTotal);
		tableHead.addData(lastMonthYo);
		tableHead.addData(lastYearMonth);
		tableHead.addData(lastYearYO);
		table.setTableHead(tableHead);
		Date lastMonthStartDate = DateUtil.getLastMonth(startDate);
		Date lastMonthEndDate = DateUtil.getLastMonth(endDate);
		Date lastYearStartDate = DateUtil.getLastYear(startDate);
		Date lastYearEndDate = DateUtil.getLastYear(endDate);
		List<Data> datas = getMoreObjectData(orgIds, lastYearStartDate, endDate, dataMap);
		for (Long orgId : orgIds){
			table.getRow(orgs.get(orgId)).putValueByHeadColumn(name,orgs.get(orgId));
		}
		for (Data data : datas){
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisMonthTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisMonthTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(thisMonthTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisMonthTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(thisMonthTotal, data.getValue());
			} else if (DateUtil.compareDate(data.getCountDate(), lastMonthStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), lastMonthEndDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastMonthTotal) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastMonthTotal, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastMonthTotal).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastMonthTotal, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastMonthTotal, data.getValue());
			} else if (DateUtil.compareDate(data.getCountDate(), lastYearStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), lastYearEndDate) != 1) {
//				if (table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearMonth) == null) {
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearMonth, data.getValue());
//				} else {
//					Integer innum = Integer.parseInt(data.getValue().toString()) + Integer.parseInt(table.getRow(zones.get(data.getValue3())).getValueByHeadColumn(lastYearMonth).toString());
//					table.getRow(zones.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearMonth, innum);
//				}
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYearMonth, data.getValue());
			}
		}
		for (Long orgId : orgIds){
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisMonthTotal) == null) {
				continue;
			}
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastMonthTotal) != null){
				String lastMonthYOStr = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisMonthTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastMonthTotal)));
//				if(lastMonthYOStr != null) {
//					lastMonthYOStr = lastMonthYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastMonthYo,lastMonthYOStr );
			}
			if (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearMonth) != null) {
				String lastYearYOStr = NumberUtil.growthRate((Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(thisMonthTotal)), (Number) (table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYearMonth)));
//				if(lastYearYOStr != null) {
//					lastYearYOStr = lastYearYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastYearYO,lastYearYOStr );

			}
		}
		return table;
	}


	/**
	 * @Description: 多对象的自定义柱状图
	 * @Param: [orgIds, startDate, endDate, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/14
	 */
	private Chart getCustomizeBar(Long[] orgIds,Date startDate,Date endDate,Map<String,Object> dataMap,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		String thisMonthTotal = LocalMessageUtil.getMessage("ParamName.traffic");
		String lastMonthTotal = LocalMessageUtil.getMessage("DateType.lastMonthDay");
		Map<Long, String> orgs = getOrgsMap(dataMap);
		Axis xAxis = AxisFactory.createStringAxis();
		Date lastMonthStartDate = DateUtil.getLastMonth(startDate);
		Date lastMonthEndDate = DateUtil.getLastMonth(endDate);
		List<Data> datas = getMoreObjectData(orgIds, lastMonthStartDate, endDate, dataMap);
		for(Long orgId : orgIds){
			xAxis.addData(orgs.get(orgId));
		}
		chart.setXAxis(xAxis);
		Map<Long,Integer> thisMonthNumMap = new HashMap<>();
		Map<Long,Integer> lastMonthMap = new HashMap<>();

		for (Data data : datas){
			if (DateUtil.compareDate(data.getCountDate(), startDate) != -1 && DateUtil.compareDate(data.getCountDate(), endDate) != 1) {
				if(thisMonthNumMap.get(data.getValue3())==null) {
					thisMonthNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					thisMonthNumMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+thisMonthNumMap.get(Long.parseLong(data.getValue3().toString())));
				}

			}else if (DateUtil.compareDate(data.getCountDate(), lastMonthStartDate) != -1 && DateUtil.compareDate(data.getCountDate(), lastMonthEndDate) != 1){
				if(lastMonthMap.get(data.getValue3())==null) {
					lastMonthMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString()));
				}else{
					lastMonthMap.put(Long.parseLong(data.getValue3().toString()),Integer.parseInt(data.getValue().toString())+lastMonthMap.get(Long.parseLong(data.getValue3().toString())));
				}
			}
		}
		for(Long orgId : orgIds){
			chart.getSeries(thisMonthTotal).adjustOrPutValueByCoordinate(orgs.get(orgId),thisMonthNumMap.get(orgId));
			chart.getSeries(lastMonthTotal).adjustOrPutValueByCoordinate(orgs.get(orgId),lastMonthMap.get(orgId));
		}
		return chart;
	}
}
