package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Row;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.*;
import com.viontech.mall.service.adapter.ZoneService;
import javafx.beans.binding.ObjectExpression;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.net.Inet4Address;
import java.util.*;


@Service
public class YoYOrMoMDayReportServiceImpl extends YoYOrMoMBaseService {

	@Resource
	private ZoneReportDataService zoneReportDataService;

	@Resource
	private GateReportDataService gateReportDataService;

	@Resource
	private FloorReportDataService floorReportDataService;

	@Resource
	private ZoneService zoneService;

	@Resource
	private MallReportDataService mallReportDataService;


	/**今日实时时刻同环比报表*/
	public static final String REPORT_DAY_COUNTING_YoY ="DayCountingYoY";
	/**近15天同环比报表*/
	public static final String REPORT_15DAY_COUNTING_YoY ="15DayCountingYoY";
	/**今日累计同环比报表*/
	public static final String REPORT_DAY_ADD_YoY ="DayAddYoY";

	/** 近15天同环比报表客流量趋势图 */
	public static final String REPORT_15TREND_LINE = "15TrafficTrendLine";

	/** 近15天同环比报表的同环比趋势折线图 */
	public static final String REPOR_15YOTREND_LINE = "15YOTrendLine";

	/** 今日实时客流同环比客流量趋势图 */
	public static final String REPORT_REALTIME_TRAFFIC_TREND = "realTimeTrafficTrendLine";

	/** 今日实时客流同环比同环比趋势图 */
	public static final String REPORT_REALTIME_YO_TREND = "realTimeYOTrendLine";

	public static final String REPORT_TOTALTRAFFIC_TREND = "totalTrafficTrendLine";

	public static final String REPORT_TOTALYO_TREND = "totalYOTrendLine";

	public static final String REPORT_MOREOBJECT_TABLE = "moreObjectTable";

	public static final String REPOR_MOREOBJECT_BAR = "moreObjectBar";

	public static final String REPORT_CUSTOMIZE_TABLE = "CustomizeDatesTable";

	public static final String REPOR_CUSTOMIZE_TRAFFIC_TREND_LINE = "CustomizeTrafficTrendLine";

	public static final String REPORT_CUSTOMIZE_YO_TREND_TABLE = "CustomizeYOTrendLine";
	/**
	 *
	 * @param startDate   查询起始日期（可选）
	 * @param endDate     查询结束日期（可选）
	 * @param dataMap     数据存放Map（可以将该报表中重复使用的数据放入）
	 * @param reportChart  该报表的基本信息（必须）
	 * @return
	 */
	public Chart getChart(Long[] orgIds,  Date startDate, Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		dataMap.put("orgIds",orgIds);
		Date date = startDate;
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");

		Chart chart = null;
		List datas = null;
		List near15Datas = null;
		if (orgType == OrgType.zone) {
			datas = getZoneHourReportData(orgIds, date, dataMap, kpiType);
			near15Datas = getZoneReportNera15Data(orgIds, date, dataMap, kpiType);
		}else if (orgType == OrgType.gate) {
			datas = getGateHourReportData(orgIds, date, dataMap, kpiType);
			near15Datas = getGateReportNera15Data(orgIds, date, dataMap, kpiType);
		}else if (orgType == OrgType.floor) {
			datas = getFloorHourReportData(orgIds, date, dataMap, kpiType);
			near15Datas = getFloorReportNera15Data(orgIds, date, dataMap, kpiType);
		}else if (orgType == OrgType.mall) {
			datas = getMallHourReportData(orgIds, date, dataMap, kpiType);
			near15Datas = getMallReportNera15Data(orgIds, date, dataMap, kpiType);
		}
		List<Data> customizeData = null;
		Date lastYearDay = DateUtil.getLastYear(startDate);
		switch (reportChart.getKey()) {
			case REPORT_DAY_COUNTING_YoY:/**今日实时时刻同环比报表*/
				chart = DayOrTimeCountingYoY(date,datas,dataMap,reportChart,true, kpiType);
				break;
			case REPORT_DAY_ADD_YoY:/**今日累计实时同环比报表*/
				chart = DayAddYoY(date,datas,dataMap,reportChart, kpiType);
				break;
			case REPORT_15DAY_COUNTING_YoY:/**近15天同环比报表*/
				chart = DayOrTimeCountingYoY(date,near15Datas,dataMap,reportChart,false, kpiType);
				break;
			case REPORT_15TREND_LINE:
				chart = getTrafficTrendLine(DateUtil.addDays(date,-14),date,near15Datas,reportChart);
				break;
			case REPOR_15YOTREND_LINE:
				chart = getYOTrendLine(DateUtil.addDays(date,-14),date,near15Datas,reportChart);
				break;
			case REPORT_REALTIME_TRAFFIC_TREND:
				chart = getRealTimeTrafficTrend(orgIds[0],dataMap,date,datas,reportChart,false);
				break;
			case REPORT_REALTIME_YO_TREND:
				chart = getRealTimeYOTreand(orgIds[0],date,datas,dataMap,reportChart,false);
				break;
			case REPORT_TOTALTRAFFIC_TREND:
				chart = getRealTimeTrafficTrend(orgIds[0],dataMap,date,datas,reportChart,true);
				break;
			case REPORT_TOTALYO_TREND:
				chart = getRealTimeYOTreand(orgIds[0],date,datas,dataMap,reportChart,true);
				break;
			case REPORT_MOREOBJECT_TABLE:
				chart = getMoreObjectTable(orgIds,date,dataMap,reportChart);
				break;
			case REPOR_MOREOBJECT_BAR:
				chart = getMoreObjectBar(orgIds,date,dataMap,reportChart);
				break;
			case REPORT_CUSTOMIZE_TABLE:
				customizeData = getMoreObjectData(orgIds,lastYearDay,endDate,dataMap);
				chart = getCustomizeTable(startDate,endDate,customizeData,dataMap,reportChart,kpiType);
				break;
			case REPOR_CUSTOMIZE_TRAFFIC_TREND_LINE:
				customizeData = getMoreObjectData(orgIds,lastYearDay,endDate,dataMap);
				chart = getTrafficTrendLine(startDate,endDate,customizeData,reportChart);
				break;
			case REPORT_CUSTOMIZE_YO_TREND_TABLE:
				customizeData = getMoreObjectData(orgIds,lastYearDay,endDate,dataMap);
				chart = getYOTrendLine(startDate,endDate,customizeData,reportChart);
				break;
			default:
				break;
		}
		return chart;
	}


	/**今日时刻实时  同环比增长率报表
	 * @param datas   传入报表的数据
	 * @param kpiType
	 */
	private Chart DayOrTimeCountingYoY(Date date,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart,boolean isTimeCounting, KPIType kpiType){

		final String timeQuantum = LocalMessageUtil.getMessage("timeQuantum");//国际化:时间段
		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		final String ToY = LocalMessageUtil.getMessage("ToY");//国际化:昨日环比
		final String ToWD = LocalMessageUtil.getMessage("ToWD");//国际化:上周环比
		final String ToMD = LocalMessageUtil.getMessage("ToMD");//国际化:上月同日环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年同期环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int todayIndex = getIndexByTableHead(DateType.TODAY.getName());
				Number todayNum = (Number) data.get(todayIndex);
				String result = null;
				if(index ==  getIndexByTableHead(ToY)  ){
					Number yesterdayNum = (Number) data.get(getIndexByTableHead(DateType.YESTERDAY.getName()));
					result = NumberUtil.growthRate(todayNum , yesterdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result;
				}else if(getIndexByTableHead(ToWD) == index){
					Number lastweekdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTWEEKDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastweekdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(ToMD) == index){
					Number lastmonthdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTMONTHDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastmonthdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastyeardayNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastyeardayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else{
					return data.get(index);
				}
			}
		};

		TableHead tableHead = new TableHead();
		if (isTimeCounting) {
			tableHead.addData(timeQuantum,DateType.TODAY.getName(),DateType.YESTERDAY.getName(),ToY,DateType.LASTWEEKDAY.getName(),ToWD,DateType.LASTMONTHDAY.getName(),ToMD,DateType.LASTYEARDAY.getName(),ToYD);
			table.setTableHead(tableHead);
			putValue2Table(table, datas, date,true,dataMap);
		}else {
			tableHead.addData(dateStr,DateType.TODAY.getName(),DateType.YESTERDAY.getName(),ToY,DateType.LASTWEEKDAY.getName(),ToWD,DateType.LASTMONTHDAY.getName(),ToMD,DateType.LASTYEARDAY.getName(),ToYD);
			table.setTableHead(tableHead);
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			List<Date> dates =  DateUtil.getDaysBetweenDates(startDate, date);
			dates.add(date);
			Collections.reverse(dates);
			putValue2Table(table, datas, dates);
		}

		return table;
	}

	/**
	 * @Description: 得到今日实时|累计客流同环比报表的客流量趋势
	 * @Param: [orgId, dataMap, date, datas, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/6
	 */
	private Chart getRealTimeTrafficTrend(Long orgId,Map<String,Object>dataMap,Date date,List<Data> datas,ReportChart reportChart,Boolean isTotal){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		//当日
		String today = LocalMessageUtil.getMessage("DateType.today");
		//上月同期
		String lastMonth = LocalMessageUtil.getMessage("DateType.lastMonthDay");
		//去年同期
		String lastYear = LocalMessageUtil.getMessage("DateType.lastYearDay");
		BaseDataServiceImpl.DateCriteria mallOpentime = zoneReportDataService.getMallOpentimesByOrgId(orgId,null,dataMap);
		Axis<String> xAxis = AxisFactory.createStringAxis();
		Date openTime = mallOpentime.getStartDate();
		Date closeTime = mallOpentime.getEndDate();
		Date currentTime = openTime;
		while(currentTime.before(closeTime)|| currentTime.equals(closeTime)){
			String dateStr = DateUtil.format("HH:00",currentTime);
			xAxis.addData(dateStr);
			currentTime = DateUtil.addHours(currentTime,1);
		}
		//可能情况还需要转换一下，MM-dd形式
//		if (!xAxis.isLock()){
//			xAxis.lock();
//		}
		xAxis.lock();
		chart.setXAxis(xAxis);
		chart.getSeries(today);
		chart.getSeries(lastMonth);
		chart.getSeries(lastYear);
		Map<String,Data> dataNow = new HashMap<>();
		Map<String,Data> dataLastMonth = new HashMap<>();
		Map<String,Data> dataLastYear = new HashMap<>();
		Date startDateLastMonth = DateUtil.getLastMonth(date);
		//得到的countdate的形式是怎么样的
		for (Data data : datas){
			if(DateUtil.compareDate(data.getCountDate(),date)!=-1){
				dataNow.put(DateUtil.format("HH:00",data.getCountTime()),data);
			}else if(DateUtil.compareDate(data.getCountDate(),startDateLastMonth)!= -1 && DateUtil.compareDate(data.getCountDate(),date) == -1){
				dataLastMonth.put(DateUtil.format("HH:00",data.getCountTime()),data);
			}else if(DateUtil.compareDate(data.getCountDate(),startDateLastMonth)==-1){
				dataLastYear.put(DateUtil.format("HH:00",data.getCountTime()),data);
			}
		}
		//之后判断是否得在营业时间内
		Integer nowTotal = 0;
		Integer lastMonthTotal = 0;
		Integer lastYearTotal = 0;
		List xAxisList = chart.getXAxis().getData();
		Date nowTime = openTime;
		//for(Data data : dataNow){
		while(nowTime.before(closeTime)|| nowTime.equals(closeTime)) {
			String now = DateUtil.format("HH:00",nowTime);
//			if (!DateUtil.isSameDay(date, data.getCountDate()) || !xAxisList.contains(now)) {
//				continue;
//			}
			Integer nowNum = 0;
			if(dataNow.get(now)!=null){
				nowNum = (Integer) dataNow.get(now).getValue();
			}
			nowTotal += nowNum;
			//Integer totalValue = nowTotal.intValue();

			if (!isTotal) {
				if(dataNow.get(now)!=null) {
					chart.getSeries(today).adjustOrPutValueByCoordinate(now, dataNow.get(now).getValue());
				}
			} else {
				chart.getSeries(today).adjustOrPutValueByCoordinate(now, nowTotal);
			}
			//}
			//for (Data data : dataLastMonth){
			//String now = DateUtil.format("HH:00", DateUtil.getNextMonth(data.getCountTime()));
//			if (!DateUtil.isLastMonthDay(date, data.getCountDate()) || !xAxisList.contains(now)) {
//				continue;
//			}

			Integer lastMonthNum = 0;
			if(dataLastMonth.get(now)!=null){
				lastMonthNum = (Integer) dataLastMonth.get(now).getValue();
			}
			lastMonthTotal += lastMonthNum;

			//lastMonthTotal += (Integer) data.getValue();
			//Integer totalValue = lastMonthTotal.intValue();

			if (!isTotal) {
				if(dataLastMonth.get(now)!=null) {
					chart.getSeries(lastMonth).adjustOrPutValueByCoordinate(now, dataLastMonth.get(now).getValue());
				}
			} else {
				chart.getSeries(lastMonth).adjustOrPutValueByCoordinate(now, lastMonthTotal);
			}
			//}
			//for (Data data : dataLastYear){
//			String now = DateUtil.format("HH:00", getNextYear(data.getCountTime()));
//			if (!DateUtil.isLastYearDay(date, data.getCountDate()) || !xAxisList.contains(now)) {
//				continue;
//			}
			//lastYearTotal += (Integer) data.getValue();
			//Integer totalValue = lastYearTotal.intValue();
			Integer lastYearNum = 0;
			if(dataLastYear.get(now)!=null){
				lastYearNum = (Integer) dataLastYear.get(now).getValue();
			}
			lastYearTotal += lastYearNum;

			if (!isTotal) {
				if(dataLastYear.get(now)!=null) {
					chart.getSeries(lastYear).adjustOrPutValueByCoordinate(now, dataLastYear.get(now).getValue());
				}
			} else {
				chart.getSeries(lastYear).adjustOrPutValueByCoordinate(now, lastYearTotal);
			}
			//}
			nowTime = DateUtil.addHours(nowTime,1);
		}

		return chart;
	}

	/**
	 * @Description: 得到今日实时|累计客流同环比报表的同环比趋势
	 * @Param: [orgId, nDate, datas, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/6
	 */
	private Chart getRealTimeYOTreand(Long orgId,Date nDate,List<Data> datas,Map<String,Object>dataMap,ReportChart reportChart,Boolean isTotal){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		//上月环比
		String mD = LocalMessageUtil.getMessage("ToMD");
		//去年同比
		String yD = LocalMessageUtil.getMessage("ToYD");
		BaseDataServiceImpl.DateCriteria mallOpentime = zoneReportDataService.getMallOpentimesByOrgId(orgId,null,dataMap);
		//Axis xAxis = AxisFactory.createHourOfDayAxis();
		Axis<String> xAxis = AxisFactory.createStringAxis();
		Date openTime = mallOpentime.getStartDate();
		Date closeTime = mallOpentime.getEndDate();
		Date currentTime = openTime;
		while(currentTime.before(closeTime)|| currentTime.equals(closeTime)){
			String dateStr = DateUtil.format("HH:00",currentTime);
			xAxis.addData(dateStr);
			currentTime = DateUtil.addHours(currentTime,1);
		}
		//可能情况还需要转换一下，MM-dd形式
//		xAxis.setMin(mallOpentime.getStartDate());
//		xAxis.setMax(mallOpentime.getEndDate());
//		xAxis.lockMinMax();
		chart.setXAxis(xAxis);
		chart.getSeries(mD);
		chart.getSeries(yD);
		Map<String,Object> dataNow = new HashMap<>();
		Map<String,Object> dataLastMonth = new HashMap<>();
		Map<String,Object> dataLastYear = new HashMap<>();
		Date startDateLastMonth = DateUtil.getLastMonth(nDate);
		for(Data data : datas){
			if(DateUtil.compareDate(data.getCountDate(),nDate)!=-1){
				if(DateUtil.isSameDay(nDate,data.getCountDate())) {
					String counttime = DateUtil.format("HH:00", data.getCountTime());
					dataNow.put(counttime, data.getValue());
				}
			}else if(DateUtil.compareDate(data.getCountDate(),startDateLastMonth)!= -1 && DateUtil.compareDate(data.getCountDate(),nDate) == -1){
				if(DateUtil.isLastMonthDay(nDate,data.getCountDate())) {
					String now = DateUtil.format("HH:00", DateUtil.getNextMonth(data.getCountTime()));
					dataLastMonth.put(now, data.getValue());
				}
			}else if(DateUtil.compareDate(data.getCountDate(),startDateLastMonth)==-1){
				if(DateUtil.isLastYearDay(nDate,data.getCountDate())) {
					String now = DateUtil.format("HH:00", getNextYear(data.getCountTime()));
					dataLastYear.put(now, data.getValue());
				}
			}
		}
		//List<Date> dateList  = DateUtil.getDaysBetweenDates(mallOpentime.getStartDate(),mallOpentime.getEndDate());
		Double nowDate = null;
		Double lastMonth = null;
		Double lastYear = null;
		Date startTime = mallOpentime.getStartDate();
		Date endTime = mallOpentime.getEndDate();
		Date nowTime = startTime;

		Double nowDateTotal = 0.0;
		Double lastMonthDataTotal = 0.0;
		Double lastYearDataTotal = 0.0;
		while(nowTime.before(endTime)|| nowTime.equals(endTime)){
			String templeTime = DateUtil.format("HH:00",nowTime);
			if((dataNow.get(templeTime)==null && nowDateTotal == 0.0 && isTotal) || (dataNow.get(templeTime)==null && !isTotal)){
				nowTime = DateUtil.addHours(nowTime,1);
				continue;
			}

			if(dataNow.get(templeTime) != null) {
				nowDate = Double.parseDouble(dataNow.get(templeTime).toString());
				nowDateTotal += nowDate.doubleValue();
			}
			String lastMonthGrowth = null;
			String lastYearGrowth = null;
			if(dataLastMonth.get(templeTime)!=null) {
				lastMonth = Double.parseDouble(dataLastMonth.get(templeTime).toString());
				lastMonthDataTotal += lastMonth.doubleValue();
			}
				if(!isTotal) {
					if(dataLastMonth.get(templeTime)!=null) {
						lastMonthGrowth = NumberUtil.growthRate(nowDate.doubleValue(), lastMonth.doubleValue());
					}
				}else{
					lastMonthGrowth = NumberUtil.growthRate(nowDateTotal.doubleValue(), lastMonthDataTotal.doubleValue());
				}
				if(lastMonthGrowth != null) {
					lastMonthGrowth = lastMonthGrowth.replace("%", "");
				}

			if(dataLastYear.get(templeTime)!=null) {
				lastYear = Double.parseDouble(dataLastYear.get(templeTime).toString());
				lastYearDataTotal += lastYear.doubleValue();
			}
				if(!isTotal) {
					if(dataLastYear.get(templeTime)!=null) {
						lastYearGrowth = NumberUtil.growthRate(nowDate.doubleValue(), lastYear.doubleValue());
					}
				}else{
					lastYearGrowth = NumberUtil.growthRate(nowDateTotal.doubleValue(), lastYearDataTotal.doubleValue());
				}
				if(lastYearGrowth != null) {
					lastYearGrowth = lastYearGrowth.replace("%", "");
				}

			String dateStr = DateUtil.format("HH:00",nowTime);
			chart.getSeries(mD).adjustOrPutValueByCoordinate(dateStr,lastMonthGrowth);
			chart.getSeries(yD).adjustOrPutValueByCoordinate(dateStr,lastYearGrowth);
			nowTime = DateUtil.addHours(nowTime,1);
		}
		return chart;
	}

	/**今日时刻累计同环比增长率报表
	 * @param datas   传入报表的数据
	 * @param kpiType
	 */
	private Chart DayAddYoY(final Date date,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart, KPIType kpiType){

		final String time = LocalMessageUtil.getMessage("time");//国际化:时间
		final String ToY = LocalMessageUtil.getMessage("ToY");//国际化:昨日环比
		final String ToWD = LocalMessageUtil.getMessage("ToWD");//国际化:上周环比
		final String ToMD = LocalMessageUtil.getMessage("ToMD");//国际化:上月同日环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年同期环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				if(getIndexByTableHead(DateType.TODAY.getName()) == index ||
						getIndexByTableHead(DateType.YESTERDAY.getName()) == index||
						getIndexByTableHead(DateType.LASTWEEKDAY.getName()) == index||
						getIndexByTableHead(DateType.LASTMONTHDAY.getName()) == index||
						getIndexByTableHead(DateType.LASTYEARDAY.getName()) == index) {
					List<Series> seriesList = getSeries();
					if (seriesList == null || seriesList.size() <= 0) {
						return null;
					}
					Object sum = null;

					for (Series series : seriesList) {
						if(sum == null){
							sum = series.getData().get(index);
						}else{
							sum = NumberUtil.valueAdd(sum, series.getRawData().get(index));
						}
						if(series.getName().equals(name)){
							break;
						}
						if(getIndexByTableHead(DateType.TODAY.getName()) == index && DateUtil.isSameDay(date, new Date())){//日期为当天日期
							String dt1 = DateUtil.format("HH:00",new Date());
							int compareResult = DateUtil.compareDate("HH:00", name, dt1);//数据时间 》 当前时间
							if(compareResult > 0)
								return null;
						}
					}
					return sum;
				}

				int todayIndex = getIndexByTableHead(DateType.TODAY.getName());
				Number todayNum =  (Number) data.get(todayIndex) ;
				String result = null;
				if(getIndexByTableHead(ToY) == index){
					Number yesterdayNum = (Number) data.get(getIndexByTableHead(DateType.YESTERDAY.getName()));
					result = NumberUtil.growthRate(todayNum , yesterdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(ToWD) == index){
					Number lastweekdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTWEEKDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastweekdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result;
				}else if(getIndexByTableHead(ToMD) == index){
					Number lastmonthdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTMONTHDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastmonthdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastyeardayNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastyeardayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else {
					return data.get(index);
				}
			}
		};

		TableHead tableHead = new TableHead();
		tableHead.addData(time,DateType.TODAY.getName(),DateType.YESTERDAY.getName(),ToY,DateType.LASTWEEKDAY.getName(),ToWD,DateType.LASTMONTHDAY.getName(),ToMD,DateType.LASTYEARDAY.getName(),ToYD);
		table.setTableHead(tableHead);
		putValue2Table(table, datas, date,false,dataMap);
		return table;
	}


	/***
	 * 获取近15天的数据
	 * @param orgId
	 * @param date
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getZoneReportNera15Data(Long[] orgIds,  Date date,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC  || kpiType == KPIType.ENTERINGRATE  || kpiType == KPIType.DURATIONTIME) {//客流量
			List<ZoneDayCountData>  zoneDayDatas = zoneReportDataService.getZoneNear15DayTraffic(orgIds, date, dataMap);
			if (zoneDayDatas == null || zoneDayDatas.size() <= 0) {
				return datas;
			}

			for (ZoneDayCountData zoneDayCountData : zoneDayDatas) {
				Date countDate = zoneDayCountData.getCountdate();
				int innum = zoneDayCountData.getInnum();
				if (kpiType == KPIType.TRAFFIC) {
					Data data = new Data(null, countDate, innum);
					datas.add(data);
				}else if (kpiType == KPIType.ENTERINGRATE) {
					int passNum = zoneDayCountData.getOutsideInnum()+zoneDayCountData.getOutsideOutnum();
					Double value = NumberUtil.percentage(innum, passNum, 2);
					Data data = new Data(null, countDate, value);
					datas.add(data);
				}else if (kpiType == KPIType.DURATIONTIME) {
					List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(orgIds, date, dataMap);
					int allHourInnum = 0;
					if (zoneDatas == null || zoneDatas.size() <= 0) {
						return datas;
					}
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						allHourInnum += zoneHourCountData.getInnum();
					}
					double value = NumberUtil.percentage(allHourInnum, innum, 2);
					Data data = new Data(null, countDate, value);
					datas.add(data);
				}
			}
		}else if (kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE ||
				kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.ORDER) {
			List<Sale> zoneSales = zoneReportDataService.getZoneNear15DaySales(orgIds, date, dataMap);
			if (zoneSales == null || zoneSales.size() <= 0) {
				return datas;
			}
			for (Sale sale : zoneSales) {
				Date countDate = sale.getSaledate();
				if (kpiType == KPIType.SALES) {
					Double value = sale.getMoney();
					Data data = new Data(null,countDate,value);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Double money = sale.getMoney();
					Double value = NumberUtil.divide(money, saleCount, 2);
					Data data = new Data(null,countDate,value);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Double money = sale.getMoney();
					Long zoneId = sale.getZoneId();
					float zoneArea = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap).getArea();
					Double value = NumberUtil.divide(money, zoneArea, 2);
					Data data = new Data(null,countDate,value);
					datas.add(data);

				}else if (kpiType == KPIType.ORDER) {
					int value = sale.getSalecount();
					Data  data =  new Data(null,countDate,value);
					datas.add(data);
				}

			}
		}else if (kpiType == KPIType.HANDBAGRATE) {
			List<Sale> zoneSales = zoneReportDataService.getZoneNear15DaySales(orgIds, date, dataMap);
			if (zoneSales == null || zoneSales.size() <= 0) {
				return datas;
			}
			List<ZoneDayCountData>  zoneDayDatas = zoneReportDataService.getZoneNear15DayTraffic(orgIds, date, dataMap);
			if (zoneDayDatas == null || zoneDayDatas.size() <= 0) {
				return datas;
			}
			for (ZoneDayCountData zoneDayCountData : zoneDayDatas) {
				Date countDate = zoneDayCountData.getCountdate();
				int innum = zoneDayCountData.getInnum();
				Long zoneId = zoneDayCountData.getZoneId();
				int saleCount = 0;
				for (Sale sale : zoneSales) {
					if (zoneId == sale.getZoneId()) {
						saleCount = sale.getSalecount();
					}
				}
				Double value = NumberUtil.percentage(saleCount, innum, 2);
				Data data = new Data(null, countDate, value);
				datas.add(data);
			}
		}

		return datas;
	}

	/***
	 * 获取当天的小时数据
	 * @param orgId 店铺id
	 * @param date  当天日期
	 * @param dataMap  数据缓存
	 * @param kpiType  获取数据的指标
	 * @return
	 */
	private List<Data> getZoneHourReportData(Long[] orgIds,  Date date,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC || kpiType == KPIType.ENTERINGRATE) {//客流量  //进店率
			List<ZoneHourCountData> zoneDatas = zoneReportDataService.getZoneNearCurrentDayHourTraffic(orgIds, date, dataMap);
			if (zoneDatas == null || zoneDatas.size() <= 0) {
				return datas;
			}
			for (ZoneHourCountData zoneHourCountData : zoneDatas) {
				Date countDate = zoneHourCountData.getCountdate();
				Date countTime = zoneHourCountData.getCounttime();
				int innum = zoneHourCountData.getInnum();
				if (kpiType == KPIType.TRAFFIC) {
					int value = innum;
					Data data = new Data(countTime, countDate, value);
					datas.add(data);
				}else if ( kpiType == KPIType.ENTERINGRATE) {
					int passNum = zoneHourCountData.getOutsideInnum()+zoneHourCountData.getOutsideOutnum();
					Double value = NumberUtil.percentage(innum, passNum, 2);
					Data data = new Data(countTime, countDate, value);
					datas.add(data);
				}
			}
		}

		return datas;
	}

	/***
	 * 获取近15天的数据
	 * @param orgId
	 * @param date
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getMallReportNera15Data(Long[] orgIds, Date date, Map<String, Object> dataMap, KPIType kpiType) {
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC ) {
			List<MallDayCountData>  DayDatas = mallReportDataService.getMallNear15DayTraffic(orgIds,  date, dataMap);
			if (DayDatas == null || DayDatas.size() <= 0) {
				return datas;
			}
			for (MallDayCountData mallDayCountData : DayDatas) {
				Date countDate = mallDayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC) {
					int innum = mallDayCountData.getInnum();
					Data data = new Data(null, countDate, innum);
					datas.add(data);
				}
			}
		}else if (kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE ) {
			List<Sale> floorSales = mallReportDataService.getMallNear15DaySales(orgIds, date, dataMap);
			if (floorSales == null || floorSales.size() <= 0) {
				return datas;
			}
			for (Sale sale : floorSales) {
				Date countDate = sale.getSaledate();
				Double mallSales = 0.0;
				if (kpiType == KPIType.SALES) {
					mallSales+= sale.getMoney();
					Data data = new Data(null,countDate,mallSales);
					datas.add(data);
				}else if (kpiType == KPIType.PREPRICE) {
					int saleCount = sale.getSalecount();
					Double money = sale.getMoney();
					Double value = NumberUtil.divide(money, saleCount, 2);
					Data data = new Data(null,countDate,value);
					datas.add(data);
				}else if (kpiType == KPIType.PERAREAVALUE) {
					Double money = sale.getMoney();
					Long mallId = sale.getMallId();
					float mallArea = mallReportDataService.getMallByMallId(mallId, dataMap).getArea();
					Double value = NumberUtil.divide(money, mallArea, 2);
					Data data = new Data(null,countDate,value);
					datas.add(data);

				}
			}
		}
		return datas;
	}

	/***
	 * 获取当天的小时数据
	 * @param orgId 监控点id
	 * @param date  当天日期
	 * @param dataMap  数据缓存
	 * @param kpiType  获取数据的指标
	 * @return
	 */
	private List<Data> getMallHourReportData(Long[] orgIds, Date date,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC ) {//客流量
			List<MallHourCountData> hourDatas = mallReportDataService.getMallCurrentDayHourTraffic(orgIds, date, dataMap);
			if (hourDatas == null || hourDatas.size() <= 0) {
				return datas;
			}
			for (MallHourCountData mallHourCountData : hourDatas) {
				Date countDate = mallHourCountData.getCountdate();
				Date countTime = mallHourCountData.getCounttime();
				if (kpiType == KPIType.TRAFFIC) {
					int value = mallHourCountData.getInnum();
					Data data = new Data(countTime, countDate, value);
					datas.add(data);
				}
			}
		}

		return datas;
	}

	/***
	 * 获取近15天的数据
	 * @param orgId
	 * @param date
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getFloorReportNera15Data(Long[] orgIds, Date date, Map<String, Object> dataMap, KPIType kpiType) {
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC ) {
			List<FloorDayCountData>  DayDatas = floorReportDataService.getFloorNear15DayTraffic(orgIds,  date, dataMap);
			if (DayDatas == null || DayDatas.size() <= 0) {
				return datas;
			}
			for (FloorDayCountData floorDayCountData : DayDatas) {
				Date countDate = floorDayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC) {
					int innum = floorDayCountData.getInnum();
					Data data = new Data(null, countDate, innum);
					datas.add(data);
				}
			}
		}else if (kpiType == KPIType.SALES ) {
			List<Sale> floorSales = floorReportDataService.getFloorNear15DaySales(orgIds, date, dataMap);
			if (floorSales == null || floorSales.size() <= 0) {
				return datas;
			}
			for (Sale sale : floorSales) {
				Date countDate = sale.getSaledate();
				if (kpiType == KPIType.SALES) {
					Double value = sale.getMoney();
					Data data = new Data(null,countDate,value);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/***
	 * 获取当天的小时数据
	 * @param orgId 监控点id
	 * @param date  当天日期
	 * @param dataMap  数据缓存
	 * @param kpiType  获取数据的指标
	 * @return
	 */
	private List<Data> getFloorHourReportData(Long[] orgIds, Date date,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC ) {//客流量
			List<FloorHourCountData> hourDatas = floorReportDataService.getFloorNearCurrentDayHourTraffic(orgIds, date, dataMap);
			if (hourDatas == null || hourDatas.size() <= 0) {
				return datas;
			}
			for (FloorHourCountData floorHourCountData : hourDatas) {
				Date countDate = floorHourCountData.getCountdate();
				Date countTime = floorHourCountData.getCounttime();
				if (kpiType == KPIType.TRAFFIC) {
					int value = floorHourCountData.getInnum();
					Data data = new Data(countTime, countDate, value);
					datas.add(data);
				}
			}
		}

		return datas;
	}

	/***
	 * 获取近15天的数据
	 * @param orgId
	 * @param date
	 * @param dataMap
	 * @param kpiType
	 * @return
	 */
	private List<Data> getGateReportNera15Data(Long[] orgIds, Date date, Map<String, Object> dataMap, KPIType kpiType) {
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC ) {
			List<GateDayCountData>  gateDayDatas = gateReportDataService.getGateNear15DayTraffic(orgIds, date, dataMap);
			if (gateDayDatas == null || gateDayDatas.size() <= 0) {
				return datas;
			}
			for (GateDayCountData gateDayCountData : gateDayDatas) {
				Date countDate = gateDayCountData.getCountdate();
				if (kpiType == KPIType.TRAFFIC) {
					int innum = gateDayCountData.getInnum();
					Data data = new Data(null, countDate, innum);
					datas.add(data);
				}
			}
		}
		return datas;
	}

	/***
	 * 获取当天的小时数据
	 * @param orgId 监控点id
	 * @param date  当天日期
	 * @param dataMap  数据缓存
	 * @param kpiType  获取数据的指标
	 * @return
	 */
	private List<Data> getGateHourReportData(Long[] orgIds,  Date date,Map<String, Object> dataMap,KPIType kpiType){
		List<Data> datas = new ArrayList<Data>();
		if (kpiType == KPIType.TRAFFIC ) {//客流量
			List<GateHourCountData> gateDatas = gateReportDataService.getGateCurrentDayHourTraffic(orgIds, date, dataMap);
			if (gateDatas == null || gateDatas.size() <= 0) {
				return datas;
			}
			for (GateHourCountData gateHourCountData : gateDatas) {
				Date countDate = gateHourCountData.getCountdate();
				Date countTime = gateHourCountData.getCounttime();
				if (kpiType == KPIType.TRAFFIC) {
					int value = gateHourCountData.getInnum();
					Data data = new Data(countTime, countDate, value);
					datas.add(data);
				}
			}
		}

		return datas;
	}


	/**今日时刻同环比添加数据*/
	private void putValue2Table(Table table,List<Data> datas,Date today,boolean isCountingTime,Map<String, Object> dataMap){

		Long[] orgIds = (Long[])dataMap.get("orgIds");
		if (datas == null || datas.size() <= 0) {
			return;
		}

		final String time = LocalMessageUtil.getMessage("time");//国际化:时间
		final String timeQuantum = LocalMessageUtil.getMessage("timeQuantum");//国际化:时间段

		BaseDataServiceImpl.DateCriteria dateCriteria = new BaseDataServiceImpl.DateCriteria();
		dateCriteria = mallReportDataService.getMallOpentimesByOrgId(orgIds[0], OrgType.mall, dataMap);
		Date openTime = dateCriteria.getStartDate();
		Date closeTime = dateCriteria.getEndDate();
		Date currentTime = openTime;
		String serierName = "";
		while(currentTime.before(closeTime) || currentTime.equals(closeTime)){
			serierName = DateUtil.format("HH:00",currentTime);
			if (isCountingTime) {
				Date date = DateUtil.addHours(currentTime, 1);
				String currentTimeStr =DateUtil.format("HH:00", currentTime)+"-"+DateUtil.format("HH:00",date);
				table.getRow(serierName).putValueByHeadColumn(timeQuantum, currentTimeStr);
			}else {
				String currentTimeStr = DateUtil.format("HH:00", currentTime);
				table.getRow(serierName).putValueByHeadColumn(time, currentTimeStr);
			}
			currentTime = DateUtil.addHours(currentTime, 1);
		}
		for (Data data : datas) {
			DateType dateType = DateType.valueOfDay(today, data.getCountDate());
			if(dateType == null || dateType == DateType.NONE) {
				continue;
			}
			Date countTime = data.getCountTime();
			boolean inOpenTime = DateUtil.isInOpenTime(countTime, openTime, closeTime);
			if (!inOpenTime){
				continue;
			}
			String dataTimeStr = DateUtil.format("HH:00", countTime);
			table.getRow(dataTimeStr).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
		}

	}

	/**近15天同环比添加数据*/
	private void putValue2Table(Table table,List<Data> datas,List<Date> dates){
		if (datas == null || datas.size() <= 0) {
			return;
		}
		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		Map<String, Date> serierDateMap = new HashMap<String, Date>();
		for (Date date : dates) {
			Date today = date;
			String serierName  = DateUtil.format(DateUtil.FORMAT_SHORT,today);
			table.getRow(serierName).putValueByHeadColumn(dateStr, serierName);
			serierDateMap.put(serierName, today);
		}
		List<Row> rows = table.getSeries();
		for (Row row : rows) {
			String serierName = row.getName();
			Date date = serierDateMap.get(serierName);
			for (Data data : datas) {
				DateType dateType = DateType.valueOfDay(date, data.getCountDate());
				if(dateType == null || dateType == DateType.NONE) {
					continue;
				}
				table.getRow(serierName).adjustOrPutValueByHeadColumn(dateType.getName(), data.getValue());
			}
		}
	}


//	class Data<T>{
//		private Date countTime;
//		private Date countDate;
//		private T value;
//
//		public Data(Date countTime, Date countDate, T value) {
//			this.countTime = countTime;
//			this.countDate = countDate;
//			this.value = value;
//		}
//
//		public Date getCountTime() {
//			return countTime;
//		}
//		public void setCountTime(Date countTime) {
//			this.countTime = countTime;
//		}
//		public Date getCountDate() {
//			return countDate;
//		}
//		public void setCountDate(Date countDate) {
//			this.countDate = countDate;
//		}
//		public T getValue() {
//			return value;
//		}
//		public void setValue(T value) {
//			this.value = value;
//		}
//
//	}
	/**
	 * @Description: 同环比分析多对象表格
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/12
	 */
	private Chart getMoreObjectTable(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart){
		Table table = new Table(reportChart.getTitle());
		String name = LocalMessageUtil.getMessage("NAME");
		String today = LocalMessageUtil.getMessage("DateType.today");
		String yesterday = LocalMessageUtil.getMessage("DateType.yesterday");
		String yesterdayYO = LocalMessageUtil.getMessage("ToY");
		String lastWeek = LocalMessageUtil.getMessage("DateType.lastWeekDay");
		String lastWeekYO = LocalMessageUtil.getMessage("ToWD");
		String lastMonth = LocalMessageUtil.getMessage("DateType.lastMonthDay");
		String lastMonthYO = LocalMessageUtil.getMessage("ToMD");
		String lastYear = LocalMessageUtil.getMessage("DateType.lastYearDay");
		String lastYearYO = LocalMessageUtil.getMessage("ToYD");
		TableHead tableHead = new TableHead();
		tableHead.addData(name,today,yesterday,yesterdayYO,lastWeek,lastWeekYO,lastMonth,lastMonthYO,lastYear,lastYearYO);
		table.setTableHead(tableHead);
		List<Data> datas = getMoreObjectData(orgIds,date,date,dataMap);
		Map<Long,String> orgs = getOrgsMap(dataMap);
		for(long orgId : orgIds){
			table.getRow(orgs.get(orgId)).putValueByHeadColumn(name,orgs.get(orgId));
		}
		for (Data data : datas){
			if(DateUtil.isSameDay(data.getCountDate(),date)) {
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(today,data.getValue());
			}else if(DateUtil.isYesterday(date,data.getCountDate())){
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(yesterday,data.getValue());
			}else if(DateUtil.isLastWeekDay(date,data.getCountDate())){
                table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastWeek,data.getValue());
            }else if(DateUtil.isLastMonthDay(date,data.getCountDate())){
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastMonth,data.getValue());
			}else if(DateUtil.isLastYearDay(date,data.getCountDate())){
				table.getRow(orgs.get(data.getValue3())).adjustOrPutValueByHeadColumn(lastYear,data.getValue());
			}
		}
		for(long orgId : orgIds){
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(today)==null){
				continue;
			}
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(yesterday)!=null){
				String yesterdayYOStr = NumberUtil.growthRate((Number)table.getRow(orgs.get(orgId)).getValueByHeadColumn(today),(Number) table.getRow(orgs.get(orgId)).getValueByHeadColumn(yesterday));
//				if(yesterdayYOStr != null) {
//					yesterdayYOStr = yesterdayYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(yesterdayYO,yesterdayYOStr);

			}
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastWeek)!=null){
				String lastWeekYOStr = NumberUtil.growthRate((Number)table.getRow(orgs.get(orgId)).getValueByHeadColumn(today),(Number) table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastWeek));
//				if(lastWeekYOStr != null) {
//					lastWeekYOStr = lastWeekYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastWeekYO,lastWeekYOStr);

			}
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastMonth)!=null){
				String lastMonthYOStr = NumberUtil.growthRate((Number)table.getRow(orgs.get(orgId)).getValueByHeadColumn(today),(Number) table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastMonth));
//				if(lastMonthYOStr != null) {
//					lastMonthYOStr = lastMonthYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastMonthYO,lastMonthYOStr);

			}
			if(table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYear)!=null){
				String lastYearYOStr = NumberUtil.growthRate((Number)table.getRow(orgs.get(orgId)).getValueByHeadColumn(today),(Number) table.getRow(orgs.get(orgId)).getValueByHeadColumn(lastYear));
//				if(lastYearYOStr != null) {
//					lastYearYOStr = lastYearYOStr.replace("%", "");
//				}
				table.getRow(orgs.get(orgId)).adjustOrPutValueByHeadColumn(lastYearYO,lastYearYOStr);

			}
		}
		return table;
	}

	/**
	 * @Description: 同环比分析多对象柱状图
	 * @Param: [orgIds, date, dataMap, reportChart]
	 * @return: com.viontech.keliu.chart.Chart
	 * @Date: 2019/3/13
	 */
	private Chart getMoreObjectBar(Long[] orgIds,Date date,Map<String,Object> dataMap,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		Axis xAxis = AxisFactory.createStringAxis();
		Map<Long,String> orgs = getOrgsMap(dataMap);
		String today = LocalMessageUtil.getMessage("DateType.today");
		String lastMonth = LocalMessageUtil.getMessage("DateType.lastMonthDay");
		for(Long orgId : orgIds){
			xAxis.addData(orgs.get(orgId));
		}
		chart.setXAxis(xAxis);
		chart.getSeries(today);
		chart.getSeries(lastMonth);
		List<Data> datas = getMoreObjectData(orgIds,date,date,dataMap);
		for(Data data : datas){
			if(DateUtil.isSameDay(data.getCountDate(),date)){
				chart.getSeries(today).adjustOrPutValueByCoordinate(orgs.get(data.getValue3()),data.getValue());
			}else if(DateUtil.isLastMonthDay(date,data.getCountDate())){
				chart.getSeries(lastMonth).adjustOrPutValueByCoordinate(orgs.get(data.getValue3()),data.getValue());
			}
		}
		return chart;
	}

	private Chart getCustomizeTable(Date startDate,Date endDate,List<Data> datas, Map<String, Object> dataMap, ReportChart reportChart, KPIType kpiType){

		final String timeQuantum = LocalMessageUtil.getMessage("timeQuantum");//国际化:时间段
		final String dateStr = LocalMessageUtil.getMessage("date");//国际化:日期
		final String ToY = LocalMessageUtil.getMessage("ToY");//国际化:昨日环比
		final String ToWD = LocalMessageUtil.getMessage("ToWD");//国际化:上周环比
		final String ToMD = LocalMessageUtil.getMessage("ToMD");//国际化:上月同日环比
		final String ToYD = LocalMessageUtil.getMessage("ToYD");//国际化:去年同期环比

		Table table = new Table(reportChart.getTitle()){
			@Override
			public Object calcValue(String name,int index, List data) {
				int todayIndex = getIndexByTableHead(DateType.TODAY.getName());
				Number todayNum =  (Number) data.get(todayIndex) ;
				String result = null;
				if(index ==  getIndexByTableHead(ToY)  ){
					Number yesterdayNum = (Number) data.get(getIndexByTableHead(DateType.YESTERDAY.getName()));
					result = NumberUtil.growthRate(todayNum , yesterdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result;
				}else if(getIndexByTableHead(ToWD) == index){
					Number lastweekdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTWEEKDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastweekdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return  result ;
				}else if(getIndexByTableHead(ToMD) == index){
					Number lastmonthdayNum = (Number) data.get(getIndexByTableHead(DateType.LASTMONTHDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastmonthdayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result ;
				}else if(getIndexByTableHead(ToYD) == index){
					Number lastyeardayNum = (Number) data.get(getIndexByTableHead(DateType.LASTYEARDAY.getName()));
					result = NumberUtil.growthRate(todayNum, lastyeardayNum);
//					if(result != null) {
//						result = result.replace("%", "");
//					}
					return result;
				}else{

					return data.get(index);

				}

			}
		};

		TableHead tableHead = new TableHead();

		tableHead.addData(dateStr,DateType.TODAY.getName(),DateType.YESTERDAY.getName(),ToY,DateType.LASTWEEKDAY.getName(),ToWD,DateType.LASTMONTHDAY.getName(),ToMD,DateType.LASTYEARDAY.getName(),ToYD);
		table.setTableHead(tableHead);
		//Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
		List<Date> dates =  DateUtil.getDaysBetweenDates(startDate, endDate);
		//dates.add(date);
		Collections.reverse(dates);
		putValue2Table(table, datas, dates);

		return table;
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
