package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class WeekComparedServiceImpl extends ChartReportBaseService {

	@Resource
	private GateReportDataService gateReportDataService;
	
	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private MallReportDataService mallReportDataService;
	
	private  final  String REPORT_WEEKDAYOREND ="weekdayOrEnd";
	
	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		switch (reportChart.getKey()) {
		case REPORT_WEEKDAYOREND:
			chart = weekDayOrEndComparedReport(orgIds, startDate, endDate, dataMap, reportChart);
			break;

		default:
			break;
		}
		return chart;
	}
	
	private Chart weekDayOrEndComparedReport(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar){
			@Override
			public Object calcValue(String name, int index, List data_raw) {
				List<String> seriesName = Arrays.asList("avgWeekDay","avgWeekend","growthRate");
				if (seriesName.get(2).equals(name)) {
					Series weekdaySeries =  getSeries(seriesName.get(0));
					Number Weekday = (Number) weekdaySeries.getValueByIndex(index);
					Number weekdayCount = weekdaySeries.getCountByIndex(index);
					Number avgWeekday = NumberUtil.divide(Weekday, weekdayCount, 2);
					Series weekendSeries =  getSeries(seriesName.get(1));
					Number Weekend = (Number) weekendSeries.getValueByIndex(index);
					Number WeekendCount = weekendSeries.getCountByIndex(index);
					Number avgWeekend = NumberUtil.divide(Weekend, WeekendCount, 2);
					return NumberUtil.percentage(NumberUtil.subtract(avgWeekend, avgWeekday), avgWeekday, 2);
				}
				return super.calcValue(name, index, data_raw);
			}
			
		};
		
		Axis<Date> xAxis = AxisFactory.createWeekOFYearAxis();
		xAxis.setMin(startDate);
		xAxis.setMax(endDate);
		chart.setXAxis(xAxis);
		
		List<DataVo> dataVos = new ArrayList<DataVo>();
		
 		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
 		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		if (orgType == OrgType.gate) {
			List<GateDayCountData> datas =	gateReportDataService.getOrQueryGateBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dataVos = gateReportDataService.convert2Data(datas);
		}else if (orgType == OrgType.zone) {
			if (kpiType == KPIType.TRAFFIC || kpiType == KPIType.ENTERINGRATE) {
				//天级客流
				List<ZoneDayCountData> dayDatas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
				dataVos = zoneReportDataService.convert2Data(dayDatas);
			}else if (kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.ORDER) {
				//销售数据
				List<Sale> saleDatas = zoneReportDataService.getOrQueryZoneBetweenDateSale(orgIds, startDate, endDate, dataMap);
				dataVos  = zoneReportDataService.convert2Data(saleDatas);
			}else if (kpiType == KPIType.DURATIONTIME ) {
				//天级客流
				List<ZoneDayCountData> dayDatas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
				List<DataVo> dayDataVos = zoneReportDataService.convert2Data(dayDatas);
				dataVos.addAll(dayDataVos);
				//小时客流
				List<ZoneHourCountData> hourDatas = zoneReportDataService.getOrQueryZoneBetweenDateHourTraffic(orgIds, startDate, endDate, dataMap);
				List<DataVo> hourDataVos = zoneReportDataService.convert2Data(hourDatas);
				dataVos.addAll(hourDataVos);
			}else if (kpiType == KPIType.HANDBAGRATE) {
				//销售数据
				List<Sale> saleDatas = zoneReportDataService.getOrQueryZoneBetweenDateSale(orgIds, startDate, endDate, dataMap);
				dataVos  = zoneReportDataService.convert2Data(saleDatas);
				//天级客流
				List<ZoneDayCountData> dayDatas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
				List<DataVo> dayDataVos = zoneReportDataService.convert2Data(dayDatas);
				dataVos.addAll(dayDataVos);
			}
		}else if (orgType == OrgType.floor) {
			if (kpiType == KPIType.TRAFFIC){
				//客流
				List<FloorDayCountData> dayDatas = floorReportDataService.getOrQueryFloorBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
				dataVos = floorReportDataService.convert2Data(dayDatas);
			}else if (kpiType == KPIType.SALES) {
				//销售数据
				List<Sale> saleDatas = floorReportDataService.getOrQueryFloorBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
				dataVos = floorReportDataService.convert2Data(saleDatas);
			}
		}else if (orgType == OrgType.mall) {
			if (kpiType == KPIType.TRAFFIC ) {
				//天级客流
				List<MallDayCountData> dayDatas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
				dataVos = mallReportDataService.convert2Data(dayDatas);
			}else if (kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE ) {
				//销售数据
				List<Sale> saleDatas = mallReportDataService.getOrQueryMallBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
				dataVos = mallReportDataService.convert2Data(saleDatas);
			}else if (kpiType == KPIType.DURATIONTIME ) {
				//天级客流
				List<MallDayCountData> dayDatas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
				dataVos = mallReportDataService.convert2Data(dayDatas);
				//小时客流
				List<MallHourCountData> hourDatas = mallReportDataService.getOrQueryMallBetweenDateHourTraffic(orgIds, startDate, endDate, dataMap);
				dataVos.addAll(mallReportDataService.convert2Data(hourDatas));
			}
			
			
		}
		putDate2Chart(chart, dataVos, dataMap);
		return chart;
	}
	
	private void putDate2Chart(Chart chart,List<DataVo> dataVos,Map<String, Object> dataMap){
		if (dataVos != null && dataVos.size() >0) {
			List<String> seriesNames = Arrays.asList("avgWeekDay","avgWeekend","growthRate");
			for (String seriesName : seriesNames) {
				Series series = null;
				if (seriesName.equals("growthRate")) {
					series = chart.createSeries(seriesName,SeriesType.line);
				}else {
					series = chart.createSeries(seriesName);
				}
				series.setAllCalcType(Series.CALC_TYPE_AVG);
			}
			KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
			for (DataVo dataVo : dataVos) {
				Date date = dataVo.getDate();
				boolean isWeekday = DateUtil.isWeekday(date);
				int seriesIndex = 0;
				if (!isWeekday) {
					seriesIndex = 1;
				}
				Number result = getKpiResult(dataVo, dataVos, dataMap,kpiType);
				if (result == null || result.equals(-10001)) {// -10001 是标识数字 ，当返回这个数值，代表continue
					continue;
				}
				chart.getSeries(seriesNames.get(seriesIndex)).adjustOrPutValueByCoordinate(date,result);
			}
		}
	}
	
	
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}


}
