package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

;

@Service
public class TrafficInAndOutReportImpl  extends ChartReportBaseService {

	@Resource
	private MallReportDataService mallReportDataServiceImpl;
	@Resource
	private FloorReportDataService floorReportDataServiceImpl;
	@Resource
	private ZoneReportDataService zoneReportDataServiceImpl;
	@Resource
	private GateReportDataService gateReportDataServiceImpl;
	

	private final String REPORT_TRAFFIC_MINUTE_INANDOUT = "trafficInAndOut";

	private final String REPORT_TRAFFIC_MINUTE_INANDOUT_TABLE = "trafficInAndOutTable";
	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		List<Date> dates = new ArrayList<Date>();
		dates.add(startDate);
		
		List<DataVo> dataVos = new ArrayList<DataVo>();
		OptionsContain option = (OptionsContain) dataMap.get("chartOption");
		if(OrgType.mall == orgType){
			if(option == OptionsContain.TAB_MINUTE){
				List<MallMinuteCountData> minTraffic = mallReportDataServiceImpl.getOrQueryMallInDatesMinTraffic(orgIds, dates, dataMap);
				dataVos = mallReportDataServiceImpl.convert2Data(minTraffic);
			}else if(option == OptionsContain.TAB_HOUR){
				List<MallHourCountData> hourTraffic = mallReportDataServiceImpl.getOrQueryMallDaysHourTraffic(orgIds, dates, dataMap);
				dataVos = mallReportDataServiceImpl.convert2Data(hourTraffic);
			}
			DateCriteria mallOpentime = mallReportDataServiceImpl.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("MallOpenTime",mallOpentime);
		}else if(OrgType.floor == orgType){
			if(option == OptionsContain.TAB_MINUTE){
				List<FloorMinuteCountData> minTraffic = floorReportDataServiceImpl.getOrQueryFloorInDatesMinTraffic(orgIds, dates, dataMap);
				dataVos = floorReportDataServiceImpl.convert2Data(minTraffic);
			}else if(option == OptionsContain.TAB_HOUR){
				List<FloorHourCountData> hourData = floorReportDataServiceImpl.getOrQueryFloorInDatesHourTraffic(orgIds, dates, dataMap);
				dataVos = floorReportDataServiceImpl.convert2Data(hourData);
			}
			DateCriteria mallOpentime = floorReportDataServiceImpl.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("MallOpenTime",mallOpentime);
		}else if(OrgType.zone == orgType){
			if(option == OptionsContain.TAB_MINUTE){
				List<ZoneMinuteCountData> minTraffic = zoneReportDataServiceImpl.getOrQueryZoneInDates10MinetuTraffic(orgIds, dates, dataMap);
				dataVos = zoneReportDataServiceImpl.convert2Data(minTraffic);
			}else if(option == OptionsContain.TAB_HOUR){
				List<ZoneHourCountData> hourData = zoneReportDataServiceImpl.getOrQueryZoneInDatesHourTraffic(orgIds, dates, dataMap);
				dataVos = zoneReportDataServiceImpl.convert2Data(hourData);
			}
			DateCriteria mallOpentime = zoneReportDataServiceImpl.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("MallOpenTime",mallOpentime);
		}else if(OrgType.gate == orgType){
			if(option == OptionsContain.TAB_MINUTE){
				List<GateMinuteCountData> minTraffic = gateReportDataServiceImpl.getOrQueryGateDays10MinData(orgIds, dates, dataMap);
				dataVos = gateReportDataServiceImpl.convert2Data(minTraffic);
			}else if(option == OptionsContain.TAB_HOUR){
				List<GateHourCountData> hourData = gateReportDataServiceImpl.getOrQueryGateDaysHourData(orgIds, dates, dataMap);
				dataVos = gateReportDataServiceImpl.convert2Data(hourData);
			}
			DateCriteria mallOpentime = gateReportDataServiceImpl.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("MallOpenTime",mallOpentime);
		}
		Chart chart = null;
		switch (reportChart.getKey()) {
			case REPORT_TRAFFIC_MINUTE_INANDOUT:
				chart = trafficInAndOutReport(orgIds,dataVos, dataMap, reportChart);
				break;
			case REPORT_TRAFFIC_MINUTE_INANDOUT_TABLE:
				chart = trafficInAndOutReportTable(orgIds,dataVos, dataMap, reportChart);
				break;
			default:
				break;
		}
		
		
		return chart;
	}
	
	/**
	 * 获取进出客流报表
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart trafficInAndOutReport(Long[] orgIds,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);

		Axis<Date> xAxis = null;
		OptionsContain option = (OptionsContain) dataMap.get("chartOption");
		if(option == OptionsContain.TAB_MINUTE){
			xAxis = AxisFactory.creatSdfDateAxix("HH:mm",Calendar.MINUTE);
			xAxis.setScale(10);

		}else if(option == OptionsContain.TAB_HOUR){
			xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		}
		DateCriteria mallOpentime = (DateCriteria) dataMap.get("MallOpenTime");
		Date startDate = mallOpentime.getStartDate();
		xAxis.setMin(startDate);
		Date endDate = mallOpentime.getEndDate();
		xAxis.setMax(endDate);
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);

		
		String tableName = null;
		for (DataVo dataVo : dataVos) {
			tableName = getOrgName(dataVo,dataMap);
			String mallInColumn = LocalMessageUtil.getMessage("Traffic.inNum", new Object[]{tableName});
			String mallOutColumn = LocalMessageUtil.getMessage("Traffic.outNum", new Object[]{tableName});

			Date time = dataVo.getTime();

			chart.getSeries(mallInColumn).adjustOrPutValueByCoordinate(time, dataVo.getInnum());
			chart.getSeries(mallOutColumn).adjustOrPutValueByCoordinate(time, dataVo.getOutnum());
		}
		return chart;
	}
	

	/**
	* @Description: 获取进出客流对比表格数据
	* @Param: [orgIds, dataVos, dataMap, reportChart]
	* @return: com.viontech.keliu.chart.Chart
	* @Date: 2019/2/21
	*/
	private Chart trafficInAndOutReportTable(Long[] orgIds,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		Table table = new Table(reportChart.getTitle());
		final String time = LocalMessageUtil.getMessage("timeQuantum");
		final String inNum = LocalMessageUtil.getMessage("KPIType.inNum");
		final String outNum = LocalMessageUtil.getMessage("KPIType.outNum");
		TableHead tableHead = new TableHead();
		tableHead.addData(time);
		//table.setTableHead(tableHead);
		OptionsContain option = (OptionsContain) dataMap.get("chartOption");
		DataVo dataVotemple = null;
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for(Long orgId :orgIds){
			dataVotemple = new DataVo();
			if(orgType == OrgType.mall){
				dataVotemple.setMallId(orgId);
			}else if (orgType == OrgType.floor){
				dataVotemple.setFloorId(orgId);
			}else if (orgType == OrgType.zone){
				dataVotemple.setZoneId(orgId);
			}else if (orgType == OrgType.gate){
				dataVotemple.setGateId(orgId);
			}else {

			}
			String inNumStr = getOrgName(dataVotemple,dataMap)+"@"+inNum;
			String outNumStr = getOrgName(dataVotemple,dataMap)+"@"+outNum;
			tableHead.addData(inNumStr);
			tableHead.addData(outNumStr);
			table.setTableHead(tableHead);
		}

		DateCriteria mallOpenTime = (DateCriteria) dataMap.get("MallOpenTime");
		Date openTime = mallOpenTime.getStartDate();
		Date closeTime = mallOpenTime.getEndDate();
		Date currentTime = openTime;
		while(currentTime.before(closeTime) || currentTime.equals(closeTime)){
			if(option == OptionsContain.TAB_HOUR) {
				String dateStr = DateUtil.format("HH:00", currentTime);
				currentTime = DateUtil.addHours(currentTime, 1);
				String nextTimeStr = DateUtil.format("HH:00", currentTime);
				table.getRow(dateStr).putValueByHeadColumn(time,dateStr+"-"+nextTimeStr);
			}else if(option == OptionsContain.TAB_MINUTE){
				String dateStr = DateUtil.format("HH:mm", currentTime);
				currentTime = DateUtil.addMinutes(currentTime, 10);
				String nextTimeStr = DateUtil.format("HH:mm", currentTime);
				table.getRow(dateStr).putValueByHeadColumn(time,dateStr+"-"+nextTimeStr);
			}

		}

		for (DataVo dataVo : dataVos){
			String inNumStr = getOrgName(dataVo,dataMap)+"@"+inNum;
			String outNumStr = getOrgName(dataVo,dataMap)+"@"+outNum;
			Date date = dataVo.getTime();
			String dateStr = null;
			if(option == OptionsContain.TAB_HOUR) {
				dateStr = DateUtil.format("HH:00", date);
			}else if (option == OptionsContain.TAB_MINUTE){
				dateStr = DateUtil.format("HH:mm", date);
			}
			table.getRow(dateStr).adjustOrPutValueByHeadColumn(inNumStr,dataVo.getInnum());
			table.getRow(dateStr).adjustOrPutValueByHeadColumn(outNumStr,dataVo.getOutnum());
		}

		List<String> tableHeads = table.getTableHead().getData();
		TableHead newTableHead = new TableHead();
		Set<String> headSet = new HashSet<String>();
		newTableHead.addData(time);
		for (String head : tableHeads){
			if(headSet.contains(head)){
				continue;
			}else{
				if(!head.contains("@")){
					newTableHead.addData(head);
				}else {
					String newHead = head.split("@")[0];
					newTableHead.addData("[" + "\'" + newHead + "\'" + ",\'" + inNum + "\'," + "\'" + outNum + "\'" + "]");
				}
			}
		}
		table.setTableHead(newTableHead);
		return table;
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
