package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.*;
import com.viontech.mall.service.adapter.FloorService;
import com.viontech.mall.service.adapter.GateService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: ShoppingMall-parent
 * @description: 时间对比分析
 * @author: WJY
 * @create: 2019-01-17 09:39
 **/
@Service
public class TimeCompareAnalysisImpl extends ChartReportBaseService{

    //总客流对比
    private static final String REPORTTOTALPASSAGERCOMPARE = "totalPassengerCompare";
    //总客流对比饼图
    private static final String TOTALANDAVERAGETRAFFIC = "totalAndAverageTraffic";
    //天级对比表格
    private static final String REPORTDAYCOMPARETABLE = "dayCompareTable";
    //天级对比折线图
    private static final String REPORDAYCOMPARELINE = "dayCompareLine";

    @Resource
    private MallReportDataService mallReportDataService;

    @Resource
    private FloorReportDataService floorReportDataService;

    @Resource
    private ZoneReportDataService zoneReportDataService;

    @Resource
    private GateReportDataService gateReportDataService;

    @Resource
    private MallDataService mallDataService;

    @Resource
    private FloorDataService floorDataService;

    @Resource
    private ZoneDataService zoneDataService;

    @Resource
    private GateDataService gateDataService;

    @Resource
    private FloorService floorService;

    @Resource
    private ZoneService zoneService;

    @Resource
    private GateService gateService;


    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = null;
        Date startDate2 = (Date) dataMap.get("startDate1");
        Date endDate2 = (Date) dataMap.get("endDate1");
        List<DataVo> dataVos = getData(orgIds,startDate,endDate,startDate2,endDate2,dataMap);
        Map<String,Object> totalAndAverMap = getTotalAndAver(startDate,endDate,startDate2,endDate2,dataVos);
        switch (reportChart.getKey()){
            case REPORTTOTALPASSAGERCOMPARE:
                    chart = getTotalPassagerCompare(startDate,endDate,startDate2,endDate2,dataVos,reportChart);
                    break;
            case REPORTDAYCOMPARETABLE:
                    chart = getDayCompareTable(startDate,endDate,startDate2,endDate2,dataVos,reportChart);
                    break;
            case REPORDAYCOMPARELINE:
                    chart = getDayCompareLine(startDate,endDate,startDate2,endDate2,dataVos,dataMap,reportChart);
                    break;
            case TOTALANDAVERAGETRAFFIC:
                chart = getTotalOrAverageTraffic(dataVos,reportChart,totalAndAverMap);
                break;
                    default:
                        break;
        }
        return chart;
    }
    
    
    /**
    * @Description: 总客流对比
    * @Param: [startDate1, endDate1, startDate2, endDate2, dataVos, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/17
    */ 
    private Chart getTotalPassagerCompare(Date startDate1,Date endDate1,Date startDate2,Date endDate2,List<DataVo> dataVos,ReportChart reportChart){
        Table table = new Table(reportChart.getTitle(), SeriesType.table);
        //设置表头，数据为空时返回带表头的表格
        final String timeQuantum = LocalMessageUtil.getMessage("timeQuantum");
        final String dayNum = LocalMessageUtil.getMessage("dayNum");
        final String totalPassenger = LocalMessageUtil.getMessage("TOTALPASSENGERFLOW");
        final String totalPassengerPropority = LocalMessageUtil.getMessage("TATALPASSENGERPROPORTION");
        final String averagePassenger = LocalMessageUtil.getMessage("AVERAGEPASSENGER");
        final String averagePassengerPropority = LocalMessageUtil.getMessage("AVERAGEPASSENGERPROPORITY");
        TableHead tableHead = new TableHead();
        //tableHead.addData(serialnumber);
        tableHead.addData(timeQuantum);
        tableHead.addData(dayNum);
        tableHead.addData(totalPassenger);
        tableHead.addData(totalPassengerPropority);
        tableHead.addData(averagePassenger);
        tableHead.addData(averagePassengerPropority);
        table.setTableHead(tableHead);
        String date1 = DateUtil.format("yyyy-MM-dd",startDate1)+"~"+DateUtil.format("yyyy-MM-dd",endDate1);
        String date2 = DateUtil.format("yyyy-MM-dd",startDate2)+"~"+DateUtil.format("yyyy-MM-dd",endDate2);
        table.getRow(date1).putValueByHeadColumn(timeQuantum,date1);
        table.getRow(date2).putValueByHeadColumn(timeQuantum,date2);
        if (dataVos == null || dataVos.isEmpty()){
            return table;
        }

        //得到两个时间段的客流量
        Map<String,Object> dataMap = getTotalAndAver(startDate1,endDate1,startDate2,endDate2,dataVos);
        Integer periodPassenger1 = Integer.parseInt(dataMap.get("periodPassenger1").toString());
        Integer periodPassenger2 = Integer.parseInt(dataMap.get("periodPassenger2").toString());;
        //得到两个时间段的天数
        Integer dayNumber1 = DateUtil.getDaysBetweenDates(startDate1,endDate1).size();
        Integer dayNumber2 = DateUtil.getDaysBetweenDates(startDate2,endDate2).size();
        //得到两个时间段的总客流占比
        String totalPassengerPropority1 = null;
        String totalPassengerPropority2 = null;
        if(periodPassenger1 !=0 || periodPassenger2 !=0) {
            totalPassengerPropority1 = NumberUtil.growthRate(periodPassenger1+periodPassenger1+periodPassenger2,periodPassenger1+periodPassenger2);
            totalPassengerPropority2 = NumberUtil.growthRate(periodPassenger2+periodPassenger1+periodPassenger2,periodPassenger1+periodPassenger2);
        }
        //得到两个时间段的平均客流量
        Double averagePassenger1 = Double.parseDouble(dataMap.get("averagePassenger1").toString());
        Double averagePassenger2 = Double.parseDouble(dataMap.get("averagePassenger2").toString());
        //得到两个时间段的平均客流占比
        String averagePassengerPropority1 = null;
        String averagePassengerPropority2 = null;
        averagePassengerPropority1 = NumberUtil.growthRate(averagePassenger1,averagePassenger1+averagePassenger2);
        averagePassengerPropority2 = NumberUtil.growthRate(averagePassenger2,averagePassenger1+averagePassenger2);
        table.getRow(date1).adjustOrPutValueByHeadColumn(totalPassenger,periodPassenger1);
        table.getRow(date2).adjustOrPutValueByHeadColumn(totalPassenger,periodPassenger2);
        table.getRow(date1).adjustOrPutValueByHeadColumn(dayNum,dayNumber1);
        table.getRow(date2).adjustOrPutValueByHeadColumn(dayNum,dayNumber2);
        table.getRow(date1).adjustOrPutValueByHeadColumn(totalPassengerPropority,totalPassengerPropority1);
        table.getRow(date2).adjustOrPutValueByHeadColumn(totalPassengerPropority,totalPassengerPropority2);
        table.getRow(date1).adjustOrPutValueByHeadColumn(averagePassenger,averagePassenger1);
        table.getRow(date2).adjustOrPutValueByHeadColumn(averagePassenger,averagePassenger2);
        table.getRow(date1).adjustOrPutValueByHeadColumn(averagePassengerPropority,averagePassengerPropority1);
        table.getRow(date2).adjustOrPutValueByHeadColumn(averagePassengerPropority,averagePassengerPropority2);

        return table;
    }

    /**
    * @Description: 获取两个时间的总的客流量和平均客流量
    * @Param: [startDate1, endDate1, startDate2, endDate2, dataVos]
    * @return: java.util.Map<java.lang.String,java.lang.Object>
    * @Date: 2019/1/18
    */ 
    private Map<String,Object> getTotalAndAver(Date startDate1,Date endDate1,Date startDate2,Date endDate2,List<DataVo> dataVos){
        if(dataVos == null || dataVos.isEmpty()){
            return null;
        }
        Map<String,Object> dataMap = new HashMap<>();
        Integer periodPassenger1 = 0;
        Integer periodPassenger2 = 0;
        for (DataVo dataVo : dataVos){
            Date nowDate = dataVo.getDate();
            Integer Innum = dataVo.getInnum();
            if(DateUtil.compareDate(nowDate,startDate1) != -1 && DateUtil.compareDate(nowDate,endDate1) != 1){
                periodPassenger1 += Innum;
            }
            if(DateUtil.compareDate(nowDate,startDate2) != -1 && DateUtil.compareDate(nowDate,endDate2) != 1){
                periodPassenger2 += Innum;
            }
        }
        dataMap.put("periodPassenger1",periodPassenger1);
        dataMap.put("periodPassenger2",periodPassenger2);
        //得到两个时间段的天数
        Integer dayNumber1 = DateUtil.getDaysBetweenDates(startDate1,endDate1).size();
        Integer dayNumber2 = DateUtil.getDaysBetweenDates(startDate2,endDate2).size();

        //得到两个时间段的平均客流量
        Double averagePassenger1 = null;
        Double averagePassenger2 = null;
        if(dayNumber1 != 0){
            averagePassenger1 = NumberUtil.divide(periodPassenger1,dayNumber1,2);
        }
        if(dayNumber2 != 0){
            averagePassenger2 = NumberUtil.divide(periodPassenger2,dayNumber2,2);
        }

        dataMap.put("averagePassenger1",averagePassenger1);
        dataMap.put("averagePassenger2",averagePassenger2);
        return dataMap;
    }

    /**
    * @Description: 总客流量和平均客流量饼图
    * @Param: [dataVos, reportChart, isTotalTraffic, dataMap]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/18
    */
    private Chart getTotalOrAverageTraffic(List<DataVo> dataVos,ReportChart reportChart,Map<String,Object> dataMap){
        Object totalData1 = dataMap.get("periodPassenger1");
        Object totalData2 = dataMap.get("periodPassenger2");
        Object averageData1 = dataMap.get("averagePassenger1");
        Object averageData2 = dataMap.get("averagePassenger2");
        final String totalPassengerFlow = LocalMessageUtil.getMessage("TOTALPASSENGERFLOW");
        final String averagePassenger = LocalMessageUtil.getMessage("AVERAGEPASSENGER");
        final String time1 = LocalMessageUtil.getMessage("timeQuantum1");
        final String time2 = LocalMessageUtil.getMessage("timeQuantum2");
        Chart chart = new Chart(reportChart.getTitle(),SeriesType.pie);
        chart.getSeries(totalPassengerFlow).adjustOrPutValueByCoordinate(time1,totalData1);
        chart.getSeries(totalPassengerFlow).adjustOrPutValueByCoordinate(time2, totalData2);
        chart.getSeries(averagePassenger).adjustOrPutValueByCoordinate(time1, averageData1);
        chart.getSeries(averagePassenger).adjustOrPutValueByCoordinate(time2, averageData2);
        return chart;
    }

    /**
    * @Description: 天级对比表格数据
    * @Param: [startDate1, endDate1, startDate2, endDate2, dataVos, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/18
    */ 
    private Chart getDayCompareTable(Date startDate1,Date endDate1,Date startDate2,Date endDate2,List<DataVo> dataVos,ReportChart reportChart){
        Table table = new Table(reportChart.getTitle(),SeriesType.table);
        String timeQuantum1 = LocalMessageUtil.getMessage("timeQuantum1");
        String timeQuantum2 = LocalMessageUtil.getMessage("timeQuantum2");
        String PASSAGENERFLOW1 = LocalMessageUtil.getMessage("PASSAGENERFLOW1");
        String PASSAGENERFLOW2 = LocalMessageUtil.getMessage("PASSAGENERFLOW2");
        String DAILYPROPORITY1 = LocalMessageUtil.getMessage("DAILYPROPORITY1");
        String DAILYPROPORITY2 = LocalMessageUtil.getMessage("DAILYPROPORITY2");
        TableHead tableHead = new TableHead();
        tableHead.addData(timeQuantum1);
        tableHead.addData(PASSAGENERFLOW1);
        tableHead.addData(DAILYPROPORITY1);
        tableHead.addData(timeQuantum2);
        tableHead.addData(PASSAGENERFLOW2);
        tableHead.addData(DAILYPROPORITY2);
        table.setTableHead(tableHead);
        if(dataVos == null || dataVos.isEmpty()){
            return null;
        }
        List<Date> dates1 = DateUtil.getDaysBetweenDates(startDate1, endDate1);
        List<Date> dates2 = DateUtil.getDaysBetweenDates(startDate2, endDate2);

        int total1 = 0;
        int total2 = 0;
        Date nowDate = null;
        int innum = 0;
        String dateStr = null;
        for (DataVo dataVo : dataVos){
            nowDate = dataVo.getDate();
            innum = dataVo.getInnum();
            dateStr = DateUtil.format("MM月dd日",nowDate);
            if(dates1.contains(nowDate)){
                total1 += innum;
                table.getRow(""+dates1.indexOf(nowDate)).putValueByHeadColumn(timeQuantum1,dateStr);
            }
            if(dates2.contains(nowDate)){
                total2 += innum;
                table.getRow(""+dates2.indexOf(nowDate)).putValueByHeadColumn(timeQuantum2,dateStr);
            }
        }
        for (DataVo item : dataVos){
            nowDate = item.getDate();
            dateStr = DateUtil.format("MM月dd日",nowDate);
            innum = Optional.ofNullable(item.getInnum()).orElse(0);
            total1 = total1 == 0 ? 1:total1;
            total2 = total2 == 0 ? 1:total2;
            if(dates1.contains(nowDate)){
                table.getRow(""+dates1.indexOf(nowDate)).adjustOrPutValueByHeadColumn(PASSAGENERFLOW1,innum);
                table.getRow(""+dates1.indexOf(nowDate)).putValueByHeadColumn(DAILYPROPORITY1,NumberUtil.growthRate(innum+total1,total1));
            }
            if(dates2.contains(nowDate)){
                int index = dates2.indexOf(nowDate);
                table.getRow(""+index).adjustOrPutValueByHeadColumn(PASSAGENERFLOW2,innum);
                table.getRow(""+index).putValueByHeadColumn(DAILYPROPORITY2,NumberUtil.growthRate(innum+total2,total2));
            }
        }
        return table;
    }

    /**
    * @Description: 得到天级对比折线图
    * @Param: [startDate1, endDate1, startDate2, endDate2, dataVos, dataMap, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/18
    */ 
    private Chart getDayCompareLine(Date startDate1,Date endDate1,Date startDate2,Date endDate2,List<DataVo> dataVos,Map<String,Object>dataMap,ReportChart reportChart){
        Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);
        Axis xAxis  = AxisFactory.createStringAxis();
        chart.setXAxis(xAxis);

        String PASSAGENERFLOW1 = LocalMessageUtil.getMessage("PASSAGENERFLOW1");
        String PASSAGENERFLOW2 = LocalMessageUtil.getMessage("PASSAGENERFLOW2");

        if (dataVos == null || dataVos.size()==0){
            return  chart;
        }

        List<Date> dates1 = DateUtil.getDaysBetweenDates(startDate1, endDate1);
        List<Date> dates2 = DateUtil.getDaysBetweenDates(startDate2, endDate2);

        Integer innum = null;
        String xName = "第%天";
        Date nowDate = null;
        for(int i =0 ;i<dataVos.size();i++){
            innum = dataVos.get(i).getInnum();
            nowDate = dataVos.get(i).getDate();
            if(dates1.contains(nowDate)) {
                int index = dates1.indexOf(nowDate);
                String condition1 = xName.replace("%", String.valueOf(index+1));
                chart.getSeries(PASSAGENERFLOW1).putValueByCoordinate(condition1, innum);
            }
            if(dates2.contains(nowDate)) {
                int index = dates2.indexOf(nowDate);
                String condition2 = xName.replace("%", String.valueOf(index+1));
                chart.getSeries(PASSAGENERFLOW2).putValueByCoordinate(condition2, innum);
            }
        }
        return chart;
    }

    /**
    * @Description: 根据输入的时间1和时间2查询以及组织类型出对应的数据
    * @Param: [orgIds, startDate1, endDate1, startDate2, endDate2, dataMap]
    * @return: java.util.List<com.viontech.mall.report.model.DataVo>
    * @Date: 2019/1/17
    */
    private List<DataVo> getData(Long[] orgIds,Date startDate1,Date endDate1,Date startDate2,Date endDate2,Map<String,Object> dataMap){
        //不包括边界的情况，根据需求加入，同时list数组里面可能有重复数据
        List<Date> dateList = DateUtil.getDaysBetweenDates(startDate1,endDate1);
        dateList.addAll(DateUtil.getDaysBetweenDates(startDate2,endDate2));
        OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
        KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
        String str = kpiType.getName();
        List<DataVo> dataVoList = null;
        switch (kpiType){
            case TRAFFIC:
                if(orgType == OrgType.mall){
                    List<MallDayCountData> mallDayCountDataList = mallReportDataService.getOrQueryMallInDatesDayTraffic(orgIds,dateList,dataMap);
                    dataVoList = mallReportDataService.convert2Data(mallDayCountDataList);
                }else if (orgType == OrgType.floor){
                    List<FloorDayCountData> floorDayCountDataList = floorReportDataService.getOrQueryFloorInDatesDayTraffic(orgIds,dateList,dataMap);
                    dataVoList = floorReportDataService.convert2Data(floorDayCountDataList);
                }else if(orgType == OrgType.zone){
                    List<ZoneDayCountData> zoneDayCountDataList = zoneReportDataService.getOrQueryZoneInDatesDayTraffic(orgIds,dateList,dataMap);
                    dataVoList = zoneReportDataService.convert2Data(zoneDayCountDataList);
                }else if (orgType == OrgType.gate){
                    List<GateDayCountData> gateDayCountDataList = gateReportDataService.getOrQueryGateInDatesDayTraffic(orgIds,dateList,dataMap);
                    dataVoList = gateReportDataService.convert2Data(gateDayCountDataList);
                }else{
                    return null;
                }
                break;
            case EFFECTIVETRAFFIC:
                //ConfigParamsExample configParamsExample = new ConfigParamsExample();
                List<Long> mallIdArr = new ArrayList<>();
                List<Long> orgArr  = Arrays.asList(orgIds);
                if(orgType == OrgType.mall) {
                    mallIdArr = orgArr;
                }else{
                    mallIdArr = getMallIds(dataMap,mallIdArr);
                }
                Long orgMallId = mallIdArr.get(0);
                Long orgId = orgIds[0];
                Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(orgMallId, dataMap);
                if (configParamsMap == null || configParamsMap.size() <= 0){
                    return null;
                }
                ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
                String enableTrafficConfigStr = enableTrafficConfig.getValue();
                    if(orgType == OrgType.mall){
                        List<MallDayFaceRecognitionSta> mallDayFaceRecognitionSta = (List<MallDayFaceRecognitionSta>)mallDataService.getFaceDayData(dateList,orgId);
                        dataVoList = convertFaceDataToDataVoByParamconfig(enableTrafficConfigStr,mallDayFaceRecognitionSta);
                    }else if (orgType == OrgType.floor){
                        List<FloorDayFaceRecognitionSta> floorDayFaceRecognitionSta =(List<FloorDayFaceRecognitionSta>) floorDataService.getFaceDayData(dateList,orgId);
                        dataVoList = convertFaceDataToDataVoByParamconfig(enableTrafficConfigStr,floorDayFaceRecognitionSta);
                    }else if(orgType == OrgType.zone){
                        List<ZoneDayFaceRecognitionSta> zoneDayFaceRecognitionSta =(List<ZoneDayFaceRecognitionSta>) zoneDataService.getFaceDayData(dateList,orgId);
                        dataVoList = convertFaceDataToDataVoByParamconfig(enableTrafficConfigStr,zoneDayFaceRecognitionSta);
                    }else if (orgType == OrgType.gate){
                        List<GateDayFaceRecognitionSta> gateDayFaceRecognitionSta =(List<GateDayFaceRecognitionSta>) gateDataService.getFaceDayData(dateList,orgId);
                        dataVoList = convertFaceDataToDataVoByParamconfig(enableTrafficConfigStr,gateDayFaceRecognitionSta);
                    }else{
                        return null;
                    }
        }
        return dataVoList;
    }

    /**
    * @Description: 根据orgId得到其mallId
    * @Param: [dataMap, orgIds]
    * @return: java.util.List<java.lang.Long>
    * @Date: 2019/1/17
    */ 
    private List<Long> getMallIds(Map<String,Object> dataMap,List<Long> orgIds){
        OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
        List<Long> mallIds = null;
        if(orgType == OrgType.floor) {
            FloorExample floorExample = new FloorExample();
            floorExample.createCriteria().andIdIn(orgIds);
            floorExample.createColumns().hasMallIdColumn();
            List<Floor> floors = floorService.selectByExample(floorExample);
            mallIds = floors.stream().map(Floor::getMallId).collect(Collectors.toList());
        }else if (orgType == OrgType.zone){
            ZoneExample zoneExample = new ZoneExample();
            zoneExample.createCriteria().andIdIn(orgIds);
            zoneExample.createColumns().hasMallIdColumn();
            List<Zone> zones = zoneService.selectByExample(zoneExample);
            mallIds = zones.stream().map(Zone::getMallId).collect(Collectors.toList());
        }else if (orgType == OrgType.gate){
            GateExample gateExample = new GateExample();
            gateExample.createCriteria().andIdIn(orgIds);
            gateExample.createColumns().hasMallIdColumn();
            List<Gate> gates = gateService.selectByExample(gateExample);
            mallIds = gates.stream().map(Gate::getMallId).collect(Collectors.toList());
        }
        return mallIds;
    }

    /**
    * @Description: 将人脸数据转成统一标准格式
    * @Param: [paramConfig, faceDataList]
    * @return: java.util.List<com.viontech.mall.report.model.DataVo>
    * @Date: 2019/1/18
    */
    private <T> List<DataVo> convertFaceDataToDataVoByParamconfig(String paramConfig,List<T> faceDataList){
        if(faceDataList == null || faceDataList.isEmpty()){
            return null;
        }
        List<DataVo> dataVos = new ArrayList<>();

        //int flag = 0;
        T t = faceDataList.get(0);
        switch (paramConfig){
            case "0":
                if(t instanceof MallDayFaceRecognitionSta){
                    //  flag = 1;
                    for (T item : faceDataList){
                        MallDayFaceRecognitionSta temple= (MallDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getCustomCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else if(t instanceof FloorDayFaceRecognitionSta){
                    //flag = 2;
                    for (T item : faceDataList){
                        FloorDayFaceRecognitionSta temple= (FloorDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getCustomCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else if (t instanceof ZoneDayFaceRecognitionSta){
                    //flag = 3;
                    for (T item : faceDataList){
                        ZoneDayFaceRecognitionSta  temple= (ZoneDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getCustomCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else if (t instanceof GateDayFaceRecognitionSta){
                    //flag = 4;
                    for (T item : faceDataList){
                        GateDayFaceRecognitionSta temple= (GateDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getCustomCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else{
                    //flag = flag;
                    dataVos = dataVos;
                }

            case "1"://严格模式
                if(t instanceof MallDayFaceRecognitionSta){
                    //  flag = 1;
                    for (T item : faceDataList){
                        MallDayFaceRecognitionSta  temple= (MallDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getMaleCount()+temple.getFemaleCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else if(t instanceof FloorDayFaceRecognitionSta){
                    //flag = 2;
                    for (T item : faceDataList){
                        FloorDayFaceRecognitionSta  temple= (FloorDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getMaleCount()+temple.getFemaleCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else if (t instanceof ZoneDayFaceRecognitionSta){
                    //flag = 3;
                    for (T item : faceDataList){
                        ZoneDayFaceRecognitionSta  temple= (ZoneDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getMaleCount()+temple.getFemaleCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else if (t instanceof GateDayFaceRecognitionSta){
                    //flag = 4;
                    for (T item : faceDataList){
                        GateDayFaceRecognitionSta  temple= (GateDayFaceRecognitionSta)item;
                        DataVo dataVo = new DataVo();
                        dataVo.setInnum(temple.getMaleCount()+temple.getFemaleCount());
                        dataVo.setDate(temple.getCountdate());
                        dataVos.add(dataVo);
                    }
                }else{
                    //flag = flag;
                    dataVos = dataVos;
                }
        }
        return dataVos;
    }
}
