package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.DateAxis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import com.viontech.mall.report.util.AgeProcessUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class SynthesizeCompareServiceImpl extends ChartReportBaseService {

	@Value("${Age.stage}")
	private String ageStage;

	@Resource
	private GateReportDataService gateReportDataService;
	
	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private MallReportDataService mallReportDataService;
	
	/**性别分布*/
	private final String REPORT_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**年龄分布*/
	private final String REPORT_CUSTOMERFEATURE_AGE ="customerfeature_age";
	/**趋势图*/
	private final String REPORT_DAY_TREND = "dayTrend";
	/**月级趋势图*/
	private final String REPORT_MONTH_TREND = "monthTrend";
	
	

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		String dateType = (String) dataMap.get("DATETYPE");
		List<FaceVo> faceDatas = new ArrayList<FaceVo>();
		List<DataVo>  hourDataVos = new ArrayList<DataVo>();
		List<DataVo>  dayDataVos = new ArrayList<DataVo>();
		if (orgType == OrgType.gate) {
 			//人脸
			List<GateDayFaceRecognitionSta> faceRecDatas = gateReportDataService.getOrQueryGateFaceData(orgIds, startDate, endDate, dataMap);
			faceDatas = gateReportDataService.convertFace2Data(faceRecDatas);
			//天级客流
			List<GateDayCountData> dayDatas = gateReportDataService.getOrQueryGateBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dayDataVos = gateReportDataService.convert2Data(dayDatas);
		}else if (orgType == OrgType.zone) {
 			//人脸
			List<ZoneDayFaceRecognitionSta> zoneFaceDatas = zoneReportDataService.getOrQueryZoneDayFaceRecognitionStas(orgIds, startDate, endDate, dataMap);
			faceDatas = zoneReportDataService.convertFace2Data(zoneFaceDatas);
			//天级客流
			List<ZoneDayCountData> dayDatas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dayDataVos = zoneReportDataService.convert2Data(dayDatas);
		}else if (orgType == OrgType.floor) {
			//人脸
			List<FloorDayFaceRecognitionSta> floorFaceDatas = floorReportDataService.getOrQueryFloorDayFaceRecognitionStas(orgIds, startDate, endDate, dataMap);
			faceDatas = floorReportDataService.convertFace2Data(floorFaceDatas);
			//添加客流
			List<FloorDayCountData> dayDatas = floorReportDataService.getOrQueryFloorBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dayDataVos = floorReportDataService.convert2Data(dayDatas);
		}else if (orgType == OrgType.mall) {
			//人脸
			List<MallDayFaceRecognitionSta> mallFaceDatas = mallReportDataService.getOrQueryMallFaceData(orgIds, startDate, endDate, dataMap);
			faceDatas = mallReportDataService.convertFace2Data(mallFaceDatas);
			//天级客流
			List<MallDayCountData> dayDatas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dayDataVos = mallReportDataService.convert2Data(dayDatas);
		}
		
		switch (reportChart.getKey()) {
		case REPORT_CUSTOMERFEATURE_GENDER:
			chart = genderDistributionReport(faceDatas, dataMap, reportChart);
			break;
		case REPORT_CUSTOMERFEATURE_AGE:
			chart = ageDistributionReport(faceDatas, dataMap, reportChart);
			break;
		case REPORT_DAY_TREND:
			chart = DayTrendReport(dayDataVos, dataMap, startDate, endDate, reportChart);
			break;
		case REPORT_MONTH_TREND:
			chart = MonthTrendReport(dayDataVos, dataMap, startDate, endDate, reportChart);
			break;
		default:
			break;
		}
		return chart;
	}
	
	//近期天对比
	private Chart DayTrendReport(List<DataVo> dataVos,Map<String, Object> dataMap, Date startDate, Date endDate,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);
		
		Axis<Date> xAxis = null;
		OptionsContain option = (OptionsContain) dataMap.get("chartOption");
		if(option == OptionsContain.TAB_WEEK){
			xAxis = AxisFactory.createWeekOFYearAxis();
		}else if(option == OptionsContain.TAB_MONTH){
			xAxis = AxisFactory.createMonthOFYearAxis();
		}else{
			xAxis = AxisFactory.createDayOFMonthAxis();
		}
		xAxis.setMin(startDate);
		xAxis.setMax(endDate);
		chart.setXAxis(xAxis);
		putData2Chart(chart, dataVos, dataMap);
		return chart;
	}

	private Chart MonthTrendReport(List<DataVo> dataVos,Map<String, Object> dataMap, Date startDate, Date endDate,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);

		Axis<Date> xAxis = null;
		xAxis = AxisFactory.createMonthOFYearAxis();
		((DateAxis)xAxis).setDateFormatStr("MM月");
		xAxis.setMin(startDate);
		xAxis.setMax(endDate);
		chart.setXAxis(xAxis);
		putData2Chart(chart, dataVos, dataMap);
		return chart;
	}
	
	private void putData2Chart(Chart chart,List<DataVo> dataVos,Map<String, Object> dataMap){
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		for (DataVo dataVo : dataVos) {
			String SeriesName = "未知";
			switch (orgType) {
			case gate:
				Long gateId = dataVo.getGateId();
				Gate gate = gateReportDataService.getGateInfoById(gateId, dataMap);
				if (gate != null && gate.getName() != null) {
					SeriesName = gate.getName();
				}
				break;
			case zone:
				Long zoneId = dataVo.getZoneId();
				Zone zone = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap);
				if (zone != null && zone.getName() != null) {
					SeriesName = zone.getName();
				}
				break;
			case floor:
				Long floorId = dataVo.getFloorId();
				Floor floor = floorReportDataService.getFloorInfoById(floorId, dataMap);
				if (floor != null && floor.getName() != null) {
					SeriesName = floor.getName();
				}
				break;
			case mall:
				Long mallId = dataVo.getMallId();
				Mall mall = mallReportDataService.getMallByMallId(mallId, dataMap);
				if (mall != null && mall.getName() != null) {
					SeriesName = mall.getName();
				}
				break;
			default:
				break;
			}
			Date coordinateName = dataVo.getDate();
			switch (kpiType) {
			case TRAFFIC:
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(coordinateName, dataVo.getInnum());
				break;
			case ENTERINGRATE:
				int passNum = dataVo.getPassInnum()+ dataVo.getPassOutnum();
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(coordinateName, NumberUtil.percentage(dataVo.getInnum(), passNum, 2));
				break;
			
			default:
				break;
			}
			
		}
	}
	
	/**顾客特征--性别分布*/
	public Chart genderDistributionReport(List<FaceVo> faceDatas,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
	
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (FaceVo faceVo : faceDatas) {
			String SeriesName = "未知";
			switch (orgType) {
			case gate:
				Long gateId = faceVo.getGateId();
				Gate gate = gateReportDataService.getGateInfoById(gateId, dataMap);
				if (gate != null && gate.getName() != null) {
					SeriesName = gate.getName();
				}
				break;
			case zone:
				Long zoneId = faceVo.getZoneId();
				Zone zone = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap);
				if (zone != null && zone.getName() != null)  {
					SeriesName = zone.getName();
				}
				break;
			case floor:
				Long floorId = faceVo.getFloorId();
				Floor floor = floorReportDataService.getFloorInfoById(floorId, dataMap);
				if (floor != null && floor.getName() != null)  {
					SeriesName = floor.getName();
				}
				break;
			case mall:
				Long mallId = faceVo.getMallId();
				Mall mall = mallReportDataService.getMallByMallId(mallId, dataMap);
				if (mall != null && mall.getName() != null) {
					SeriesName = mall.getName();
				}
				break;
			default:
				break;
			}
			
			chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), faceVo.getMaleMantime());
			chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(), faceVo.getFemaleMantime());
		}
		
		return chart;
	}

	/**顾客特征--年龄分布*/
	public Chart ageDistributionReport(List<FaceVo> faceDatas,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (FaceVo faceVo : faceDatas) {
			String SeriesName = "未知";
			switch (orgType) {
			case gate:
				Long gateId = faceVo.getGateId();
				Gate gate = gateReportDataService.getGateInfoById(gateId, dataMap);
				if (gate != null && gate.getName() != null) {
					SeriesName = gate.getName();
				}
				break;
			case zone:
				Long zoneId = faceVo.getZoneId();
				Zone zone = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap);
				if (zone != null && zone.getName() != null)  {
					SeriesName = zone.getName();
				}
				break;
			case floor:
				Long floorId = faceVo.getFloorId();
				Floor floor = floorReportDataService.getFloorInfoById(floorId, dataMap);
				if (floor != null && floor.getName() != null)  {
					SeriesName = floor.getName();
				}
				break;
			case mall:
				Long mallId = faceVo.getMallId();
				Mall mall = mallReportDataService.getMallByMallId(mallId, dataMap);
				if (mall != null && mall.getName() != null) {
					SeriesName = mall.getName();
				}
				break;
			default:
				break;
			}

			String maleStage = faceVo.getMaleStage();
			String femaleStage = faceVo.getFemaleStage();
			if(maleStage == null || femaleStage == null){
				continue;
			}
			String[] maleAgestatic = maleStage.split(",", -2);
			String[] femaleAgestatic = femaleStage.split(",", -2);

			if (maleAgestatic.length != femaleAgestatic.length) {
				continue;
			}
			String[] ages = ageStage.split(",");
			List<Integer> ageStages = new ArrayList<>();
			for (String age : ages) {
				Integer ageInt = Integer.parseInt(age);
				ageStages.add(ageInt);
			}
			String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
			
			for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
				String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
				int maleAgeNum = Integer.parseInt(maleAgestatic[rangeNum].trim());
				int femaleAgeNum = Integer.parseInt(femaleAgestatic[rangeNum].trim());
				int num = maleAgeNum+femaleAgeNum;
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(ageRange, num);
			}
		}
		return chart;
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}
	

}
