package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import com.viontech.mall.report.util.AgeProcessUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class SynthesizeCompareDayServiceImpl extends ChartReportBaseService {

	@Value("${Age.stage}")
	private String ageStage;

	@Resource
	private GateReportDataService gateReportDataService;
	
	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private MallReportDataService mallReportDataService;
	
	/**性别分布*/
	private final String REPORT_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**年龄分布*/
	private final String REPORT_CUSTOMERFEATURE_AGE ="customerfeature_age";
	/**实时*/
	private final String REPORT_DAY_HOUR = "hourTrend";
	/**累计*/
	private final String REPORT_DAY_HOUR_ACCUMULATIVE ="accumulative";
	/**趋势图*/
	private final String REPORT_DAY_TREND = "dayTrend";
	
	

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		String dateType = (String) dataMap.get("DATETYPE");
		Date date = startDate;
		dataMap.put("currentDate", date);
		List<FaceVo> faceDatas = new ArrayList<FaceVo>();
		List<DataVo>  hourDataVos = new ArrayList<DataVo>();
		List<DataVo>  dayDataVos = new ArrayList<DataVo>();
		Date beforeDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
		if (orgType == OrgType.gate) {
 			//人脸
			List<GateDayFaceRecognitionSta> faceRecDatas = gateReportDataService.getOrQueryGateFaceData(orgIds, date, date, dataMap);
			faceDatas = gateReportDataService.convertFace2Data(faceRecDatas);
			//小时客流
			List<GateHourCountData> hourDatas  = gateReportDataService.getOrQueryGateDaysHourData(orgIds, Arrays.asList(date), dataMap);
			hourDataVos = gateReportDataService.convert2Data(hourDatas);
			//天级客流
			List<GateDayCountData> dayDatas = gateReportDataService.getOrQueryGateBetweenDateDayTraffic(orgIds, beforeDate, date, dataMap);
			dayDataVos = gateReportDataService.convert2Data(dayDatas);
		}else if (orgType == OrgType.zone) {
 			//人脸
			List<ZoneDayFaceRecognitionSta> zoneFaceDatas = zoneReportDataService.getOrQueryZoneDayFaceRecognitionStas(orgIds, date, date, dataMap);
			faceDatas = zoneReportDataService.convertFace2Data(zoneFaceDatas);
			//小时客流
			List<ZoneHourCountData> hourDatas  = zoneReportDataService.getOrQueryZoneBetweenDateHourTraffic(orgIds, date, date, dataMap);
			hourDataVos = zoneReportDataService.convert2Data(hourDatas);
			//天级客流
			List<ZoneDayCountData> dayDatas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, beforeDate, date, dataMap);
			dayDataVos = zoneReportDataService.convert2Data(dayDatas);
		}else if (orgType == OrgType.floor) {
			//人脸
			List<FloorDayFaceRecognitionSta> floorFaceDatas = floorReportDataService.getOrQueryFloorDayFaceRecognitionStas(orgIds, date, date, dataMap);
			faceDatas = floorReportDataService.convertFace2Data(floorFaceDatas);
			//小时客流
			List<FloorHourCountData> hourDatas  = floorReportDataService.getOrQueryFloorBetweenDateHourTraffic(orgIds, date, date, dataMap);
			hourDataVos = floorReportDataService.convert2Data(hourDatas);
			//添加客流
			List<FloorDayCountData> dayDatas = floorReportDataService.getOrQueryFloorBetweenDateDayTraffic(orgIds, beforeDate, date, dataMap);
			dayDataVos = floorReportDataService.convert2Data(dayDatas);
		}else if (orgType == OrgType.mall) {
			//人脸
			List<MallDayFaceRecognitionSta> mallFaceDatas = mallReportDataService.getOrQueryMallFaceData(orgIds, date, date, dataMap);
			faceDatas = mallReportDataService.convertFace2Data(mallFaceDatas);
			//小时客流
			List<MallHourCountData> hourDatas  = mallReportDataService.getOrQueryMallDaysHourTraffic(orgIds, Arrays.asList(date), dataMap);
			hourDataVos = mallReportDataService.convert2Data(hourDatas);
			//天级客流
			List<MallDayCountData> dayDatas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, beforeDate, date, dataMap);
			dayDataVos = mallReportDataService.convert2Data(dayDatas);
		}
		
		switch (reportChart.getKey()) {
		case REPORT_CUSTOMERFEATURE_GENDER:
			chart = genderDistributionReport(faceDatas, dataMap, reportChart);
			break;
		case REPORT_CUSTOMERFEATURE_AGE:
			chart = ageDistributionReport(faceDatas, dataMap, reportChart);
			break;
		case REPORT_DAY_HOUR:
			chart = HourTrendReport(orgIds,orgType, hourDataVos, dataMap, reportChart);
			break;
		case REPORT_DAY_HOUR_ACCUMULATIVE:
			chart = HourAddTrendReport(orgIds,orgType, hourDataVos, dataMap, reportChart);
			break;
		case REPORT_DAY_TREND:
			chart = DayTrendReport(dayDataVos, dataMap, beforeDate, date, reportChart);
			break;
		default:
			break;
		}
		return chart;
	}
	//累计对比
	public Chart HourAddTrendReport(Long[] orgIds,OrgType orgType,List<DataVo> dataVos,Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line){
			@Override
			public Object calcValue(String name, int index, List data_raw) {
				Double result = null;
				if (data_raw.get(index) != null) {
					result = Double.parseDouble(data_raw.get(index).toString());
				}
				for(int i=index-1;i>=0;i--){//往前查找 直到找到一个不是null的值
					if(data_raw.get(i) == null){
						continue;
					}
					if(result == null){
						result =  Double.parseDouble(data_raw.get(i).toString());
					}else{
						result += Double.parseDouble(data_raw.get(i).toString());
					}
					break;
				}
				
				return result;
			}
		};
		Axis<Date>  xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		if (orgIds.length > 0) {
			Long id = orgIds[0];
			DateCriteria dCriteria = zoneReportDataService.getMallOpentimesByOrgId(id, orgType, dataMap);
			xAxis.setMin(dCriteria.getStartDate());
			xAxis.setMax(dCriteria.getEndDate());
			xAxis.lockMinMax();
			chart.setXAxis(xAxis);
		}
		putData2Chart(chart, dataVos, dataMap,"hour");
		return chart;
	}
	//时刻对比
	private Chart HourTrendReport(Long[] orgIds,OrgType orgType,List<DataVo> dataVos,Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		
		Axis<Date>  xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		if (orgIds.length > 0) {
			Long zoneId = orgIds[0];
			DateCriteria dCriteria = zoneReportDataService.getMallOpentimesByOrgId(zoneId, orgType, dataMap);
			xAxis.setMin(dCriteria.getStartDate());
			xAxis.setMax(dCriteria.getEndDate());
			xAxis.lockMinMax();
			chart.setXAxis(xAxis);
		}
		putData2Chart(chart, dataVos, dataMap,"hour");
		return chart;
	}
	//近15天对比
	private Chart DayTrendReport(List<DataVo> dataVos,Map<String, Object> dataMap, Date startDate, Date endDate,ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);
		
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
		chart.setXAxis(xAxis);
		putData2Chart(chart, dataVos, dataMap,"day");
		return chart;
	}

	
	private void putData2Chart(Chart chart,List<DataVo> dataVos,Map<String, Object> dataMap,String dataType){
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		for (DataVo dataVo : dataVos) {
			String SeriesName = "未知";
			switch (orgType) {
			case gate:
				Long gateId = dataVo.getGateId();
				Gate gate = gateReportDataService.getGateInfoById(gateId, dataMap);
				if (gate != null && gate.getName() != null) {
					SeriesName = gate.getName();
				}
				break;
			case zone:
				Long zoneId = dataVo.getZoneId();
				Zone zone = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap);
				if (zone != null && zone.getName() != null) {
					SeriesName = zone.getName();
				}
				break;
			case floor:
				Long floorId = dataVo.getFloorId();
				Floor floor = floorReportDataService.getFloorInfoById(floorId, dataMap);
				if (floor != null && floor.getName() != null) {
					SeriesName = floor.getName();
				}
				break;
			case mall:
				Long mallId = dataVo.getMallId();
				Mall mall = mallReportDataService.getMallByMallId(mallId, dataMap);
				if (mall != null && mall.getName() != null) {
					SeriesName = mall.getName();
				}
				break;
			default:
				break;
			}
			Object coordinateName = null;
			if (dataType.equals("hour")) {
				coordinateName = dataVo.getTime();
			}else if (dataType.equals("day")) {
				coordinateName = dataVo.getDate();
			}
			switch (kpiType) {
			case TRAFFIC:
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(coordinateName, dataVo.getInnum());
				break;
			case ENTERINGRATE:
				int passNum = dataVo.getPassInnum()+ dataVo.getPassOutnum();
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(coordinateName, NumberUtil.percentage(dataVo.getInnum(), passNum, 2));
				break;
			
			default:
				break;
			}
			
		}
	}
	
	/**顾客特征--性别分布*/
	public Chart genderDistributionReport(List<FaceVo> faceDatas,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
	
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (FaceVo faceVo : faceDatas) {
			String SeriesName = "未知";
			switch (orgType) {
			case gate:
				Long gateId = faceVo.getGateId();
				Gate gate = gateReportDataService.getGateInfoById(gateId, dataMap);
				if (gate != null && gate.getName() != null) {
					SeriesName = gate.getName();
				}
				break;
			case zone:
				Long zoneId = faceVo.getZoneId();
				Zone zone = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap);
				if (zone != null && zone.getName() != null)  {
					SeriesName = zone.getName();
				}
				break;
			case floor:
				Long floorId = faceVo.getFloorId();
				Floor floor = floorReportDataService.getFloorInfoById(floorId, dataMap);
				if (floor != null && floor.getName() != null)  {
					SeriesName = floor.getName();
				}
				break;
			case mall:
				Long mallId = faceVo.getMallId();
				Mall mall = mallReportDataService.getMallByMallId(mallId, dataMap);
				if (mall != null && mall.getName() != null) {
					SeriesName = mall.getName();
				}
				break;
			default:
				break;
			}
			
			chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), faceVo.getMaleMantime());
			chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(), faceVo.getFemaleMantime());
		}
		
		return chart;
	}

	/**顾客特征--年龄分布*/
	public Chart ageDistributionReport(List<FaceVo> faceDatas,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (FaceVo faceVo : faceDatas) {
			String SeriesName = "未知";
			switch (orgType) {
			case gate:
				Long gateId = faceVo.getGateId();
				Gate gate = gateReportDataService.getGateInfoById(gateId, dataMap);
				if (gate != null && gate.getName() != null) {
					SeriesName = gate.getName();
				}
				break;
			case zone:
				Long zoneId = faceVo.getZoneId();
				Zone zone = zoneReportDataService.getOrQueryZoneById(zoneId, dataMap);
				if (zone != null && zone.getName() != null)  {
					SeriesName = zone.getName();
				}
				break;
			case floor:
				Long floorId = faceVo.getFloorId();
				Floor floor = floorReportDataService.getFloorInfoById(floorId, dataMap);
				if (floor != null && floor.getName() != null)  {
					SeriesName = floor.getName();
				}
				break;
			case mall:
				Long mallId = faceVo.getMallId();
				Mall mall = mallReportDataService.getMallByMallId(mallId, dataMap);
				if (mall != null && mall.getName() != null) {
					SeriesName = mall.getName();
				}
				break;
			default:
				break;
			}

			String maleStage = faceVo.getMaleStage();
			String femaleStage = faceVo.getFemaleStage();
			if(maleStage == null || femaleStage == null){
				continue;
			}
			String[] maleAgestatic = maleStage.split(",", -2);
			String[] femaleAgestatic = femaleStage.split(",", -2);

			if (maleAgestatic.length != femaleAgestatic.length) {
				continue;
			}
			String[] ages = ageStage.split(",");
			List<Integer> ageStages = new ArrayList<>();
			for (String age : ages) {
				Integer ageInt = Integer.parseInt(age);
				ageStages.add(ageInt);
			}
			String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
			
			for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
				String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
				int maleAgeNum = Integer.parseInt(maleAgestatic[rangeNum].trim());
				int femaleAgeNum = Integer.parseInt(femaleAgestatic[rangeNum].trim());
				int num = maleAgeNum+femaleAgeNum;
				chart.getSeries(SeriesName).adjustOrPutValueByCoordinate(ageRange, num);


			}
		}
		return chart;
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}
	

}
