package com.viontech.mall.report.service.impl;

import com.viontech.mall.model.Sale;
import com.viontech.mall.model.SaleExample;
import com.viontech.mall.model.SaleExample.Criteria;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.SaleDataService;
import com.viontech.mall.service.adapter.SaleService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Service
public class SaleDataServiceImpl implements SaleDataService {
	@Resource
	private SaleService saleService;
	
	@Resource
	private ZoneService zoneService;

	@Override
	public  List<Sale> getDaysData(List<DateCriteria> dates,List<Long> ids,OrgType orgType) {
		SaleExample saleExample = new SaleExample();
		saleExample.createColumns();
		Criteria criteria = saleExample.createCriteria();
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andSaledateBetween(start, end);
			}
		}
		switch (orgType) {
		case zone:
			if (ids != null && ids.size() == 1) {
				criteria.andZoneIdEqualTo(ids.get(0));
			}else {
				criteria.andZoneIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		case floor:
			if (ids != null && ids.size() == 1) {
				criteria.andFloorIdEqualTo(ids.get(0));
			}else {
				criteria.andFloorIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		case mall:
			if (ids != null && ids.size() == 1) {
				criteria.andMallIdEqualTo(ids.get(0));
			}else {
				criteria.andMallIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		case account:
			if (ids != null && ids.size() == 1) {
				criteria.andAccountIdEqualTo(ids.get(0));
			}else {
				criteria.andAccountIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		default:
			break;
		}
		return null;
	}
	@Override
	public  List<Sale> getDayData(List<Date> dates,List<Long> ids,OrgType orgType) {
		SaleExample saleExample = new SaleExample();
		saleExample.createColumns();
		Criteria criteria = saleExample.createCriteria();
		if (dates != null && dates.size() ==1) {
			criteria.andSaledateEqualTo(dates.get(0));
		}else {
			criteria.andSaledateIn(dates);
		}
		switch (orgType) {
		case zone:
			if (ids != null && ids.size() == 1) {
				criteria.andZoneIdEqualTo(ids.get(0));
			}else {
				criteria.andZoneIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		case floor:
			if (ids != null && ids.size() == 1) {
				criteria.andFloorIdEqualTo(ids.get(0));
			}else {
				criteria.andFloorIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		case mall:
			if (ids != null && ids.size() == 1) {
				criteria.andMallIdEqualTo(ids.get(0));
			}else {
				criteria.andMallIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		case account:
			if (ids != null && ids.size() == 1) {
				criteria.andAccountIdEqualTo(ids.get(0));
			}else {
				criteria.andAccountIdIn(ids);
			}
			return saleService.selectByExample(saleExample);
		default:
			break;
		}
		return null;
	}
	@Override
	public  List<Sale> getDayData(Date start,Date end,List<Long> ids,OrgType orgType){
		DateCriteria dateCriteria = new DateCriteria();
		dateCriteria.setStartDate(start);
		dateCriteria.setEndDate(end);
		List<DateCriteria> dateCriterias = new ArrayList<BaseDataServiceImpl.DateCriteria>();
		dateCriterias.add(dateCriteria);
		return this.getDaysData(dateCriterias, ids,orgType);
	}
	@Override
	public List<Sale> getDayData(Date date,List<Long> ids,OrgType orgType){
		return this.getDayData(Arrays.asList(date),ids,orgType);
	}
	@Override
	public List<Sale> getDayData(Date date, Long id,OrgType orgType){
		return this.getDayData(Arrays.asList(date),Arrays.asList(id),orgType);
	}
	@Override
	public List<Sale> getDayData(List<Date> dates, Long id,OrgType orgType){
		return this.getDayData(dates,Arrays.asList(id),orgType);
	}
	@Override
	public  List<Sale> getDayData(Date start,Date end,Long id,OrgType orgType){
		return this.getDayData(start, end, Arrays.asList(id),orgType);
	}
}
