package com.viontech.mall.report.service.impl;

import com.viontech.keliu.base.BaseModel;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.model.Residence;
import com.viontech.mall.model.ResidenceExample;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.report.util.ResidenceProcessUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Description:
 * @Author: WJY
 * @Date: 2018-11-23 16:49
 */
@Service
public class ResidenceReportServiceImpl extends ChartReportBaseService {

    /** 商场顾客特征--性别分布 */
    public static  final String REPORT_MALL_CUSTOMERFEATURE_GENDER = "customerfeature_denger";
    /** 商场顾客特征--年龄分布 */
    public static final String REPORT_MALL_CUSTOMERFEATURE_AGE = "customerfeature_age";
    /** 商场顾客特征--滞留时间分布 */
    public static final String REPORT_MALL_CUSTOMERFEATURE_RESIDENCE = "customerfeature_residence";

    /** 滞留时间数据 */
    private String KEY_RESIDENCE_DAY_DATA = "residenceData";

    @Value("${Age.stage}")
    private String ageStage;

    @Resource
    private BaseService<Residence> baseService;


    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Date date = startDate;
        Long orgId = orgIds[0];
        Chart chart = null;
        switch(reportChart.getKey()){
            case REPORT_MALL_CUSTOMERFEATURE_GENDER:// 商场顾客特征--性别分布
                chart = genderDistributionReport(orgIds, startDate,endDate, dataMap, reportChart);
                break;
            case REPORT_MALL_CUSTOMERFEATURE_AGE:// 商场顾客特征--年龄分布
                chart = ageDistributionReport(orgIds, startDate,endDate, dataMap, reportChart);
                break;
            case REPORT_MALL_CUSTOMERFEATURE_RESIDENCE://商场顾客特征--滞留时间分布
                chart = residenceDistributionReport(orgIds, startDate,endDate, dataMap, reportChart);
            default:
                break;
        }
        return chart;
    }


    public Chart genderDistributionReport(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);
        List<Long>orgIdsList = Arrays.asList( orgIds);
        String residenceStage = dataMap.get("residenceStage").toString();
        List<Residence> datas = (List<Residence>)getResidenceDayData( startDate, endDate,orgIdsList,residenceStage);
        Map<String,Integer> genderMap = new HashMap<>();

        genderMap.put("male",0);
        genderMap.put("female",0);
        Integer maleNum = genderMap.get("male");
        Integer femaleNum = genderMap.get("female");
        for (Residence residence : datas) {
            if(residence.getGender()==0){
                femaleNum++;
            }else if(residence.getGender()==1){
                maleNum++;
            }

        }
        genderMap.put("male",maleNum);
        genderMap.put("female",femaleNum);
        chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), genderMap.get("male"));
        chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),genderMap.get("female"));
        //chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), genderMap.get("male"));
        return chart;
    }


    public Chart ageDistributionReport(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

        Axis<String> xAxis = AxisFactory.createStringAxis();
        chart.setXAxis(xAxis);

        String[] ages = ageStage.split(",");
        List<Integer> ageStages = new ArrayList<>();
        for (String age : ages) {
            Integer ageInt = Integer.parseInt(age);
            ageStages.add(ageInt);
        }
        String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
        List<Long>orgIdsList = Arrays.asList( orgIds);
        List<Residence> residences =(List<Residence>) dataMap.get(KEY_RESIDENCE_DAY_DATA);
        String residenceStage = dataMap.get("residenceStage").toString();
        if(residences==null) {
            residences = (List<Residence>)getResidenceDayData( startDate, endDate,orgIdsList,residenceStage);
        }
        dataMap.put(KEY_RESIDENCE_DAY_DATA,residences);
        short[] agestatic = new short[100];
        if (residences != null && residences.size() >0) {
            if (residences != null){
                for (Residence ageStatistic : residences) {
                    short temp = ageStatistic.getAge();
                    if(temp==-1){
                        continue;
                    }
                        agestatic[temp]= (short) (agestatic[temp]+1);
                }
        }
                for (int rangeNum = 0; rangeNum < agestatic.length; rangeNum++) {
                    int num = agestatic[rangeNum];
                    String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
                    chart.getSeries(reportChart.getTitle()).adjustOrPutValueByCoordinate(ageRange, num);
                }
            }
        return chart;
    }


    public Chart residenceDistributionReport(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
        Axis<String> xAxis = AxisFactory.createStringAxis();
        chart.setXAxis(xAxis);
        String residenceStage = dataMap.get("residenceStage").toString();
        String[] residenceStageArr = residenceStage.split(",");
        String[] residenceThresholdName = ResidenceProcessUtil.calResidenceThresholdName(residenceStage);
        List<Long>orgIdsList = Arrays.asList( orgIds);
        List<Residence> residences =(List<Residence>) dataMap.get(KEY_RESIDENCE_DAY_DATA);

        if(residences==null) {
            residences = (List<Residence>)getResidenceDayData(startDate, endDate,orgIdsList,null);
        }
        dataMap.put(KEY_RESIDENCE_DAY_DATA,residences);
        String minAndMax = ResidenceProcessUtil.minAndMax(residenceStage);
        int[] minAndMaxArr = {Integer.parseInt(minAndMax.split(",")[0]),Integer.parseInt(minAndMax.split(",")[1])};
        Integer length = null;
        //length = minAndMaxArr[1]-minAndMaxArr[0];
        if(residenceStageArr[residenceStageArr.length-1].endsWith("-")){
            length = minAndMaxArr[1]-minAndMaxArr[0]+1;
        }else{
            length = minAndMaxArr[1]-minAndMaxArr[0];
        }
        int[] residencestatic = new int[length];
        if (residences != null && residences.size() >0) {
            for (Residence residenceStatistic : residences) {
                if(residenceStatistic.getResidenceTime()==null || residenceStatistic.getResidenceTime()<0){
                    continue;
                }
                int temp = (int)Math.ceil(residenceStatistic.getResidenceTime()/60.0);
                //temp++;
                if(minAndMaxArr[0]<temp && temp<minAndMaxArr[1]) {//1
                    residencestatic[temp - minAndMaxArr[0]-1] = residencestatic[temp - minAndMaxArr[0]-1] + 1;//2
                }
                //-----------------
                if(temp==minAndMaxArr[1]){
                    residencestatic[temp - minAndMaxArr[0]-2] = residencestatic[temp - minAndMaxArr[0]-2] + 1;
                }
                //-----------------
                if(residenceStageArr[residenceStageArr.length-1].endsWith("-")) {
                    if (temp > minAndMaxArr[1]){//
                        residencestatic[residencestatic.length-1] = residencestatic[residencestatic.length-1] + 1;
                    }
                }
            }
                for (int rangeNum = 0; rangeNum < residencestatic.length; rangeNum++) {
                    int num = residencestatic[rangeNum];
                    ArrayList<Integer> arrayList = ResidenceProcessUtil.getIndexByResidence(rangeNum+minAndMaxArr[0]+1,residenceStageArr);
                    if(arrayList != null){
                        for(Integer integer : arrayList){
                            String ageRange = residenceThresholdName[integer];
                            chart.getSeries(reportChart.getTitle()).adjustOrPutValueByCoordinate(ageRange, num);
                        }
                    }
                }
            }

        return chart;
    }


    public List<? extends BaseModel> getResidenceDayData(Date startDate, Date endDate, List<Long> ids, String residenceStage) {
        ResidenceExample example = new ResidenceExample();
        String[] durings = null;
        if(residenceStage != null) {
            durings = residenceStage.split("-");
        }
        ResidenceExample.Criteria criteria = example.createCriteria();
        if (ids != null && ids.size() == 1) {
            criteria.andMallIdEqualTo(ids.get(0));
        }else if (ids != null && ids.size() >  1){
            criteria.andMallIdIn(ids);
        }
        criteria.andCountdateGreaterThanOrEqualTo(startDate).andCountdateLessThanOrEqualTo(endDate).andGenderNotEqualTo(Short.parseShort("-1")).andAgeNotEqualTo(Short.parseShort("-1")).andResidenceTimeGreaterThan(0);
        if(residenceStage !=null) {
            if(residenceStage.startsWith("-")){
                criteria.andResidenceTimeLessThanOrEqualTo(Integer.valueOf(durings[1].trim())*60);
            }else if(residenceStage.endsWith("-")){
                criteria.andResidenceTimeGreaterThan(Integer.valueOf(durings[0].trim())*60);
            }else {
                criteria.andResidenceTimeGreaterThan(Integer.valueOf(durings[0].trim())*60).andResidenceTimeLessThanOrEqualTo(Integer.valueOf(durings[1].trim())*60);
            }
        }
        example.setOrderByClause("countdate desc,mall_id asc");
        return baseService.selectByExample(example);
    }

}
