package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
/**
 * 排行榜统计
 * @author dugw
 *
 */
@Service
public class RankingListReportImpl  extends ChartReportBaseService {

	@Resource
	private MallReportDataService mallReportDataServiceImpl;
	@Resource
	private FloorReportDataService floorReportDataServiceImpl;
	@Resource
	private ZoneReportDataService zoneReportDataServiceImpl;
	@Resource
	private GateReportDataService gateReportDataServiceImpl;
	
	
	private final String REPORT_RANKING = "rankingList";

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		
		List<DataVo> dataVos = new ArrayList<DataVo>();
		List orgList = new ArrayList();
		if(OrgType.mall == orgType){
			//放入客流数据
			List<MallDayCountData> dayTraffic = mallReportDataServiceImpl.getOrQueryMallBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dataVos.addAll(mallReportDataServiceImpl.convert2Data(dayTraffic));
			//放入销售数据
			List<Sale> sale = mallReportDataServiceImpl.getOrQueryMallBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			dataVos.addAll(mallReportDataServiceImpl.convert2Data(sale));

			for (Long orgId : orgIds) {
				Mall mall = mallReportDataServiceImpl.getMallByMallId(orgId, dataMap);
				orgList.add(mall);
			}
		}else if(OrgType.floor == orgType){
			List<FloorDayCountData> dayTraffic = floorReportDataServiceImpl.getOrQueryFloorBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dataVos.addAll(floorReportDataServiceImpl.convert2Data(dayTraffic));
			List<Sale> sale = floorReportDataServiceImpl.getOrQueryFloorBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			dataVos.addAll(floorReportDataServiceImpl.convert2Data(sale));
			for (Long orgId : orgIds) {
				Floor floor = floorReportDataServiceImpl.getFloorInfoById(orgId, dataMap);
				orgList.add(floor);
			}
		}else if(OrgType.zone == orgType){
			List<ZoneDayCountData> dayTraffic = zoneReportDataServiceImpl.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dataVos.addAll(zoneReportDataServiceImpl.convert2Data(dayTraffic));
			List<Sale> sale = zoneReportDataServiceImpl.getOrQueryZoneBetweenDateSale(orgIds, startDate, endDate, dataMap);
			dataVos.addAll(zoneReportDataServiceImpl.convert2Data(sale));
			for (Long orgId : orgIds) {
				Zone zone = zoneReportDataServiceImpl.getOrQueryZoneById(orgId, dataMap);
				orgList.add(zone);
			}
		}else if(OrgType.gate == orgType) {
			List<GateDayCountData> dayTraffic = gateReportDataServiceImpl.getOrQueryGateBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dataVos.addAll(gateReportDataServiceImpl.convert2Data(dayTraffic));
			for (Long orgId : orgIds) {
				Gate gate = gateReportDataServiceImpl.getGateInfoById(orgId, dataMap);
				orgList.add(gate);
			}
		}
		Chart chart = null;
		switch (reportChart.getKey()) {
		case REPORT_RANKING:
			chart = rankingListReport(orgList,dataVos, dataMap,orgType, reportChart);
			break;
		default:
			break;
		}
		
		
		return chart;
	}
	
	/**
	 * 排行榜报表
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart rankingListReport(List orgList,List<DataVo> dataVos, Map<String, Object> dataMap,OrgType orgType, ReportChart reportChart){
		String titleStr =LocalMessageUtil.getMessage(orgType.toString());
		Chart chart = new Chart(titleStr+reportChart.getTitle(),SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);

		for (Object o : orgList) {
			String seriesName = "";
			if(OrgType.mall == orgType){
				Mall mall = (Mall) o;
				seriesName = mall.getName();

			}else if(OrgType.floor == orgType){
				Floor floor = (Floor) o;
				seriesName = floor.getName();
			}else if(OrgType.zone == orgType){
				Zone zone = (Zone) o;
				seriesName = zone.getName();
			}else if(OrgType.gate == orgType){
				Gate gate = (Gate) o;
				seriesName = gate.getName();
			}
			chart.createSeries(seriesName);
		}

		List<KPIType> kpiTypes = (List<KPIType>) dataMap.get("KPITYPES");
		for (DataVo dataVo : dataVos) {
			String seriesName = null;
			if(OrgType.mall == orgType){
				Long mallId = dataVo.getMallId();
				Mall mall = mallReportDataServiceImpl.getMallByMallId(mallId, dataMap);
				if(mall == null)
					continue;
				seriesName = mall.getName();
			}else if(OrgType.floor == orgType){
				Long floorId = dataVo.getFloorId();
				Floor floor = floorReportDataServiceImpl.getFloorInfoById(floorId, dataMap);
				if(floor == null)
					continue;
				seriesName = floor.getName();
			}else if(OrgType.zone == orgType){
				Long zoneId = dataVo.getZoneId();
				Zone zone = zoneReportDataServiceImpl.getOrQueryZoneById(zoneId, dataMap);
				if(zone == null)
					continue;
				seriesName = zone.getName();
			}else if(OrgType.gate == orgType){
				Long gateId = dataVo.getGateId();
				Gate gate = gateReportDataServiceImpl.getGateInfoById(gateId, dataMap);
				if(gate == null)
					continue;
				seriesName = gate.getName();
			}
			for (KPIType kpiType : kpiTypes) {
				String kpiStr = kpiType.getName();
				
				Number result = getKpiResult(dataVo, dataVos, dataMap, kpiType);
				
				if (result != null && result.equals(-10001)) 
					continue;
				
				if(kpiType == KPIType.ZONENUM)
					chart.getSeries(seriesName).putValueByCoordinate(kpiStr, result);
				else
				   chart.getSeries(seriesName).adjustOrPutValueByCoordinate(kpiStr, result);
				
				chart.sort(new Comparator<Series>() {
					@Override
					public int compare(Series o1, Series o2) {
						Double d1 = NumberUtil.parseDouble(o1.getValueByCoordinate(kpiStr));
						Double d2 = NumberUtil.parseDouble(o2.getValueByCoordinate(kpiStr));
						return -1*Double.compare(d1, d2);
					}
				});
			}
		}
		
		return chart;
	}
	

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
