package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.MallDayCountData;
import com.viontech.mall.model.MallHourCountData;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class NewEnteringRateReportServiceImpl extends ChartReportBaseService {

    @Resource
    private MallReportDataService mallReportDataService;

    /**
     * 单对象小时数据报表
     */
    private final  String SINGLEOBJECTHOURCHART = "singleObjectHourChart";
    /**
     * 单对象小时数据表格
     */
    private final  String SINGLEOBJECTHOURTABLE = "singleObjectHourTable";
    /**
     * 单对象天级数据报表
     */
    private final  String SINGLEOBJECTDAYCHART  = "singleObjectDayChart";
    /**
     * 单对象天级数据表格
     */
    private final  String SINGLEOBJECTDAYTABLE  = "singleObjectDayTable";
    /**
     * 多对象天级数据报表
     */
    private final  String MULTIOBJECTDAYCHART = "multiObjectDayChart";
    /**
     * 多对象天级数据表格
     */
    private final  String MULTIOBJECTDAYTABLE = "multiObjectDayTable";


    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return  null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = null;
        OrgType orgType = (OrgType) dataMap.get("ORGTYPE");

        OptionsContain chartOption = (OptionsContain) dataMap.get("chartOption");
        String key = reportChart.getKey();

        List<DataVo> dataVos = new ArrayList<>();
        //处理数据
        if (OrgType.mall.equals(orgType)){
            Date new_startDate = null;
            switch (key) {
                case SINGLEOBJECTHOURCHART:
                case SINGLEOBJECTHOURTABLE:
                    new_startDate = DateUtil.addDays(endDate, -1);
                    List<MallHourCountData> mallHourTraffic = mallReportDataService.getOrQueryMallBetweenDateHourTraffic(orgIds, new_startDate, endDate, dataMap);
                    dataVos = mallReportDataService.convert2Data(mallHourTraffic);
                    break;
                case SINGLEOBJECTDAYCHART:
                case SINGLEOBJECTDAYTABLE:
                case MULTIOBJECTDAYCHART:
                case MULTIOBJECTDAYTABLE:
                    if (OptionsContain.TAB_DAY.equals(chartOption)){
                        Date lastMonth_date = DateUtil.addMonths(startDate, -1);
                        List<Date> dates = new ArrayList<>();
                        dates.add(lastMonth_date);
                        dates.add(startDate);
                        List<MallDayCountData> mallDayTraffic = mallReportDataService.getOrQueryMallInDatesDayTraffic(orgIds, dates, dataMap);
                        dataVos = mallReportDataService.convert2Data(mallDayTraffic);
                        break;
                    }else if(OptionsContain.TAB_WEEK.equals(chartOption)){
                        new_startDate = DateUtil.addWeeks(startDate, -4);
                        List<MallDayCountData> mallDayTraffic = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, new_startDate, endDate, dataMap);
                        dataVos = mallReportDataService.convert2Data(mallDayTraffic);
                        break;
                    }else if(OptionsContain.TAB_MONTH.equals(chartOption)){
                        new_startDate = DateUtil.addMonths(startDate, -1);
                        List<MallDayCountData> mallDayTraffic = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, new_startDate, endDate, dataMap);
                        dataVos = mallReportDataService.convert2Data(mallDayTraffic);
                        break;
                    }
                default:
                    break;
            }
        }
        //生成报表
        switch (key) {
            case  SINGLEOBJECTHOURCHART:
                chart = singleObjectHourLineChart(orgIds[0],dataVos,endDate,dataMap,reportChart);
                break;
            case  SINGLEOBJECTHOURTABLE:
                chart = singleObejectHourTable(orgIds[0],dataVos,endDate,dataMap,reportChart);
                break;
            case SINGLEOBJECTDAYCHART:
            case SINGLEOBJECTDAYTABLE:
            case MULTIOBJECTDAYTABLE:
            case MULTIOBJECTDAYCHART:
                String flag = "";
                if (OptionsContain.TAB_DAY == chartOption){
                    flag = "day";
                }else if(OptionsContain.TAB_WEEK ==chartOption){
                    flag = "week";
                }else if(OptionsContain.TAB_MONTH == chartOption){
                    flag = "month";
                }
                if (key.equals(MULTIOBJECTDAYTABLE))
                    chart = multiObjectDayTable(orgIds,dataVos,startDate,endDate,dataMap,reportChart,flag);
                else if(key.equals(MULTIOBJECTDAYCHART))
                    chart = multiObjectDayChart(orgIds,dataVos,startDate,endDate,dataMap,reportChart,flag);
                else if(key.equals(SINGLEOBJECTDAYTABLE))
                    chart = singleObejectDayTable(dataVos,startDate,endDate,dataMap,reportChart,flag);
                else if(key.equals(SINGLEOBJECTDAYCHART))
                    chart = singleObejectDayChart(dataVos,startDate,endDate,dataMap,reportChart,flag);
                break;
            default:
                break;
        }
        return chart;
    }

    /**
     * 单对象小时进店率趋势报表
     * @param orgId
     * @param dataVos
     * @param today
     * @param dataMap
     * @param reportChart
     * @return
     */
    private Chart singleObjectHourLineChart(Long orgId,List<DataVo> dataVos, Date today, Map<String, Object> dataMap, ReportChart reportChart){
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        //生成x轴
        Axis<Date> hourOfDayAxis = AxisFactory.creatSdfDateAxix(DateUtil.FORMAT_HHMM,Calendar.HOUR);
        BaseDataServiceImpl.DateCriteria mallOpentimes = mallReportDataService.getMallOpentimesByOrgId(orgId, OrgType.mall, dataMap);
        Date mallOpenTime = mallOpentimes.getStartDate();
        hourOfDayAxis.setMin(mallOpenTime);
        Date mallCloseTime = mallOpentimes.getEndDate();
        hourOfDayAxis.setMax(mallCloseTime);
        hourOfDayAxis.lockMinMax();
        chart.setXAxis(hourOfDayAxis);

        //数据放入报表
        for (DataVo dataVo : dataVos) {
            Date date = dataVo.getDate();
            Date time = dataVo.getTime();
            boolean inOpenTime = DateUtil.isInOpenTime(time, mallOpenTime, mallCloseTime);
            if (!inOpenTime)
                continue;
            Number enterRate = getKpiResult(dataVo, dataVos, dataMap, KPIType.ENTERINGRATE);
            DateType dateType = DateType.valueOfDay(today, date);
            chart.getSeries(dateType.toString()).putValueByCoordinate(time,enterRate);
        }
        return chart;
    }

    /**
     * 单对象小时进店率详情
     * @param orgId
     * @param dataVos
     * @param today
     * @param dataMap
     * @param reportChart
     * @return
     */
    private Chart singleObejectHourTable(Long orgId,List<DataVo> dataVos, Date today, Map<String, Object> dataMap, ReportChart reportChart){
        String dateStr = LocalMessageUtil.getMessage("DateMessage.time");//时间
        String effectiveTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.EFFECTIVE");//客流量
        String outsideTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.OUTSIDETRAFFIC");//店外正客流
        String autiTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.AUTITRAFFIC");//店外反客流
        String totalTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.TOTALTRAFFIC");//店外总客流
        String enteringRate = LocalMessageUtil.getMessage("ParamName.enteringRate");//进店率
        String yesterdayEnteringRate = LocalMessageUtil.getMessage("enteringRate.yesterdayEnterRate");//昨日同期进店率
        String ToY = LocalMessageUtil.getMessage("ToY");//昨日环比

        Table table = new Table(reportChart.getTitle()){
            @Override
            public Object calcValue(String name,int index, List data) {
                String result = null;
                if(index ==  getIndexByTableHead(ToY)){
                    String enterRate_str= ""+data.get(getIndexByTableHead(enteringRate));
                    String compared_enterRate_str = ""+ data.get(getIndexByTableHead(yesterdayEnteringRate));
                    if (!enterRate_str.contains("null") && !compared_enterRate_str.contains("null")){
                        Number todayEnterRate = Double.parseDouble(enterRate_str.toString().replace("%","")) ;
                        Number yesterdayEnterRate = Double.parseDouble(compared_enterRate_str.toString().replace("%",""));
                        result = NumberUtil.growthRate(todayEnterRate , yesterdayEnterRate);
                    }
                    return  result;
                }else if (index ==  getIndexByTableHead(enteringRate) || index ==  getIndexByTableHead(yesterdayEnteringRate) ){
                    Object data_result = data.get(index);
                    if (data_result != null)
                        return ""+ data_result +"%";
                    return data_result;
                }else{
                    return data.get(index);
                }
            }
        };
        //设置表头
        TableHead tableHead = new TableHead();
        tableHead.addHeadColumn(dateStr,effectiveTraffic,outsideTraffic,autiTraffic,totalTraffic,enteringRate,yesterdayEnteringRate,ToY);
        table.setTableHead(tableHead);
        //生成第一列的时间段
        BaseDataServiceImpl.DateCriteria mallOpentimes = mallReportDataService.getMallOpentimesByOrgId(orgId, OrgType.mall, dataMap);
        Date mallOpenTime = mallOpentimes.getStartDate();
        Date mallCloseTime = mallOpentimes.getEndDate();
        Date currentTime = mallOpenTime;
        while (currentTime.compareTo(mallCloseTime) <= 0) {
            String currentTimeStr = DateUtil.format("HH:00",currentTime);
            Date nextTime =  DateUtil.addHours(currentTime, 1);
            String nextTimeStr = DateUtil.format("HH:00",nextTime);
            String timeQuanTumStr = currentTimeStr+"-"+nextTimeStr;
            table.getRow(currentTimeStr).putValueByHeadColumn(dateStr, timeQuanTumStr);
            currentTime = nextTime;
        }
        //放入数据
        for (DataVo dataVo : dataVos) {
            Date currentDate = dataVo.getTime();
            String currentTimeStr = DateUtil.format("HH:00",currentDate);

            boolean inOpenTime = DateUtil.isInOpenTime(currentDate, mallOpenTime, mallCloseTime);
            if (!inOpenTime)
                continue;
            DateType dateType = DateType.valueOfDay(today, currentDate);
            if (DateType.TODAY.equals(dateType)){
                Number effective = getKpiResult(dataVo, dataVos, dataMap, KPIType.EFFECTIVETRAFFIC);//有效客流
                table.getRow(currentTimeStr).putValueByHeadColumn(effectiveTraffic,effective);
                int passInnum = dataVo.getPassInnum();
                table.getRow(currentTimeStr).putValueByHeadColumn(outsideTraffic,passInnum);
                int passOutnum = dataVo.getPassOutnum();
                table.getRow(currentTimeStr).putValueByHeadColumn(autiTraffic,passOutnum);
                Number passTraffic = getKpiResult(dataVo, dataVos, dataMap, KPIType.PASSTRAFFIC);
                table.getRow(currentTimeStr).putValueByHeadColumn(totalTraffic,passTraffic);
                Number enterTate = getKpiResult(dataVo, dataVos, dataMap, KPIType.ENTERINGRATE);
                table.getRow(currentTimeStr).putValueByHeadColumn(enteringRate,enterTate);
            }else if(DateType.YESTERDAY.equals(dateType)){
                Number enterRate = getKpiResult(dataVo, dataVos, dataMap, KPIType.ENTERINGRATE);
                table.getRow(currentTimeStr).putValueByHeadColumn(yesterdayEnteringRate,enterRate);
            }
        }

        return  table;
    }

    private Chart singleObejectDayChart(List<DataVo> dataVos, Date startDate, Date endDate, Map<String, Object> dataMap,
                                       ReportChart reportChart,String chartFlagh){
        Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);

        Axis axis = AxisFactory.createStringAxis();
        List<Date> current_dates = DateUtil.getDaysBetweenDates(startDate, endDate);
        for(Date date : current_dates){
            String format = DateUtil.format(DateUtil.FORMAT_SHORT_WEEK,date);
            axis.addData(format);
        }
        chart.setXAxis(axis);

        String current_enterRate = "";
        String compare_enterRate = "";

        if("week".equals(chartFlagh)){
            current_enterRate = LocalMessageUtil.getMessage("ENTERINGRATE.WEEKENTERINGRATE");
            compare_enterRate =  LocalMessageUtil.getMessage("enteringRate.last4WeekEnterRate");//前四周平均进店率
        }else if("month".equals(chartFlagh)){
            current_enterRate = LocalMessageUtil.getMessage("ENTERINGRATE.MONTHENTERINGRATE");
            compare_enterRate = LocalMessageUtil.getMessage("enteringRate.lastMonthDayEnterRate");//上月同期进店率;
        }

        for (DataVo dataVo : dataVos) {
            Date date = dataVo.getDate();
            String format = DateUtil.format(DateUtil.FORMAT_SHORT_WEEK,date);
            Number enterRate = getKpiResult(dataVo, dataVos, dataMap, KPIType.ENTERINGRATE);
            if (current_dates.contains(date)) {
                chart.getSeries(current_enterRate).putValueByCoordinate(format,enterRate);
                Integer compared_innum = 0,compared_passNum = 0;
                Double c_enterRate = 0.0;
                if("week".equals(chartFlagh)){
                    c_enterRate = getForward4WeekEnterRate(dataVos, dataMap, date);
                }else if("month".equals(chartFlagh)){
                    Date lastMonthDay = DateUtil.addMonths(date, -1);
                    for (DataVo dataVo1 : dataVos) {
                        Date dataVoDate = dataVo.getDate();
                        if (DateUtil.isSameDay(lastMonthDay, dataVoDate)) {
                            Number result = getKpiResult(dataVo1, dataVos, dataMap, KPIType.ENTERINGRATE);
                            c_enterRate = result.doubleValue();
                            break;
                        }
                    }
                }
                 chart.getSeries(compare_enterRate).putValueByCoordinate(format,c_enterRate);
            }
        }
        return chart;
    }

    /**
     * 单对象多天进店率详情
     * @param dataVos
     * @param startDate
     * @param endDate
     * @param dataMap
     * @param reportChart
     * @param chartFlagh
     * @return
     */
    private Chart singleObejectDayTable(List<DataVo> dataVos, Date startDate, Date endDate, Map<String, Object> dataMap,
                                       ReportChart reportChart,String chartFlagh){
        String dateStr = LocalMessageUtil.getMessage("ENTERINGRATE.DATE");//日期
        String enableTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.EFFECTIVE");//客流量
        String outside_innum = LocalMessageUtil.getMessage("ENTERINGRATE.OUTSIDETRAFFIC");//店外正客流
        String outside_outnum = LocalMessageUtil.getMessage("ENTERINGRATE.AUTITRAFFIC");//店外反客流
        String passTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.TOTALTRAFFIC");//店外总客流
        String enterRate = LocalMessageUtil.getMessage("KPIType.enteringRate");//进店率
        String lastMonthDay_enterRate = LocalMessageUtil.getMessage("enteringRate.lastMonthDayEnterRate");//上月同期进店率
        String last4Week_enterRate = LocalMessageUtil.getMessage("enteringRate.last4WeekEnterRate");//前四周平均进店率
        String lastMonthDay_YoY = LocalMessageUtil.getMessage("enteringRate.lastMonthDayYoY");//上月同期环比
        String last4Week_YoY = LocalMessageUtil.getMessage("enteringRate.last4WeekYoY");//前四周平均环比

        Chart chart = new Table(reportChart.getTitle());

        TableHead tableHead = new TableHead();
        tableHead.addHeadColumn(dateStr,enableTraffic,outside_innum,outside_outnum,passTraffic,enterRate);
        if("week".equals(chartFlagh)){
            tableHead.addHeadColumn(last4Week_enterRate,last4Week_YoY);
        }else if("month".equals(chartFlagh)){
            tableHead.addHeadColumn(lastMonthDay_enterRate,lastMonthDay_YoY);
        }
        ((Table) chart).setTableHead(tableHead);

        //初始化第一列时间，防止数据缺失引起时间断裂
        List<Date> daysBetweenDates = DateUtil.getDaysBetweenDates(startDate, endDate);
        for (Date date : daysBetweenDates) {
            String format_Date = DateUtil.format(DateUtil.FORMAT_SHORT_WEEK, date);
            chart.getSeries(format_Date).putValueByCoordinate(dateStr,format_Date);
        }

        for (DataVo dataVo : dataVos) {
            Date date = dataVo.getDate();
            if (!daysBetweenDates.contains(date))
                continue;
            String format_Date = DateUtil.format(DateUtil.FORMAT_SHORT_WEEK, date);
            Number enableTrafficStr = getKpiResult(dataVo, dataVos, dataMap, KPIType.EFFECTIVETRAFFIC);
            chart.getSeries(format_Date).putValueByCoordinate(enableTraffic,enableTrafficStr);
            int pass_innum = dataVo.getPassInnum();
            chart.getSeries(format_Date).putValueByCoordinate(outside_innum,pass_innum);
            int pass_Outnum = dataVo.getPassOutnum();
            chart.getSeries(format_Date).putValueByCoordinate(outside_outnum,pass_Outnum);
            Number pass_traffic = getKpiResult(dataVo, dataVos, dataMap, KPIType.PASSTRAFFIC);
            chart.getSeries(format_Date).putValueByCoordinate(passTraffic,pass_traffic);
            Number current_enterRate = getKpiResult(dataVo, dataVos, dataMap, KPIType.ENTERINGRATE);
            if(current_enterRate != null)
                chart.getSeries(format_Date).putValueByCoordinate(enterRate,current_enterRate+"%");
            else
                chart.getSeries(format_Date).putValueByCoordinate(enterRate,current_enterRate);
            Integer compared_innum = 0,compared_passNum = 0;
            Double compared_percentage = 0.0;
            if("week".equals(chartFlagh)){//计算前4周平均进店率
                compared_percentage = getForward4WeekEnterRate(dataVos, dataMap,  date);
                String growthRate = NumberUtil.growthRate(current_enterRate, compared_percentage);
                if (compared_percentage != null)
                    chart.getSeries(format_Date).putValueByCoordinate(last4Week_enterRate,compared_percentage+"%");
                else
                    chart.getSeries(format_Date).putValueByCoordinate(last4Week_enterRate,compared_percentage);
                chart.getSeries(format_Date).putValueByCoordinate(last4Week_YoY,growthRate);
            }else if("month".equals(chartFlagh)){//商业同期进店率
                Date lastMonthDay = DateUtil.addMonths(date, -1);
                for (DataVo dataVo1 : dataVos) {
                    Date dataVoDate = dataVo.getDate();
                    if (DateUtil.isSameDay(lastMonthDay,dataVoDate)){
                        Number result= getKpiResult(dataVo1, dataVos, dataMap, KPIType.ENTERINGRATE);
                        compared_percentage = result.doubleValue();
                        String growthRate = NumberUtil.growthRate(current_enterRate, compared_percentage);
                        if (compared_percentage != null)
                            chart.getSeries(format_Date).putValueByCoordinate(lastMonthDay_enterRate,compared_percentage+"%");
                        else
                            chart.getSeries(format_Date).putValueByCoordinate(lastMonthDay_enterRate,compared_percentage);
                        chart.getSeries(format_Date).putValueByCoordinate(lastMonthDay_YoY,growthRate);
                        break;
                    }
                }
            }
        }
        return chart;
    }

    /**
     * 获取前4周的进店率
     * @param dataVos
     * @param dataMap
     * @param date
     * @return
     */
    private Double getForward4WeekEnterRate(List<DataVo> dataVos, Map<String, Object> dataMap,  Date date) {
        Double compared_percentage;
        List<Date> betweenDates = new ArrayList<>();
        Date forward4week = DateUtil.addWeeks(date, -4);
        betweenDates.add(forward4week);
        Date forward3week = DateUtil.addWeeks(date, -3);
        betweenDates.add(forward3week);
        Date forward2week = DateUtil.addWeeks(date, -2);
        betweenDates.add(forward2week);
        Date forward1week = DateUtil.addWeeks(date, -1);
        betweenDates.add(forward1week);

        Integer compared_innum = 0,compared_passNum = 0;
        for (DataVo dataVo1 : dataVos) {
            Date dataVoDate = dataVo1.getDate();
            if (betweenDates.contains(dataVoDate)){
                Number innum = getKpiResult(dataVo1, dataVos, dataMap, KPIType.EFFECTIVETRAFFIC);
                compared_innum += innum.intValue();
                Number lastMonthDay_passTraffic = getKpiResult(dataVo1, dataVos, dataMap, KPIType.PASSTRAFFIC);
                compared_passNum += lastMonthDay_passTraffic.intValue();
            }
        }
        compared_percentage = NumberUtil.percentage(compared_innum, compared_passNum, 2);
        return compared_percentage;
    }

    /**
     * 多天多对象进店率柱状图
     * @param dataVos
     * @param startDate
     * @param endDate
     * @param dataMap
     * @param reportChart
     * @param chartFlagh
     * @return
     */
    private Chart multiObjectDayChart(Long[] orgIds,List<DataVo> dataVos, Date startDate, Date endDate,
                                      Map<String, Object> dataMap, ReportChart reportChart,String chartFlagh){

        Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);

        Axis axis = AxisFactory.createStringAxis();
        chart.setXAxis(axis);

        String enterRate = "";
        String YoY_enterRate = "";
        if ("day".equals(chartFlagh)){
            enterRate = LocalMessageUtil.getMessage("ENTERINGRATE.TODAYENTERINGRATE");
            YoY_enterRate = LocalMessageUtil.getMessage("enteringRate.lastMonthDayEnterRate");
        }else if("week".equals(chartFlagh)){
            enterRate = LocalMessageUtil.getMessage("ENTERINGRATE.WEEKENTERINGRATE");
            YoY_enterRate = LocalMessageUtil.getMessage("enteringRate.last4WeekEnterRate");
        }else if("month".equals(chartFlagh)){
            enterRate = LocalMessageUtil.getMessage("ENTERINGRATE.MONTHENTERINGRATE");
            YoY_enterRate = LocalMessageUtil.getMessage("enteringRate.lastMonthEnterRate");
        }

        //生成店铺名称
        for (Long orgId : orgIds) {
            String name = getOrgNameById(orgId,null, dataMap);
            chart.getSeries(enterRate).putValueByCoordinate(name,name);
            chart.getSeries(YoY_enterRate).putValueByCoordinate(name,name);
        }

        Map<String,Map<String,Number>> resultMap = new HashMap<>();
        for (DataVo dataVo : dataVos) {
            Date date = dataVo.getDate();
            String name = getOrgName(dataVo, dataMap);
            if (name == null)
                continue;
            Map<String, Number> trafficMap = resultMap.get(name);
            if (trafficMap == null){
                trafficMap = new HashMap<>();
                trafficMap.put("enableTraffic",0);
                trafficMap.put("passTraffic",0);
                trafficMap.put("compare_enableTraffic",0);
                trafficMap.put("compare_passTraffic",0);
            }

            Number  enableTraffic = trafficMap.get("enableTraffic"),
                    passTraffic = trafficMap.get("passTraffic"),
                    compare_enableTraffic = trafficMap.get("compare_enableTraffic"),
                    compare_passTraffic = trafficMap.get("compare_passTraffic");

            Number enableNum = getKpiResult(dataVo, dataVos, dataMap, KPIType.EFFECTIVETRAFFIC);
            Number passNum = getKpiResult(dataVo, dataVos, dataMap, KPIType.PASSTRAFFIC);
            if (("month".equals(chartFlagh) && DateUtil.isSameMonth(endDate, date)) ||
                    ("week".equals(chartFlagh) && DateUtil.isSameWeek(endDate, date)) ||
                    ("day".equals(chartFlagh) && DateUtil.isSameDay(endDate, date))){
                enableTraffic = (Number) NumberUtil.valueAdd(enableNum, enableTraffic);
                trafficMap.put("enableTraffic",enableTraffic);
                passTraffic = (Number) NumberUtil.valueAdd(passNum, passTraffic);
                trafficMap.put("passTraffic",passTraffic);
           }else {
                compare_enableTraffic = (Number) NumberUtil.valueAdd(enableNum, compare_enableTraffic);
                trafficMap.put("compare_enableTraffic",compare_enableTraffic);
                compare_passTraffic = (Number) NumberUtil.valueAdd(passNum, compare_passTraffic);
                trafficMap.put("compare_passTraffic",compare_passTraffic);
            }
            resultMap.put(name,trafficMap);
        }

        for (Map.Entry<String, Map<String, Number>> entry : resultMap.entrySet()) {
            String name = entry.getKey();
            Map<String, Number> trafficMap = entry.getValue();
            Number  enableTraffic = trafficMap.get("enableTraffic"),
                    passTraffic = trafficMap.get("passTraffic"),
                    compare_enableTraffic = trafficMap.get("compare_enableTraffic"),
                    compare_passTraffic = trafficMap.get("compare_passTraffic");

            Double percentage = NumberUtil.percentage(enableTraffic, passTraffic, 2);
            chart.getSeries(enterRate).putValueByCoordinate(name, percentage);
            Double compare_enterRate = NumberUtil.percentage(compare_enableTraffic, compare_passTraffic, 2);
            chart.getSeries(YoY_enterRate).putValueByCoordinate(name, compare_enterRate);
        }
        return  chart;
    }

    /**
     * 多天多对象进店率详情
     * @param orgIds
     * @param dataVos
     * @param startDate
     * @param endDate
     * @param dataMap
     * @param reportChart
     * @param chartFlagh
     * @return
     */
    private  Chart multiObjectDayTable(Long[] orgIds,List<DataVo> dataVos, Date startDate, Date endDate,
                                       Map<String, Object> dataMap, ReportChart reportChart,String chartFlagh){
        String shopName = LocalMessageUtil.getMessage("enteringRate.shopName");//名称
        String enableTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.EFFECTIVE");//客流量
        String compare_enableTraffic = LocalMessageUtil.getMessage("enteringRate.comparedEffective");//对比有效客流
        String outside_innum = LocalMessageUtil.getMessage("ENTERINGRATE.OUTSIDETRAFFIC");//店外正客流
        String outside_outnum = LocalMessageUtil.getMessage("ENTERINGRATE.AUTITRAFFIC");//店外反客流
        String passTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.TOTALTRAFFIC");//店外总客流
        String compare_passTraffic = LocalMessageUtil.getMessage("enteringRate.comparedTotalTraffic");//对比店外总客流
        String enterRate = LocalMessageUtil.getMessage("KPIType.enteringRate");//进店率

        String lastMonth_enterRate = LocalMessageUtil.getMessage("enteringRate.lastMonthEnterRate");//上月进店率
        String lastMonthDay_enterRate = LocalMessageUtil.getMessage("enteringRate.lastMonthDayEnterRate");//上月同期进店率
        String last4Week_enterRate = LocalMessageUtil.getMessage("enteringRate.last4WeekEnterRate");//前四周平均进店率
        String lastMonth_YoY = LocalMessageUtil.getMessage("enteringRate.lastMonthYoY");//上月环比
        String lastMonthDay_YoY = LocalMessageUtil.getMessage("enteringRate.lastMonthDayYoY");//上月同期环比
        String last4Week_YoY = LocalMessageUtil.getMessage("enteringRate.last4WeekYoY");//前四周平均环比


        Chart chart = new Table(reportChart.getTitle()){
            @Override
            public Object calcValue(String name, int index, List data_raw) {
                int index_enableTraffic = getIndexByTableHead(enableTraffic);
                Number enabeTraffic  = (Number) data_raw.get(index_enableTraffic);
                int index_passTraffic = getIndexByTableHead(passTraffic);
                Number passTraffic = (Number) data_raw.get(index_passTraffic);
                int index_compare_enableTraffic = getIndexByTableHead(compare_enableTraffic);
                Number compare_enableTraffic = (Number) data_raw.get(index_compare_enableTraffic);
                int index_compare_passTraffic = getIndexByTableHead(compare_passTraffic);
                Number compare_passTraffic = (Number) data_raw.get(index_compare_passTraffic);

                Double enterRatePer = NumberUtil.percentage(enabeTraffic, passTraffic, 2);
                Double compare_enterRatePre = NumberUtil.percentage(compare_enableTraffic, compare_passTraffic, 2);
                String growthRate = NumberUtil.growthRate(enterRatePer, compare_enterRatePre);

                Integer index_enterRate = getIndexByTableHead(enterRate);
                Integer index_compare_enterRate = null;
                Integer YoY = null;
                if ("day".equals(chartFlagh)){
                    index_compare_enterRate = getIndexByTableHead(lastMonthDay_enterRate);
                    YoY = getIndexByTableHead(lastMonthDay_YoY);
                }else if("week".equals(chartFlagh)){
                    index_compare_enterRate = getIndexByTableHead(last4Week_enterRate);
                    YoY = getIndexByTableHead(last4Week_YoY);
                }else if("month".equals(chartFlagh)){
                    index_compare_enterRate = getIndexByTableHead(lastMonth_enterRate);
                    YoY = getIndexByTableHead(lastMonth_YoY);
                }

                if ( index_enterRate == index ){
                    if (enterRatePer == null) {
                        return enterRatePer;
                    }else {
                        return  enterRatePer+"%";
                    }
                } else if(index_compare_enterRate == index){
                    if (compare_enterRatePre == null ) {
                        return compare_enterRatePre;
                    }else {
                        return  compare_enterRatePre+"%";
                    }
                } else if(YoY == index){
                    return growthRate;
                }

                return super.calcValue(name, index, data_raw);
            }
        };

        TableHead heads = new TableHead();
        if ("day".equals(chartFlagh)){
            heads.addHeadColumn(shopName,enableTraffic,compare_enableTraffic,outside_innum,outside_outnum,passTraffic,
                    compare_passTraffic,enterRate,lastMonthDay_enterRate,lastMonthDay_YoY);
        }else if("week".equals(chartFlagh)){
            heads.addHeadColumn(shopName,enableTraffic,compare_enableTraffic,outside_innum,outside_outnum,passTraffic,
                    compare_passTraffic,enterRate,last4Week_enterRate,last4Week_YoY);
        }else if("month".equals(chartFlagh)){
            heads.addHeadColumn(shopName,enableTraffic,compare_enableTraffic,outside_innum,outside_outnum,passTraffic,
                    compare_passTraffic,enterRate,lastMonth_enterRate,lastMonth_YoY);
        }
        heads.addHideData(compare_enableTraffic);
        heads.addHideData(compare_passTraffic);
        ((Table) chart).setTableHead(heads);

        //生成店铺名称
        for (Long orgId : orgIds) {
            String name = getOrgNameById(orgId,null, dataMap);
            chart.getSeries(name).putValueByCoordinate(shopName,name);
        }


        for (DataVo dataVo : dataVos) {
            Date date = dataVo.getDate();
            String name = getOrgName(dataVo, dataMap);
            if (name == null)
                continue;
            Number enableNum = getKpiResult(dataVo, dataVos, dataMap, KPIType.EFFECTIVETRAFFIC);
            Number passNum = getKpiResult(dataVo, dataVos, dataMap, KPIType.PASSTRAFFIC);
            if (("month".equals(chartFlagh) && DateUtil.isSameMonth(endDate,date)) ||
                    ("week".equals(chartFlagh) && DateUtil.isSameWeek(endDate,date)) ||
                    ("day".equals(chartFlagh) && DateUtil.isSameDay(endDate,date))){
                chart.getSeries(name).adjustOrPutValueByCoordinate(enableTraffic,enableNum);
                int passInnum = dataVo.getPassInnum();
                chart.getSeries(name).adjustOrPutValueByCoordinate(outside_innum,passInnum);
                int passOutnum = dataVo.getPassOutnum();
                chart.getSeries(name).adjustOrPutValueByCoordinate(outside_outnum,passOutnum);
                chart.getSeries(name).adjustOrPutValueByCoordinate(passTraffic,passNum);
            }else {
                chart.getSeries(name).adjustOrPutValueByCoordinate(compare_enableTraffic,enableNum);
                chart.getSeries(name).adjustOrPutValueByCoordinate(compare_passTraffic,passNum);
            }
        }
        return chart;
    }



}
